local E, L, V, P, G = unpack(ElvUI)
local B = E:GetModule("Bags")
local BC = E:NewModule("BagControl", "AceHook-3.0", "AceEvent-3.0", "AceTimer-3.0")
local EP = LibStub("LibElvUIPlugin-1.0")

local pairs = pairs

local AUCTIONS, GUILD_BANK, MAIL_LABEL, MERCHANT, TRADESKILLS, TRADE = AUCTIONS, GUILD_BANK, MAIL_LABEL, MERCHANT, TRADESKILLS, TRADE

P["BagControl"] = {
	["Enabled"] = true,
	["Open"] = {
		["Mail"] = true,
		["Vendor"] = true,
		["Bank"] = true,
		["GB"] = true,
		["AH"] = true,
		["TS"] = true,
		["Trade"] = true
	},
	["Close"] = {
		["Mail"] = true,
		["Vendor"] = true,
		["Bank"] = true,
		["GB"] = true,
		["AH"] = true,
		["TS"] = true,
		["Trade"] = true
	}
}

local function ColorizeSettingName(settingName)
	return format("|cff1784d1%s|r", settingName)
end

function BC:InsertOptions()
	if not E.Options.args.elvuiPlugins then
		E.Options.args.elvuiPlugins = {
			order = 50,
			type = "group",
			name = "|cff00b30bE|r|cffC4C4C4lvUI_|r|cff00b30bP|r|cffC4C4C4lugins|r",
			args = {
				header = {
					order = 0,
					type = "header",
					name = "|cff00b30bE|r|cffC4C4C4lvUI_|r|cff00b30bP|r|cffC4C4C4lugins|r"
				},
				bagControlShortcut = {
					type = "execute",
					name = ColorizeSettingName(L["Bag Control"]),
					func = function()
						if IsAddOnLoaded("ElvUI_Config") then
							local ACD = LibStub("AceConfigDialog-3.0-ElvUI")
							ACD:SelectGroup("ElvUI", "elvuiPlugins", "bagControl")
						end
					end
				}
			}
		}
	elseif not E.Options.args.elvuiPlugins.args.bagControlShortcut then
		E.Options.args.elvuiPlugins.args.bagControlShortcut = {
			type = "execute",
			name = ColorizeSettingName(L["Bag Control"]),
			func = function()
				if IsAddOnLoaded("ElvUI_Config") then
					local ACD = LibStub("AceConfigDialog-3.0-ElvUI")
					ACD:SelectGroup("ElvUI", "elvuiPlugins", "bagControl")
				end
			end
		}
	end

	E.Options.args.elvuiPlugins.args.bagControl = {
		type = "group",
		name = ColorizeSettingName(L["Bag Control"]),
		disabled = function() return not E.bags; end,
		get = function(info) return E.db.BagControl[ info[#info] ] end,
		set = function(info, value) E.db.BagControl[ info[#info] ] = value end,
		args = {
			header = {
				order = 1,
				type = "header",
				name = L["Bag Control"]
			},
			Enabled = {
				order = 2,
				type = "toggle",
				name = L["Enable"],
				set = function(info, value) E.db.BagControl[ info[#info] ] = value BC:Update() end
			},
			Open = {
				order = 3,
				type = "group",
				name = L["Open bags when the following windows open:"],
				guiInline = true,
				disabled = function() return not E.db.BagControl.Enabled end,
				get = function(info) return E.db.BagControl.Open[ info[#info] ] end,
				set = function(info, value) E.db.BagControl.Open[ info[#info] ] = value end,
				args = {
					Mail = {
						order = 1,
						type = "toggle",
						name = MAIL_LABEL
					},
					Vendor = {
						order = 2,
						type = "toggle",
						name = MERCHANT
					},
					Bank = {
						order = 3,
						type = "toggle",
						name = L["Bank"]
					},
					GB = {
						order = 4,
						type = "toggle",
						name = GUILD_BANK
					},
					AH = {
						order = 5,
						type = "toggle",
						name = AUCTIONS
					},
					TS = {
						order = 6,
						type = "toggle",
						name = TRADESKILLS
					},
					Trade = {
						order = 7,
						type = "toggle",
						name = TRADE
					}
				}
			},
			Close = {
				order = 4,
				type = "group",
				name = L["Close bags when the following windows close:"],
				guiInline = true,
				disabled = function() return not E.db.BagControl.Enabled end,
				get = function(info) return E.db.BagControl.Close[ info[#info] ] end,
				set = function(info, value) E.db.BagControl.Close[ info[#info] ] = value end,
				args = {
					Mail = {
						order = 1,
						type = "toggle",
						name = MAIL_LABEL
					},
					Vendor = {
						order = 2,
						type = "toggle",
						name = MERCHANT
					},
					Bank = {
						order = 3,
						type = "toggle",
						name = L["Bank"]
					},
					GB = {
						order = 4,
						type = "toggle",
						name = GUILD_BANK
					},
					AH = {
						order = 5,
						type = "toggle",
						name = AUCTIONS
					},
					TS = {
						order = 6,
						type = "toggle",
						name = TRADESKILLS
					},
					Trade = {
						order = 7,
						type = "toggle",
						name = TRADE
					}
				}
			}
		}
	}
end

local OpenEvents = {
	["MAIL_SHOW"] = "Mail",
	["MERCHANT_SHOW"] = "Vendor",
	["BANKFRAME_OPENED"] = "Bank",
	["GUILDBANKFRAME_OPENED"] = "GB",
	["AUCTION_HOUSE_SHOW"] = "AH",
	["TRADE_SKILL_SHOW"] = "TS",
	["TRADE_SHOW"] = "Trade"
}

local CloseEvents = {
	["MAIL_CLOSED"] = "Mail",
	["MERCHANT_CLOSED"] = "Vendor",
	["BANKFRAME_CLOSED"] = "Bank",
	["GUILDBANKFRAME_CLOSED"] = "GB",
	["AUCTION_HOUSE_CLOSED"] = "AH",
	["TRADE_SKILL_CLOSE"] = "TS",
	["TRADE_CLOSED"] = "Trade"
}

local function EventHandler(_, event, ...)
	if not E.bags then return end

	if OpenEvents[event] then
		if event == "BANKFRAME_OPENED" then
			B:OpenBank()
			if not E.db.BagControl.Open[OpenEvents[event]] then
				B.BagFrame:Hide()
			end
			return
		elseif E.db.BagControl.Open[OpenEvents[event]] then
			B:OpenBags()
			return
		else
			B:CloseBags()
			return
		end
	elseif CloseEvents[event] then
		if E.db.BagControl.Close[CloseEvents[event]] then
			B:CloseBags()
			return
		else
			B:OpenBags()
			return
		end
	end
end

local EventFrame = CreateFrame("Frame")
EventFrame:SetScript("OnEvent", EventHandler)

local eventsRegistered = false
local function RegisterMyEvents()
	for event in pairs(OpenEvents) do
		EventFrame:RegisterEvent(event)
	end

	for event in pairs(CloseEvents) do
		EventFrame:RegisterEvent(event)
	end

	eventsRegistered = true
end

local function UnregisterMyEvents()
	for event in pairs(OpenEvents) do
		EventFrame:UnregisterEvent(event)
	end

	for event in pairs(CloseEvents) do
		EventFrame:UnregisterEvent(event)
	end

	eventsRegistered = false
end

function BC:Update()
	if E.db.BagControl.Enabled and not eventsRegistered then
		RegisterMyEvents()
	elseif not E.db.BagControl.Enabled and eventsRegistered then
		UnregisterMyEvents()
	end
end

function BC:Initialize()
	EP:RegisterPlugin("ElvUI_BagControl", BC.InsertOptions)
	BC:Update()
end

local function InitializeCallback()
	BC:Initialize()
end

E:RegisterModule(BC:GetName(), InitializeCallback)