local E, L, V, P, G = unpack(ElvUI)
local S = E:GetModule("Skins")

local _G = _G
local ipairs = ipairs
local find = string.find

-- AdvancedTradeSkillWindow v0.6.9 (TBC)

local function LoadSkin()
	if not E.private.addOnSkins.AdvancedTradeSkillWindow then return end

	local scrollBars = {
		-- Main Frame
		"ATSWListScrollFrameScrollBar",
		"ATSWQueueScrollFrameScrollBar",
		-- Sorting Editor
		"ATSWCSUListScrollFrameScrollBar",
		"ATSWCSSListScrollFrameScrollBar",
	}

	local buttons = {
		-- Scan
		"ATSWScanDelayFrameSkipButton",
		"ATSWScanDelayFrameAbortButton",
		-- Main Frame
		"ATSWCSButton",
		"ATSWOptionsButton",
		"ATSWQueueAllButton",
		"ATSWCreateAllButton",
		"ATSWCreateButton",
		"ATSWQueueButton",
		"ATSWQueueStartStopButton",
		"ATSWQueueDeleteButton",
		"ATSWReagentsButton",
		"ATSWQueueItem1DeleteButton",
		"ATSWQueueItem2DeleteButton",
		"ATSWQueueItem3DeleteButton",
		"ATSWQueueItem4DeleteButton",
		-- Sorting Editor
		"ATSWAddCategoryButton",
		-- Reagent Frame
		"ATSWBuyReagentsButton",
		-- Options
		"ATSWOptionsFrameOKButton",
		-- Merchant Frame
		"ATSWAutoBuyButton",
		"ATSWEnchantButton",
	}

	local checkBoxes = {
		-- Main Frame
		"ATSWHeaderSortButton",
		"ATSWNameSortButton",
		"ATSWDifficultySortButton",
		"ATSWCustomSortButton",
		-- Options
		"ATSWOFUnifiedCounterButton",
		"ATSWOFSeparateCounterButton",
		"ATSWOFIncludeBankButton",
		"ATSWOFIncludeAltsButton",
		"ATSWOFIncludeMerchantsButton",
		"ATSWOFAutoBuyButton",
		"ATSWOFTooltipButton",
		"ATSWOFShoppingListButton",
		"ATSWOFReagentListButton",
		"ATSWOFNewRecipeLinkButton",
	}

	local editBoxes = {
		-- Main Frame
		"ATSWFilterBox",
		"ATSWInputBox",
		-- Sorting Editor
		"ATSWCSNewCategoryBox",
	}

	local dropDownBoxes = {
		-- Main Frame
		"ATSWSubClassDropDown",
		"ATSWInvSlotDropDown",
	}

	local closeButtons = {
		-- Main Frame
		"ATSWFrameCloseButton",
		-- Reagent Frame
		"ATSWReagentFrameCloseButton",
		-- Sorting Editor
		"ATSWCSFrameCloseButton",
	}

	local statusBars = {
		-- Scan
		"ATSWScanDelayFrameBar",
		-- Main Frame
		"ATSWRankFrame",
	}

	for _, scrollBar in ipairs(scrollBars) do
		if scrollBar then
			_G[scrollBar]:GetParent():StripTextures()
			S:HandleScrollBar(_G[scrollBar])
		end
	end
	for _, button in ipairs(buttons) do
		if button then S:HandleButton(_G[button]) end
	end
	for _, checkBox in ipairs(checkBoxes) do
		if checkBox then S:HandleCheckBox(_G[checkBox]) end
	end
	for _, editBox in ipairs(editBoxes) do
		if editBox then S:HandleEditBox(_G[editBox]) end
	end
	for _, dropDownBox in ipairs(dropDownBoxes) do
		if dropDownBox then S:HandleDropDownBox(_G[dropDownBox]) end
	end
	for _, closeButton in ipairs(closeButtons) do
		if closeButton then S:HandleCloseButton(_G[closeButton], _G[closeButton]:GetParent().backdrop) end
	end
	for _, statusBar in ipairs(statusBars) do
		if statusBar then
			_G[statusBar]:StripTextures()
			_G[statusBar]:CreateBackdrop()
			_G[statusBar]:SetStatusBarTexture(E.media.normTex)
			E:RegisterStatusBar(_G[statusBar])
		end
	end

	ATSWScanDelayFrame:StripTextures()
	ATSWScanDelayFrame:SetTemplate("Transparent")

	ATSWOptionsFrame:SetParent(E.UIParent);
	ATSWOptionsFrame:StripTextures()
	ATSWOptionsFrame:SetTemplate("Transparent")

	ATSWFrame:StripTextures()
	ATSWFrame:CreateBackdrop("Transparent")
	ATSWFrame.backdrop:Point("TOPLEFT", 10, -12)
	ATSWFrame.backdrop:Point("BOTTOMRIGHT", -34, 10)
	ATSWFrame:SetClampedToScreen(true)

	ATSWCSFrame:StripTextures()
	ATSWCSFrame:CreateBackdrop("Transparent")
	ATSWCSFrame.backdrop:Point("TOPLEFT", 10, -12)
	ATSWCSFrame.backdrop:Point("BOTTOMRIGHT", -34, 10)
	ATSWCSFrame:SetClampedToScreen(true)

	ATSWReagentFrame:StripTextures()
	ATSWReagentFrame:CreateBackdrop("Transparent")
	ATSWReagentFrame.backdrop:Point("TOPLEFT", 12, -14)
	ATSWReagentFrame.backdrop:Point("BOTTOMRIGHT", -34, 74)

	S:HandleNextPrevButton(_G["ATSWDecrementButton"])
	S:HandleNextPrevButton(_G["ATSWIncrementButton"])

	ATSWTradeskillTooltip:SetTemplate("Transparent")

	ATSWScanDelayFrame:Size(400, 151) -- fix pixelperfect

	ATSWFramePortrait:Kill()

	for i = 1, 23 do
		local button = _G["ATSWSkill"..i]
		if button then
			button:SetNormalTexture("")
			button.SetNormalTexture = E.noop
			button:GetHighlightTexture():SetAlpha(0)
			button:SetDisabledTexture("")
			button.SetDisabledTexture = E.noop

			button.Text = button:CreateFontString(nil, "OVERLAY")
			button.Text:FontTemplate(nil, 22)
			button.Text:Point("LEFT", 3, 0)
			button.Text:SetText("+")

			hooksecurefunc(button, "SetNormalTexture", function(self, texture)
				if find(texture, "MinusButton") then
					self.Text:SetText("-")
				elseif find(texture, "PlusButton") then
					self.Text:SetText("+")
				else
					self.Text:SetText("")
				end
			end)
		end
	end

	ATSWExpandButtonFrame:StripTextures()

	ATSWCollapseAllButton:SetNormalTexture("")
	ATSWCollapseAllButton.SetNormalTexture = E.noop
	ATSWCollapseAllButton:GetHighlightTexture():SetAlpha(0)
	ATSWCollapseAllButton:SetDisabledTexture("")
	ATSWCollapseAllButton.SetDisabledTexture = E.noop

	ATSWCollapseAllButton.Text = ATSWCollapseAllButton:CreateFontString(nil, "OVERLAY")
	ATSWCollapseAllButton.Text:FontTemplate(nil, 22)
	ATSWCollapseAllButton.Text:Point("LEFT", 3, 0)
	ATSWCollapseAllButton.Text:SetText("-")

	ATSWCollapseAllButton:HookScript("OnClick", function(self)
		if self.collapsed then
			self.Text:SetText("+")
		else
			self.Text:SetText("-")
		end
	end)

	ATSWRankFrameBorder:StripTextures()
	ATSWRankFrameBorder:Hide()

	local function SkinIcon(reagent, icon, count)
		reagent:StripTextures()

		icon:SetTexCoord(unpack(E.TexCoords))
		icon:SetDrawLayer("OVERLAY")

		icon.backdrop = CreateFrame("Frame", nil, reagent)
		icon.backdrop:SetFrameLevel(reagent:GetFrameLevel() - 1)
		icon.backdrop:SetTemplate("Default")
		icon.backdrop:SetOutside(icon)

		icon:SetParent(icon.backdrop)
		count:SetParent(icon.backdrop)
		count:SetDrawLayer("OVERLAY")
	end

	hooksecurefunc(ATSWSkillIcon, "SetNormalTexture", function(self)
		if self.skinned then
			self:GetNormalTexture():SetTexCoord(unpack(E.TexCoords))
		else
			local reagent = _G["ATSWSkillIcon"]
			local icon = _G["ATSWSkillIcon"]:GetNormalTexture()
			local count = _G["ATSWSkillIconCount"]

			SkinIcon(reagent, icon, count)

			self.skinned = true
		end
	end)

	for i = 1, ATSW_MAX_TRADE_SKILL_REAGENTS do
		local reagent = _G["ATSWReagent"..i]
		local icon = _G["ATSWReagent"..i.."IconTexture"]
		local count = _G["ATSWReagent"..i.."Count"]

		SkinIcon(reagent, icon, count)
	end

	for i = 1, 17 do
		local buttonDelete = _G["ATSWCSCSkill"..i.."Delete"]
		local buttonUp = _G["ATSWCSCSkill"..i.."MoveUp"]
		local buttonDown = _G["ATSWCSCSkill"..i.."MoveDown"]

		S:HandleButton(buttonDelete)
		buttonDelete:Size(17)

		buttonUp:Size(24)
		S:HandleNextPrevButton(buttonUp, "UP")
		S:SquareButton_SetIcon(buttonUp, "UP")

		buttonDown:Size(24)
		S:HandleNextPrevButton(buttonDown, "DOWN")
		S:SquareButton_SetIcon(buttonDown, "DOWN")
	end

	ATSWRankFrame:Size(282, 15)
	ATSWRankFrame:ClearAllPoints()
	ATSWRankFrame:Point("TOPLEFT", ATSWFrame, "TOPRIGHT", -412, -33)
	ATSWRankFrame:SetStatusBarColor(0.13, 0.35, 0.80)

	ATSWHeaderSortButton:ClearAllPoints()
	ATSWHeaderSortButton:Point("TOPLEFT", ATSWFrame, "TOPLEFT", 24, -34)

	ATSWNameSortButton:ClearAllPoints()
	ATSWNameSortButton:Point("TOP", ATSWHeaderSortButton, "BOTTOM", 0, 6)

	ATSWDifficultySortButton:ClearAllPoints()
	ATSWDifficultySortButton:Point("LEFT", ATSWHeaderSortButton, "RIGHT", 140, 0)

	ATSWCustomSortButton:ClearAllPoints()
	ATSWCustomSortButton:Point("TOP", ATSWDifficultySortButton, "BOTTOM", 0, 6)

	ATSWOptionsButton:Height(20)
	ATSWOptionsButton:ClearAllPoints()
	ATSWOptionsButton:Point("TOPLEFT", ATSWFrame, "TOPRIGHT", -130, -50)

	ATSWCreateButton:ClearAllPoints()
	ATSWCreateButton:Point("CENTER", ATSWFrame, "TOPLEFT", 627, -348)

	ATSWDecrementButton:ClearAllPoints()
	ATSWDecrementButton:Point("LEFT", ATSWCreateAllButton, "RIGHT", 5, 0)

	ATSWInputBox:ClearAllPoints()
	ATSWInputBox:Point("LEFT", ATSWDecrementButton, "RIGHT", 5, 0)

	ATSWIncrementButton:ClearAllPoints()
	ATSWIncrementButton:Point("LEFT", ATSWInputBox, "RIGHT", 5, 0)

	ATSWReagentsButton:ClearAllPoints()
	ATSWReagentsButton:Point("BOTTOMLEFT", ATSWFrame, "BOTTOMRIGHT", -130, 20)

	ATSWQueueDeleteButton:ClearAllPoints()
	ATSWQueueDeleteButton:Point("RIGHT", ATSWReagentsButton, "LEFT", -8, 0)

	ATSWQueueStartStopButton:ClearAllPoints()
	ATSWQueueStartStopButton:Point("RIGHT", ATSWQueueDeleteButton, "LEFT", -8, 0)

	ATSWInvSlotDropDown:ClearAllPoints()
	ATSWInvSlotDropDown:Point("TOPLEFT", ATSWFrame, "TOPLEFT", 198, -66)

	ATSWSubClassDropDown:ClearAllPoints()
	ATSWSubClassDropDown:Point("RIGHT", ATSWInvSlotDropDown, "LEFT", 24, 0)

	ATSWCSNewCategoryBox:ClearAllPoints()
	ATSWCSNewCategoryBox:Point("TOPLEFT", ATSWCSFrame, "TOPLEFT", 398, -471)

	ATSWAddCategoryButton:ClearAllPoints()
	ATSWAddCategoryButton:Point("LEFT", ATSWCSNewCategoryBox, "RIGHT", 3, 0)
end

S:AddCallbackForAddon("AdvancedTradeSkillWindow", "AdvancedTradeSkillWindow", LoadSkin)