local E, L, V, P, G = unpack(ElvUI)
local S = E:GetModule("Skins")

-- Skillet: v1.10 - r81029.6

local _G = _G
local unpack = unpack

local hooksecurefunc = hooksecurefunc

local function LoadSkin()
	if not E.private.addOnSkins.Skillet then return end

	S:HandleCloseButton(SkilletFrameCloseButton)

	S:HandleScrollBar(SkilletSkillListScrollBar)

	S:HandleDropDownBox(SkilletSortDropdown)

	S:HandleEditBox(SkilletFilterBox)

	S:HandleCheckBox(SkilletHideUncraftableRecipes)
	SkilletHideUncraftableRecipes.backdrop:SetFrameLevel(SkilletHideUncraftableRecipes:GetFrameLevel())

	S:HandleCheckBox(SkilletHideTrivialRecipes)
	SkilletHideTrivialRecipes.backdrop:SetFrameLevel(SkilletHideTrivialRecipes:GetFrameLevel())

	S:HandleButton(SkilletShowOptionsButton)
	S:HandleButton(SkilletRescanButton)
	S:HandleButton(SkilletRecipeNotesButton)

	S:HandleButton(SkilletQueueAllButton)
	S:HandleButton(SkilletCreateAllButton)
	S:HandleButton(SkilletQueueButton)
	S:HandleButton(SkilletCreateButton)

	S:HandleSliderFrame(SkilletCreateCountSlider)
	SkilletCreateCountSlider.backdrop:SetFrameLevel(SkilletCreateCountSlider:GetFrameLevel())

	S:HandleEditBox(SkilletItemCountInputBox)

	S:HandleScrollBar(SkilletQueueListScrollBar)

	S:HandleButton(SkilletStartQueueButton)
	S:HandleButton(SkilletEmptyQueueButton)
	S:HandleButton(SkilletShoppingListButton)

	S:HandleCloseButton(SkilletNotesCloseButton)

	S:HandleScrollBar(SkilletNotesListScrollBar)

	for i = 1, 7 do
		local buttonIcon = _G["SkilletNotesButton"..i.."Icon"]
		buttonIcon:SetTemplate("Default")
	end

	if SkilletRankFrameBorder then SkilletRankFrameBorder:Hide() end

	if SkilletRankFrame then
		SkilletRankFrame:StripTextures()
		SkilletRankFrame:CreateBackdrop()
		SkilletRankFrame:SetStatusBarTexture(E.media.normTex)

		E:RegisterStatusBar(SkilletRankFrame)
	end

	hooksecurefunc(Skillet, "CreateTradeSkillWindow", function()
		SkilletFrame:StripTextures()

		SkilletFrame:SetTemplate("Transparent")

		SkilletSkillListParent:SetTemplate("Default")
		SkilletSkillListParent:Point("TOPLEFT", 8, -100)
		SkilletSkillListParent:Point("BOTTOM", 0, 8)

		SkilletReagentParent:SetTemplate("Default")
		SkilletReagentParent:Point("TOPRIGHT", -8, -75)

		SkilletQueueParent:SetTemplate("Default")
		SkilletQueueParent:Point("TOP", SkilletCreateButton, "BOTTOM", 0, -3)
		SkilletQueueParent:Point("BOTTOMRIGHT", SkilletFrame, "BOTTOMRIGHT", -8, 32)

		SkilletRecipeNotesFrame:SetTemplate("Transparent")
	end)

	hooksecurefunc(Skillet, "UpdateNotesWindow", function()
		for i = 1, 7 do
			local buttonIcon = _G["SkilletNotesButton"..i.."Icon"]
			if buttonIcon:GetNormalTexture() then
				buttonIcon:GetNormalTexture():SetInside()
				buttonIcon:GetNormalTexture():SetTexCoord(unpack(E.TexCoords))
			end
		end
	end)
end

S:AddCallbackForAddon("Skillet", "Skillet", LoadSkin)