local Factions = {}
local RepStandingColor = {["Hated"] 	 = "|cFFCC2224",
						  ["Hostile"] 	 = "|cFFFF221C",
						  ["Unfriendly"] = "|cFFCF6624",
						  ["Neutral"]	 = "|cFFFFDF00",
						  ["Friendly"]	 = "|cFF0aF207",
						  ["Honored"]	 = "|cFF09F25C",
						  ["Revered"]	 = "|cFF03FFAC",
						  ["Exalted"]	 = "|cFF02FEDC"}
local textColor = "|cFFABD6F4"
local newFactionColor = "|cFF9B8900"

local function loadFactions(start, finish)
	start = start or 1
	finish = finish or GetNumFactions()
	for factionIndex = start, finish do
		-- name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild, factionID, hasBonusRepGain, canBeLFGBonus = GetFactionInfo(index)
		local name, _, _, _, _, _, _, _, isHeader, isCollapsed, _, _, _, factionID = GetFactionInfo(factionIndex)
		if isHeader == false then
			Factions[name] = factionID
		elseif isCollapsed == true then
			ExpandFactionHeader(factionIndex)
			loadFactions(factionIndex, factionIndex+(GetNumFactions()-finish))
			CollapseFactionHeader(factionIndex)
		end
	end
end

local function factionInfo(factionName)
	if factionName == "Guild" then
		local name, _, standingID, bottomValue, topValue, earnedValue = GetGuildFactionInfo()
		return name, bottomValue, topValue, earnedValue, standingID
	end

	if Factions[factionName] == nil then
		loadFactions()
		if Factions[factionName] == nil then 
			-- NOTE: if we get here, something is wrong. Probably found a new faction.
			return "error", nil, nil, nil, nil
		end
	end

	-- name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild, factionID, hasBonusRepGain, canBeLFGBonus = GetFactionInfoByID(factionID)
	local name, _, standingID, bottomValue, topValue, earnedValue = GetFactionInfoByID(Factions[factionName])
	return name, bottomValue, topValue, earnedValue, standingID
end

local function stringSplit(str)
	local table = {}
	local ix = 0
	for word in string.gmatch(str, "%S+") do
		table[ix] = word
		ix = ix + 1
	end

	return table
end

local function parseMsg(message)
	-- Message format: "Reputation with {%s} [increased|decreased] by %d."c
	local words = stringSplit(message)
	local name = words[2]
	local change = ""
	local delta = 0
	for ix = 3, #words do
		if words[ix] == "increased" or words[ix] == "decreased" then
			change = words[ix]
			delta = tonumber(words[ix+2]:sub(1, -2))
			break
		end
		name = name .. " " .. words[ix]
	end

	return name, change, delta
end

local function levelUpMsg(message)
	local name, change, delta = parseMsg(message)
	local changeColor = "|cFF42FF42+"
	if change == "decreased" then
		changeColor = "|cFFFF4242-"
	end
	local factionName, bottomValue, topValue, earnedValue, standingID = factionInfo(name)
	if factionName == "error" then
		return newFactionColor .. "New Faction! " .. textColor .. name .. " " .. changeColor .. delta
	end

	local deltaLeft = topValue-earnedValue
	local repStanding = getglobal("FACTION_STANDING_LABEL" .. standingID)
	local repColor = RepStandingColor[repStanding]
	local repNextStanding = getglobal("FACTION_STANDING_LABEL" .. standingID+1)
	local repNextColor = RepStandingColor[repNextStanding]

	local perTotal = 100-math.floor((earnedValue-bottomValue)*100/(topValue-bottomValue) + 0.5)
	if perTotal == 100 or perTotal == 0 then
		perTotal = tonumber(string.format("%.2f", 100-math.floor((earnedValue-bottomValue)*100/(topValue-bottomValue) * 100 + 0.5) / 100))
	end
	local perDelta = math.floor(delta * 100 / (topValue-bottomValue) * 10 + 0.5) / 10
	if perDelta == 0 then
		perDelta = tonumber(string.format("%.2f", math.floor(delta * 100 / (topValue-bottomValue) * 100 + 0.5) / 100))
	end

	-- local testString = "#color$factionName#color $delta ($perDelta) - #color$standing #colorwith $delta ($total) left to #color$nextStanding"
	local msg = ""
	if repStanding == "Exalted" then
		msg = textColor .. factionName .. textColor .. " - Reached " .. repColor .. repStanding
	else
		msg = textColor .. factionName .. " " ..  changeColor .. delta .. " (" .. perDelta .. "%) " .. textColor .. "- " .. repColor .. repStanding .. textColor .. " with " .. deltaLeft .. " (" .. perTotal .. "%) left to " .. repNextColor .. repNextStanding
	end
	return msg
end

local function replaceBlizzard(self, event, message, ...)
	return false, levelUpMsg(message), ...
end

-- local levelUpEvent = CreateFrame("Frame")
-- levelUpEvent:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE")
-- levelUpEvent:SetScript("OnEvent", levelUP)
ChatFrame_AddMessageEventFilter("CHAT_MSG_COMBAT_FACTION_CHANGE", replaceBlizzard)
local frame = CreateFrame("Frame")
frame:RegisterEvent("PLAYER_LOGIN")
frame:SetScript("OnEvent", function()
					loadFactions()
				end)