﻿--[[    xpNotify: Shows rested experience as a percentage.
--		    Author: Kadolar/Bollarian of Proudmoore & tapi0/Kaderc of Vashj.

(future features)
-----------------
* [request] Local translations of the TOC "Title" and "Notes" fields would be appreciated --
usEN: "xpNotify" / "Show rested XP percentage"
frFR:
deDE:
koKR:
zhCN:

7.3.5.01 2018/02/04 (current release)
---------------------
* Minor TOC update for latest patch.

7.2.0.01 2017/04/07
---------------------
* Bumped maximum level var to 110

7.0.3.01 2016/08/28
---------------------
* Minor TOC update for latest patch.

6.2.0.01 2015/09/08
---------------------
* Minor TOC update for latest patch.

6.0.3.2   2014/12/25
---------------------
* Minor TOC update for latest patch.
* Bumped maximum level var to 100

4.0.3.02   2011/01/07
---------------------
* Cataclysm lua errors fixed by Jim-Bim/urmelus.

4.0.3.01   2010/12/06
---------------------
* Minor TOC update for latest patch.
* Lots of Cataclysm lua errors fixed
* Bumped maximum level var to 85

3.3.0.02   2009/12/09
---------------------
* Minor TOC update for latest patch.

3.2.0.01   2009/09/21
---------------------
* Minor TOC update for latest patch.

3.1.0.08   2009/04/29
---------------------
* Minor TOC update for latest patch.

3.0.3.07   2008/12/16 
---------------------
* Minor update to fix version numbering
* Max level now matches WotLK, being 80 (you'd think I could probably find a function for this, eh?)

2.04.3.01  2008/10/09 
---------------------
* Rebuilt for 2.4.3 of WoW

1.12.0.05  2006/09/04
---------------------
* Added various styles to display message using mousewheel (not saved between sessions)
* Prevented repetition of status message when zoning, etc.
* No longer changes to 50% transparency when 150% rested XP
* UnregisterEvent code added, so  level 60 gameplay is 100% unaffected by xpNotify
* Added PLAYER_LEVEL_UP code to handle 59 -> 60

1.12.0.04  2006/08/24
---------------------
* Updated release for 1.12.0 of WoW
* Moved frame to a lower strata so it's behind bag panels, etc.
* Changed to use PLAYER_ENTERING_WORLD event for initialization

1.11.03  2006/08/21
-------------------
* Addon disables itself and frame hides when at maximum level (level 60 as of WoW 1.11)
* Frame 50% transparent when rested XP is at 0% or 150%
* Now uses 'Events' rather than polling: ultra-efficient!
* Now using GlobalStrings.lua - should work in all languages that are supported by WoW
* Better handling of less than 1% rested XP (instead of assuming it's zero)

1.11.02  2006/08/18
-------------------
* Polling rate slowed down for less CPU impact
* Minor wording changes

1.11.01  2006/08/17
-------------------
* Initial release for 1.11 of WoW

The following "GlobalStrings.lua" fields are used:
-------------------
TUTORIAL_TITLE26 = "Rested";
XP = "XP"; -- Abbreviation for "experience"
LEVEL = "Level"; -- Level of a monster, character or item
PERCENT_SYMBOL = "%%";
GAME_VERSION_LABEL = "Version"; -- generic version
ADDON_DISABLED = "Disabled";

]]--

--GLOBAL VARIABLES
xpNotify_msg_disabled = false;
xpNotify_debug = false;
xpNotify_max_level = 110;
xpNotify_StyleVerbose = 1;  -- Rested XP: 55%
xpNotify_StyleNormal = 2;   --        XP: 55%
xpNotify_StyleTerse = 3;    --            55%
xpNotify_StyleNumber = 4;   --            55
xpNotify_CurrentStyle = 1;

function xpNotify_OnLoad(self)
    self:RegisterForDrag("LeftButton");
    xpNotifyFrame:RegisterEvent("PLAYER_XP_UPDATE");
    xpNotifyFrame:RegisterEvent("UPDATE_EXHAUSTION");
    xpNotifyFrame:RegisterEvent("PLAYER_LEVEL_UP");
    xpNotifyFrame:RegisterEvent("PLAYER_LOGIN");
end

function xpNotify_Unload()
    xpNotifyFrame:UnregisterEvent("PLAYER_XP_UPDATE");
    xpNotifyFrame:UnregisterEvent("UPDATE_EXHAUSTION");
    xpNotifyFrame:UnregisterEvent("PLAYER_LEVEL_UP");
    xpNotifyFrame:UnregisterEvent("PLAYER_LOGIN");
    xpNotifyFrame:Hide();
    if( xpNotify_debug ) then DEFAULT_CHAT_FRAME:AddMessage("(xpn) events unregistered and frame hidden", 1, 1, 1); end
end

function xpNotify_OnEvent(self, event, ...)
    local arg1 = ...;
    if( xpNotify_debug ) then
        DEFAULT_CHAT_FRAME:AddMessage("(xpn) " .. event .. " fired.");
        if( xpNotify_msg_disabled ) then DEFAULT_CHAT_FRAME:AddMessage("(xpn) MsgDisabled(true)");
        else DEFAULT_CHAT_FRAME:AddMessage("(xpn) MsgDisabled(false)"); end
    end

    if( event == "PLAYER_XP_UPDATE" or event == "UPDATE_EXHAUSTION" ) then
        xpNotify_UpdateValue();
    elseif( event == "PLAYER_LEVEL_UP" ) then
        if( xpNotify_debug ) then DEFAULT_CHAT_FRAME:AddMessage("(xpn) levelled to " .. arg1, 1, 1, 1); end
        if( arg1 >= xpNotify_max_level ) then
            DEFAULT_CHAT_FRAME:AddMessage("xpNotify: " .. ADDON_DISABLED .. " - " .. SPELL_FAILED_HIGHLEVEL .. " (" .. LEVEL .. " " .. xpNotify_char_level .. ")", 1, 1, 1);
            xpNotify_Unload();
        end
    elseif( event == "PLAYER_LOGIN" ) then
        xpNotify_Initialize();
    end
end

function xpNotify_Initialize()
    local xpNotify_char_level = UnitLevel("player");
    local xpNotify_version = "xpNotify " .. GAME_VERSION_LABEL .. " 7.3.5.01";

    if( xpNotify_msg_disabled ) then
        return
    end
    if( xpNotify_char_level >= xpNotify_max_level ) then
        DEFAULT_CHAT_FRAME:AddMessage(xpNotify_version .. ": " .. ADDON_DISABLED .. " - " .. SPELL_FAILED_HIGHLEVEL .. " (" .. LEVEL .. " " .. xpNotify_char_level .. ")", 1, 1, 1);
        xpNotify_Unload();
    else
        DEFAULT_CHAT_FRAME:AddMessage(xpNotify_version .. " (" .. LEVEL .. " " .. xpNotify_char_level .. ")", 1, 1, 1);
        xpNotify_UpdateValue();
    end
    xpNotify_msg_disabled = true;
end

function xpNotify_UpdateValue()
    local xpNotify_rested_xp = GetXPExhaustion();
	local xpNotify_rested_xp_percent = 0;
	local frame_alpha = xpNotifyFrame:GetAlpha();

    if( xpNotify_rested_xp ~= nil ) then
        xpNotify_rested_xp_percent = math.floor((xpNotify_rested_xp/ UnitXPMax("player") )*100);
        if( xpNotify_rested_xp_percent == 0 ) then
            xpNotify_rested_xp_percent = 1;
        end
        if( frame_alpha < 1 ) then
            xpNotifyFrame:SetAlpha(1);
        end
    else
        if( frame_alpha ~= ".5" ) then
            xpNotifyFrame:SetAlpha(.5);
        end
    end

    if( xpNotify_debug ) then DEFAULT_CHAT_FRAME:AddMessage("(xpn) style is " .. xpNotify_CurrentStyle, 1, 1, 1); end
    if( xpNotify_CurrentStyle == xpNotify_StyleVerbose ) then
        xpNotifyText:SetText(string.format(TUTORIAL_TITLE26 .. " " .. XP .. ": " .. xpNotify_rested_xp_percent .. PERCENT_SYMBOL));
    elseif( xpNotify_CurrentStyle == xpNotify_StyleNormal ) then
        xpNotifyText:SetText(string.format(XP .. ": " .. xpNotify_rested_xp_percent .. PERCENT_SYMBOL));
    elseif( xpNotify_CurrentStyle == xpNotify_StyleTerse ) then
        xpNotifyText:SetText(string.format(xpNotify_rested_xp_percent .. PERCENT_SYMBOL));
    else
        xpNotifyText:SetText(xpNotify_rested_xp_percent);
    end

end

function xpNotify_MouseWheel(self, delta)
    if( xpNotify_debug ) then DEFAULT_CHAT_FRAME:AddMessage("(xpn) Mousewheel fired..."); end
    xpNotify_CurrentStyle = xpNotify_CurrentStyle + 1;
    if( xpNotify_CurrentStyle > 4 ) then xpNotify_CurrentStyle = xpNotify_CurrentStyle - 4; end
    xpNotify_UpdateValue();
end

function xpNotify_OnDragStart(self, button)
	xpNotifyFrame:StartMoving();
end

function xpNotify_OnDragStop(self)
	xpNotifyFrame:StopMovingOrSizing()
end
