npcGenerator = { }

NPCG            = NPCG            or { }
NPCG.Events     = NPCG.Events     or { }
NPCG.Interface  = NPCG.Interface  or { }
--NPCG.Options    = NPCG.Options    or { }

local characterTemplates = { }

function GetCurrentCharacterTemplate()
  return characterTemplates[npcGenerator_NPC_Frame.Tabs.CurrentTab]
end

function GetCharacterTemplateInTab(tabNumber)
  return characterTemplates[tabNumber]
end

function RemakeGenerator()
  remakeRaceGenerator()
  remakeTribeGenerator()
  remakeClassGenerator()
end

function SaveNPC(npc, saveSlot)

  local i = npcGenerator_NPC_Frame.Tabs.CurrentTab
  if not nilOrWhitespace(npc.name) then
    local npcName = npc.name
    savedNpcTemplates[saveSlot] = CharacterTemplate.clone(npc)
    npcGenerator_NPC_Frame.Tabs.ContextFrame:Hide()
  else
    npcGenerator_NPC_Frame.HelperMessageFrame:AddMessage("The npcs needs a name to be saved.", 1.00, 0.05,0.05, 1.0)
  end
  --print "The npc is not well defined, some vital traits are lacking"
end

function LoadNPC(npc)
  -- Current open tab.
  local frame = npcGenerator_NPC_Frame
  local n     = frame.Tabs.CurrentTab

  -- The npc parameter is a clone, not a reference, so we can simply link to that, instead of making a new clone.
  characterTemplates[n] = npc
  printToFrame(GetCurrentCharacterTemplate())
end

function DeleteNPC(index)
  table.remove(savedNpcTemplates, index)
end

function npcGenerator.OnLoad()
  print "Hello, this is your pocket gnome kindly asking you to report npcGenerator issues to our issue tracker at https://wow.curseforge.com/projects/npcgenerator/issues"
  table.insert(characterTemplates, CharacterTemplate:new())
  
  local frame = npcGenerator_NPC_Frame
  
  -- Set up the Labels correctly.
  frame.Title.Label:SetText(       "npcGenerator 1.2.4a")
  frame.Name.Label:SetText(        "Name")
  frame.Race.Label:SetText(        "Race")
  frame.Tribe.Label:SetText(       "Tribe")
  frame.Gender.Label:SetText(      "Gender")
  frame.Age.Label:SetText(         "Age")
  frame.Alignment.Label:SetText(   "Alignment")
  frame.Faith.Label:SetText(       "Faith")
  frame.Class.Label:SetText(       "Class")
  frame.Feature.Label:SetText(     "Prominent Feature")
  frame.Motivations.Label:SetText( "Motivations")
  
  -- Hook up events.
  
  -- OnChar scripts to load to characterTemplate.
  frame.Name.EditBox:SetScript(         "OnTextChanged", readName)
  frame.Race.EditBox:SetScript(         "OnTextChanged", readRace)
  frame.Tribe.EditBox:SetScript(        "OnTextChanged", readTribe)
  frame.Gender.EditBox:SetScript(       "OnTextChanged", readGender)
  frame.Age.EditBox:SetScript(          "OnTextChanged", readAge)
  frame.Alignment.EditBox:SetScript(    "OnTextChanged", readAlignment)
  frame.Faith.EditBox:SetScript(        "OnTextChanged", readFaith)
  frame.Class.EditBox:SetScript(        "OnTextChanged", readClass)
  frame.Feature.EditBox:SetScript(      "OnTextChanged", readFeature)
  frame.Motivations.EditBox1:SetScript( "OnTextChanged", function() readMotivation(1) end)
  frame.Motivations.EditBox2:SetScript( "OnTextChanged", function() readMotivation(2) end)
  frame.Motivations.EditBox3:SetScript( "OnTextChanged", function() readMotivation(3) end)
  
  -- OnClick scripts to reroll traits.
  frame.Name.RollButton:SetScript(         "OnClick", rollName)
  frame.Race.RollButton:SetScript(         "OnClick", rollRace)
  frame.Tribe.RollButton:SetScript(        "OnClick", rollTribe)
  frame.Gender.RollButton:SetScript(       "OnClick", rollGender)
  frame.Age.RollButton:SetScript(          "OnClick", rollAge)
  frame.Alignment.RollButton:SetScript(    "OnClick", rollAlignment)
  frame.Faith.RollButton:SetScript(        "OnClick", rollFaith)
  frame.Class.RollButton:SetScript(        "OnClick", rollClass)
  frame.Feature.RollButton:SetScript(      "OnClick", rollFeature)
  frame.Motivations.RollButton1:SetScript( "OnClick", function() rollMotivation(1) end )
  frame.Motivations.RollButton2:SetScript( "OnClick", function() rollMotivation(2) end )
  frame.Motivations.RollButton3:SetScript( "OnClick", function() rollMotivation(3) end )
  
  -- OnClick scripts to clear traits.
  frame.Name.ClearButton:SetScript(         "OnClick", clearName)
  frame.Race.ClearButton:SetScript(         "OnClick", clearRace)
  frame.Tribe.ClearButton:SetScript(        "OnClick", clearTribe)
  frame.Gender.ClearButton:SetScript(       "OnClick", clearGender)
  frame.Age.ClearButton:SetScript(          "OnClick", clearAge)
  frame.Alignment.ClearButton:SetScript(    "OnClick", clearAlignment)
  frame.Faith.ClearButton:SetScript(        "OnClick", clearFaith)
  frame.Class.ClearButton:SetScript(        "OnClick", clearClass)
  frame.Feature.ClearButton:SetScript(      "OnClick", clearFeature)
  frame.Motivations.ClearButton1:SetScript( "OnClick", function() clearMotivation(1) end )
  frame.Motivations.ClearButton2:SetScript( "OnClick", function() clearMotivation(2) end )
  frame.Motivations.ClearButton3:SetScript( "OnClick", function() clearMotivation(3) end )
  
  -- Hover messages, move these to Frames/npcFrame.lua (npcFrame_OnLoad)
  --local helperLabel = frame.HelperMessageFrame
  frame.Name.RollButton:SetScript(        "OnEnter", function(self) SetHelperText("Generate a new name", self)        end)
  frame.Race.RollButton:SetScript(        "OnEnter", function(self) SetHelperText("Generate a new race", self)        end)
  frame.Tribe.RollButton:SetScript(       "OnEnter", function(self) SetHelperText("Generate a new tribe", self)       end)
  frame.Gender.RollButton:SetScript(      "OnEnter", function(self) SetHelperText("Generate a new gender", self)      end)
  frame.Age.RollButton:SetScript(         "OnEnter", function(self) SetHelperText("Generate a new age", self)         end)
  frame.Alignment.RollButton:SetScript(   "OnEnter", function(self) SetHelperText("Generate a new alignment", self)   end)
  frame.Faith.RollButton:SetScript(       "OnEnter", function(self) SetHelperText("Generate a new faith", self)       end)
  frame.Class.RollButton:SetScript(       "OnEnter", function(self) SetHelperText("Generate a new class", self)       end)
  frame.Feature.RollButton:SetScript(     "OnEnter", function(self) SetHelperText("Generate a new feature", self)     end)
  frame.Motivations.RollButton1:SetScript("OnEnter", function(self) SetHelperText("Generate a new motivation", self)  end)
  frame.Motivations.RollButton2:SetScript("OnEnter", function(self) SetHelperText("Generate a new motivation", self)  end)
  frame.Motivations.RollButton3:SetScript("OnEnter", function(self) SetHelperText("Generate a new motivation", self)  end)
  
  frame.Name.ClearButton:SetScript(        "OnEnter", function(self) SetHelperText("Clear the name", self)        end)
  frame.Race.ClearButton:SetScript(        "OnEnter", function(self) SetHelperText("Clear the race", self)        end)
  frame.Tribe.ClearButton:SetScript(       "OnEnter", function(self) SetHelperText("Clear the tribe", self)       end)
  frame.Gender.ClearButton:SetScript(      "OnEnter", function(self) SetHelperText("Clear the gender", self)      end)
  frame.Age.ClearButton:SetScript(         "OnEnter", function(self) SetHelperText("Clear the age", self)         end)
  frame.Alignment.ClearButton:SetScript(   "OnEnter", function(self) SetHelperText("Clear the alignment", self)   end)
  frame.Faith.ClearButton:SetScript(       "OnEnter", function(self) SetHelperText("Clear the faith", self)       end)
  frame.Class.ClearButton:SetScript(       "OnEnter", function(self) SetHelperText("Clear the class", self)       end)
  frame.Feature.ClearButton:SetScript(     "OnEnter", function(self) SetHelperText("Clear the feature", self)     end)
  frame.Motivations.ClearButton1:SetScript("OnEnter", function(self) SetHelperText("Clear the motivation", self)  end)
  frame.Motivations.ClearButton2:SetScript("OnEnter", function(self) SetHelperText("Clear the motivation", self)  end)
  frame.Motivations.ClearButton3:SetScript("OnEnter", function(self) SetHelperText("Clear the motivation", self)  end)
  
  frame.Name:SetScript(        "OnEnter", function(self) SetHelperInfo("Name", 							self, "The name of the NPC is based on the Race and Gender traits")        end)
  frame.Race:SetScript(        "OnEnter", function(self) SetHelperInfo("Race", 							self, "The race of the NPC is picked from the playable and lorewise appropriate races. Location and faction decide the outcome of this trait, but these dependencies can be changed in the options") end)
  frame.Tribe:SetScript(       "OnEnter", function(self) SetHelperInfo("Tribe", 						self, "The tribe or subrace of the NPC and it's meaning depend on the race of the NPC. Location and faciton play a part in deciding on this trait, but this can be modified in the options.") end)
  frame.Gender:SetScript(      "OnEnter", function(self) SetHelperInfo("Gender", 						self, "The gender of the NPC is either male, female or androgynous (being hard to determine the gender on, or having both masculine and feminine characteristics") end)
  frame.Age:SetScript(         "OnEnter", function(self) SetHelperInfo("Age", 							self, "The age of the NPC described in approximations rather than years, as the meaning of these vary per race") end)
  frame.Alignment:SetScript(   "OnEnter", function(self) SetHelperInfo("Alignment", 				self, "The alignment of the NPC, based on \"DND\" alignments, describing the way the NPC is expected to act") end)
  frame.Faith:SetScript(       "OnEnter", function(self) SetHelperInfo("Faith", 						self, "The religion or faith that drives the npc.") end)
  frame.Class:SetScript(       "OnEnter", function(self) SetHelperInfo("Class", 						self, "The class of the NPC indicates the job for the NPC. This includes the playable classes (excluding Death Knight and Demon Hunter, which function more like races) and also includes other possible jobs") end)
  frame.Feature:SetScript(     "OnEnter", function(self) SetHelperInfo("Prominent Feature", self, "Something that immediately stands out for the NPC. It can be considered as a hook for observers to react on") end)
  frame.Motivations:SetScript( "OnEnter", function(self) SetHelperInfo("Motivations", 			self, "Motivations that drive the NPC. (This is under redesign)") end)
  
  -- Hook onto Tab Changes.
  -- frame.Tabs.OnTabAdded is protected! Awyzuu set up events to overwrite and npcFrame.xml uses this...
  frame.Tabs.OnTabChanged = function(tabIndex)
    if tabIndex > table.getn(characterTemplates) then -- Workaround for the above.  
      table.insert(characterTemplates, CharacterTemplate:new())
    end
    printToFrame(characterTemplates[tabIndex]) 
    end
  frame.Tabs.OnTabRemoved = function(tabIndex)
    table.remove(characterTemplates, tabIndex)
  end

  frame.Tabs.ContextFrame:SetScript("OnShow", function(self)
    local ContextFrameTitle = ""
    if nilOrWhitespace(characterTemplates[self.GetTabIndex()]:getName()) then
      ContextFrameTitle = "Unamed npc " .. self.GetTabIndex()
      frame.Tabs.ContextFrame.SaveButton:Disable()
      frame.Tabs.ContextFrame.SaveButton.Text:SetTextColor("0.5", "0.5", "0.5", "1.0")
    elseif frame.Tabs.ContextFrame.GetTabIndex() ~= frame.Tabs.CurrentTab then
      ContextFrameTitle = characterTemplates[self.GetTabIndex()]:getName()
      frame.Tabs.ContextFrame.SaveButton:Disable()
      frame.Tabs.ContextFrame.SaveButton.Text:SetTextColor("0.5", "0.5", "0.5", "1.0")
    else
      ContextFrameTitle = characterTemplates[self.GetTabIndex()]:getName()
      frame.Tabs.ContextFrame.SaveButton:Enable()
      frame.Tabs.ContextFrame.SaveButton.Text:SetTextColor("1.0", "0.82", "0.0", "1.0")
    end
    
    self["Label"]:SetText(ucWords(ContextFrameTitle))
  end)
  
  frame.Tabs.ContextFrame.LoadButton:SetScript("OnClick", function()
    npcGenerator_Load_Frame:Show()
    frame.Tabs.ContextFrame:Hide()
  end)
  frame.BottomBar.LoadButton:SetScript("OnClick", function() npcGenerator_Load_Frame:Show() end)
  
  local onSaveClicked = function()
    if not nilOrWhitespace(GetCurrentCharacterTemplate().name) then
      npcGenerator_Save_Frame:Show()
    else
      npcGenerator_NPC_Frame.HelperMessageFrame:AddMessage("The npcs needs a name to be saved.", 1.00, 0.05,0.05, 1.0)
    end
    npcGenerator_NPC_Frame.Tabs.ContextFrame:Hide()
  end
  
  frame.Tabs.ContextFrame.SaveButton:SetScript("OnClick", onSaveClicked)
  frame.BottomBar.SaveButton:SetScript(        "OnClick", onSaveClicked)
  
  local onTribeSet = function()
    local tribeContext = getTribeContext(GetCurrentCharacterTemplate():getRace())
    local hasTribe = not nilOrWhitespace(tribeContext)
    
    if not hasTribe then
      frame.Tribe.Label:SetTextColor(0.5, 0.5, 0.5)
      frame.Tribe.Label:SetText("Tribe")
      frame.Tribe.EditBox:SetTextColor(0.5, 0.5, 0.5)
      frame.Tribe.EditBox:SetText("")
      frame.Tribe.EditBox:Disable()
      frame.Tribe.RollButton:Disable()
    else
      frame.Tribe.EditBox:SetTextColor(1.0, 1.0, 1.0)
      frame.Tribe.EditBox:Enable()
      frame.Tribe.EditBox:SetText("")
      frame.Tribe.Label:SetTextColor(1.0, 1.0, 1.0)
      frame.Tribe.Label:SetText(tribeContext)
      frame.Tribe.RollButton:Enable()
    end
    
    
  end
  
  local createDepencencyOn = function(item, listOfDependancies)
    local allRequirementsMet = function() return
      all(function(req) return
        not nilOrWhitespace(frame[req].EditBox:GetText()) end,
        listOfDependancies)
    end
    
    local enable = function(uiElement)
      if uiElement ~= "Motivation" then
        --[[frame[uiElement].Label:SetTextColor(    1.0, 1.0, 1.0)
        frame[uiElement].EditBox:Enable()
        frame[uiElement].EditBox:SetTextColor(  1.0, 1.0, 1.0)]]
        frame[uiElement].RollButton:Enable()
      else
        frame.Motivations.Label:SetTextColor( 1.0, 1.0, 1.0)
        iterate(function(i)
          --frame.Motivations["EditBox"    .. i]:Enable()
          --frame.Motivations["EditBox"    .. i]:SetTextColor(  1.0, 1.0, 1.0)
          frame.Motivations["RollButton" .. i]:Enable()
          end,
          1,
          3
        )
      end
    end
    
    local disable = function(uiElement)
      if uiElement ~= "Motivation" then
        --[[frame[uiElement].Label:SetTextColor(    0.5, 0.5, 0.5)
        frame[uiElement].EditBox:Disable()
        frame[uiElement].EditBox:SetText("")
        frame[uiElement].EditBox:SetTextColor(  0.5, 0.5, 0.5)]]
        frame[uiElement].RollButton:Disable()
      else
        --frame.Motivations.Label:SetTextColor(   0.5, 0.5, 0.5)
        iterate(function(i)
          --[[frame.Motivations["EditBox"    .. i]:Disable()
          frame.Motivations["EditBox"    .. i]:SetText("")
          frame.Motivations["EditBox"    .. i]:SetTextColor(  0.5, 0.5, 0.5)]]
          frame.Motivations["RollButton" .. i]:Disable()
          end,
          1,
          3
        )
      end
    end
    
    forEach(function(dep)
      frame[dep].EditBox:HookScript("OnTextChanged", function()
          if allRequirementsMet() then enable(item) else disable(item) end
        end) end,
      listOfDependancies
    )
  end
  
  createDepencencyOn("Faith",   { "Alignment" })
  createDepencencyOn("Feature", { "Race", "Class", "Gender", "Age" })
  createDepencencyOn("Class",   { "Race", "Age", "Faith" })
  --createDepencencyOn("Name",    { "Race" })
  createDepencencyOn("Motivation", { "Race", "Class", "Age", "Faith", "Gender", "Alignment" })
  
  frame.Race.EditBox:SetScript("OnEditFocusLost", onTribeSet)
  frame.Race.EditBox:SetScript("OnTextSet",       onTribeSet)
  frame.Race.EditBox:HookScript("OnTextChanged", function()
    if nilOrWhitespace(frame.Race.EditBox:GetText()) then frame.Name.RollButton:Disable() else frame.Name.RollButton:Enable() end
  end)
  frame.Name.RollButton:Disable()
  frame.BottomBar.ClearButton:Disable()
  frame.BottomBar.PrintButton:Disable()
  frame.BottomBar.SaveButton:Disable()
  --frame:HookScript("OnShow", function() frame.HelperMessageFrame:AddMessage("Press Generate to make an npc") end)

  onTribeSet()
end

function NPCG.Events.OnAddonLoad()
  if savedNpcTemplates == nil then
    savedNpcTemplates = { }
  end
  if NPCG_Options == nil then
    NPCG_Options = { 
      debug="false", 
      --raceSettings={ 
      --  factionMatchingMode="Context-based" }, 
      --tribeSettings={
      --  factionMatchingMode="Context-based" },
      safeMode="false",
      factionSettings={
        matching = true,
        context  = true,
      },
      locationSettings={
        zones    = true,
        subZones = true,
        mock     = false,
        mockZone = "",
        mockSub  = false,
        mockSubZone = "",
      },
      friendSettings={
        friends  = true,
      },
			interface={
				minimapPosition = 45, -- Position in deg, ccw.
				displayMinimapButton = true,
				enableTooltips = true,
			},
    }  
  else
    NPCG_Options.debug         = NPCG_Options.debug         or "false"
    NPCG_Options.factionSettings  = NPCG_Options.factionSettings  or { }
    if NPCG_Options.factionSettings.matching  == nil then NPCG_Options.factionSettings.matching  = true end
    if NPCG_Options.factionSettings.context   == nil then NPCG_Options.factionSettings.context   = true end
    NPCG_Options.locationSettings = NPCG_Options.locationSettings or { }
    if NPCG_Options.locationSettings.zones    == nil then NPCG_Options.locationSettings.zones    = true end
    if NPCG_Options.locationSettings.subZones == nil then NPCG_Options.locationSettings.subZones = true end
    if NPCG_Options.locationSettings.mock     == nil then NPCG_Options.locationSettings.mock     = true end
    NPCG_Options.locationSettings.mockZone    = NPCG_Options.locationSettings.mockZone or ""
    if NPCG_Options.locationSettings.mockSub  == nil then NPCG_Options.locationSettings.mockSub  = true end
    NPCG_Options.locationSettings.mockSubZone = NPCG_Options.locationSettings.mockSubZone or ""
    NPCG_Options.friendSettings   = NPCG_Options.friendSettings   or { }
    if NPCG_Options.friendSettings.friends    == nil then NPCG_Options.friendSettings.friends    = false end
    if NPCG_Options.raceSettings  ~= nil then
      NPCG_Options.raceSettings = nil
    end
    if NPCG_Options.tribeSettings  ~= nil then
      NPCG_Options.tribeSettings = nil
    end
		if NPCG_Options.interface == nil then
			NPCG_Options.interface = { }
		end
		NPCG_Options.interface.minimapPosition 			= NPCG_Options.interface.minimapPosition or 45
		if NPCG_Options.interface.displayMinimapButton == nil then
			NPCG_Options.interface.displayMinimapButton = true
		end

    NPCG_Options.safeMode      = NPCG_Options.safeMode      or "false"
  end

  NPCG.LoadOptions()
  --remakeRaceGenerator()  -- This will bite me later, won't it..?
  --remakeTribeGenerator() -- It already is, isn't it..?
  --remakeClassGenerator() -- It definitely is...
  RemakeGenerator()
  if not (NPCG_Options.locationSettings.zones and NPCG_Options.locationSettings.mock) then
    npcGenerator_settings_Frame.Panel.MockZoneEditBox:Disable()
    npcGenerator_settings_Frame.Panel.MockZoneEditBox:SetTextColor(0.5, 0.5, 0.5)
  end
  
  if not (NPCG_Options.locationSettings.zones and NPCG_Options.locationSettings.subZones and NPCG_Options.locationSettings.mockSub) then
    npcGenerator_settings_Frame.Panel.MockSubZoneEditBox:Disable()
    npcGenerator_settings_Frame.Panel.MockSubZoneEditBox:SetTextColor(0.5, 0.5, 0.5)
  end
	
	-- Reposition the Minimap Button
	npcGenerator_Minimap_Button_OnAddonLoaded()
  
  -- Until Friends are implemented:
  npcGenerator_settings_Frame.Panel.FriendsButton:SetTextColor(0.5, 0.5, 0.5)
  npcGenerator_settings_Frame.Panel.FriendsButton:Disable()
	
end

function NPCG.Events.OnAddonUnload()
  
end

local eventFrame = CreateFrame("FRAME")

eventFrame:RegisterEvent("ADDON_LOADED")
eventFrame:RegisterEvent("PLAYER_LOGOUT")

function eventFrame.OnEvent(unusedArg, event, name)
  if name == "npcGenerator" then
    if     event == "ADDON_LOADED"  then NPCG.Events.OnAddonLoad()
    elseif event == "PLAYER_LOGOUT" then NPCG.Events.OnAddonUnload() end
  end
end
eventFrame:SetScript("OnEvent", eventFrame.OnEvent)
-- End of File.