CharacterTemplate = {
  age         = "",
  alignment   = "",
  class       = "",
  faith       = "",
  feature     = "",
  gender      = "",
  name        = "",
  race        = "",
  tribe       = "",
  
  motivations = nil
}

CharacterTemplate.getAge        = function(self)    return self.age                end
CharacterTemplate.getAlignment  = function(self)    return self.alignment          end
CharacterTemplate.getClass      = function(self)    return self.class              end
CharacterTemplate.getFaith      = function(self)    return self.faith              end
CharacterTemplate.getFeature    = function(self)    return self.feature            end
CharacterTemplate.getGender     = function(self)    return self.gender             end
CharacterTemplate.getName       = function(self)    return self.name               end
CharacterTemplate.getRace       = function(self)    return self.race               end
CharacterTemplate.getTribe      = function(self)    return self.tribe              end
CharacterTemplate.getMotivation = function(self, i) return self.motivations[i]     end

CharacterTemplate.setAge        = function(self, x)        self.age = x            end
CharacterTemplate.setAlignment  = function(self, x)        self.alignment = x      end
CharacterTemplate.setClass      = function(self, x)        self.class = x          end
CharacterTemplate.setFaith      = function(self, x)        self.faith = x          end
CharacterTemplate.setFeature    = function(self, x)        self.feature = x        end
CharacterTemplate.setGender     = function(self, x)        self.gender = x         end
CharacterTemplate.setName       = function(self, x)        self.name = x           end
CharacterTemplate.setRace       = function(self, x)        self.race = x           end
CharacterTemplate.setTribe      = function(self, x)        self.tribe = x          end
CharacterTemplate.setMotivation = function(self, i, x)
  if     i == 1
  then   self.motivations[1] = x
  elseif i == 2
  then   if     self.motivations[1] == ""
         then   self.motivations[1] = x
         else   self.motivations[2] = x end
  else   if     self.motivations[1] == ""
         then   self.motivations[1] = x
         elseif self.motivations[2] == ""
         then   self.motivations[2] = x
                self.motivations[3] = ""
         else   self.motivations[3] = x end
  end
end
CharacterTemplate.setMotivations = function(self, xs)
  self.motivations[1] = xs[1]
  self.motivations[2] = xs[2]
  self.motivations[3] = xs[3]
end

function CharacterTemplate:clear()
  self:setAge("")
  self:setAlignment("")
  self:setClass("")
  self:setFaith("")
  self:setFeature("")
  self:setGender("")
  self:setMotivations({ "", "", "" })
  self:setName("")
  self:setRace("")
  self:setTribe("")
end

function CharacterTemplate:clone()
  local newTemplate = CharacterTemplate:new()
  --[[
  newTemplate:setAge(self:getAge())
  newTemplate:setAlignment(self:getAlignment())
  newTemplate:setClass(self:getClass())
  newTemplate:setFaith(self:getFaith())
  newTemplate:setFeature(self:getFeature())
  newTemplate:setGender(self:getGender())
  newTemplate:setMotivations({ self:getMotivation(1), self:getMotivation(2), self:getMotivation(3) })
  newTemplate:setName(self:getName())
  newTemplate:setRace(self:getRace())
  newTemplate:setTribe(self:getTribe())
  ]]
  newTemplate[      "age"] = self[      "age"]
  newTemplate["alignment"] = self["alignment"]
  newTemplate[    "class"] = self[    "class"]
  newTemplate[    "faith"] = self[    "faith"]
  newTemplate[  "feature"] = self[  "feature"]
  newTemplate[   "gender"] = self[   "gender"]
  newTemplate[     "name"] = self[     "name"]
  newTemplate[     "race"] = self[     "race"]
  newTemplate[    "tribe"] = self[    "tribe"]
  
  newTemplate["motivations"] = map(id, self["motivations"])
  
  return newTemplate
end

function CharacterTemplate:isEmpty()
  return
    self[      "age"] == "" and
    self["alignment"] == "" and
    self[    "class"] == "" and
    self[    "faith"] == "" and
    self[  "feature"] == "" and
    self[   "gender"] == "" and
    self[     "name"] == "" and
    self[     "race"] == "" and
    self[    "tribe"] == "" and
    all(function(motivation) return motivation == "" end, self["motivations"])
end

function CharacterTemplate:new()
  local instance = { }
  setmetatable(instance, self)
  self.__index = self
  instance.motivations = { "", "", "" }
  return instance
end

function CharacterTemplate:log()
  print("Name: "      .. self.name)
  print("Race: "      .. self.tribe .. " " .. self.race .. " " .. self.class)
  print("Age: "       .. self.age)
  print("Gender: "    .. self.gender)
  print("Alignment: " .. self.alignment)
  print("Faith: "     .. self.faith)
  print("Motivations: ")
  logTable(self.motivations)
end

