local races = { }
races[   "blood elf"] = { raceTypes = {      "horde",                          "civilized",           "elven", "magic"              } }
races["death knight"] = { raceTypes = {                             "neutral"                                                       } }
races[     "draenei"] = { raceTypes = {               "alliance",                           "tribal"                                } }
races[       "dwarf"] = { raceTypes = {               "alliance",              "civilized"                                          } }
races[       "gnome"] = { raceTypes = {               "alliance",              "civilized",                    "magic"              } }
races[      "goblin"] = { raceTypes = {      "horde",                                                                               } }
races[    "half elf"] = { raceTypes = {      "horde", "alliance",   "neutral", "civilized",           "elven", "magic", "halfbreed" } }
races[    "half orc"] = { raceTypes = {      "horde", "alliance",   "neutral", "civilized", "tribal",                   "halfbreed" } }
races[    "high elf"] = { raceTypes = {               "alliance",              "civilized",           "elven", "magic"              } }
races[       "human"] = { raceTypes = {               "alliance",              "civilized",                    "magic"              } }
races[   "night elf"] = { raceTypes = {               "alliance",              "civilized",           "elven"                       } }
races[         "orc"] = { raceTypes = {      "horde",                                       "tribal"                                } }
races[    "pandaren"] = { raceTypes = {      "horde", "alliance",   "neutral"                                                       } }
races[      "tauren"] = { raceTypes = {      "horde",                                       "tribal"                                } }
races[       "troll"] = { raceTypes = {      "horde",                                       "tribal"                                } }
races[      "undead"] = { raceTypes = {      "horde",                          "civilized"                                          } }
races[      "worgen"] = { raceTypes = {               "alliance",              "civilized"                                          } }

---------------------------------------------------------------------------------------------------------------------------------------
-- | Queries | ------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------



---------------------------------------------------------------------------------------------------------------------------------------
-- | Zone-based Generation | ----------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------
zonesToRaces = { }
-- Legion Zones
zonesToRaces[          "Dalaran"] = mergeTables(-- This works for both versions :D
	replicate( 5,      "blood elf"),
	replicate( 4,         "goblin"),
	replicate( 1,            "orc"),
	replicate( 1,         "tauren"),
	replicate( 1,          "troll"),
	replicate( 5,         "undead"),
  replicate( 1,        "draenei"),
	replicate( 5,          "dwarf"),
	replicate( 8,          "gnome"),
	replicate( 2,       "half elf"),
	replicate( 1,       "half orc"),
	replicate(10,       "high elf"),
	replicate(10,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 2,      "night elf"),
	replicate( 5,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[           "Azsuna"] = mergeTables(
	replicate( 1,      "blood elf"),
	replicate( 1,         "goblin"),
	replicate( 1,            "orc"),
	replicate( 1,         "tauren"),
	replicate( 1,          "troll"),
	replicate( 1,         "undead"),
  replicate( 1,        "draenei"),
	replicate( 1,          "dwarf"),
	replicate( 1,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 1,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 3,      "night elf"),
	replicate( 1,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[     "Highmountain"] = mergeTables(
	replicate( 1,      "blood elf"),
	replicate( 2,         "goblin"),
	replicate( 2,            "orc"),
	replicate(30,         "tauren"),
	replicate( 1,          "troll"),
	replicate( 1,         "undead"),
  replicate( 1,        "draenei"),
	replicate( 3,          "dwarf"),
	replicate( 2,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 2,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 2,      "night elf"),
	replicate( 2,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[    "Thunder Totem"] = mergeTables(  -- Yes, this counts as a separate zone. It should have higher amount of Tauren than the other parts of Highmountain.
	replicate( 1,      "blood elf"),
	replicate( 1,         "goblin"),
	replicate( 1,            "orc"),
	replicate(40,         "tauren"),
	replicate( 1,          "troll"),
	replicate( 1,         "undead"),
  replicate( 1,        "draenei"),
	replicate( 1,          "dwarf"),
	replicate( 1,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 1,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 1,      "night elf"),
	replicate( 1,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[        "Stormheim"] = mergeTables(
	replicate( 2,      "blood elf"),
	replicate( 4,         "goblin"),
	replicate( 2,            "orc"),
	replicate( 2,         "tauren"),
	replicate( 2,          "troll"),
	replicate(15,         "undead"),
  replicate( 2,        "draenei"),
	replicate( 2,          "dwarf"),
	replicate( 2,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 2,          "human"), -- This might be increases when Vrykul are added as racial synonym.
	replicate( 1,       "pandaren"),
	replicate( 2,      "night elf"),
	replicate(15,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[          "Suramar"] = mergeTables(
	replicate( 2,      "blood elf"),
	replicate( 2,         "goblin"),
	replicate( 2,            "orc"),
	replicate( 2,         "tauren"),
	replicate( 2,          "troll"),
	replicate( 2,         "undead"),
  replicate( 2,        "draenei"),
	replicate( 2,          "dwarf"),
	replicate( 2,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 2,       "high elf"),
	replicate( 2,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 8,      "night elf"),
	replicate( 2,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[       "Val'sharah"] = mergeTables(
	replicate( 1,      "blood elf"),
	replicate( 1,         "goblin"),
	replicate( 1,            "orc"),
	replicate( 5,         "tauren"),
	replicate( 2,          "troll"),
	replicate( 1,         "undead"),
  replicate( 1,        "draenei"),
	replicate( 1,          "dwarf"),
	replicate( 1,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 3,          "human"),
	replicate( 1,       "pandaren"),
	replicate(30,      "night elf"),
	replicate( 2,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[     "Broken Shore"] = mergeTables(
	replicate( 2,      "blood elf"),
	replicate( 2,         "goblin"),
	replicate( 2,            "orc"),
	replicate( 2,         "tauren"),
	replicate( 2,          "troll"),
	replicate( 2,         "undead"),
  replicate( 2,        "draenei"),
	replicate( 2,          "dwarf"),
	replicate( 2,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 2,       "high elf"),
	replicate( 2,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 2,      "night elf"),
	replicate( 2,         "worgen"),
  replicate( 2,   "death knight"))
  
-- Horde Cities
zonesToRaces[  "Silvermoon City"] = mergeTables(
	replicate(41,      "blood elf"),
	replicate( 1,         "goblin"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,            "orc"),
	replicate( 1,       "pandaren"),
	replicate( 1,         "tauren"),
	replicate( 1,          "troll"),
	replicate( 2,         "undead"),
  replicate( 1,   "death knight"))
zonesToRaces[        "Orgrimmar"] = mergeTables(
	replicate( 1,      "blood elf"),
	replicate( 4,         "goblin"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate(22,            "orc"),
	replicate( 1,       "pandaren"),
	replicate( 3,         "tauren"),
	replicate( 4,          "troll"),
	replicate( 1,         "undead"),
  replicate( 1,   "death knight"))
zonesToRaces[    "Thunder Bluff"] = mergeTables(
	replicate( 1,      "blood elf"),
	replicate( 1,         "goblin"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 4,            "orc"),
	replicate( 1,       "pandaren"),
	replicate(19,         "tauren"),
	replicate( 1,          "troll"),
	replicate( 1,         "undead"),
  replicate( 1,   "death knight"))
zonesToRaces[        "Undercity"] = mergeTables(
	replicate( 2,      "blood elf"),
  replicate( 4,   "death knight"),
	replicate( 1,         "goblin"),
	replicate( 1,       "half elf"),
	replicate( 1,            "orc"),
	replicate( 1,       "pandaren"),
	replicate( 1,         "tauren"),
	replicate( 1,          "troll"),
	replicate(19,         "undead"),
  replicate( 1,   "death knight"))

-- Alliance Cities
zonesToRaces[   "Stormwind City"] = mergeTables(
  replicate( 1,        "draenei"),
	replicate( 5,          "dwarf"),
	replicate( 2,          "gnome"),
	replicate( 3,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 3,       "high elf"),
	replicate(20,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 2,      "night elf"),
	replicate( 1,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[        "Darnassus"] = mergeTables(
  replicate( 4,        "draenei"),
	replicate( 1,          "dwarf"),
	replicate( 1,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 2,          "human"),
	replicate( 1,       "pandaren"),
	replicate(24,      "night elf"),
	replicate( 8,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces["City of Ironforge"] = mergeTables(
  replicate( 1,        "draenei"),
	replicate(12,          "dwarf"),
	replicate( 6,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 4,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 1,      "night elf"),
	replicate( 1,         "worgen"),
  replicate( 1,   "death knight"))
zonesToRaces[       "The Exodar"] = mergeTables(
  replicate(21,        "draenei"),
	replicate( 1,          "dwarf"),
	replicate( 1,          "gnome"),
	replicate( 1,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,       "high elf"),
	replicate( 1,          "human"),
	replicate( 1,       "pandaren"),
	replicate( 1,      "night elf"),
	replicate( 1,         "worgen"),
  replicate( 1,   "death knight"))

-- Neutral Hotspots
zonesToRaces[   "Shattrath City"] = nil

-- Horde Starting Zones (for now they are similar to the capitals next to them)
zonesToRaces[          "Durotar"] = zonesToRaces["Orgrimmar"]
zonesToRaces[   "Eversong Woods"] = zonesToRaces["Silvermoon City"]
zonesToRaces[       "Ghostlands"] = mergeTables(
  replicate(22,      "blood elf"),
	replicate( 1,         "goblin"),
	replicate( 2,       "half elf"),
	replicate( 1,       "half orc"),
	replicate( 1,            "orc"),
	replicate( 1,       "pandaren"),
	replicate( 1,         "tauren"),
	replicate( 1,          "troll"),
	replicate( 6,         "undead"),
  replicate( 1,   "death knight"))
zonesToRaces[          "Mulgore"] = zonesToRaces["Thunder Bluff"]
zonesToRaces[  "Sunstrider Isle"] = zonesToRaces["Eversong Woods"]
zonesToRaces[  "Tirisfal Glades"] = zonesToRaces["Undercity"]


-- Alliance Starting Zones (for now they are similar to the capitals next to them)
zonesToRaces[   "Azuremyst Isle"] = zonesToRaces["The Exodar"]
zonesToRaces[       "Dun Morogh"] = zonesToRaces["City of Ironforge"]
zonesToRaces[    "Elwynn Forest"] = zonesToRaces["Stormwind City"]
zonesToRaces[       "Teldrassil"] = zonesToRaces["Darnassus"]

--zonesToRaces[   "Shattrath City"] = nil

-- Class Order Halls (Only the zone based ones)
zonesToRaces[   "Trueshot Lodge"] = mergeTables(
  replicate( 1,      "blood elf"),
  replicate( 1,        "draenei"),
  replicate( 1,          "dwarf"),
  replicate( 1,          "gnome"),
  replicate( 1,         "goblin"),
  replicate( 1,          "human"),
  replicate( 1,      "night elf"),
  replicate( 1,            "orc"),
  replicate( 1,       "pandaren"),
  replicate( 1,         "tauren"),
  replicate( 1,          "troll"),
  replicate( 1,         "undead"),
  replicate( 1,         "worgen"))

zonesToRaces[          "Default"] = keys(races) -- Will later be map(const(1), races)

---------------------------------------------------------------------------------------------------------------------------------------
-- | Subzone-based Generation | -------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

subzonesToRaces = {
  ["Orgrimmar"]   = {
    ["Valley of Honor"]     = mergeTables(
      replicate(9, "orc"),
      replicate(3, "pandaren"),
      replicate(2, "goblin"),
      replicate(2, "tauren"),
      { "blood elf", "undead", "half elf", "half orc" }
    ),
  },
  ["Val'sharah"]  = {
    ["Bradensbrook"]        = mergeTables(
      replicate( 1,      "blood elf"),
      replicate( 1,         "goblin"),
      replicate( 1,            "orc"),
      replicate( 3,         "tauren"),
      replicate( 2,          "troll"),
      replicate( 1,         "undead"),
      replicate( 1,        "draenei"),
      replicate( 1,          "dwarf"),
      replicate( 1,          "gnome"),
      replicate( 1,       "half elf"),
      replicate( 1,       "half orc"),
      replicate( 1,       "high elf"),
      replicate(20,          "human"),
      replicate( 1,       "pandaren"),
      replicate( 5,      "night elf"),
      replicate( 2,         "worgen"),
      replicate( 1,   "death knight")
    ),
    ["Marl's Stead"]        = mergeTables(
      replicate( 1,      "blood elf"),
      replicate( 1,         "goblin"),
      replicate( 1,            "orc"),
      replicate( 3,         "tauren"),
      replicate( 2,          "troll"),
      replicate( 1,         "undead"),
      replicate( 1,        "draenei"),
      replicate( 1,          "dwarf"),
      replicate( 1,          "gnome"),
      replicate( 1,       "half elf"),
      replicate( 1,       "half orc"),
      replicate( 1,       "high elf"),
      replicate(20,          "human"),
      replicate( 1,       "pandaren"),
      replicate( 5,      "night elf"),
      replicate( 2,         "worgen"),
      replicate( 1,   "death knight")
    ),
    ["Carlisle Cottage"]    = mergeTables(
      replicate( 1,      "blood elf"),
      replicate( 1,         "goblin"),
      replicate( 1,            "orc"),
      replicate( 3,         "tauren"),
      replicate( 2,          "troll"),
      replicate( 1,         "undead"),
      replicate( 1,        "draenei"),
      replicate( 1,          "dwarf"),
      replicate( 1,          "gnome"),
      replicate( 1,       "half elf"),
      replicate( 1,       "half orc"),
      replicate( 1,       "high elf"),
      replicate(20,          "human"),
      replicate( 1,       "pandaren"),
      replicate( 5,      "night elf"),
      replicate( 2,         "worgen"),
      replicate( 1,   "death knight")
    ),
    ["Heathrow Manor"]      = mergeTables(
      replicate( 1,      "blood elf"),
      replicate( 1,         "goblin"),
      replicate( 1,            "orc"),
      replicate( 3,         "tauren"),
      replicate( 2,          "troll"),
      replicate( 1,         "undead"),
      replicate( 1,        "draenei"),
      replicate( 1,          "dwarf"),
      replicate( 1,          "gnome"),
      replicate( 1,       "half elf"),
      replicate( 1,       "half orc"),
      replicate( 1,       "high elf"),
      replicate(20,          "human"),
      replicate( 1,       "pandaren"),
      replicate( 5,      "night elf"),
      replicate( 2,         "worgen"),
      replicate( 1,   "death knight")
    ),
    ["Thornton's Cottage"]  = mergeTables(
      replicate( 1,      "blood elf"),
      replicate( 1,         "goblin"),
      replicate( 1,            "orc"),
      replicate( 3,         "tauren"),
      replicate( 2,          "troll"),
      replicate( 1,         "undead"),
      replicate( 1,        "draenei"),
      replicate( 1,          "dwarf"),
      replicate( 1,          "gnome"),
      replicate( 1,       "half elf"),
      replicate( 1,       "half orc"),
      replicate( 1,       "high elf"),
      replicate(20,          "human"),
      replicate( 1,       "pandaren"),
      replicate( 5,      "night elf"),
      replicate( 2,         "worgen"),
      replicate( 1,   "death knight")

    ),
  },
}

---------------------------------------------------------------------------------------------------------------------------------------
-- | Functions for Generation and Retrieval | -----------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

-- Main generator should be CharacterTemplate -> { Trait }
-- This will later change to be CharacterTemplate -> { Trait, weight } or something similar.

-- Part 1: Get potential candidates
-- Part 2: Weed out unfeasable candidates, like those not within context or faction
-- Part 3: Select a random item

---------------------------------------------------------------------------------------------------------------------------------------
---- | Part 1 Functions: Generation | -------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

local function checkAllLocations(zone, subZone)
  --print("Zone: " .. (zone or "") .. ", subZone: " .. (subZone or ""))
  return 
    -- Test whether the SubZone has values.
    ((subzonesToRaces[zone] or { })[subZone])
    -- Test whether the Zone has values.
    or zonesToRaces[zone]
    -- Fallback to default.
    or zonesToRaces["Default"]
    -- Fallback in case some extreme breaking happened.
    or { }
end

local function checkZonesOnly(zone)
  return
    -- Test whether the Zone has values.
    zonesToRaces[zone]
    -- Fallback to default.
    or zonesToRaces["Default"]
    -- Fallback in case some extreme breaking happened.
    or { }
end

local function dontCheckLocations()
  return
    -- Fallback to default.
    zonesToRaces["Default"]
    -- Fallback in case some extreme breaking happened.
    or { }
end

---------------------------------------------------------------------------------------------------------------------------------------
---- | Part 2 Functions: Filtering | --------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

-- These functions should be of type:
-- race -> bool

local function isRaceOfFaction(race)
  return any(
    function(x) return x == string.lower(UnitFactionGroup("player")) or x == "neutral" end, 
    races[race].raceTypes)
end

local function isRaceWithinContext(race, zone, subZone)
  --local zone    = eitherOr(NPCG_Options.locationSettings.mock,    NPCG_Options.locationSettings.mockZone,     GetZoneText())
  --local subZone = eitherOr(NPCG_Options.locationSettings.mockSub, NPCG_Options.locationSettings.mockSubZone,  GetSubZoneText())
  
  if      zone == "Suramar" then
    return isRaceOfFaction(race) or race == "night elf"
  elseif  zone == "Dalaran" then
    return true
  elseif  zone == "Broken Shore" then
    return true
  elseif  zone == "Trueshot Lodge" then
    return true
  elseif zone == "Val'sharah" and (subZone == "Bradensbrook" or subZone == "Marl's Stead" or subZone == "Carlisle Cottage" or subZone == "Heathrow Manor" or subZone == "Thornton's Cottage") then
    return isRaceOfFaction(race) or race == "human" or race == "night elf"
  elseif zone == "Val'sharah" then
    return isRaceOfFaction(race) or race == "night elf"
  elseif zone == "Azsuna" then
    return isRaceOfFaction(race) or race == "night elf"
  else
    return isRaceOfFaction(race)
  end
end

---------------------------------------------------------------------------------------------------------------------------------------
---- | Part 3 Functions: Selection | --------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

-- These functions should be of type:
-- { race } -> race
-- This might change in the future.

---------------------------------------------------------------------------------------------------------------------------------------
--| Combination Function | ------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------------

function createRaceGenerator(generatorF, filterF, selectorF)
  return function(characterTemplate, zone, subZone) 
    return selectorF(filter(function(race) return filterF(race, zone, subZone) end, generatorF(zone, subZone))) or "Error: No options found!"
  end
end

-- Context + SubZone
local contextAndSubZoneBasedRaceGenerator   = createRaceGenerator(  checkAllLocations,  isRaceWithinContext,  randomFrom)
-- Context + Zone
local contextAndZoneBasedRaceGenerator      = createRaceGenerator(  checkZonesOnly,     isRaceWithinContext,  randomFrom)
-- Context + No Location
local contextAndNoZoneBasedRaceGenerator    = createRaceGenerator(  dontCheckLocations, isRaceWithinContext,  randomFrom)
-- Faction + SubZone
local factionAndSubZoneBasedRaceGenerator   = createRaceGenerator(  checkAllLocations,  isRaceOfFaction,      randomFrom)
-- Faction + Zone
local factionAndZoneBasedRaceGenerator      = createRaceGenerator(  checkZonesOnly,     isRaceOfFaction,      randomFrom)
-- Faction + No Location
local factionAndNoZoneBasedRaceGenerator    = createRaceGenerator(  dontCheckLocations, isRaceOfFaction,      randomFrom)
-- No Faction + SubZone
local noFactionAndSubZoneBasedRaceGenerator = createRaceGenerator(  checkAllLocations,  const(true),          randomFrom)
-- No Faction + Zone
local noFactionAndZoneBasedRaceGenerator    = createRaceGenerator(  checkZonesOnly,     const(true),          randomFrom)
-- No Faction + No Location
local noFactionAndNoZoneBasedRaceGenerator  = createRaceGenerator(  dontCheckLocations, const(true),          randomFrom)

-- This function attempts to set the race generator based on settings)
function remakeRaceGenerator()
  generateRandomRace = function() return "Error: generateRandomRace is not set" end
  if not NPCG_Options.factionSettings.matching then
    -- faction matching is off
    if not NPCG_Options.locationSettings.zones then
      -- location matching is also off
      generateRandomRace = noFactionAndNoZoneBasedRaceGenerator
    elseif NPCG_Options.locationSettings.subZones then
      generateRandomRace = noFactionAndSubZoneBasedRaceGenerator
    else
      generateRandomRace = noFactionAndZoneBasedRaceGenerator
    end
  elseif NPCG_Options.factionSettings.context then
    -- faction is on, but context is also on
    if not NPCG_Options.locationSettings.zones then
      -- location matching is off
      generateRandomRace = contextAndNoZoneBasedRaceGenerator
    elseif NPCG_Options.locationSettings.subZones then
      generateRandomRace = contextAndSubZoneBasedRaceGenerator
    else
      generateRandomRace = contextAndZoneBasedRaceGenerator
    end
  else
    -- faction is on, context is off
    if not NPCG_Options.locationSettings.zones then
      -- location matching is off
      generateRandomRace = factionAndNoZoneBasedRaceGenerator
    elseif NPCG_Options.locationSettings.subZones then
      generateRandomRace = factionAndSubZoneBasedRaceGenerator
    else
      generateRandomRace = factionAndZoneBasedRaceGenerator
    end
  end
end

--[[ LEGACY generateRandomRace
-- generateRandomRace :: CharacterTemplate -> Race
function generateRandomRace(characterTemplate)
  local selectionList = 
    -- Subzone-based selection.
    ((subzonesToRaces[GetZoneText()] or { })[GetSubZoneText()])
    -- Zone-based selection.
    or zonesToRaces[GetZoneText()] 
    -- Default selection.
    or zonesToRaces["Default"]
  
  if NPCG_Options.factionSettings.matching and not NPCG_Options.factionSettings.context then
    selectionList = filter(
      isRaceOfFaction,
      selectionList)
  elseif NPCG_Options.factionSettings.context and NPCG_Options.factionSettings.matching then
    selectionList = filter(
      isRaceWithinContext,
      selectionList)
  end
  return randomFrom(selectionList or zonesToRaces["Default"])
	or "Error: No options found!"
end
]]

-- allRacesExcept :: Race -> ... -> { Race }
function allRacesExcept(...)
  return without(keys(races), {...})
end

-- racesByType :: RaceType -> { Race }
function racesByType(raceType)
  return filterKeysByValue(
    function(x) return
      contains(raceType, x.raceTypes)
    end,
    eitherOr(raceType == "any", { }, races)
  )
end

-- racesByFaction :: UnitFactionGroup -> { Race }
function racesByFaction(faction)
  return racesByType(string.lower(faction))
end

function testZoneToRaceRatio()
  local test = { }
  local zone   =  eitherOr(
                    NPCG_Options.locationSettings.mock  and 
                    NPCG_Options.locationSettings.zones, 
                    NPCG_Options.locationSettings.mockZone,
                    GetZoneText())
  local subzone = eitherOr(
                    NPCG_Options.locationSettings.mockSub and
                    NPCG_Options.locationSettings.zones   and
                    NPCG_Options.locationSettings.subZones,
                    NPCG_Options.locationSettings.mockSubZone or "<No SubZone>",
                    GetSubZoneText() or "<No SubZone>")
  print("Testing Zone to Race Ratio for: " .. zone .. ", " .. subzone)
  forEach(
    function(x) 
      local result = generateRandomRace(nil, zone, subzone)
      test[result] = (test[result] or 0) + 1 end,
    replicate(10000, 1))
  logTableMapped(function(x) return x .. ", (" .. ((x / 10000) * 100) .. "%)" end, test)
end


-- End of File.