local motivations = { }

local function default(replacements)
  replacements = replacements or { }
  return { 
    races       = replacements[     "races"] or { "any" },
    classes     = replacements[   "classes"] or { "any" },
    faiths      = replacements[    "faiths"] or { "any" },
    genders     = replacements[   "genders"] or { "any" },
    alignments  = replacements["alignments"] or { "any" },
    ages        = replacements[      "ages"] or olderThan("child")
  }
end

-- a ---------------------------------------------------------------------
motivations[  "aquiring an ancient artifact"                      ] = default({
  })
motivations[  "attending a prayer for the Holy Light"             ] = default({
  faiths = { 
    "church of the holy light" },
  alignments =
    alignmentsByEthics("lawful") })  
motivations[  "atoning for previous wrongdoings"                  ] = default({
  alignments  = { 
    "neutral good",
    "true neutral" }, })   
motivations[  "avenging %xir brother"                             ] = default({
  alignments  = 
    getAlignmentsByTag("vengeful"), })
motivations[  "avenging %xir sister"                              ] = default({
  alignments = 
    getAlignmentsByTag("vengeful"), })
motivations[  "avenging the death of %xir parents"                ] = default({
  alignments = 
    getAlignmentsByTag("vengeful"),
  ages =
    olderThan( "teen" ) })
motivations[  "avenging the death of %xir teddybear"              ] = default({
  alignments = 
    getAlignmentsByTag("vengeful"),
  ages =
    agesBetween(       "child",         "child") })
motivations[  "avenging the attack of %xir village"               ] = default({
  alignments =
    getAlignmentsByTag("vengeful"),
  ages =
    olderThan( "teen" ) })
motivations[  "avenging %xir spouse"                              ] = default({
  alignments = 
    getAlignmentsByTag("vengeful"),
  ages =
    olderThan( "young adult" ) })
motivations[  "avenging %xir people"                              ] = default({
  alignments =
    getAlignmentsByTag("vengeful"),
  ages =
    olderThan( "teen" ) })
motivations[  "avenging the attack on Silvermoon"                 ] = default({
  races = {
    "blood elf" },
  alignments =
    getAlignmentsByTag("vengeful"),
  ages =
    olderThan( "young adult" ) })
motivations[  "avenging the death of %xir leader"                 ] = default({
  alignments =
    getAlignmentsByTag("vengeful"),
  ages =
    olderThan( "teen" ) })

-- b ---------------------------------------------------------------------
motivations[  "badly wants to be admired"                         ] = default({
  alignments = {
    "chaotic good",
    "chaotic neutral",
    "lawful evil",
    "neutral evil",
    "chaotic evil" }, })
motivations[  "baking a cake"                                     ] = default({
  })
motivations[  "beating a HearthStone Adventure"                   ] = default({
  })
motivations[  "becoming a %randomClass"                           ] = default({
  })
motivations[  "becoming leader of %xir religion"                  ] = default({
  alignments = {
    "lawful good",
    "lawful neutral",
    "lawful evil" },
  ages =
    olderThan( "young adult" ) })
-- >>>>>>>>>> Alignments checked up to here.
motivations[  "becoming part of ETC"                              ] = default({
  })
motivations[  "becoming a famous engineer"                        ] = default({
  races = {
    "goblin",
    "gnome" }, })
motivations[  "becoming the next leader of %xir race"             ] = default({
  })
motivations[  "becoming the next Warchief"                        ] = default({
  races = {
    "blood elf",
    "goblin",
    "half elf",
    "half orc",
    "orc",
    "tauren",
    "troll",
    "undead" }, })
motivations[  "becoming a great story teller"                     ] = default({
  })
motivations[  "becoming a famous musician"                        ] = default({
  })
motivations[  "becoming immortal"                                 ] = default({
  })
motivations[  "becoming the HearthStone world champion"           ] = default({
  })
motivations[  "becoming the leader of the Kirin Tor"              ] = default({
  races = {
    "blood elf",
    "gnome",
    "half elf",
    "half orc",
    "high elf",
    "human" },
  faiths = {
    "the arcane",
    "the kirin tor" }, })
motivations[  "becoming the leader of %xir group"                 ] = default({
  })
motivations[  "being in control"                                  ] = default({
  })
motivations[  "being a dancing master"                            ]	= default({
  ages =
    olderThan(          "teen" ) })
motivations[  "being a hero"                                      ] = default({
  })
motivations[  "being a good sister"                               ] = default({ 
  genders = {
    "female" }, })
motivations[  "being a good brother"                              ] = default({
  genders = { 
    "male" }, })
motivations[  "being a good parent"                               ] = default({
  ages =
    agesBetween( "young adult", "adult" ) })
motivations[  "being the top student"                             ] = default({
  ages =
    agesBetween( "teen",   "young adult" ) })
motivations[  "being a leading inventor"                          ] = default({
  races = { 
    "goblin", 
    "gnome" }, })
motivations[  "being the first to discover a new metal"           ] = default({
  classes = {
    "miner" }, })
motivations[  "being famous"                                      ] = default({
  })
motivations[  "being prepared"                                    ]	= default({
  })
motivations[  "breaking %xir addiction for bloodthistle"          ] = default({
  races = {
    "blood elf",
    "half elf",
    "high elf" },
  ages =
    olderThan( "adult" ) })
motivations[  "breaking %xir addiction for love"                  ] = default({
  ages =
    olderThan( "young adult" ) })
motivations[  "breaking %xir brother's addiction of alcohol"      ] = default({
  races =
    allRacesExcept( "dwarf" ), })
motivations[  "breaking %xir addiction to fel"                    ] = default({
  races = {
    "blood elf" }, 
  ages =
    olderThan(   "young adult" ) })
motivations[  "breaking %xir addiction to magic"                  ] = default({
  races = {
    "blood elf",
    "high elf" }, 
  ages = 
    olderThan( "teen" ) })
motivations[  "buying a cask of wine"                             ]	= default({
  races = {
    "blood elf",
    "dwarf",
    "gnome",
    "goblin",
    "half elf",
    "half orc",
    "high elf",
    "human",
    "night elf",
    "pandaren",
    "worgen" },
  ages =
    olderThan( "young adult" ) })
motivations[  "buying a house"                                    ] = default({
  races =
    allRacesExcept( "troll" ), 
  ages =
    olderThan( "young adult" ) })
motivations[  "buying a bed"                                      ] = default({
  races =
    allRacesExcept(
      "orc",
      "tauren",
      "troll",
      "undead" ), 
  ages =
    olderThan( "young adult" ) })
motivations[  "buying a pet"                                      ] = default({
  })
motivations[  "buying new shoes"                                  ] = default({
  races =
    allRacesExcept(
      "draenei",
      "pandaren",
      "tauren" ), })
motivations[  "buying a pretty dress"                             ] = default({
  genders = {
    "female",
    "androgynous" }, })
motivations[  "buying food for %xir family"                       ] = default({
  races = {     
    "troll",
    "undead" },
  ages =
    olderThan( "teen" ) })  --exclude classes that dont -buy- food
motivations[  "buying a new sword"                                ] = default({
  races =
    allRacesExcept( "undead" ),
  classes = { 
    "adventurer",
    "bodyguard",
    "knight",
    "mercenary",
    "paladin",
    "ranger",
    "soldier",
    "swordsman" }, })  --sword using classes?
motivations[  "buying a new door"                                 ] = default({
  })
motivations[  "buying slaves"                                     ] = default({
  races = {
    "goblin",
    "orc",
    "troll",
    "undead" }, })  --add slave holding people in the race,class,faith things
motivations[  "buying bloodthistle"                               ] = default({
  races = {
    "blood elf",
   "half elf",
   "high elf" }, })
motivations[  "buying medicine for %xir child"                    ] = default({
  ages =
    olderThan( "young adult" ) })
motivations[  "buying candy"                                      ] = default({
  ages = agesBetween( "child", "teen" ) })
motivations[  "buying toys"                                       ] = default({
  ages =
    agesBetween( "child", "child" ) })
-- c ---------------------------------------------------------------------
motivations[  "constructing a shredder"                           ]	= default({
  races = {
    "dwarf",
    "gnome",
    "goblin" },
  classes = {
    "engineer" }, })
motivations[  "crafting a sword"                                  ]	= default({
  classes = {
    "blacksmith" }, })
motivations[  "crafting a bow"                                    ]	= default({
  classes = {
    "armourer",
    "bowyer",
    "farstrider",
    "marksman",
    "ranger" }, })
motivations[  "crafting a paper zeppelin"                         ] = default({
  ages =
    agesBetween( "child", "teen") })
motivations[  "crafting a siege engine"                           ] = default({
  races = {
    "dwarf",
    "gnome",
    "goblin" },
  classes = {
    "engineer" }, })
-- d ---------------------------------------------------------------------
motivations[  "dating a %randomRace"                              ] = default({
  ages =
    olderThan( "teen") })
motivations[  "desperately wants to lift a curse"                 ] = default({
  ages =
    olderThan( "teen" ) })
motivations[  "destroying the Legion"                             ]	= default({
  classes = {"demon hunter" }, })
motivations[  "disproving a magical theory"                       ] = default({
  classes = 
    classesByType("magic") })
motivations[  "doing \"da Voodoo\" with a deranged Troll"         ] = default({
  ages =
    olderThan( "teen" ) })
motivations[  "drive a trike"                                     ] = default({
  races = {
    "goblin" }, })
motivations[  "destroying Stormwind"                              ] = default({
  races = {
    "goblin" }, })
motivations[  "destroying Ironforge"                              ] = default({
  races = {
    "goblin" }, })
motivations[  "destroying %xir brothers relationship"             ] = default({
  races = {
    "goblin" }, })
motivations[  "destroying a building"                             ] = default({
  races = {
    "goblin" }, })
motivations[  "destroying the Tauren"                             ] = default({
  races = { "goblin" }, })
--motivations["destroying the legion"]                         			  = { races = {    "goblin" }, classes = {         "any" }, faiths = {                      "any" }, genders = {         "any" }, ages = olderThan(         "child" ) }
motivations[  "destroying all life on Azeroth"                    ] = default({
  races = { 
    "goblin" }, })
motivations[  "destroying Dalaran"                                ] = default({
  races = {
    "goblin" }, })
motivations[  "destroying Orgrimmar"                              ] = default({
  races = {
    "goblin" }, })
-- e ---------------------------------------------------------------------
motivations[  "extreme faith in %xir religion"                    ] = default({
  faiths = allFaithsExcept(
      "undecided",
      "%xir people",
      "%ximself" ) })
motivations[  "expand others knowledge of the Arcane"             ] = default({
  faiths = { 
    "the arcane",
    "the kirin tor" },
  ages = olderThan( "child" ) })
motivations[  "expand others knowledge of the Light"              ] = default({
  faiths = {
    "church of the holy light",
    "the holy light",
    "the light",
    "the order of the silver hand" }, })
--motivations["expand others knowledge of the twisting nether"]       = { races = {       "any" }, classes = {         "any" }, faiths = {                      "any" }, genders = {         "any" }, ages = olderThan(         "child" ) }  
motivations[  "expand others knowledge of history"                ] = default({
  })
motivations[  "expand others knowledge of murlocs"                ] = default({
  })
motivations[  "expand others knowledge of Fel"                    ] = default({
  })
motivations[  "expand others knowledge of elven traditions"       ] = default({
  races = {
    "blood elf",
    "high elf",
    "night elf" }, }  )
--motivations["expand others knowledge of the danger in eating meat"] = { races = {       "any" }, classes = {         "any" }, faiths = {                      "any" }, genders = {         "any" }, ages = olderThan(         "child" ) }  
-- f ---------------------------------------------------------------------
motivations[  "free %xir family member from imprisonment"         ] = default({
  })
motivations[  "free the Old Gods"                                 ] = default({
  faiths = { "the old gods" }, })
motivations[  "free %xir brother"                                 ] = default({
  }) 
motivations[  "free %xir sister"                                  ] = default({
  }) 
motivations[  "free %xir mind"                                    ] = default({
  }) 
motivations[  "free all animals in captivity"                     ] = default({
  classes = { 
    "druid" }, })
motivations[  "free others from themself"                         ] = default({
  classes = {
    "cultist",
    "doomsayer",
    "priest" },
  faiths = {
    "blood knights",
    "church of the holy light",
    "the holy light",
    "the light",
    "the old gods",
    "the void" }, })
motivations[  "free %xir friend from jail "                       ] = default({
  }) 
motivations[  "free Azeroth of all demons"                        ] = default({
  }) 
motivations[  "free Azeroth of orcs"                              ] = default({
  races = allRacesExcept( "orc" ) })
motivations[  "figuring out who %xhe really is"                   ] = default({
  })
motivations[  "finding a ghost crab"                              ] = default({
  })
motivations[  "finding a job"                                     ] = default({
  })
motivations[  "finding a place to belong"                         ] = default({
  })
motivations[  "finding a sparring partner"                        ] = default({
  })
motivations[  "finding out what happened to %xir baby sister"     ] = default({
  })
motivations[  "finding out what happened to %xir brother"         ] = default({
  })
motivations[  "finding out what happened to %xir parents"         ] = default({
  })
motivations[  "finding %xir lost teddy"                           ] = default({
  ages = agesBetween( "child", "teen") })
motivations[  "finding treasure"                                  ] = default({
  })
motivations[  "finding %xir place in life"                        ] = default({
  })
-- g ---------------------------------------------------------------------
motivations[  "getting a drink, or two, or three" 								] = default({
  ages = olderThan( "young adult" ) })
motivations[  "getting away from someone"                         ] = default({
  })
motivations[  "getting away from the law"                         ] = default({
  classes = {
    "assassin",
    "pickpocket",
    "swindler",
    "thief",
    "outlaw",
    "thug",
    "smuggler",
    "burglar" }, }) -- Ted, add more classes in the string
motivations[  "getting help from a medic or healer"               ] = default({
  })
motivations[  "getting laid"                                      ] = default({
  ages = olderThan( "teen" ) })
motivations[  "getting promoted"                                  ] = default({ 
  ages = olderThan( "teen" ) })
motivations[  "getting adopted"                                   ] = default({
  ages = agesBetween( "child", "teen") })
motivations[  "getting rich"                                      ] = default({
  })
motivations[  "going on an adventure"                             ] = default({
  })
motivations[  "greatly desires to kill %xir sister"               ] = default({
  })
motivations[  "greed and anger"                                   ] = default({
  faiths = {
    "profit",
    "the old gods",
    "the void",
    "the burning legion",
    "demonology" }, })
-- h ---------------------------------------------------------------------
motivations[  "having a sex change"                               ] = default({
  ages = olderThan( "young adult" ) })
motivations[  "having a boy"                           					  ] = default({
  ages = olderThan( "young adult" ) })
motivations[  "having a girl"                           				  ] = default({
  ages = olderThan( "young adult") })
motivations[  "having children"                                   ] = default({
  })
motivations[  "humiliating %xir leader"                           ] = default({
  })
-- i ---------------------------------------------------------------------
motivations[  "inventing something special"                       ] = default({
  })
motivations[  "inventing a new machine"                           ] = default({
  classes = {
    "engineer" }, })
motivations[  "inventing a mechanical butterfly"                  ] = default({
  })
motivations[  "inventing a new way to bake cake"                  ] = default({
  })
motivations[  "inventing a better trike"                          ] = default({
  races = {
    "goblin" }, })
motivations[  "inventing a cure for the Plague"                   ] = default({
  })
motivations[  "inventing a way to make more gold"                 ] = default({
  races = {
    "goblin" }, })
motivations[  "inventing the best way to distribute ale"          ] = default({
  })
-- j ---------------------------------------------------------------------
motivations[  "joining a tavern brawl"                            ] = default({
  })
motivations[  "joining the League of Explorers"                   ] = default({
  })
motivations[  "joining the city guards" 													] = default({
  })
motivations[  "joining a group of adventurers" 										] = default({
  })
motivations[  "joining the rebels" 																] = default({
  })
-- k ---------------------------------------------------------------------
motivations[  "knowing all the gossip"                            ] = default({
  })
motivations[  "knowing everything about the Light"                ] = default({
  })
motivations[  "knowing how to raise dragons"                      ] = default({
  })
--motivations[  "knowing when to speak and when to stay quiet"      ] = default({   }
motivations[  "knowing how to cast a frostbolt"                   ] = default({
  })
-- l ---------------------------------------------------------------------
motivations[  "learning a profession"                             ] = default({
  })
motivations[  "learning how to fly"                               ] = default({
  })
motivations[  "learning how to ride"                              ] = default({
  })
motivations[  "living in luxury"                                  ] = default({
  })
motivations[  "learning to control %xir temper"                   ] = default({
  })
motivations[  "learning to defend %xir family" 										] = default({
  })
motivations[  "learning to use a bow" 										        ] = default({
  })
motivations[  "learning to use a sword" 										      ] = default({
  })
motivations[  "learning how to read" 										          ] = default({
  })
motivations[  "learning how to pickpocket" 										    ] = default({
  }) --Ted, do class thing thing here
motivations[  "learning to use magic" 										        ] = default({
  })
motivations[  "learning how to cook" 										          ] = default({
  })
motivations[  "learning a new language" 										      ] = default({
  })
motivations[  "learning about other races" 										    ] = default({
  })
motivations[  "learning about other religions" 										] = default({
  })
motivations[  "learning how to fight" 										        ] = default({
  })
motivations[  "learning selfdefense" 										          ] = default({
  classes = allClassesExcept(unpack(classesByType(
    "fighter" ))), })
-- m ---------------------------------------------------------------------
motivations[  "making friends"                                    ] = default({
  })
--motivations[  "making people see that we're no strangers to love" ] = default({   }
motivations[  "mastering the fireball spell"                      ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering the arcane arts"                         ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering swordfighting"                           ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering archery"                                 ] = default({
  classes = {
    "mage" }, })
motivations[  "mastering cooking"                                 ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering the way of the monks"                    ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering poledancing"                             ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering the language of murlocs"                 ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering an ancient magic"                        ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering frost magic"                             ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering the bagpipe"                             ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering the art of seduction"                    ] = default({
  classes = {
    "mage" }, }) 
motivations[  "mastering the art of brewing"                      ] = default({
  races = {
    "pandaren",
    "dwarf" }, })
-- n ---------------------------------------------------------------------
motivations[  "no longer losing the game"                         ] = default({
  })	-- Thank you ._.
motivations[  "need for company"                                  ] = default({
  })
-- o ---------------------------------------------------------------------
motivations[  "obtaining a doll" 																	] = default({
  ages = agesBetween( "child", "child") })
motivations[  "obtaining a mount"                                 ] = default({
  })
motivations[  "obtaining a torture victim" 						 						] = default({
  faiths = {
    "the old gods", 
    "veritatem" }, })
motivations[  "overcoming %xir fear of %fear"                     ] = default({
  })
motivations[  "overcoming %xir addiction to blood"                ] = default({
  })
motivations[  "overcoming %xir addiction to magic"                ] = default({
  })
-- p ---------------------------------------------------------------------
motivations[  "protecting the peace of the area"                  ] = default({
  })
motivations[  "protecting %xir people"                            ] = default({
  })
motivations[  "protecting %xir village"                           ] = default({
  })
motivations[  "protecting %xir brother"                           ] = default({
  })
motivations[  "protecting %xir sister"                            ] = default({
  })
motivations[  "protecting %xir child"                             ] = default({
  ages = agesBetween( "young adult", "adult" ) })
motivations[  "protecting %xir parents"                           ] = default({
  ages = agesBetween( "child", "adult") })
motivations[  "protecting the innocent"                           ] = default({
  })
motivations[  "protecting the cult"                               ] = default({
  classes = {
    "cultist",
    "doomsayer" }, }) --add religions to this string
motivations[  "protecting %xir tribe"                             ] = default({
  races = racesByType( "tribal" ), }) --add races with tribes to this string
motivations[  "proving a magical theory"                          ] = default({
  classes = {
    "mage" }, })
motivations[  "proving the Old Gods are right"                    ] = default({
  faiths = {
    "the old gods" }, })
motivations[  "proving that Fel is superiour to Arcane"           ] = default({
  classes = {
    "warlock" }, })
motivations[  "proving %xhe is right"                             ] = default({
  })
motivations[  "proving bows are better than guns"                 ] = default({
  })
motivations[  "proving guns are better than bows"                 ] = default({
  })
motivations[  "proving rangers are best"                          ] = default({
  classes = {
    "ranger" }, })
motivations[  "proving %xhe is the best"                          ] = default({
  })
motivations[  "proving it's safe to use an Iron Golem"            ] = default({
  })
motivations[  "proving that inventions are meant to explode"      ] = default({
  races = {
    "goblin" },
  classes = {
    "engineer" }, })
motivations[  "proving %xir religion is the truth"                ] = default({
  })
motivations[  "proving guards aren't unintelligent"               ] = default({
  classes = {
    "guard" }, })
motivations[  "proving magic is a faux"                           ] = default({
  })
motivations[  "proving Azeroth doesn't exist"                     ] = default({
  })
-- q ---------------------------------------------------------------------
-- r ---------------------------------------------------------------------
motivations[  "recovering from a knee injury"                     ] = default({
  classes = {
    "guard" }, })
motivations[  "retrieving a stolen heirloom"                      ] = default({
  })
motivations[  "ruling the world"                                  ] = default({
  })
motivations[  "ressurecting the Old Gods"                         ] = default({ 
  faiths = {
    "the old gods" }, })
motivations[  "ressurecting %xir loved one"                       ] = default({
  ages = olderThan( "young adult" ) })
motivations[  "ressurecting %xir child"                           ] = default({
  ages = olderThan( "young adult" ) })
motivations[  "ressurecting %xir sister"                          ] = default({
  })
motivations[  "ressurecting %xir brother"                         ] = default({
  })
-- s ---------------------------------------------------------------------
motivations[  "scaring people"                                    ] = default({
  ages = youngerThan( "young adult" ) })
motivations[  "seeing the world"                                  ] = default({
  })
motivations[  "spreading %xir religion"                           ] = default({
  })
motivations[  "starting %xir own business"                        ] = default({
  })
motivations[  "soothing %xir thirst for blood"                    ] = default({
  }) 
motivations[  "soothing %xir thirst for blood thistle"            ] = default({
  races = {
    "blood elf",
    "half elf",
    "high elf" }, })
motivations[  "soothing %xir thirst for alcohol"                  ] = default({
  }) 
motivations[  "solving the box of Yogg-Saron"                     ] = default({
  }) 
motivations[  "solving the mystery of life"                       ] = default({
  }) 
motivations[  "solving the answer to life"                        ] = default({
  }) 
motivations[  "starting again, somewhere else"                    ] = default({
  ages = olderThan( "teen" ) })
-- t ---------------------------------------------------------------------
motivations[  "teaching others the \"true way\""                  ] = default({
  faiths = allFaithsExcept(
    "undecided",
    "%xir people" ), })
motivations[  "telling stories"                                   ] = default({
  })
motivations[  "teaching others about nature"                      ] = default({
  classes = { "druid" }, })
motivations[  "teaching %xir comrade a lesson"                    ] = default({
  })
-- u ---------------------------------------------------------------------
-- v ---------------------------------------------------------------------
motivations[  "visiting the armoury"                              ] = default({
  classes = { "soldier" }, })
motivations[  "visit %xir parents"                                ] = default({
  ages = agesBetween( "teen", "adult") })
motivations[  "visit %xir birth village"                          ] = default({
  }) 
motivations[  "visit an old friend"                               ] = default({
  }) 
motivations[  "visit %xir child"                                  ] = default({
  ages = agesBetween( "teen", "adult") })
-- w ---------------------------------------------------------------------
motivations[  "wanting to solve an ancient mystery"               ] = default({
  })
motivations[  "winning a beauty contest"                          ] = default({
  races = {
    "blood elf" },
  genders = {
    "male" }, })
motivations[  "winning a game of HearthStone"                     ] = default({
  })
motivations[  "wishing to marry a hedgehog"                       ] = default({
  })
motivations[  "wrestling a murloc"                                ] = default({
  })
motivations[  "witness the destruction of the world"              ] = default({
  })
-- x ---------------------------------------------------------------------
-- y ---------------------------------------------------------------------
-- z ---------------------------------------------------------------------

-- generateRandomMotivation :: (Race a, Class a, Faith a, Gender a, Alignment a, Age a) => Motivation
function generateRandomMotivation(characterTemplate)
  return --fixGender(characterTemplate.getGender(),
    randomFrom(
      filter(function(item) return not contains(string.lower(item), map(string.lower, characterTemplate.motivations)) end,
      filterKeysByValue(
        function(val) return
          (contains(characterTemplate:getRace(),      val.races)      or contains("any", val.races))
          and
          (contains(characterTemplate:getClass(),     val.classes)    or contains("any", val.classes))
          and
          (contains(characterTemplate:getFaith(),     val.faiths)     or contains("any", val.faiths))
          and
          (contains(characterTemplate:getGender(),    val.genders)    or contains("any", val.genders))
          and
          (contains(characterTemplate:getAlignment(), val.alignments) or contains("any", val.alignments))
          and
          (contains(characterTemplate:getAge(),       val.ages)       or contains("any", val.ages))
        end,
        motivations)
        )
    ) or "Error: No options found."
  --)
end

-- generateRandomMotivations :: (Race a, Class a, Faith a, Gender a, Age a) => { Motivation }
function generateRandomMotivations(characterTemplate)

  local d = date("*t")
  if d.month == 4 and d.day == 1 then return
  { 
    "getting rid of the Left Shark",
    "not be killed by D.E.H.T.A",
    "wishing everyone a happy April Fools\' Day"
  }
  else
    
  return --map(function(x) return fixGender(characterTemplate.getGender(), x) end,    
    uniqueRandomsFrom(3, 
      filterKeysByValue(
        function(val) return
          (contains(characterTemplate:getRace(), val.races)           or contains("any", val.races))
          and
          (contains(characterTemplate:getClass(), val.classes)        or contains("any", val.classes))
          and
          (contains(characterTemplate:getFaith(), val.faiths)         or contains("any", val.faiths))
          and
          (contains(characterTemplate:getGender(), val.genders)       or contains("any", val.genders))
          and
          (contains(characterTemplate:getAlignment(), val.alignments) or contains("any", val.alignments))
          and
          (contains(characterTemplate:getAge(), val.ages)             or contains("any", val.ages))
        end,
        motivations
      )
    )
end -- April fool end
  --)
end

function testForDuplicateMotivations()
print "Testing for duplicate motivations in npcG"
iterate(
  function()
    local results = { }
    local motivs = generateRandomMotivations(GetCurrentCharacterTemplate())
    results[motivs[1]]            = (results[motivs[1]           ] or 0) + 1
    results[motivs[2] or "nil"]   = (results[motivs[2] or "nil"  ] or 0) + 1
    results[motivs[3] or "empty"] = (results[motivs[3] or "empty"] or 0) + 1
    
    if any(function(x) return x > 1 end, results) then
      print "Duplicates found"
      logTable(motivs)
    end
  end,
  1,
  10000)
print "Testing finished"
end

function testForDuplicateMotivations2()
print "Testing for duplicate motivations in npcG for the roll button"
local motivs = GetCurrentCharacterTemplate().motivations
iterate(
  function()
    local results = { }
    motivs[1] = generateRandomMotivation(GetCurrentCharacterTemplate())
    results[motivs[1]]            = (results[motivs[1]           ] or 0) + 1
    results[motivs[2] or "nil"]   = (results[motivs[2] or "nil"  ] or 0) + 1
    results[motivs[3] or "empty"] = (results[motivs[3] or "empty"] or 0) + 1
    
    if any(function(x) return x > 1 end, results) then
      print "Duplicates found"
      logTable(motivs)
    end
  end,
  1,
  10000)
print "Testing finished"
end
--[[
local i = 0
for _,_ in pairs(motivations) do
  i = i + 1
end
print(i)
]]
-- End of File.