-- Note:
-- There does not seem to be a belief in the Elemental Lords as a whole, and they are not evil, but chaotic.

local faiths = { }

-- a
faiths[       "al'akir, the windlord"]  = { alignments = { "chaotic neutral" }, races = { "unknown??" }, tags = { "elemental" } } -- Note: Deceased? No known followers.
faiths[                     "animism"]	= { alignments = {     "lawful good",
                                                              "neutral good",
                                                            "lawful neutral",
                                                              "true neutral" },	races = { "night elf", 
                                                                                                "orc",
                                                                                           "pandaren",                                                                                                
                                                                                             "tauren" }, tags = {       "any" } }
faiths[                      "an'she"]	= { alignments = {     "lawful good",
													    										  					"neutral good",
											    								  								"lawful neutral" },	races = {    "tauren" }, tags = {       "any" } }
faiths[            "ancestor worship"]  = { alignments = {     "lawful good",
                                                              "neutral good",
                                                            "lawful neutral",
                                                              "true neutral",
                                                               "lawful evil" }, races = {       "orc",
                                                                                           "pandaren",
                                                                                             "tauren" }, tags = {       "any" } }
-- b
faiths[               "blood knights"]  = { alignments = {    "neutral good",
                                                              "chaotic good",
                                                            "lawful neutral",
                                                               "lawful evil" }, races = { "blood elf" }, tags = {     "light" } }
-- c
faiths[    "church of the holy light"]  = { alignments = {     "lawful good",
                                                            "lawful neutral",
                                                              "neutral good",
                                                              "true neutral" }, races = {     "dwarf",
                                                                                              "gnome",
                                                                                           "half elf",
                                                                                           "half orc",
                                                                                           "high elf",
                                                                                              "human",
                                                                                             "worgen" }, tags = {     "light" } }
faiths[          "cult of the damned"]  = { alignments = {     "lawful evil" }, races = { "blood elf",
                                                                                            "draenei",
                                                                                              "dwarf",
                                                                                              "gnome",
                                                                                           "half elf",
                                                                                           "half orc",
                                                                                           "high elf",
                                                                                              "human",
                                                                                          "night elf",
                                                                                                "orc",
                                                                                             "tauren",
                                                                                              "troll",
                                                                                             "undead" }, tags = {      "cult" } }
faiths[        "the forgotten shadow"]	= { alignments = {             "any" },	races = {    "undead" }, tags = {       "any" } }
-- d
faiths[                  "demonology"]  = { alignments = {  "lawful neutral",
                                                               "lawful evil",
                                                              "neutral evil",
                                                              "chaotic evil" }, races = { "blood elf",
                                                                                              "dwarf",
                                                                                              "gnome",
                                                                                             "goblin",
                                                                                           "half elf",
                                                                                           "half orc",
                                                                                              "human",
                                                                                                "orc",
                                                                                             "undead",
                                                                                             "worgen" }, tags = {       "any" } }
faiths[                    "druidism"]  = { alignments = {     "lawful good",
                                                              "neutral good",
                                                              "true neutral" }, races = {     "dwarf",
                                                                                             "goblin",
                                                                                           "half elf",
                                                                                           "high elf",
                                                                                          "night elf",
                                                                                             "tauren" }, tags = {       "any" } }
-- e
faiths[                       "elune"]	= { alignments = {     "lawful good",
                                                              "neutral good",
							       																				"lawful neutral" }, races = { "night elf" }, tags = {       "any" } }
-- f
-- g
faiths[                    "geomancy"]  = { alignments = {    "neutral good" }, races = {  "pandaren" }, tags = {       "any" } }
--faiths[              "goldrinn"]	= { alignments = {             "any" },	races = { "night elf", "tauren", "dwarf", "goblin" }, tags = {     "any" } }
-- h
-- i
-- j
-- k
-- l
faiths[                       "light"]	= { alignments = {     "lawful good",
                                                              "neutral good",
                                                            "lawful neutral",
                                                              "true neutral" },	races = { "blood elf",
									  		    																																"draenei",
										  			    															                                "dwarf",
											  				    																													"gnome",
												  					    																								   "half elf",
													  						    																							 "high elf",
                                                                                           "half orc",
														  									    																			    "human",
															  										    																		 "undead",
																  											    																 "worgen" }, tags = {     "light" } }
--faiths[            "lycanthoth"]	= { alignments = {             "any" },	races = { "any" }, tags = {     "any" } }	-- Twilight's Hammer uses this to replace Goldrinn
-- m
--faiths[               "malorne"]	= { alignments = {             "any" },	races = { "night elf", "tauren" }, tags = {     "any" } }
faiths[       "mystery of the makers"]	= { alignments = { "chaotic neutral",
														    					  								  "true neutral",
												    			  											    "chaotic good",
										    				  														"chaotic evil",
								    							  													"neutral evil" },	races = {     "dwarf",
						    								  																														"gnome" }, tags = {       "any" } }
-- n
faiths[    "neptulon, the tidehunter"]  = { alignments = { "chaotic neutral" }, races = {      "naga" }, tags = { "elemental" } } -- Note: Naga are not supported.
-- o
faiths[    "order of the silver hand"]  = { alignments = {     "lawful good",
                                                            "lawful neutral" }, races = { "blood elf",
                                                                                            "draenei",
                                                                                              "dwarf",
                                                                                           "half elf",
                                                                                           "half orc",
                                                                                           "high elf",
                                                                                              "human",
                                                                                             "tauren" }, tags = {     "light" } }
-- p
faiths[                      "profit"]	= { alignments = { "chaotic neutral",
								      																				"chaotic evil" }, races = {       "any" }, tags = {       "any" } }
-- q
-- r
faiths[      "ragnaros, the firelord"]  = { alignments = { "chaotic neutral" }, races = {     "dwarf" }, tags = { "elemental" } }
-- s
faiths[             "sect of dragons"]  = { alignments = {     "lawful good",
                                                              "neutral good",
                                                            "lawful neutral" }, races = { "night elf" }, tags = {       "any" } }
faiths[                   "shamanism"]  = { alignments = {     "lawful good",
                                                              "neutral good",
                                                              "chaotic good",
                                                              "neutral good",
                                                              "true neutral",
                                                           "chaotic neutral" }, races = {   "draenei",
                                                                                              "dwarf",
                                                                                             "goblin",
                                                                                           "half elf",
                                                                                           "half orc",
                                                                                                "orc",
                                                                                           "pandaren",
                                                                                             "tauren",
                                                                                              "troll" }, tags = {       "any" } }
-- t
faiths[       "the ancient guardians"]	= { alignments = {    "true neutral" },	races = { "night elf",
					  																																					     	 "tauren" }, tags = {       "any" } }
faiths[                  "the arcane"]	= { alignments = {     "lawful good",
                                                              "neutral good",
                                                              "chaotic good",
                                                              "neutral good",
                                                              "true neutral",
                                                           "chaotic neutral" }, races = {       "any" }, tags = {       "any" } }
faiths[       "the august celestials"]  = { alignments = {             "any" },	races = {  "panderen" }, tags = {       "any" } }
faiths[          "the burning legion"]	= { alignments = {     "lawful evil" },	races = { "blood elf",
                                                                                             "goblin",
                                                                                           "half elf",
                                                                                              "human",
                                                                                          "night elf",
                                                                                                "orc",
                                                                                             "undead" }, tags = {      "cult" } }
faiths[            "the earth mother"]	= { alignments = {    "neutral good",
                                                              "chaotic good",
                                                           "chaotic neutral",
                                                               "lawful evil",
														    														  "neutral evil" },	races = {     "dwarf",
												    																	  													 "pandaren",
										    																				  												   "tauren" }, tags = {       "any" } }
faiths[            "the echo of life"]	= { alignments = { "chaotic neutral",
					  		    																				  "chaotic evil" },	races = {    "undead" }, tags = {       "any" } }
faiths[              "the holy light"]	= { alignments = {     "lawful good",
                                                              "neutral good",
                                                            "lawful neutral",
                                                              "true neutral" },	races = { "blood elf",
									  		    																																"draenei",
										  			    															                                "dwarf",
											  				    																													"gnome",
												  					    																								   "half elf",
													  						    																							 "high elf",
                                                                                           "half orc",
														  									    																			    "human",
															  										    																		 "undead",
																  											    																 "worgen" }, tags = {     "light" } }
faiths[              "The Holy Light"]	= { alignments = {     "lawful good",
                                                              "neutral good",
                                                            "lawful neutral",
                                                              "true neutral" },	races = { "blood elf",
									  		    																																"draenei",
										  			    															                                "dwarf",
											  				    																													"gnome",
												  					    																								   "half elf",
													  						    																							 "high elf",
                                                                                           "half orc",
														  									    																			    "human",
															  										    																		 "undead",
																  											    																 "worgen" }, tags = {     "light" } }
faiths[                "the illidari"]  = { alignments = {  "lawful neutral",
                                                           "chaotic neutral" }, races = { "blood elf",
                                                                                          "night elf" }, tags = {       "any" } }
faiths[                   "the light"]	= { alignments = {     "lawful good",
                                                              "neutral good",
                                                            "lawful neutral",
                                                              "true neutral" },	races = { "blood elf",
									  		    																																"draenei",
										  			    															                                "dwarf",
											  				    																													"gnome",
												  					    																								   "half elf",
													  						    																							 "high elf",
                                                                                           "half orc",
														  									    																			    "human",
															  										    																		 "undead",
																  											    																 "worgen" }, tags = {     "light" } }
faiths[                     "the loa"]	= { alignments = {             "any" },	races = {     "troll" }, tags = {       "any" } }
faiths[                "the old gods"]	= { alignments = {    "chaotic evil",
							  								    											     "lawful evil",
								  									    									    "neutral evil" },	races = {       "any" }, tags = {      "cult" } }
faiths[          "the shadow council"]  = { alignments = {     "lawful evil" }, races = {       "orc" }, tags = {      "cult" } }
faiths[                  "the titans"]	= { alignments = {    "neutral good",
								      																				"chaotic good",
						    		  																				"true neutral",
								      																		 "chaotic neutral",
									      																			 "lawful evil",
											      																	"neutral evil",
											  		    															"chaotic evil" },	races = {       "any" }, tags = {       "any" } }
faiths[                    "the void"]	= { alignments = allAlignmentsExcept(
                                                               "lawful good",
                                                              "neutral good",
                                                              "chaotic good",
                                                              "true neutral",
                                                           "chaotic neutral" ),	races = { "blood elf",
                                                                                              "dwarf",
                                                                                              "gnome",
                                                                                           "half elf",
                                                                                           "half orc",
                                                                                           "high elf",
                                                                                              "human",
                                                                                             "worgen",
                                                                                             "undead" }, tags = {      "cult" } }
--faiths[         "the wild gods"]  = { alignments = {             "any" },	races = { "any" }, tags = {     "any" } }
faiths[  "therazane, the stonemother"]  = { alignments = {  "lawful neutral" }, races = {     "dwarf",
                                                                                             "tauren" }, tags = { "elemental" } }
faiths[           "twilight's hammer"]  = { alignments = {    "chaotic evil" }, races = {       "any" }, tags = {       "any" } }
-- u
faiths[                   "undecided"]  = { alignments = allAlignmentsExcept(
                                                               "lawful good" ), races = {       "any" }, tags = {       "any" } }
--faiths[       "ursoc and ursol"]	= { alignments = {             "any" },	races = { "any" }, tags = {     "any" } }
-- v
faiths[                   "veritatem"]  = { alignments = { "chaotic neutral",
                                                               "lawful evil",
                                                              "chaotic evil" },  races = allRacesExcept(
                                                                                           "pandaren",
                                                                                             "tauren" ), tags = {       "cult" } }
faiths[                      "voodoo"]	= { alignments = {  "lawful neutral",
                                                           "chaotic neutral",
                                                               "lawful evil",
                                                              "neutral evil",
                                                              "chaotic evil" },	races = {     "troll" }, tags = {       "any" } }
-- w
-- x
faiths[                    "%ximself"]	= { alignments = { "chaotic neutral",
						    		  																				"chaotic evil" },	races = {       "any" }, tags = {       "any" } }
faiths[                 "%xir people"]	= { alignments = {  "lawful neutral",
					    					  																	  "chaotic good",
					    					  																 "chaotic neutral" }, races = {       "any" }, tags = {       "any" } }
-- y
-- z

-- allFaithsExcept :: Faith -> ... -> { Faith }
function allFaithsExcept(...)
  local exceptions = {...}
  return without(keys(faiths), exceptions)
end

-- faithsByTag :: string -> { Faith }
function faithsByTag(tag)
  return filterKeysByValue(
    function(x) return
      contains(tag, x.tags)
    end,
    eitherOr(tag == "any", { }, faiths)
  )
end

-- generateRandomFaith :: (Alignment a, Race a) => a -> Faith
function generateRandomFaith(characterTemplate)
  return --fixGender(characterTemplate.getGender(),
    randomFrom(
      filterKeysByValue(
        function(val) return
					(contains(characterTemplate:getAlignment(), val.alignments) or contains("any", val.alignments))
					and
          (contains(characterTemplate:getRace(),           val.races) or contains("any", val.races))
        end,
        faiths
      )
    ) or "Error: No options found!"
  --)
end

-- End of File