function isFirstGlanceWellDefined(characterTemplate)
  return
    characterTemplate:getName()    ~= "" and
    characterTemplate:getAge()     ~= "" and
    characterTemplate:getRace()    ~= "" and
    characterTemplate:getClass()   ~= "" and
    characterTemplate:getFeature() ~= ""
end

local characterStrings = { }
table.insert(
  characterStrings,
  function(characterTemplate)
    return foldr(
      combineWithSpace,
      "",
      {
        "||",
        ucWords(characterTemplate:getName()),
        "is",
        aOrAn(characterTemplate:getAge()),
        characterTemplate:getAge(),
        ucWords(characterTemplate:getTribe()),
        ucWords(characterTemplate:getRace()),
        characterTemplate:getGender(),
        "that appears to be",
        aOrAn(characterTemplate:getClass()),
        characterTemplate:getClass(),
        "and",
        lcFirst(characterTemplate:getFeature()) .. "."
      } )
  end
)

table.insert(
  characterStrings,
  function(characterTemplate)
    return foldr(
      combineWithSpace,
      "",
      {
        "|| Behold! It is",
        ucWords(characterTemplate:getName()) .. "!",
        ucFirst(xhe(characterTemplate:getGender(), "%xhe")),
        "is",
        aOrAn(characterTemplate:getTribe()),
        characterTemplate:getTribe(),
        characterTemplate:getRace() .. ".",
        ucFirst(xhe(characterTemplate:getGender(), "%xhe")),
        "seems to work as",
        aOrAn(characterTemplate:getClass()),
        characterTemplate:getClass().. ",",
        "is",
        characterTemplate:getAge(),
        "and to top it all off,",
        xhe(characterTemplate:getGender(), "%xhe"),
        lcFirst(characterTemplate:getFeature()) .. "."
      } )
  end
)

-- generatesCharacterString :: (Name a, Age a, Tribe a, Race a, Gender a, Class a, Feature a) => a -> string
function generateCharacterString(characterTemplate)
	return
    eitherOr(
      isFirstGlanceWellDefined(characterTemplate),
      processSubstitutionString(characterTemplate, randomFrom(characterStrings)(characterTemplate)),
      "")
end



-- End of File.