-- Adding "any" and another will always return true.

local alignments = { }
alignments["lawful good"    ] = { moral = {    "good", "any" }, ethic = {  "lawful", "any" } }
alignments["lawful neutral" ] = { moral = { "neutral", "any" }, ethic = {  "lawful", "any" } }
alignments["lawful evil"    ] = { moral = {    "evil", "any" }, ethic = {  "lawful", "any" } }
alignments["neutral good"   ] = { moral = {    "good", "any" }, ethic = { "neutral", "any" } }
alignments["true neutral"   ] = { moral = { "neutral", "any" }, ethic = { "neutral", "any" } }
alignments["neutral evil"   ] = { moral = {    "evil", "any" }, ethic = { "neutral", "any" } }
alignments["chaotic good"   ] = { moral = {    "good", "any" }, ethic = { "chaotic", "any" } }
alignments["chaotic neutral"] = { moral = { "neutral", "any" }, ethic = { "chaotic", "any" } }
alignments["chaotic evil"   ] = { moral = {    "evil", "any" }, ethic = { "chaotic", "any" } }

local alignmentsByTag = { 
  ["vengeful"] = {
    "chaotic neutral",
    "lawful neutral",
    "lawful evil",
    "neutral evil",
    "chaotic evil" },
}

-- generateRandomAlignment :: CharacterTemplate -> Moral -> Alignment
function generateRandomAlignment(characterTemplate, moral)
	return randomFrom(
		filterKeysByValue(
			function(val) return
				contains(moral or "any",	val.moral) --[[or contains(params.moral, val.moral)]]
			end,
			alignments
		)
	) or "Error: No options found!"
end

-- alignmentsWithMoral :: Moral -> { Alignment }
function alignmentsWithMoral(moral)
  return filterKeysByValue(
    function(val) return
      contains(moral, val.moral)
    end,
    alignments
  )
end

function alignmentsByEthics(ethic)
  return filterKeysByValue(
    function(val) return
      contains(ethic, val.ethic)
    end,
    alignments
  )
end

-- allAlignmentsExcept :: Alignment -> ... -> { Alignment }
function allAlignmentsExcept(...)
  local args = {...}
  return without(keys(alignments), args)
end

function getAlignmentsByTag(tag)
  return alignmentsByTag[tag] or keys(alignments)
end
-- End of File