NPCG          = NPCG or { }
NPCG.DATA     = NPCG.DATA or { }
NPCG.DATA.Age = { }


local inc = getIncremental(1)

local ages = { }
ages[       "child"] = { tags = {     "minor" }, sortOrder = inc() }
ages[        "teen"] = { tags = { "workforce" }, sortOrder = inc() }
ages[ "young adult"] = { tags = { "workforce" }, sortOrder = inc() }
ages[       "adult"] = { tags = { "workforce" }, sortOrder = inc() }
ages["mature adult"] = { tags = { "workforce" }, sortOrder = inc() }
ages[       "elder"] = { tags = { "workforce" }, sortOrder = inc() }
ages[         "old"] = { tags = { "workforce" }, sortOrder = inc() }
ages[   "venerable"] = { tags = { "workforce" }, sortOrder = inc() }

-- generateRandomAge :: Race a => a -> Age
function generateRandomAge(characterTemplate)
  return randomFrom(
    eitherOr(
      characterTemplate:getRace() == "undead" or characterTemplate:getRace() == "death knight", 
      olderThan("young adult"),
      keys(ages)
    )
  ) or ""
end

-- keysBy :: (a -> k) -> { b, a } -> { k, b }
local function keysBy(sortF, xs)
  local output = { }
  
  for k,v in pairs(xs) do
    output[sortF(v)] = k
  end
  return output
end

-- olderThan :: Age -> { Age }
function olderThan(age)
  return skipWhile(function(x) return x == age end, keysBy(function(v) return v.sortOrder end, ages))
end

-- youngerThan :: Age -> { Age }
function youngerThan(age)
  return takeWhile(function(x) return x == age end, keysBy(function(v) return v.sortOrder end, ages))
end

-- agesBetween :: Age -> { Age }
function agesBetween(min, max)
  local output = skipWhile(function(x) return x == min end, youngerThan(max))
  table.insert(output, max)
  return output
end

-- End of File