
local function getDisplayItems(page, searchSpace)
  local start = (page - 1) * 4
  local count  = 4
  
  if table.getn(searchSpace) < 4 then
    -- need to return less
    count = table.getn(searchSpace) - start
  end
  return takeWhile(
    function(x)
      count = count - 1
      return count < 0
    end,
    skipWhile(
      function(x)
        start = start - 1
        return start < 0
      end,
      searchSpace
    )
  )
end

function refreshDisplayItems2()
  local frame = npcGenerator_Save_Frame
  
  frame.selectedItemOverlay:Hide()
  frame.selectedItem = nil
  frame.selectedItemIndex = 0
  frame.SaveButton:Disable()
  frame.DeleteButton:Disable()
  
  -- Query the persistent storage for the items
  local searchSpace = map(id, savedNpcTemplates)
    
  -- Narrow search space
  if not nilOrWhitespaceOr(frame.SearchBox:GetText(), "Search for name, race, class...") then
    searchSpace = mergeTablesWithoutDuplicates(
      searchF(function(npc) return npc.name:lower()  end, frame.SearchBox:GetText():lower(), savedNpcTemplates),
      searchF(function(npc) return npc.race:lower()  end, frame.SearchBox:GetText():lower(), savedNpcTemplates),
      searchF(function(npc) return npc.class:lower() end, frame.SearchBox:GetText():lower(), savedNpcTemplates))
  end
  table.insert(searchSpace, { name="new", race=" ", class=" " })
  
  -- Extract items
  local items = getDisplayItems(frame.NavigationBar.NumberBox:GetNumber(), searchSpace)
  if table.getn(items) == 0 then
    local max_pages_needed = math.max(1, math.ceil(table.getn(searchSpace) / 4))
    frame.NavigationBar.NumberBox:SetNumber(max_pages_needed)
  end
  
  local actualItemsObtained = 0
  -- Copy to display
  iterate(
    function(i)
      frame["Item" .. i].ItemName:SetText( ucWords( items[i].name  ))
      frame["Item" .. i].ItemRace:SetText( ucWords( items[i].race  ))
      frame["Item" .. i].ItemClass:SetText(ucWords( items[i].class ))
      actualItemsObtained = actualItemsObtained + 1
    end,
    1,
    table.getn(items)
  )
  iterate(
    function(i)
      frame["Item" .. 5-i].ItemName:SetText( "")
      frame["Item" .. 5-i].ItemRace:SetText( "")
      frame["Item" .. 5-i].ItemClass:SetText("")
    end,
    1,
    4 - actualItemsObtained
  )
end

local function getIndex(selectedIndex, page)
  return (page - 1) * 4 + selectedIndex
end

function npcGenerator_Save_Frame_SaveButton_OnClick()
  local frame = npcGenerator_Save_Frame
  
  -- Query Persistent Storage for items
  local searchSpace = savedNpcTemplates
  
  if not nilOrWhitespaceOr(frame.SearchBox:GetText(), "Search for name, race, class...") then
    searchSpace = mergeTablesWithoutDuplicates(
      searchF(function(npc) return npc.name:lower()  end, frame.SearchBox:GetText():lower(), savedNpcTemplates),
      searchF(function(npc) return npc.race:lower()  end, frame.SearchBox:GetText():lower(), savedNpcTemplates),
      searchF(function(npc) return npc.class:lower() end, frame.SearchBox:GetText():lower(), savedNpcTemplates))
  end
  
  -- Get the item at searchSpace selectedIndex
  local template = searchSpace[getIndex(frame.selectedItemIndex, frame.NavigationBar.NumberBox:GetNumber())]
  
  if template ~= nil then -- Template existed. Ask to overwrite!
    local savePopup = CreateFrame("Frame", nil, UIParent, "npcGeneratorPopupTemplate")
    savePopup.Title:SetText("Are you sure you want to overwrite " .. ucWords(template.name) .. "?")
    savePopup.Text:SetText("This means " .. ucWords(template.name) .. " will no longer be in your saved npcs.")
    savePopup.OkButton:SetScript("OnClick", function()
      local indexInSearchSpace = getIndex(frame.selectedItemIndex, frame.NavigationBar.NumberBox:GetNumber())
      local indexInSavedSpace = findKey(
        function(x) return x == searchSpace[indexInSearchSpace] end, 
        savedNpcTemplates)
      SaveNPC(GetCurrentCharacterTemplate(), indexInSavedSpace)
      frame:Hide()
      savePopup.OkButton:SetScript("OnClick", function() end)
      savePopup:Hide()
    end)
    savePopup:Show()
  else
    SaveNPC(GetCurrentCharacterTemplate(), table.getn(savedNpcTemplates)+1)
    frame:Hide()
  end
end

function npcGenerator_Save_Frame_DeleteButton_OnClick()
  local frame = npcGenerator_Save_Frame
  
  -- Query Persistent Storage for items
  local searchSpace = savedNpcTemplates
  
  if not nilOrWhitespaceOr(frame.SearchBox:GetText(), "Search for name, race, class...") then
    searchSpace = mergeTablesWithoutDuplicates(
      searchF(function(npc) return npc.name:lower()  end, frame.SearchBox:GetText():lower(), savedNpcTemplates),
      searchF(function(npc) return npc.race:lower()  end, frame.SearchBox:GetText():lower(), savedNpcTemplates),
      searchF(function(npc) return npc.class:lower() end, frame.SearchBox:GetText():lower(), savedNpcTemplates))
  end
  
  -- Get the item at searchSpace selectedIndex
  local template = searchSpace[getIndex(frame.selectedItemIndex, frame.NavigationBar.NumberBox:GetNumber())]
  if template ~= nil then
    local deletePopup = CreateFrame("Frame", nil, UIParent, "npcGeneratorPopupTemplate")
    deletePopup.Title:SetText("Are you sure you want to delete " .. ucWords(template.name) .. "?")
    deletePopup.Text:SetText("This means " .. ucWords(template.name) .. " will no longer be in your saved npcs.")
    deletePopup.OkButton:SetScript("OnClick", function()
      local indexInSearchSpace = getIndex(frame.selectedItemIndex, frame.NavigationBar.NumberBox:GetNumber())
      local indexInSavedSpace = findKey(
        function(x) return x == searchSpace[indexInSearchSpace] end, 
        savedNpcTemplates
      )
      DeleteNPC(indexInSavedSpace)
      frame:Hide()
      deletePopup.OkButton:SetScript("OnClick", function() end)
      deletePopup:Hide()
    end)
    deletePopup:Show()
  else
    local npc = CharacterTemplate:new()
    npc.name        = randomFrom({ "mmmrrrggglll", "mrglrg", "glrglmglr", "gmrlgrmlg", "glr", "mrglr" })
    npc.race        = "murloc"
    npc.tribe       = randomFrom({ "bluegill", "blowgill", "grimscale", "bilefin", "coldlight", "seadevil", "primalfin" })
    npc.class       = randomFrom({ "raider", "oracle", "tidehunter", "tidecaller", "warrior", "seer", "stinger", "warleader", "lookout" })
    npc.age         = randomFrom({ "mmmrrrggglll", "mrglrg", "glrglmglr", "gmrlgrmlg", "glr", "mrglr" })
    npc.alignment   = randomFrom({ "mmmrrrggglll", "mrglrg", "glrglmglr", "gmrlgrmlg", "glr", "mrglr" })
    npc.faith       = randomFrom({ "mmmrrrggglll", "mrglrg", "glrglmglr", "gmrlgrmlg", "glr", "mrglr" })
    npc.gender      = randomFrom({ "mmmrrrggglll", "mrglrg", "glrglmglr", "gmrlgrmlg", "glr", "mrglr" })
    npc.motivations = { "mmmrrrggglll", "do the thing", "a Mlrglrmg for grlmrgl" }
    npc.feature     = "ate the new button and took it's place"
    SaveNPC(npc, table.getn(savedNpcTemplates)+1)
    frame:Hide()
  end
end

function npcGenerator_Save_Frame_OnShow()
  refreshDisplayItems2()
  npcGenerator_Load_Frame:Hide()
end

function npcGenerator_Save_Frame_OnLoad()
  local frame = npcGenerator_Save_Frame
  
  -- Hide this frame when the main frame is opened. 
  -- This only happens when the main frame is hidden while this is open.
  frame:GetParent():HookScript("OnShow", function() frame:Hide() end)
  
  frame.selectedItem = nil
  frame.selectedItemIndex = 0
  
  frame.SetSelectedItem = function(self, index)
    self.selectedItemIndex = index
    self.selectedItem      = self["Item" .. index]
    self["selectedItemOverlay"]:SetPoint("TOPLEFT",     self["selectedItem"], "TOPLEFT")
    self["selectedItemOverlay"]:SetPoint("BOTTOMRIGHT", self["selectedItem"], "BOTTOMRIGHT")
    self["selectedItemOverlay"]:Show()
  end
  
  frame.Item1.Button:SetScript("OnClick", function(self, button, down)
    if frame.Item1:HasValue() then
      frame.SaveButton:Enable()
      frame.DeleteButton:Enable()
      frame:SetSelectedItem(1)
    end
  end)
  
  frame.Item2.Button:SetScript("OnClick", function(self, button, down)
    if frame.Item2:HasValue() then
      frame.SaveButton:Enable()
      frame.DeleteButton:Enable()
      frame:SetSelectedItem(2)
    end
  end)
  
  frame.Item3.Button:SetScript("OnClick", function(self, button, down)
    if frame.Item3:HasValue() then
      frame.SaveButton:Enable()
      frame.DeleteButton:Enable()
      frame:SetSelectedItem(3)
    end
  end)
  
  frame.Item4.Button:SetScript("OnClick", function(self, button, down)
    if frame.Item4:HasValue() then
      frame.SaveButton:Enable()
      frame.DeleteButton:Enable()
      frame:SetSelectedItem(4)
    end
  end)

  tinsert(UISpecialFrames, frame:GetName())
end
