local function repositionMinimapButton()
	NPCG_Options.interface.minimapPosition = NPCG_Options.interface.minimapPosition or 45
	npcGenerator_Minimap_Button:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-(80*cos(NPCG_Options.interface.minimapPosition)),(80*sin(NPCG_Options.interface.minimapPosition))-52)
end

function npcGenerator_minimapButton_OnDragStart()
	npcGenerator_Minimap_Button:LockHighlight()
	npcGenerator_Minimap_Button_DraggingFrame:Show()
end

function npcGenerator_minimapButton_OnDragStop()
	npcGenerator_Minimap_Button:UnlockHighlight()
	npcGenerator_Minimap_Button_DraggingFrame:Hide()
end

function npcGenerator_minimapButton_WhileDragging()
	local xpos,ypos = GetCursorPosition()
	local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

	xpos = xmin-xpos/UIParent:GetScale()+70 -- get coordinates as differences from the center of the minimap
	ypos = ypos/UIParent:GetScale()-ymin-70

	NPCG_Options.interface.minimapPosition = math.deg(math.atan2(ypos,xpos)) -- save the degrees we are relative to the minimap center
	repositionMinimapButton() -- move the button
end

function npcGenerator_minimapButton_OnClick()
  local frame = npcGenerator_NPC_Frame
	if frame:IsVisible() then
		frame:Hide()
	else
		frame:Show()
	end
end

function npcGenerator_Minimap_Button_OnAddonLoaded()
	repositionMinimapButton()
	if NPCG_Options.interface.displayMinimapButton then npcGenerator_Minimap_Button:Show()
	else npcGenerator_Minimap_Button:Hide() end
end

function npcGenerator_minimapButton_OnLoad()
	npcGenerator_Minimap_Button:RegisterForClicks(  "LeftButtonUp", "RightButtonUp")
	npcGenerator_Minimap_Button:RegisterForDrag(      "LeftButton",   "RightButton")
end

function npcGenerator_minimapButton_OnEnter()
	GameTooltip:SetOwner(npcGenerator_Minimap_Button, "ANCHOR_LEFT")
	GameTooltip:SetText("npcGenerator", 1, 1, 1)
	GameTooltip:AddLine("Open the npcGenerator window", 1.00,	0.82,	0.00, 1)
	GameTooltip:Show()
	GameTooltip:FadeOut()
end

