-- Checking traits to be valid will be postponed until a later version.

-----------------------------------------------------------------------
-- | Writing to the User Interface | ----------------------------------
-----------------------------------------------------------------------

local function onUIChange(characterTemplate)
  local frame = npcGenerator_NPC_Frame
  if not isFirstGlanceWellDefined(characterTemplate) then
    frame.BottomBar.PrintButton:Disable()
  else
    frame.BottomBar.PrintButton:Enable()
  end
  
  if not characterTemplate:isEmpty() then
    frame.BottomBar.ClearButton:Enable()
  else
    frame.BottomBar.ClearButton:Disable()
  end
  
  if not nilOrWhitespace(characterTemplate.name) then
    frame.BottomBar.SaveButton:Enable()
  else
    frame.BottomBar.SaveButton:Disable()
  end
end

-- printToFrame :: (Age a, Alignment a, Class a, Faith a, Feature a, Gender a, Name a, Race a, Tribe a, Motivations a) => a -> ()
function printToFrame(characterTemplate)
  local frame = npcGenerator_NPC_Frame

  frame.Age.EditBox:SetText(      ucWords(                                     characterTemplate:getAge()        ))
  frame.Alignment.EditBox:SetText(ucWords(                                     characterTemplate:getAlignment()  ))
  frame.Class.EditBox:SetText(    ucWords(characterTemplate:getClass()))
  frame.Faith.EditBox:SetText(    ucWords(processSubstitutionString(characterTemplate, characterTemplate:getFaith())))
  frame.Feature.EditBox:SetText(  ucFirst(processSubstitutionString(characterTemplate, characterTemplate:getFeature())))
  frame.Gender.EditBox:SetText(   ucWords(characterTemplate:getGender()))
  frame.Name.EditBox:SetText(     ucWords(characterTemplate:getName()))
  frame.Race.EditBox:SetText(     ucWords(characterTemplate:getRace()))
  frame.Tribe.EditBox:SetText(    ucWords(characterTemplate:getTribe()))

  
  frame.Motivations.EditBox1:SetText(ucFirst(processSubstitutionString(characterTemplate, characterTemplate:getMotivation(1))))
  frame.Motivations.EditBox2:SetText(ucFirst(processSubstitutionString(characterTemplate, characterTemplate:getMotivation(2))))
  frame.Motivations.EditBox3:SetText(ucFirst(processSubstitutionString(characterTemplate, characterTemplate:getMotivation(3))))
  

end

-- printToChat :: (Age a, Class a, Feature a, Gender a, Race a, Tribe a)
function printToChat()
	local charString = generateCharacterString(GetCurrentCharacterTemplate())
  SendChatMessage(charString, "EMOTE")
end

-----------------------------------------------------------------------
-- | Reading from the User Interface | --------------------------------
-----------------------------------------------------------------------

function readAge()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setAge(
    npcGenerator_NPC_Frame.Age.EditBox:GetText():lower())
  onUIChange(characterTemplate)
end

function readAlignment()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setAlignment(
    npcGenerator_NPC_Frame.Alignment.EditBox:GetText():lower())
  onUIChange(characterTemplate)
end

function readClass()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setClass(
    npcGenerator_NPC_Frame.Class.EditBox:GetText():lower())
  onUIChange(characterTemplate)
end

function readFaith()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setFaith(
    npcGenerator_NPC_Frame.Faith.EditBox:GetText():lower())
  onUIChange(characterTemplate)
end

function readFeature()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setFeature(
    npcGenerator_NPC_Frame.Feature.EditBox:GetText())
  onUIChange(characterTemplate)
end

function readGender()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setGender(
    npcGenerator_NPC_Frame.Gender.EditBox:GetText():lower())
  onUIChange(characterTemplate)
end

function readName()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setName(
    npcGenerator_NPC_Frame.Name.EditBox:GetText())
  onUIChange(characterTemplate)
end

function readRace()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setRace(
    npcGenerator_NPC_Frame.Race.EditBox:GetText():lower())
  onUIChange(characterTemplate)
end

function readTribe()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setTribe(
    npcGenerator_NPC_Frame.Tribe.EditBox:GetText():lower())
  onUIChange(characterTemplate)
end

function readMotivation(i)
  local characterTemplate = GetCurrentCharacterTemplate()
  local frame = npcGenerator_NPC_Frame.Motivations
  characterTemplate:setMotivation(1, frame.EditBox1:GetText())
  characterTemplate:setMotivation(2, frame.EditBox2:GetText())
  characterTemplate:setMotivation(3, frame.EditBox3:GetText())
  onUIChange(characterTemplate)
end

-----------------------------------------------------------------------
-- | Rolling Traits | -------------------------------------------------
-----------------------------------------------------------------------

function rollName()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setName(
    underscoreToSpace(
			doubleUnderscoreToApostrophe(
        generateRandomName(
          characterTemplate	) ) ) )
  printToFrame(characterTemplate)
  
  return characterTemplate
end

function rollRace()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setRace(
		generateRandomRace(
      characterTemplate,
      eitherOr(
        NPCG_Options.locationSettings.mock and NPCG_Options.locationSettings.zones,
        NPCG_Options.locationSettings.mockZone,
        GetZoneText()),
      eitherOr(
        NPCG_Options.locationSettings.mockSub and NPCG_Options.locationSettings.zones and NPCG_Options.locationSettings.subZones,
        NPCG_Options.locationSettings.mockSubZone,
        GetSubZoneText())
    )
	)
	-- Also roll the Tribe to make sure it doesn't get invalid.
	rollTribe()
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollTribe()
  local characterTemplate = GetCurrentCharacterTemplate()
	characterTemplate:setTribe(
		generateRandomTribe(
			characterTemplate,
      eitherOr(
        NPCG_Options.locationSettings.mock and NPCG_Options.locationSettings.zones,
        NPCG_Options.locationSettings.mockZone,
        GetZoneText()),
      eitherOr(
        NPCG_Options.locationSettings.mockSub and NPCG_Options.locationSettings.zones and NPCG_Options.locationSettings.subZones,
        NPCG_Options.locationSettings.mockSubZone,
        GetSubZoneText())
    )
	)
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollGender()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setGender(
		generateRandomGender()
	)
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollClass()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setClass(
    generateRandomClass(
      characterTemplate,
      eitherOr(
        NPCG_Options.locationSettings.mock and NPCG_Options.locationSettings.zones,
        NPCG_Options.locationSettings.mockZone,
        GetZoneText()),
      eitherOr(
        NPCG_Options.locationSettings.mockSub and NPCG_Options.locationSettings.zones and NPCG_Options.locationSettings.subZones,
        NPCG_Options.locationSettings.mockSubZone,
        GetSubZoneText())
    )
  )
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollAge()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setAge(
    generateRandomAge(
      characterTemplate
    )
  )
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollAlignment()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setAlignment(
    generateRandomAlignment(
			characterTemplate
    )
  )
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollFeature()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setFeature(
    generateRandomFeature(
      characterTemplate
    )
  )
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollFaith()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setFaith(
    generateRandomFaith(
      characterTemplate
    )
  )
  printToFrame(characterTemplate)
  return characterTemplate
end

-- Function too complicated. Consider simplifying.
function rollMotivation(num)
  local characterTemplate = GetCurrentCharacterTemplate()
  local motivation = generateRandomMotivation(
    characterTemplate)
  
  -- If no options can be found, it might be impossible to find unique traits.
  -- Is this even still relevant?
	-- We can use nil-monadic operations to do this?
  if motivation == "Error: No options found." then
    characterTemplate:setMotivation(num, motivation)
  else
  
  local a, b = unpack(filter(function(x) return x ~= num end, { 1,2,3 }))

    -- Function 2
    while 
      motivation == characterTemplate:getMotivation(a) or 
      motivation == characterTemplate:getMotivation(b)
		do
			motivation = generateRandomMotivation(
				characterTemplate)
    end
    -- End of Function 2
    
    characterTemplate:setMotivation(num, motivation)
  end
  printToFrame(characterTemplate)
  return characterTemplate
end

function rollAllMotivations()
  local characterTemplate = GetCurrentCharacterTemplate()
  local motivations = generateRandomMotivations(
    characterTemplate
	)
  -- All motivations are ""
  characterTemplate:setMotivation(1, motivations[1] or "Error: No options found.")
  characterTemplate:setMotivation(2, motivations[2] or "") -- Finding less than three motivations is fine, as long as at least one motivation is found.
  characterTemplate:setMotivation(3, motivations[3] or "")
  printToFrame(characterTemplate)
  return characterTemplate
end

local inc = getIncremental(1)
local activeModules = { }
activeModules[inc()] = { f =           rollRace, enabled = true }
activeModules[inc()] = { f =          rollTribe, enabled = false }
activeModules[inc()] = { f =            rollAge, enabled = true }
activeModules[inc()] = { f =         rollGender, enabled = true }
activeModules[inc()] = { f =      rollAlignment, enabled = true }
activeModules[inc()] = { f =          rollFaith, enabled = true }
activeModules[inc()] = { f =          rollClass, enabled = true }
activeModules[inc()] = { f =           rollName, enabled = true }
activeModules[inc()] = { f =        rollFeature, enabled = true }
activeModules[inc()] = { f = rollAllMotivations, enabled = true }

function rollAll(self)
  
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:clear()
  
  invokeAll(
    map(
      function(x)
        return x.f end,
      filter(
        function(y) return y.enabled == true end,
        activeModules
      )
    )
  )
  printToFrame(characterTemplate)
end

-----------------------------------------------------------------------
-- | Clearing Traits | ------------------------------------------------
-----------------------------------------------------------------------

function clearName()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setName("")
  printToFrame(characterTemplate)
end

function clearAge()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setAge("")
  printToFrame(characterTemplate)
end

function clearRace()
local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setRace("")
  characterTemplate:setTribe("")
  printToFrame(characterTemplate)
end

function clearClass()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setClass("")
  printToFrame(characterTemplate)
end

function clearGender()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setGender("")
  printToFrame(characterTemplate)
end

function clearAlignment()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setAlignment("")
  printToFrame(characterTemplate)
end

function clearFaith()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setFaith("")
  printToFrame(characterTemplate)
end

function clearTribe()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setTribe("")
  printToFrame(characterTemplate)
end

function clearFeature()
  local characterTemplate = GetCurrentCharacterTemplate()
  characterTemplate:setFeature("")
  printToFrame(characterTemplate)
end

function clearMotivation(i)
  local characterTemplate = GetCurrentCharacterTemplate()
  if i == 1 then
    characterTemplate:setMotivation(1, npcGenerator_NPC_Frame.Motivations.EditBox2:GetText())
    characterTemplate:setMotivation(2, npcGenerator_NPC_Frame.Motivations.EditBox3:GetText())
  elseif i == 2 then
    characterTemplate:setMotivation(2, npcGenerator_NPC_Frame.Motivations.EditBox3:GetText())
  end
  
  characterTemplate:setMotivation(3, "")
  
  printToFrame(characterTemplate)
end

function clearAll()
  clearAge()
  clearAlignment()
  clearClass()
  clearFaith()
  clearFeature()
  clearGender()
  clearName()
  clearRace()
  clearTribe()
  clearMotivation(3)
  clearMotivation(2)
  clearMotivation(1)
  --npcGenerator_NPC_Frame.Tribe.RollButton:Enable()
  --npcGenerator_NPC_Frame.Tribe.EditBox:SetTextColor(1.0, 1.0, 1.0)
  --npcGenerator_NPC_Frame.Tribe.EditBox:Enable()
  npcGenerator_NPC_Frame.Tribe.Label:SetText("Tribe")
  
  --frm_Main.charTribe:SetText("Tribe")
  
  printToFrame(GetCurrentCharacterTemplate())
end