local substitutionStrings = { }
local inc = getIncremental(1)

--[[  All substitutionStrings
      Using inc will ensure that the list is sorted. This guarantee would not be there if random keys were used.
]]
substitutionStrings[inc()] = function(characterTemplate, s) 
  if nilOrWhitespace(characterTemplate.fear) then
    characterTemplate.fear = randomFear() end
  return s:gsub("%%fear", characterTemplate.fear) end

-- | Basic Traits | ----------------------------------------------------------------------------------------------
substitutionStrings[inc()] = function(characterTemplate, s) return s:gsub("%%race",         characterTemplate:getRace())             end
substitutionStrings[inc()] = function(characterTemplate, s) return s:gsub("%%class",        characterTemplate:getClass())            end
substitutionStrings[inc()] = function(characterTemplate, s) return s:gsub("%%faith",        characterTemplate:getFaith())            end
substitutionStrings[inc()] = function(characterTemplate, s) return s:gsub("%%gender",       characterTemplate:getGender())           end
substitutionStrings[inc()] = function(characterTemplate, s) return s:gsub("%%tribe",        characterTemplate:getTribe())            end
-- | Random Race | -----------------------------------------------------------------------------------------------
substitutionStrings[inc()] = function(characterTemplate, s) 
  if nilOrWhitespace(characterTemplate.randomRace) then
    characterTemplate.randomRace = generateRandomRace() end
  return s:gsub("%%randomRace", characterTemplate.randomRace) end

substitutionStrings[inc()] = function(characterTemplate, s)   
  if nilOrWhitespace(characterTemplate.randomRace) then
    characterTemplate.randomRace = generateRandomRace()  end
  return s:gsub("%%randomrace", characterTemplate.randomRace) end

  
-- | Random Class | ----------------------------------------------------------------------------------------------
substitutionStrings[inc()] = function(characterTemplate, s) 
  if nilOrWhitespace(characterTemplate.randomClass) then
    characterTemplate.randomClass = randomClass() end
  return s:gsub("%%randomClass", characterTemplate.randomClass) end

substitutionStrings[inc()] = function(characterTemplate, s) 
  if nilOrWhitespace(characterTemplate.randomClass) then
    characterTemplate.randomClass = generateRandomClass(characterTemplate) end
  return s:gsub("%%randomclass", characterTemplate.randomClass) end

-- | Random Gender | ---------------------------------------------------------------------------------------------
substitutionStrings[inc()] = function(characterTemplate, s) 
  if nilOrWhitespace(characterTemplate.randomGender) then
    characterTemplate.randomGender = generateRandomGender(characterTemplate) end
  return s:gsub("%%randomGender", characterTemplate.randomGender) end

substitutionStrings[inc()] = function(characterTemplate, s) 
  if nilOrWhitespace(characterTemplate.randomGender) then
    characterTemplate.randomGender = generateRandomGender(characterTemplate) end
  return s:gsub("%%randomgender", characterTemplate.randomGender) end


-- | Xir, Xim, Xhe | ---------------------------------------------------------------------------------------------
substitutionStrings[inc()] = function(characterTemplate, s) return xhe(characterTemplate:getGender(), s)                             end
substitutionStrings[inc()] = function(characterTemplate, s) return xim(characterTemplate:getGender(), s)                             end
substitutionStrings[inc()] = function(characterTemplate, s) return xir(characterTemplate:getGender(), s)                             end

-- processSubstitutionString :: (Race a, Class a, Gender a, Age a, Tribe a) => a -> string -> string
function processSubstitutionString(characterTemplate, s)
  if s == "" then return s end
  return foldr(
    function(accum, f) return f(characterTemplate, accum) end,
    s,
    substitutionStrings)
end

-- End of File.