local frame = CreateFrame("Frame",nil,UIParent)
local L=L4S[GetLocale()];
if type(L)~="table" then L=L4S["enUS"]; end
local LCH={};
local backdrop = {
    bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
    edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",   
    edgeSize = 16,
    insets = { left = 3, right = 3, top = 3, bottom = 3 }
}

function Open_chat(channel)
	local editBox = ChatEdit_ChooseBoxForSend();
	local txt = editBox:GetText();
	local chatFrame = editBox.chatFrame;
	ChatFrame_OpenChat(channel..txt, chatFrame); 
	ChatEdit_UpdateHeader(editBox);
end
function Add_Frame(w,h)
	local CF = CreateFrame("FRAME","addcomentframe_frame",UIParent);
	CF:SetMovable(true)
	CF:EnableMouse(true)
	CF:SetClampedToScreen(true)
	CF:SetScript("OnMouseDown", CF.StartMoving) 
	CF:SetScript("OnMouseUp",function(self, event, ...)
			self:StopMovingOrSizing();
			local point, relativeTo, relativePoint, xOfs, yOfs = self:GetPoint(n);
			LCH_Point={x=xOfs,y=yOfs};
	end)
	CF:SetWidth(w);   
	CF:SetHeight(h);
	CF:SetPoint("BOTTOMLEFT",LCH_Point.x,LCH_Point.y );
	CF:SetBackdrop(backdrop);
	CF:SetBackdropColor(0.2,0.2,0.2,1);
	CF:SetBackdropBorderColor(0.2,0.1,0.1,1);
	CF:Hide()
	return CF;
end
function Add_Button(text,command,x,y,parent,color) 
	local Button = CreateFrame("Button", nil, parent) 
	--Button:SetBackdropColor(1,0,0,0.5);
	--Button:SetBackdropBorderColor(0.2,0.1,0.1,1);
	Button:SetWidth(20)
	Button:SetHeight(20)
	Button:SetPoint("CENTER",parent, "LEFT", x, y);
	Button:SetNormalFontObject("GameFontHighlight");
	--local f = Button:GetNormalFontObject(); f:SetTextColor(font[0],font[1],font[2],font[3]);
	--Button:SetNormalFontObject(f);
	Button:SetText(text)
	Button:RegisterForClicks("AnyUp") 
	local textureFrame4 = Button:CreateTexture("ARTWORK")
	textureFrame4:SetColorTexture(color[1],color[2],color[3],color[4])
	textureFrame4:SetAllPoints(Button)
	Button:SetScript("OnClick", function() 
		Open_chat(command);
	end )
	return Button;
end
function Add_Button_NOc(text,x,y,parent,color) 
	local Button = CreateFrame("Button", nil, parent)
	Button:SetWidth(20)
	Button:SetHeight(20)
	Button:SetPoint("CENTER",parent, "LEFT", x, y);
	Button:SetNormalFontObject("GameFontHighlight");
	--local f = Button:GetNormalFontObject(); f:SetTextColor(font[0],font[1],font[2],font[3]);
	--Button:SetNormalFontObject(f);
	Button:SetText(text)
	Button:RegisterForClicks("AnyUp") 
	local textureFrame4 = Button:CreateTexture("ARTWORK")
	textureFrame4:SetColorTexture(color[1],color[2],color[3],color[4])
	textureFrame4:SetAllPoints(Button)
	return Button;
end


function update_frame_btn()
	if type(LCH)=="table" and LCH.F~=nil then LCH.F:Hide(); LCH={}; end
	inInstance, instanceType = IsInInstance();
	LCH.F = Add_Frame(10,10); local W=25;
	if type(LCH_Settings)=="table" then
		if LCH_Settings.bt~=1 then for key, val in pairs(L) do L[key]=""; end end
	end
	
	LCH.b0=Add_Button_NOc("¶",W,0,LCH.F,{0,0,0,1});W=W+25;
		LCH.b0:SetScript("OnClick", function()
			if ChannelFrame:IsShown() then
				ChannelFrame:Hide();
			else
				ChannelFrame:Show();
			end 
		end )
	
	LCH.b=Add_Button(L["S"],"/s ",W,0,LCH.F,{0.5,0.5,0.5,1});W=W+25;
	LCH.b1=Add_Button(L["Y"],"/y ",W,0,LCH.F,{1, 0, 0, 1}); W=W+25;
	if IsInGroup() or (inInstance ~= nil and instanceType == "party") or (inInstance ~= nil and instanceType == "raid") or (inInstance ~= nil and instanceType == "arena") then LCH.b3=Add_Button(L["G"],"/p ",W,0,LCH.F,{0.3, 0.3, 1, 1});W=W+25; end
	if (inInstance ~= nil and instanceType == "party") then LCH.b4=Add_Button(L["P"],"/п ",W,0,LCH.F,{0.7, 0.3, 0, 1});W=W+25; end
	if inInstance ~= nil and instanceType == "pvp" then LCH.b5=Add_Button(L["BG"],"/bg ",W,0,LCH.F,{0.7, 0.3, 0, 1});W=W+25; end
	if IsInRaid() or (inInstance ~= nil and instanceType == "raid") then LCH.b6=Add_Button(L["RA"],"/ra ",W,0,LCH.F,{1, 0.5, 0, 1});W=W+25; end
	if IsInRaid() or (inInstance ~= nil and (instanceType == "raid" or instanceType == "pvp")) then LCH.b6=Add_Button(L["RW"],"/rw ",W,0,LCH.F,{1, 0.3, 0, 1});W=W+25; end
	if IsInGuild() then LCH.b7=Add_Button(L["Gi"],"/g ",W,0,LCH.F,{0, 1, 0, 1});W=W+25; end
	if IsInGuild() then LCH.b8=Add_Button(L["Of"],"/o ",W,0,LCH.F,{0, 0.5, 0, 1});W=W+25; end
	
	local btxt1="";
	for i = 0, 10, 1 do
      local id, name = GetChannelName(i);
	  if name~=nil then
		if LCH.F~=nil and LCH["b"..(10+i)]==nil then
			btxt1=i;
			if type(LCH_Settings)=="table" then if LCH_Settings.bt~=1 then btxt1=""; end end
			LCH["b"..(10+i)]=Add_Button(btxt1,"/"..i.." ",W,0,LCH.F,{1, 0.7, 0.7-(i/10), 1});W=W+25;
		end
	  end
	end; 
	LCH.F:SetWidth(W);
	LCH.F:Show();
	 
end

function frame:ADDON_LOADED(arg1)  
	if (arg1 == "LCH_Settings" and type(LCH_Settings)~="table") or not LCH_Settings then LCH_Settings={bt=1}; end

	if (arg1 == "LCH_Point" and type(LCH_Point)~="table") or not LCH_Point then LCH_Point={x=(GetScreenWidth()*0.5),y=(GetScreenHeight()*0.5)}; end
	if type(LCH_Point)=="table" and LCH.F==nil then update_frame_btn(); end 
end

function frame:GROUP_ROSTER_UPDATE(arg1)	
	if type(LCH_Point)=="table" and LCH.F~=nil then update_frame_btn(); end
end
function frame:CONSOLE_MESSAGE(arg1)
	if type(LCH_Point)=="table" and LCH.F~=nil then update_frame_btn(); end 
end
function frame:PLAYER_STOPPED_MOVING(arg1)
	if type(LCH_Point)=="table" and LCH.F~=nil then update_frame_btn(); end
end
function frame:PLAYER_STARTED_MOVING(arg1)
	if type(LCH_Point)=="table" and LCH.F~=nil then update_frame_btn(); end
end
function frame:CRITERIA_UPDATE(arg1)
	if type(LCH_Point)=="table" and LCH.F~=nil then update_frame_btn(); end
end
--#####################################################################################

--SLASH_SLASHCMDNCB1='/ncb'; SlashCmdList["SLASHCMDNCB"] = sCMD;

frame:RegisterEvent("CONSOLE_MESSAGE");
frame:RegisterEvent("ADDON_LOADED");
frame:RegisterEvent("GROUP_ROSTER_UPDATE");
frame:RegisterEvent("PLAYER_STOPPED_MOVING");
frame:RegisterEvent("PLAYER_STARTED_MOVING");
frame:RegisterEvent("CRITERIA_UPDATE");
frame:SetScript("OnEvent",function(self, event, ...) self[event](self, ...) end)
