local o = mOnPVPEquipManager

o.handleUniqueGroup = function(index, group)
    if (index <= 0) then
        return
    end
    
    ordered = {}
    
    for slot, item in pairs(group.items) do
        if (o:isDoubleSlot(slot)) then
            local currentILVL1 = 0
            local currentILVL2 = 0
            if o.equip[slot] ~= nil then 
                if o.equip[slot][1] ~= nil then 
                    currentILVL1 = o.equip[slot][1].ilvl 
                end
                if o.equip[slot][2] ~= nil then 
                    currentILVL2 = o.equip[slot][2].ilvl 
                end
            end
            if item[1] ~= nil then 
                item[1].increase = item[1].ilvl - currentILVL2
                item[1].replaceSlot = 2
                if (not item[1].used) then
                    table.insert(ordered, item[1])
                end
            end
            if item[2] ~= nil then 
                item[2].increase = item[2].ilvl - currentILVL1
                item[2].replaceSlot = 1
                if (not item[2].used) then
                    table.insert(ordered, item[2])
                end
            end
        else
            local currentILVL = 0
            if o.equip[slot] ~= nil then 
                currentILVL = o.equip[slot].ilvl 
            end
            item.increase = item.ilvl - currentILVL
            if (not item.used) then
                table.insert(ordered, item)
            end
        end
    end
    
    table.sort(ordered, function(a, b) return a.increase > b.increase end)
    
    local equippedAmount = o.equippedUniqueCount(group)
    for i = 1, (group.amount - equippedAmount) do
        local item = ordered[i]
        if item ~= nil and item.increase > 0 then
            item.used = true
            if (o:isDoubleSlot(item.equipLoc)) then
                if (item.replaceSlot == 2) then
                    if (o.equip[item.equipLoc][2] ~= nil) then
                        o.equip[item.equipLoc][2].used = false
                    end
                    o.equip[item.equipLoc][2] = o.equip[item.equipLoc][1]
                    o.equip[item.equipLoc][1] = item
                else
                    local trinkets = {}
                    if (o.equip[item.equipLoc][1] ~= nil) then
                        table.insert(trinkets, o.equip[item.equipLoc][1])
                    end
                    if (o.equip[item.equipLoc][2] ~= nil) then
                        table.insert(trinkets, o.equip[item.equipLoc][2])
                    end
                    table.insert(trinkets, item)
                    table.sort(trinkets, function(a, b) return a.ilvl > b.ilvl end)
                    o.equip[item.equipLoc][1] = trinkets[1]
                    o.equip[item.equipLoc][1] = trinkets[2]
                    if (trinkets[3] ~= nil) then
                        trinkets[3].used = false
                    end
                end
            else
                o.equip[item.equipLoc].used = false
                o.equip[item.equipLoc] = item
            end
        end
    end
    
    o.handleUniqueGroup(index - 1, o.uniqueGroupsOrdered[index - 1])
end





o.equippedUniqueCount = function(group)
    local used = 0
    
    for slot, item in pairs(o.equip) do
        if (o:isDoubleSlot(slot)) then
            for i = 1, #item do 
                if (item[i].uniqueGroup and item[i].uniqueGroup.group == group.name) then
                    used = used + 1
                end
            end 
        else 
            if (item.uniqueGroup and item.uniqueGroup.group == group.name) then
                used = used + 1
            end
        end
    end
    
    return used
end