local o = mOnPVPEquipManager

---------------------------------------------------------------
-- Default Settings (mOnPVPEMSave)
---------------------------------------------------------------

o.defaultSettings = {}

---------------------------------------------------------------
-- Main Initialization
---------------------------------------------------------------

o.tooltip = CreateFrame("GameTooltip", "mOnPVPEMTooltip", nil, "GameTooltipTemplate")
o.tooltip:SetOwner(UIParent, "ANCHOR_NONE")

o.ITEM_LEVEL_PATTERN = ITEM_LEVEL:gsub("%%d", "(%%d+)")
o.UNIQUE_PATTERN = ITEM_UNIQUE_EQUIPPABLE:gsub("%-", "%%-")..": (.*) %((%d+)%)"
o.ITEM_SLOTS = {
    {CharacterHeadSlot, "INVTYPE_HEAD"},
    {CharacterNeckSlot, "INVTYPE_NECK"},
    {CharacterShoulderSlot, "INVTYPE_SHOULDER"},
    {CharacterBackSlot, "INVTYPE_CLOAK"},
    {CharacterChestSlot, "INVTYPE_CHEST"},
    {CharacterWristSlot, "INVTYPE_WRIST"},
    {CharacterHandsSlot, "INVTYPE_HAND"},
    {CharacterWaistSlot, "INVTYPE_WAIST"},
    {CharacterLegsSlot, "INVTYPE_LEGS"},
    {CharacterFeetSlot, "INVTYPE_FEET"},
    {CharacterFinger0Slot, "INVTYPE_FINGER"},
    {CharacterFinger1Slot, "INVTYPE_FINGER"},
    {CharacterTrinket0Slot, "INVTYPE_TRINKET"},
    {CharacterTrinket1Slot, "INVTYPE_TRINKET"},
    {CharacterMainHandSlot, "INVTYPE_WEAPON"},
    {CharacterSecondaryHandSlot, "INVTYPE_SHIELD"} 
}

---------------------------------------------------------------
-- Debug Methods
---------------------------------------------------------------

o.printResult = function()
    local sum = 0    
    
    for slot, item in pairs(o.equip) do
        if (o:isDoubleSlot(slot)) then
            for i = 1, #item do 
                print(slot, item[i].name, item[i].ilvl)
                sum = sum + item[i].ilvl
            end 
        else 
            print(slot, item.name, item.ilvl)
            sum = sum + item.ilvl
        end
    end
    
    print(math.floor(sum / (14) * 100) / 100)
end

function o:printCleanedGroups()
    for i = 1, #self.uniqueGroupsOrdered do
        local group = self.uniqueGroupsOrdered[i]
        print(group.name, group.amount, group.count)
        for slot, item in pairs(group.items) do
            if (o:isDoubleSlot(slot)) then
                for i = 1, #item do 
                    print(slot, item[i].name, item[i].ilvl)
                end 
            else 
                print(slot, item.name, item.ilvl)
            end
        end
    end
end

function o:printOrdered()
    for i = 1, #ordered do
        local item = ordered[i]
        local link = ''
        if self.equip[item.equipLoc] ~= nil then
            link = self.equip[item.equipLoc].link
        end
        print(item.increase, item.link, item.equipLoc, link)
    end
end

---------------------------------------------------------------
-- Methods
---------------------------------------------------------------

o.fixSettings = function()
    if mOnPVPEMSave == nil then mOnPVPEMSave = {} end
    for k, v in pairs(o.defaultSettings) do
        if mOnPVPEMSave[k] == nil then mOnPVPEMSave[k] = v end
    end
end

o.equipForPVP = function()
    o.playerInfo = {}
    o.uniqueGroups = {}
    o.equip = {}

    localizedClass, englishClass, classIndex = UnitClass("player")
    o.playerInfo.class = englishClass
    o.playerInfo.level = UnitLevel("player")

    o.scanEquippedItems()
    o.scanBagItems()

    o.uniqueGroupsOrdered = {}
    for key, value in pairs(o.uniqueGroups) do
        local clean = o.cleanup(value)
        table.insert(o.uniqueGroupsOrdered, clean)
        clean.name = key
    end

    table.sort(o.uniqueGroupsOrdered, function(a, b) return a.amount > b.amount end)
    
    for i = 1, #o.uniqueGroupsOrdered do
        o.handleUniqueGroup(i, o.uniqueGroupsOrdered[i])
    end
    
    o:equipItems()
end

o.scanEquippedItems = function()
    for _, v in ipairs(o.ITEM_SLOTS) do
        local itemLink = GetInventoryItemLink("player", v[1]:GetID())
        o.getItemInfo(itemLink, v[1]:GetID())
    end
end

o.scanBagItems = function()
    for bag = BACKPACK_CONTAINER, BACKPACK_CONTAINER + NUM_BAG_SLOTS do
        for slot = 1, GetContainerNumSlots(bag) do
            local texture, itemCount, locked, quality, readable, lootable, itemLink, isFiltered, hasNoValue, itemID = GetContainerItemInfo(bag, slot)
            o.getItemInfo(itemLink, bag, slot)
        end
    end
end

o.addPossibleItem = function(item)
    -- name, link, ilvl, equipLoc, equipped, bag, slot, unique, uniqueGroup (group, amount)
    o.firstEquipping(item)
end

o.cleanup = function(group)
    local slots = {}
    local result = {amount = group.amount, items = {}, count = 0}
    
    for i = 1, #group.items do
        local item = group.items[i]
        if (o:isDoubleSlot(item.equipLoc)) then
            if (slots[item.equipLoc] == nil) then
                slots[item.equipLoc] = {}
                table.insert(slots[item.equipLoc], item)
                result.count = result.count + 1
            elseif #slots[item.equipLoc] == 1 then
                local d1 = item.ilvl - slots[item.equipLoc][1].ilvl
                if (d1 > 0) then
                    table.insert(slots[item.equipLoc], slots[item.equipLoc][1])
                    slots[item.equipLoc][1] = item
                else
                    table.insert(slots[item.equipLoc], item)
                end
                result.count = result.count + 1
            else
                local d1 = item.ilvl - slots[item.equipLoc][1].ilvl
                local d2 = item.ilvl - slots[item.equipLoc][2].ilvl
                
                if (slots[item.equipLoc][1].name == item.name) then
                    if (d1 > 0) then
                        slots[item.equipLoc][1] = item
                    end
                elseif (slots[item.equipLoc][2].name == item.name) then
                    if (d2 > 0) then
                        slots[item.equipLoc][1] = item
                    end
                else
                    if (d1 > 0) then
                        slots[item.equipLoc][2] = slots[item.equipLoc][1]
                        slots[item.equipLoc][1] = item
                    elseif (d2 > 0) then
                        slots[item.equipLoc][2] = item
                    end
                end
            end
        else
            if (slots[item.equipLoc] == nil) or (slots[item.equipLoc].ilvl < item.ilvl) then
                if (slots[item.equipLoc] == nil) then 
                    result.count = result.count + 1
                end
                slots[item.equipLoc] = item
            end
        end
    end
    
    result.items = slots
    return result
end

o.firstEquipping = function(item)
    item.used = false
    if (not o:isDoubleSlot(item.equipLoc)) then
        if (not item.uniqueGroup) then
            if (o.equip[item.equipLoc] == nil) or (o.equip[item.equipLoc].ilvl < item.ilvl) then
                o.equip[item.equipLoc] = item
            end
        else
            if (o.uniqueGroups[item.uniqueGroup.group] == nil) then
                o.uniqueGroups[item.uniqueGroup.group] = {amount = item.uniqueGroup.amount, items = {}}
            end
            table.insert(o.uniqueGroups[item.uniqueGroup.group].items, item)
        end
    else
        if (not item.uniqueGroup) then
            if (o.equip[item.equipLoc] == nil) then
                o.equip[item.equipLoc] = {}
                table.insert(o.equip[item.equipLoc], item)
            else
                if (item.unique) then
                    if (#o.equip[item.equipLoc] == 1) then
                        if (o.equip[item.equipLoc][1].name == item.name and o.equip[item.equipLoc][1].ilvl < item.ilvl) then
                            o.equip[item.equipLoc][1] = item
                        else
                            local d1 = item.ilvl - o.equip[item.equipLoc][1].ilvl
                            if (d1 > 0) then
                                table.insert(o.equip[item.equipLoc], o.equip[item.equipLoc][1])
                                o.equip[item.equipLoc][1] = item
                            else
                                table.insert(o.equip[item.equipLoc], item)
                            end
                        end
                    else
                        local d1 = item.ilvl - o.equip[item.equipLoc][1].ilvl
                        local d2 = item.ilvl - o.equip[item.equipLoc][2].ilvl
                        
                        if (o.equip[item.equipLoc][1].name == item.name) then
                            if (d1 > 0) then
                                o.equip[item.equipLoc][1] = item
                            end
                        elseif (o.equip[item.equipLoc][2].name == item.name) then
                            if (d2 > 0) then
                                o.equip[item.equipLoc][1] = item
                            end
                        else
                            if (d1 > 0) then
                                o.equip[item.equipLoc][2] = o.equip[item.equipLoc][1]
                                o.equip[item.equipLoc][1] = item
                            elseif (d2 > 0) then
                                o.equip[item.equipLoc][2] = item
                            end
                        end
                    end
                else
                    if (#o.equip[item.equipLoc] == 1) then
                        local d1 = item.ilvl - o.equip[item.equipLoc][1].ilvl
                        if (d1 > 0) then
                            table.insert(o.equip[item.equipLoc], o.equip[item.equipLoc][1])
                            o.equip[item.equipLoc][1] = item
                        else
                            table.insert(o.equip[item.equipLoc], item)
                        end
                    else
                        local d1 = item.ilvl - o.equip[item.equipLoc][1].ilvl
                        local d2 = item.ilvl - o.equip[item.equipLoc][2].ilvl
                        
                        if (d1 > 0) then
                            o.equip[item.equipLoc][2] = o.equip[item.equipLoc][1]
                            o.equip[item.equipLoc][1] = item
                        elseif (d2 > 0) then
                            o.equip[item.equipLoc][2] = item
                        end
                    end
                end
            end
        else
            if (o.uniqueGroups[item.uniqueGroup.group] == nil) then
                o.uniqueGroups[item.uniqueGroup.group] = {amount = item.uniqueGroup.amount, items = {}}
                table.insert(o.uniqueGroups[item.uniqueGroup.group].items, item)
            else
                if (item.unique) then
                    local found = false
                    for i = 1, #o.uniqueGroups[item.uniqueGroup.group].items do
                        if (item.name == o.uniqueGroups[item.uniqueGroup.group].items[i].name) then
                            found = true
                            if (item.ilvl > o.uniqueGroups[item.uniqueGroup.group].items[i].ilvl) then
                                o.uniqueGroups[item.uniqueGroup.group].items[i] = item
                            end
                        end
                    end
                    if not found then
                        table.insert(o.uniqueGroups[item.uniqueGroup.group].items, item)
                    end
                else
                    table.insert(o.uniqueGroups[item.uniqueGroup.group].items, item)
                end
            end
        end
    end
end

o.getItemInfo = function(itemLink, bag, slot)
    if not itemLink then
        return
    end

    local itemName, itemLink_, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount,
    itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID,
    isCraftingReagent = GetItemInfo(itemLink)

    if itemEquipLoc == "INVTYPE_ROBE" then
        itemEquipLoc = "INVTYPE_CHEST"
    end

    -- No artifacts
    if itemRarity == 6 then
        return
    end

    -- Only armor
    if itemClassID ~= LE_ITEM_CLASS_ARMOR then
        return
    end

    if itemEquipLoc == "INVTYPE_HOLDABLE" then
        return
    end

    if (not not slot) and (not o.canWear(itemMinLevel, itemEquipLoc, itemSubClassID)) then
        return
    end

    local itemLevel = false
    local soulbound = false
    local unique = false
    local uniqueGroup = false

    o.tooltip:ClearLines()
    if slot then
        o.tooltip:SetBagItem(bag, slot)
    else
        o.tooltip:SetHyperlink(itemLink)
        soulbound = true
    end

    if bindType == 0 then
        soulbound = true
    end

    for i = 1, o.tooltip:NumLines() do
        local text = _G["mOnPVPEMTooltipTextLeft" .. i]:GetText()
        if (text and text ~= "") then
            if not itemLevel then
                itemLevel = tonumber(text:match(o.ITEM_LEVEL_PATTERN))
            end
            if not soulbound and text == ITEM_SOULBOUND then
                soulbound = true
            end
            if not unique and text == ITEM_UNIQUE_EQUIPPABLE then
                unique = true
            end
            if not uniqueGroup then
                local group, amount = text:match(o.UNIQUE_PATTERN)
                if group then
                    uniqueGroup = {}
                    uniqueGroup.group = group
                    uniqueGroup.amount = tonumber(amount)
                end
            end
        end
    end

    if (itemLevel and itemLevel > 1 and soulbound) then
        item = {}
        item.name = itemName
        item.link = itemLink
        item.ilvl = itemLevel
        item.equipLoc = itemEquipLoc
        item.equipped = slot == nil
        item.bag = bag
        item.slot = slot
        item.unique = unique
        item.uniqueGroup = uniqueGroup

        o.addPossibleItem(item)
    end
end

---------------------------------------------------------------
-- Events
---------------------------------------------------------------

o.eventFrame = CreateFrame("Frame")
local f = o.eventFrame
f:RegisterEvent("ADDON_LOADED")
f:RegisterEvent("PLAYER_ENTERING_WORLD")

function f:OnEvent(event, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22, arg23)
    if (event == "ADDON_LOADED") and (arg1 == "mOnArs_PVPEquipManager") then
        o.fixSettings()
        o.cooldown = 30
    end

    if (event == "PLAYER_ENTERING_WORLD") then
        o.cooldown = 30
    end
end

f:SetScript("OnEvent", f.OnEvent)
