local o = mOnPVPEquipManager
local f = o.eventFrame

function o:makeTooltip()
    GameTooltip:ClearLines()
    GameTooltip:ClearAllPoints()
    GameTooltip:SetPoint("BOTTOMLEFT", mOnPVPEM_PaperDoll_EquipButton, "TOPLEFT")
    GameTooltip:AddLine("Equip for PVP")
    if (self.cooldown > 0) then
        GameTooltip:AddLine("Please wait " .. math.ceil(self.cooldown) .. "s")
    else
        GameTooltip:AddLine("You might need to click multiple times")
    end
end

function f:OnUpdate(arg1)
    if (o.cooldown > 0) then
        o.cooldown = o.cooldown - arg1
        if (o.cooldown < 0) then
            o.cooldown = 0
        end
        if (o.cooldownVisible) then
            o:makeTooltip()
        end
    end

    if PaperDollItemsFrame then
        if mOnPVPEM_PaperDoll_EquipButton == nil then
            local b = CreateFrame("BUTTON", "mOnPVPEM_PaperDoll_EquipButton", PaperDollItemsFrame);
            b:SetPoint("TOPLEFT", 65, -25)
            b:SetWidth(32)
            b:SetHeight(32)

            b:SetScript("OnClick", function()
                if (o.cooldown <= 0) then
                    o.equipForPVP()
                    o.cooldown = 5
                end
            end)
            b:SetScript("OnLeave", function()
                GameTooltip:Hide()
                b.Ring:SetAlpha(0.7)
                o.cooldownVisible = false
            end)
            b:SetScript("OnEnter", function()
                GameTooltip_SetDefaultAnchor(GameTooltip, b)
                o:makeTooltip()
                GameTooltip:Show()
                b.Ring:SetAlpha(1)
                o.cooldownVisible = true
            end)


            b.Ring = b:CreateTexture(nil, "ARTWORK")
            b.Ring:SetAllPoints(b)
            b.Ring:SetTexture("Interface\\PVPFrame\\Icons\\prestige-icon-3")
            b.Ring:SetAlpha(0.7)

            b:SetNormalTexture(b.Icon)
        end
    end
end

f:SetScript("OnUpdate", f.OnUpdate)