--- ########## Options dialog for iGuard - Uses Ace ###########

iguard_config = {} -- Global Var holding all config releated objects


function iguard_CreateConfig()
	
	if ( iguard_config.AceConfig ~= nil) then
		return;
	end

	 iguard_config.AceConfig = {
		name = "iGuard",
		handler = nil,
		type = 'group',
		args = {
		
			--------------- General Options ----------------
		
			a = {
				type = 'header',
				name = "Action to take",
				order=100,
				
			},
			
			aa = {
				type = 'toggle',
				name = "Stop Vendor Sales",
				desc = "If you attempt to sell an item you have protected, it will be bought back automatically.",
				set = function(info,val) iguard_data.options.RestoreProtected=val end,
				get = function(info) return iguard_data.options.RestoreProtected end,
				order=101,
			},
			
			ab = {
				type = 'toggle',
				name = "Warn if destroying",
				desc = "If you are currently using a spell (Disenchant, mill, etc) that would destroy a protected item a message and audible warning will be shown.",
				set = function(info,val) iguard_data.options.BlockDisenchant=val end,
				get = function(info) return iguard_data.options.BlockDisenchant end,
				order=102,
			},
			
			ac = {
				type = 'toggle',
				name = "Log sales in chat.",
				desc = "Display the item sold in chat when sold.",
				set = function(info,val) iguard_data.options.AllSalesToChat=val end,
				get = function(info) return iguard_data.options.AllSalesToChat end,
				order=103,
			},
			
			
			b = {
				type = 'header',
				name = "Protect what",
				order=200,
				
			},

			ba = {
				type = 'toggle',
				name = "Equipment Sets",
				desc = "Protect items that are part of an equipment set.",
				set = function(info,val) iguard_data.options.ProtectEquiped=val end,
				get = function(info) return iguard_data.options.ProtectEquiped end,
				order=201,
			},
			
			bb = {
				type = 'toggle',
				name = "Epics Items(+)",
				desc = "Protect items are epic or greater.",
				set = function(info,val) iguard_data.options.ProtectEpicPlus=val end,
				get = function(info) return iguard_data.options.ProtectEpicPlus end,
				order=202,
			},
			
			
			bc = {
				type = 'toggle',
				name = "Rare Items",
				desc = "Protect items that are rare.",
				set = function(info,val) iguard_data.options.ProtectRare=val end,
				get = function(info) return iguard_data.options.ProtectRare end,
				order=203,
			},
			
			c = {
				type = 'header',
				name = "Other Options",
				order=300,
				
			},

			ca = {
				type = 'toggle',
				name = "Use Alert Sounds",
				desc = "Play alert sounds when a protected item is at risk.",
				set = function(info,val) iguard_data.options.Sound=val end,
				get = function(info) return iguard_data.options.Sound end,
				order=301,
			},
			
			
			
			
			
		},
	}

	 iguard_config.AceOptionsTable= LibStub("AceConfig-3.0")

	 iguard_config.AceOptionsTable:RegisterOptionsTable("iGuardOpt", iguard_config.AceConfig)
	 iguard_config.AceDialog= LibStub("AceConfigDialog-3.0")
	 iguard_config.optdlg=iguard_config.AceDialog:AddToBlizOptions("iGuardOpt","iGuard")
end

