if not LibStub then return end

local LDB = LibStub("LibDataBroker-1.1")
local tip = LibStub('LibQTip-1.0')


iguard_Broker = LibStub("AceAddon-3.0"):NewAddon("Broker_iguard", "AceConsole-3.0", "AceTimer-3.0", "AceEvent-3.0")
iguard_tip_popup = nil;



local function iGuardDBTooltip_Show(frame)
	iguardTooltip_Update();
	iguard_Broker.tooltip:SmartAnchorTo(frame)
	iguard_Broker.tooltip:SetAutoHideDelay(1, frame)
	iguard_Broker.tooltip:Show()
end


-- ****************************************************
--  Manage Ppoups
-- ****************************************************



local function openHistory()

---Define
  iguard_tip_popup = tip:Acquire("igaurdPopupTooltip", 3,"LEFT", "RIGHT", "RIGHT")
  iguard_tip_popup:Clear()
 -- iguard_tip_popup:SetHeaderFont(core:HeaderFont())
--  iguard_tip_popup:SetScale(vars.db.Tooltip.Scale)

--- Create

	iguard_tip_popup:AddLine("|cffC0E0FFItem", "|cffC0E0FFWhen","")
	
	local cnt=0
	for i = 1, #iguard_data.Log do
		local icon="";
		if (iguard_data.Log[i].protected) then
			icon=iguard.icons.main;
		end
		
		
		iguard_tip_popup:AddLine(iguard_data.Log[i].link, iguard.utils:TimeString(time()-iguard_data.Log[i].when),icon)

		cnt=cnt+1
	end
	
	if (cnt==0) then
		iguard_tip_popup:AddLine("None.", "","")
	end

--- Finish  
  
  iguard_tip_popup:SetAutoHideDelay(0.1, iguard_Broker.tooltip)
  iguard_tip_popup.OnRelease = function() iguard_tip_popup = nil end -- extra-safety: update our variable on auto-release
--  iguard_tip_popup:SmartAnchorTo(iguard_Broker.tooltip)

	iguard_SetMenuLocation(iguard_tip_popup,iguard_Broker.tooltip,-25)

  iguard_tip_popup:SetFrameLevel(100) -- ensure visibility when forced to overlap main tooltip
 -- addon:SkinFrame(indicatortip,"SavedInstancesIndicatorTooltip")
  iguard_tip_popup:Show()
end


local function openBuyBack()

---Define
  iguard_tip_popup = tip:Acquire("igaurdPopupTooltip", 2,"LEFT","RIGHT")
  iguard_tip_popup:Clear()
 -- iguard_tip_popup:SetHeaderFont(core:HeaderFont())
--  iguard_tip_popup:SetScale(vars.db.Tooltip.Scale)

--- Create

--	iguard_tip_popup:AddLine("|cffC0E0FFItem")
	
		
	
		local cnt=0
		for k, v in pairs(iguard.BuyBackCache) do
		
			local icon="";
			if (iguard.utils:isProtected(k)) then
				icon=iguard.icons.main;
			end
		
			iguard_tip_popup:AddLine(v,icon)
			cnt=cnt+1
		end
		
		if (cnt==0) then
			iguard_tip_popup:AddLine("None.", "","")
		end
	


--- Finish  
  
  iguard_tip_popup:SetAutoHideDelay(0.1, iguard_Broker.tooltip)
  iguard_tip_popup.OnRelease = function() iguard_tip_popup = nil end -- extra-safety: update our variable on auto-release
--  iguard_tip_popup:SmartAnchorTo(iguard_Broker.tooltip)

	iguard_SetMenuLocation(iguard_tip_popup,iguard_Broker.tooltip,-50)

  iguard_tip_popup:SetFrameLevel(100) -- ensure visibility when forced to overlap main tooltip
 -- addon:SkinFrame(indicatortip,"SavedInstancesIndicatorTooltip")
  iguard_tip_popup:Show()
end


local function openCustom()

---Define
  iguard_tip_popup = tip:Acquire("igaurdPopupTooltip", 1,"LEFT")
  iguard_tip_popup:Clear()
 -- iguard_tip_popup:SetHeaderFont(core:HeaderFont())
--  iguard_tip_popup:SetScale(vars.db.Tooltip.Scale)

--- Create

--	iguard_tip_popup:AddLine("|cffC0E0FFItem")
		local cnt=0
		for k, v in pairs(iguard_data.AlwaysProtect) do
			if (v~=nil) then 
				  iguard_tip_popup:AddLine(v)
				  cnt=cnt+1
			end
		end
		
		if (cnt==0) then
			iguard_tip_popup:AddLine("None.", "","")
		end


--- Finish  
  
  iguard_tip_popup:SetAutoHideDelay(0.1, iguard_Broker.tooltip)
  iguard_tip_popup.OnRelease = function() iguard_tip_popup = nil end -- extra-safety: update our variable on auto-release
--  iguard_tip_popup:SmartAnchorTo(iguard_Broker.tooltip)

	iguard_SetMenuLocation(iguard_tip_popup,iguard_Broker.tooltip,-140)

  iguard_tip_popup:SetFrameLevel(100) -- ensure visibility when forced to overlap main tooltip
 -- addon:SkinFrame(indicatortip,"SavedInstancesIndicatorTooltip")
  iguard_tip_popup:Show()
end


local function closePopup()

---Define
  if  iguard_tip_popup ~=nil then
	iguard_tip_popup:Hide()
  end
end

-- ****************************************************
-- ****************************************************
-- ****************************************************


function iguardTooltip_Update()

	if (iguard_Broker==nil) then 
			return;
	end
	
	
	if tip:IsAcquired("Broker_iguard") then tip:Release(iguard_Broker.tooltip) end
	iguard_Broker.tooltip = tip:Acquire("Broker_iguard", 3, "LEFT", "RIGHT", "RIGHT")
	
	--write Menu Items
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_gizmo_02.blp:16|t Configure...", "","")
		iguard_Broker.tooltip:SetLineScript(1, "OnMouseDown", iguardTooltip_Click_Line, "Configure")
		
		iguard_Broker.tooltip:AddSeparator(1, .5, .5, .5, 1)
		
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_coin_01.blp:16|t Vendor Sales History", "|cff30C0FF[".. #iguard_data.Log.."]","|cffFFF000>")
		iguard_Broker.tooltip:SetLineColor(3,0.047,0.188,.266,1)
		iguard_Broker.tooltip:SetLineScript(3, "OnMouseDown", iguardTooltip_Click_Line, "History")
		iguard_Broker.tooltip:SetLineScript(3, "OnEnter", iguardTooltip_Enter_Line, "History")
		iguard_Broker.tooltip:SetLineScript(3, "OnLeave", iguardTooltip_Leave_Line, "History")
		
		local cnt=0
		for k, v in pairs(iguard.BuyBackCache) do
			if (v~=nil) then 
				  cnt=cnt+1
			end
		end
		
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_bag_07_red.blp:16|t You can buy back","|cff30C0FF[".. cnt .."]","|cffFFF000>")
		iguard_Broker.tooltip:SetLineScript(4, "OnMouseDown", iguardTooltip_Click_Line, "BuyBack")
		iguard_Broker.tooltip:SetLineScript(4, "OnEnter", iguardTooltip_Enter_Line, "BuyBack")
		iguard_Broker.tooltip:SetLineScript(4, "OnLeave", iguardTooltip_Leave_Line, "BuyBack")

		
		iguard_Broker.tooltip:AddSeparator(1, .5, .5, .5, 1)
		
		iguard_Broker.tooltip:AddLine("|cffC0E0FFProtect:", "","")
		
		
		txtProtect="|cffff0000No"
		if (iguard_data.options.ProtectEquiped) then txtProtect="|cff00FF00Yes" end
		
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_cape_25.blp:16|t Equipment Sets",txtProtect,"")
		iguard_Broker.tooltip:SetLineColor(7,0.047,0.188,.266,1)
		iguard_Broker.tooltip:SetLineScript(7, "OnMouseDown", iguardTooltip_Click_Line, "Session")
		
		txtProtect="|cffff0000No"
		if (iguard_data.options.ProtectEpicPlus) then txtProtect="|cff00FF00Yes" end
		
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_epicgem_05.blp:16|t Epic+ Items",txtProtect,"")

		
		txtProtect="|cffff0000No"
		if (iguard_data.options.ProtectRare) then txtProtect="|cff00FF00Yes" end
		
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_epicgem_02.blp:16|t Rare Items",txtProtect,"")
		iguard_Broker.tooltip:SetLineColor(9,0.047,0.188,.266,1)
		
		local cnt=0
		for k, v in pairs(iguard_data.AlwaysProtect) do
			if (v~=nil) then 
				  cnt=cnt+1
			end
		end
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_cat_trinket05.blp:16|t Custom Items", "|cff30C0FF[".. cnt.."]","|cffFFF000>")
		iguard_Broker.tooltip:SetLineScript(10, "OnMouseDown", iguardTooltip_Click_Line, "Custom")
		iguard_Broker.tooltip:SetLineScript(10, "OnEnter", iguardTooltip_Enter_Line, "Custom")
		iguard_Broker.tooltip:SetLineScript(10, "OnLeave", iguardTooltip_Leave_Line, "Custom")
		
		iguard_Broker.tooltip:AddSeparator(1, .5, .5, .5, 1)
		iguard_Broker.tooltip:AddLine("|cffC0E0FFProtection:", "","")
		
		txtProtect="|cffff0000No"
		if (iguard_data.options.RestoreProtected) then txtProtect="|cff00FF00Yes" end
		
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_bag_17.blp:16|t Stop Vendor Sales",txtProtect,"")
		
		
		txtProtect="|cffff0000No"
		if (iguard_data.options.BlockDisenchant) then txtProtect="|cff00FF00Yes" end
		
		iguard_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_misc_bomb_07.blp:16|t Warn before destroy",txtProtect,"")
		iguard_Broker.tooltip:SetLineColor(14,0.047,0.188,.266,1)
		
		
		

		
		
end

function iguardTooltip_Click_Line(line, setName, button)
	
	if (setName=="Session") then 
		iguard:OutputSession()
		iguard_Broker.tooltip:Hide()
	end
	
	if (setName=="Configure") then 
		InterfaceOptionsFrame_OpenToCategory(iguard_config.optdlg)
		iguard_Broker.tooltip:Hide()
	end
	
    if (setName=="History") then iguardTooltip_Enter_Line(line,setName,button); end
	if (setName=="BuyBack") then  iguardTooltip_Enter_Line(line,setName,button); end
	if (setName=="Custom") then  iguardTooltip_Enter_Line(line,setName,button); end

	
	
end

function iguardTooltip_Enter_Line(line, setName, button)
	
	
    if (setName=="History") then openHistory(); end
	if (setName=="BuyBack") then openBuyBack(); end
	if (setName=="Custom") then openCustom(); end

	
	
end


function iguardTooltip_Leave_Line(line, setName, button)
	

	
    if (setName=="History") then closePopup(); end
	if (setName=="BuyBack") then closePopup(); end
	if (setName=="Custom") then closePopup(); end

	
	
end


function iguard_Broker:OnInitialize()

    -- Called when the addon is loaded
    self.lDBObject = {
		type = 'data source',
		text = 'iGuard',
		icon = 'Interface\\Icons\\INV_shield_10.blp',
		OnEnter = iGuardDBTooltip_Show,
	}
	
	LDB:NewDataObject("iGuard", self.lDBObject)
	
	iguardTooltip_Update();
end


------- Anchor to menu item


function iguard_SetMenuLocation(tooltip,frame,offsetY)
	if not frame then
		error("Invalid frame provided.", 2)
	end
	tooltip:ClearAllPoints()
	tooltip:SetClampedToScreen(true)
	tooltip:SetPoint("TOPLEFT",frame,"TOPRIGHT",0,offsetY)
end