-- Author      : Linty


iguard={frame=CreateFrame("Frame"), core={}, utils={}, event={},vars={},broker={}, icons={}, sessionProtected={}, BuyBackCache={},HasVisitedVendor=false, SelectedItem=0, SelectedItemLink="", SelectedItemWarned=false};

iguard.icons.main="|TInterface\\Icons\\INV_shield_10.blp:16|t"
iguard.icons.protected="|TInterface\\Icons\\INV_misc_qirajicrystal_02.blp:16|t"


iguard.frame:SetScript("OnEvent", function(self, event, ...)
 iguard.event:handler(self,event, ...); -- call event handler
end);

iguard.vars.debug=1; -- set debug level to critical only

iguard_data= {options = {version=0.1, logMax=40, RestoreProtected=true, AllSalesToChat=true},
				Log={},
				AlwaysProtect={},
				};


---------------------------Register Events--------
 iguard.frame:RegisterEvent("VARIABLES_LOADED");
 iguard.frame:RegisterEvent("ADDON_LOADED");


 iguard.frame:RegisterEvent("MERCHANT_UPDATE");
 iguard.frame:RegisterEvent("MERCHANT_SHOW");
 iguard.frame:RegisterEvent("EQUIPMENT_SETS_CHANGED");
 iguard.frame:RegisterEvent("EQUIPMENT_SWAP_FINISHED");
 iguard.frame:RegisterEvent("PLAYER_EQUIPMENT_CHANGED");
 iguard.frame:RegisterEvent("WEAR_EQUIPMENT_SET");
 iguard.frame:RegisterEvent("UNIT_SPELLCAST_START");




------------------------Send Mesage to chat---------------------
function iguard.utils:Chat(chatmsg)

	if (chatmsg==nil) then 
		chatmsg="";
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000iGuard: |r"..chatmsg);
end

function iguard.utils:Alert(chatmsg)

	if (chatmsg==nil) then 
		chatmsg="";
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFF0000iGuard: |r"..chatmsg);
end


------------------------Send Debug to chat---------------------
function iguard.utils:Debug(level, debugStr) --- level == 0-Critical, 1- Important, 2-Information, 3-trace only
		
		if (debugStr==nil or level == nil) then 
			return;
		end
		if (iguard.vars.debug+1<level) then 
				return;
		end
		
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000iGuard: |cffff0000[Debug] |r"..debugStr);
end

---------------------------------Helper Functions---------------------------------
function iguard.utils:SafeNil(StringVar)
		if (StringVar== nil) then
			return "";
		end

		return StringVar;
end 

function iguard.utils:TimeString(secs)

	if (secs==nil) then
		return "-";
	end
	
	if (secs<60) then
		return "< 1m";
	end
		
	
	
	local mins=math.floor(secs/60);
	local hours=0;
	local days=0;

	hours,mins=math.modf(mins/60);
	mins=math.floor(mins*60);

	days,hours=math.modf(hours/24);

	hours=math.floor(hours*24);

	sret=""
	if (days>0) then
		sret=days.."d ";
	end

	if (hours>0 or days>0) then
		sret=sret..hours.."h ";
	end

	sret=sret..mins.."m ";

return sret;
end

-------------------------Command Line--------------

function iguard_cmd(msg)

	iguard.utils:Chat("Command Line --> "..msg)
	
	msgl=string.lower(msg);
	
	if msgl=="buyback" then
		iguard.utils:Chat("Items that can be bought back:");
		local cnt=0
		for k, v in pairs(iguard.BuyBackCache) do
		  iguard.utils:Chat(" - "..v)
		  cnt=cnt+1
		end
		
		if (cnt==0) then
			iguard.utils:Chat(" - No items to buy back or you have not visited a vendor this session.")
		end
		
	elseif msgl=="session" then
		
		iguard:OutputSession()

	elseif msgl=="custom" then
		iguard.utils:Chat("Items you have defined must be protected:");
		local cnt=0
		for k, v in pairs(iguard_data.AlwaysProtect) do
			if (v~=nil) then 
				  iguard.utils:Chat(" - "..v)
				  cnt=cnt+1
			end
		end
		
		if (cnt==0) then
			iguard.utils:Chat(" - No items protected.")
		end
		
	elseif msgl=="history" then
		iguard.utils:Chat("The last items you have sold:");
		local cnt=0
		for i = 1, #iguard_data.Log do
			local icon="";
			if (iguard_data.Log[i].protected) then
				icon=iguard.icons.protected.." ";
			end
			
			iguard.utils:Chat(i..". "..icon..iguard_data.Log[i].link.. " ("..iguard.utils:TimeString(time()-iguard_data.Log[i].when)..")")
			cnt=cnt+1
		end
		
		if (cnt==0) then
			iguard.utils:Chat(" - No items have been sold.")
		end
		
	elseif (msg:match("item:(%d+):")~=nil) then
		local itemID = msg:match("item:(%d+):")
		if (iguard_data.AlwaysProtect[itemID]==nil) then
			iguard_data.AlwaysProtect[itemID]=msg
			iguard.utils:Chat("Add '"..msg.."' to custom list.");
		else
			iguard_data.AlwaysProtect[itemID]=nil
			iguard.utils:Chat("Removed '"..msg.."' from custom list.");
		end
		
	elseif (msgl=="config") then
		 InterfaceOptionsFrame_OpenToCategory(iguard_config.optdlg);
	elseif (msgl=="debug") then
		 if iguard.vars.debug>1 then
			iguard.vars.debug=1
			iguard.utils:Chat("Debug set to critical only.(off)")
		else
			iguard.vars.debug=10
			iguard.utils:Chat("Debug set to all.(on)")
		end
		
	else
	
		iguard.utils:Chat("iGuard Commands:")
		iguard.utils:Chat("\\ig config - configure iGuard.")
		iguard.utils:Chat("\\ig buyback - list items that can be bought back form the vendor.")
		iguard.utils:Chat("\\ig session - list items that are protected because they are assigned to an equipment set.")
		iguard.utils:Chat("\\ig custom - Items you have defined that must be protected.")
		iguard.utils:Chat("\\ig history - show you sales history")
		iguard.utils:Chat("\\ig [Link] - Add or remove (if already added) the [link] form the custom protection list.")
	end
	
end


function  iguard:OutputSession()
	iguard.utils:updateSessionProtected()
	iguard.utils:Chat("Equipment set items currently protected:");
	local cnt=0
	for k, v in pairs(iguard.sessionProtected) do
		if (v~=nil and v.link~=nil and v.set~=nil and k~=nil) then
			iguard.utils:Chat(" - :"..k..": "..v.link.." ("..v.set..")")
			cnt=cnt+1
		end
	end
	
	if (cnt==0) then
		iguard.utils:Chat(" - No items protected.")
	else
		iguard.utils:Debug(5,"Protected equipment: "..#iguard.sessionProtected..":"..cnt);
	end

end


-------------------------Initialize Functions--------------
function iguard:init()

	SLASH_IGUARD1="/iguard";
	SLASH_IGUARD2="/ig";
	SLASH_IGUARD3="/protect";
    SlashCmdList["IGUARD"] = iguard_cmd;
	
	 iguard.utils:upgradeData()
	 
	 iguard_CreateConfig();
	 
	 iguard.utils:updateSessionProtected();
	 
	 GameTooltip:HookScript("OnTooltipSetItem", iguard.event.ItemToolTip);
	
	iguard.utils:Chat("Loaded.")
	
end


function iguard.utils:upgradeData()

	if (iguard_data.options.version==0.1) then
		iguard_data.options.version=0.2
		iguard_data.options.ProtectEquiped=true
		iguard_data.options.ProtectEpicPlus=true
		iguard_data.options.ProtectRare=true
		iguard.utils:Chat("Upgraded to version 0.2 Data.")

	end
	
	if (iguard_data.options.version==0.2) then
		iguard_data.options.version=0.3
		iguard_data.options.BlockDisenchant=true
		
		iguard.utils:Chat("Upgraded to version 0.3 Data.")

	end
	
	
	if (iguard_data.options.version==0.3) then
		iguard_data.options.version=0.4
		iguard_data.options.Sound=true
		
		iguard.utils:Chat("Upgraded to version 0.3 Data.")

	end

end

function iguard:PlaySound(sound)

	if (iguard_data.options.Sound) then PlaySound(sound) end

end
--------------------------Event Handler---------------------------------
function iguard.event:ItemToolTip(arg1, arg2)
	name, link = GameTooltip:GetItem() 
	if (link~=nil) then
		local itemID = link:match("item:(%d+):")
	--	iguard.utils:Chat("Over: "..itemID.." : "..link)
		
		if (tonumber(itemID) ~= iguard.SelectedItem) then
			
			iguard.SelectedItemWarned = false
			iguard.SelectedItem=tonumber(itemID)
			iguard.SelectedItemLink=link
		end
		
		if (iguard.utils:isProtected(iguard.SelectedItem)) then
			GameTooltip:AddLine(iguard.icons.main.." |cFF00FFFFProtected by |cFFFF8000iGuard|r.");
		end
		
		isTargeting = SpellIsTargeting()
		canTarget = SpellCanTargetItem()
		
		if (isTargeting and canTarget and not iguard.SelectedItemWarned) then --Could destroy item
			
			iguard.utils:DisenchantBlock()
			
		end
		
	end
	
	
end

function iguard.event:handler(self, event, ...)

	if (event=="ADDON_LOADED") then
         
       
        
    elseif (event=="VARIABLES_LOADED") then
			
           
          iguard:init()
	 elseif (event=="MERCHANT_UPDATE" or event=="MERCHANT_SHOW") then
			
          iguard.utils:updateSessionProtected();
          iguard.utils:BuyBackCheck();
		  
	 elseif (event=="EQUIPMENT_SETS_CHANGED" or event=="EQUIPMENT_SWAP_FINISHED" or event=="PLAYER_EQUIPMENT_CHANGED" or event=="WEAR_EQUIPMENT_SET") then	  

		iguard.utils:updateSessionProtected();
		
	elseif (event=="UNIT_SPELLCAST_START") then
		-- local unitID, spell, rank, lineID, spellID = ...
		 
		 --iguard.utils:Chat("Casting -->> "..iguard.utils:SafeNil(spell)..":"..iguard.utils:SafeNil(unitID)..":"..iguard.utils:SafeNil(spellID))
		 
		-- if spellID~=nil and tonumber(spellID)==160201 then --Disenchant
			--iguard.utils:DisenchantBlock()
			
		 --end
		
		
		
		
    end

end


function iguard.utils:BuyBackCheck()
	local newBBCache={}
	
	for i = 1, GetNumBuybackItems() do
		local link = GetBuybackItemLink(i)
		
		
		if link then
			local itemID = link:match("item:(%d+):")
			
			
		
			newBBCache[itemID] = link
			
			local isNew=true
			
			if (iguard.BuyBackCache[itemID]~=nil) then
				isNew=false
			end
		
						
			if (isNew  and iguard.HasVisitedVendor) then -- Must be new and ignore if first time opening vendor.
			
				iguard.utils:Debug(5,"Found new item --> "..link);
				
				if iguard_data.options.AllSalesToChat then
					iguard.utils:Chat(">>> Sold "..link.." to vendor <<<")
				end
				
				
				
				if iguard.utils:isProtected(itemID) then --protected??
				
					iguard.utils:Debug(5,"Protected Value --> True")
					if IsControlKeyDown() and iguard_data.options.RestoreProtected then --By pass with CTRL key.
					
						UIErrorsFrame:AddMessage("iGuard |cffff0000 : Warning: CTRL Key pressed -->> "..link.." |cffff0000has been sold!", 1, 1, 1, 53, 5)
						iguard.utils:Alert(">>> Warning: CTRL Key pressed -->> "..link.." has been sold <<<")
						
						tinsert(iguard_data.Log,1, {item=itemID, link=link, when = time(), protected=true});
					
						while (#iguard_data.Log>iguard_data.options.logMax) do 
							tremove(iguard_data.Log,41);
						end
						
					elseif iguard_data.options.RestoreProtected then
						BuybackItem(i)
						iguard.utils:Alert(iguard.icons.main.." Bought Back "..link.." from vendor "..iguard.icons.main)
					else
						UIErrorsFrame:AddMessage("iGuard |cffff0000 : Warning: "..link.." |cffff0000has been sold!", 1, 1, 1, 53, 5)
						iguard.utils:Alert(">>> Warning "..link.." has been sold <<<")
						
						tinsert(iguard_data.Log,1, {item=itemID, link=link, when = time(), protected=true});
					
						while (#iguard_data.Log>iguard_data.options.logMax) do 
							tremove(iguard_data.Log,41);
						end
						
					end
					
					 iguard:PlaySound(SOUNDKIT.RAID_WARNING)
					
				else
				
					iguard.utils:Debug(5,"Protected Value --> false")
					
					tinsert(iguard_data.Log,1, {item=itemID, link=link, when = time(), protected=false});
					
					while (#iguard_data.Log>iguard_data.options.logMax) do 
						tremove(iguard_data.Log,41);
					end
				end
				
				
				 
			end
			
			
			
		end
		
		
		
		
	end
	
	-- Update Cache
	iguard.HasVisitedVendor=true;
	iguard.BuyBackCache={}
	
	for k, v in pairs(newBBCache) do
	  iguard.BuyBackCache[k]=v;
	end
	
end

function iguard.utils:DisenchantBlock()
	
			
	iguard.utils:Debug(5,"Checking disenchant of --> "..iguard.SelectedItem )
	
	if iguard.utils:isProtected(""..iguard.SelectedItem) then
	
		iguard.utils:Debug(5,"Protected Value --> True")
		
		if iguard_data.options.BlockDisenchant then
			UIErrorsFrame:AddMessage("iGuard |cffff0000 : Warning: "..iguard.SelectedItemLink.." |cffff0000could be destroyed!", 1, 1, 1, 53, 5)
			iguard.utils:Alert("Warning: "..iguard.SelectedItemLink.." |cffff0000could be destroyed!")
			iguard:PlaySound(SOUNDKIT.RAID_WARNING)
			iguard.SelectedItemWarned=true;
		end
		
		 
		
	else
	
		iguard.utils:Debug(5,"Protected Value --> false")

	end
	

	
end


function iguard.utils:isProtected(itemID)
	iguard.utils:Debug(5,"Verifying protection for ["..iguard.utils:SafeNil(itemID).."]...");
	if (itemID==nil) then --- item unidentifiable
		return false;
	end

	itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType,
    itemStackCount, itemEquipLoc, itemTexture, itemSellPrice =
       GetItemInfo(itemID)
	if (itemID==nil or itemLink==nil) then
		return false;
	end
	
	
	iguard.utils:Debug(5,"Idenitfied link as :: "..itemLink.."...");
	
	local protect=false
	
	--Protect Epic +
	if  (itemRarity>3 and iguard_data.options.ProtectEpicPlus) then 
		iguard.utils:Debug(5,"Protected as epic...");
		protect=true;
	end
	
	--Protect Rare
	if  (itemRarity==3 and iguard_data.options.ProtectRare) then 
		iguard.utils:Debug(5,"Protected as rare...");
		protect=true;
	end
	
	-- Protect Custom
	if (iguard_data.AlwaysProtect[itemID]~=nil) then
		iguard.utils:Debug(5,"Protected as custom...");
		protect=true;
	end
	
	
	iguard.utils:Debug(5,"Protected equipment: Type is "..type(iguard.sessionProtected[tonumber(itemID)]));
	--Protect Equipped this Session
	if (type(iguard.sessionProtected[tonumber(itemID)])=="table" and iguard_data.options.ProtectEquiped) then
		iguard.utils:Debug(5,"Protected as equipment...");
		protect=true;
	end
	
	
	
	return protect;

end

function iguard.utils:updateSessionProtected()

	iguard.sessionProtected={}

	iguard.utils:Debug(5,"Equipment Set found : "..C_EquipmentSet.GetNumEquipmentSets());
	local setIDs = C_EquipmentSet.GetEquipmentSetIDs()
	for i = 1, C_EquipmentSet.GetNumEquipmentSets() do
		local name, icon, setID, isEquipped, numItems, numEquipped, numInventory, numMissing, numIgnored = C_EquipmentSet.GetEquipmentSetInfo(setIDs[i])
		if (setID~=nil) then
			iguard.utils:Debug(5,"Equipment Set ID is : "..setID .. "["..name.."]");
			local itemIDs = C_EquipmentSet.GetItemIDs(setID)
			
			for i=1, 19 do
			  if itemIDs[i] then
				local iname, ilink, iquality, iLevel, ireqLevel, iclass, isubclass, imaxStack, iequipSlot, itexture, ivendorPrice = GetItemInfo(itemIDs[i])
				
				if (iguard.sessionProtected[itemIDs[i]]~=nil) then
					iguard.sessionProtected[itemIDs[i]].set=iguard.sessionProtected[itemIDs[i]].set..", "..name
				else
					iguard.sessionProtected[itemIDs[i]] =  {set=name, slot=i, link=ilink}
				end
			  end
			end
		end
	end

end


