local ADDON, namespace = ...
local L = namespace.L

local prgname = "|cffffd200gmExp|r"

GMEXP_LONGNRFMT = true
GMEXP_NAMES = GMEXP_NAMES or {}

local next = next
local string_format = string.format

local playerName = UnitName("player")
local realmName = GetRealmName()
local _, class = UnitClass("player")

local list_enable = true -- false to not show the list of pg
local list_maxpgnum = 23

local function classcolor(name,class)
	local color = _G["RAID_CLASS_COLORS"][class]
	return string_format("\124cff%02x%02x%02x%s\124r", color.r*255, color.g*255, color.b*255, name)
end

local string_format = string.format
local number = function(v)

	if GMEXP_LONGNRFMT then return v end

	if v <= 9999 then return v
	elseif v >= 1000000000 then return format("%.1fB", v/1000000000)	
	elseif v >= 1000000 then return format("%.1fM", v/1000000)
	elseif v >= 10000 then return format("%.1fK", v/1000)
	end
	
end

local ldb = LibStub:GetLibrary("LibDataBroker-1.1")
local dataobj = ldb:NewDataObject("gmXp", {
	type = "data source",
	icon = "Interface\\Addons\\"..ADDON.."\\icon.tga",
	text = "-",
})

local frame = CreateFrame("Frame")
frame:RegisterEvent("PLAYER_ENTERING_WORLD")
frame:RegisterEvent("PLAYER_LOGIN")
frame:RegisterEvent("PLAYER_XP_UPDATE")
frame:RegisterEvent("ARTIFACT_XP_UPDATE")
frame:RegisterEvent("PLAYER_EQUIPMENT_CHANGED")

frame:SetScript("OnEvent", function(self, event, ...)

	if UnitLevel("player") == GetMaxPlayerLevel() then 
	
		if HasArtifactEquipped() then 
			local artifactItemID, _, _, _, ArtPower, ArtPointsSpent, _, _, _, _, _, _, artifactTier = C_ArtifactUI.GetEquippedArtifactInfo();
			dataobj.text = string_format("A:%s %.1f%%", ArtPointsSpent, ArtPower/C_ArtifactUI.GetCostForPointAtRank(ArtPointsSpent,artifactTier)*100)
		else 
			dataobj.text = "L: " .. UnitLevel("player")		
		end
	
	else	
		dataobj.text = string_format("L:%s %.1f%%", UnitLevel("player"), UnitXP("player")/UnitXPMax("player")*100)	
	end
		

	-- Define the current row in the array
	GMEXP_NAMES[realmName.."-"..playerName] = GMEXP_NAMES[realmName.."-"..playerName] or {}
	
	GMEXP_NAMES[realmName.."-"..playerName]["NAME"] 	= realmName.."-"..playerName
	GMEXP_NAMES[realmName.."-"..playerName]["ILVO"] 	= string_format("%.1f",select(1,GetAverageItemLevel()))
	GMEXP_NAMES[realmName.."-"..playerName]["ILVE"] 	= string_format("%.1f",select(2,GetAverageItemLevel()))
	GMEXP_NAMES[realmName.."-"..playerName]["CLASS"]	= class
	GMEXP_NAMES[realmName.."-"..playerName]["LIVL"] 	= string_format("%s", UnitLevel("player"))
	
end)	

dataobj.OnClick = function(self, button)  

		if 	button == "LeftButton" and IsShiftKeyDown() then 
			GMEXP_LONGNRFMT = not GMEXP_LONGNRFMT
			return
		end
		
		if button == "MiddleButton" and IsShiftKeyDown() then 
			GMEXP_NAMES = {}
			return
		end
		
		if 	button == "LeftButton" and HasArtifactEquipped() then 

			ArtifactFrame_LoadUI()

			if ( ArtifactFrame:IsVisible() ) then
					HideUIPanel(ArtifactFrame)
				else
					SocketInventoryItem(16);
			end	
				
		end 
end

function dataobj.OnTooltipShow(tooltip)

	tooltip:AddLine(ADDON)
	tooltip:AddLine(" ")
	
	if UnitLevel("player") == GetMaxPlayerLevel() then
		
		tooltip:AddDoubleLine(L["Max content level"], UnitLevel("player"), 1, 1, 1, 0, 1, 0)		

	else
	
		tooltip:AddDoubleLine(L["Level"], UnitLevel("player"), 1, 1, 1, 0, 1, 0)
		tooltip:AddDoubleLine(L["Current XP"], UnitXP("player"), 1, 1, 1, 0, 1, 0)
		tooltip:AddDoubleLine(L["Remaining XP"], UnitXPMax("player") - UnitXP("player"), 1, 1, 1, 1, 0, 0)
		tooltip:AddDoubleLine(L["Level Progress %"], string_format("%.1f", UnitXP("player")/UnitXPMax("player")*100) , 1, 1, 1, 0, 1, 0)
		tooltip:AddDoubleLine(L["Remaining rested"], GetXPExhaustion() or 0, 1, 1, 1, 0, 1, 0)

	end

	tooltip:AddLine(" ")

	
	if HasArtifactEquipped() then 

		local _, _, ArtName,ArtIcon,ArtPower,ArtPointsSpent ,  _, _, _, _, _, _, artifactTier = C_ArtifactUI.GetEquippedArtifactInfo();
		local ArtNextRank=C_ArtifactUI.GetCostForPointAtRank(ArtPointsSpent,artifactTier)
		local delta = ArtNextRank-ArtPower
	
		tooltip:AddDoubleLine(L["Artifact"], ArtName,1, 1, 1, 0, 1, 1)
		tooltip:AddDoubleLine(L["Rank"], number(ArtPointsSpent), 1, 1, 1, 0, 1, 0)
		tooltip:AddDoubleLine(L["Artifact Power"],number(ArtPower), 1, 1, 1, 0, 1, 0)

		if (delta) >= 0 then 
			tooltip:AddDoubleLine(L["Power to next rank"],number(delta), 1, 1, 1, 1, 0, 0)
		else
			tooltip:AddDoubleLine(L["Power in excess in rank"],number(abs(delta)), 1, 1, 1, 1, 1, 0)				
		end

		tooltip:AddDoubleLine(L["Progress in rank %"], string_format("%.1f", ArtPower/ArtNextRank*100) , 1, 1, 1, 0, 1, 0)
		tooltip:AddLine(" ")
		tooltip:AddDoubleLine(L["Left-Click"], ArtName,0, 1, 0, 0, 1, 1)
		
	end	

	if GMEXP_LONGNRFMT == true then 
		tooltip:AddDoubleLine(L["Shift"] .. "+" .. L["Left-Click"], L["Short Numbers"],0, 1, 0, 1, 1, 0)
	else
		tooltip:AddDoubleLine(L["Shift"] .. "+" .. L["Left-Click"], L["Long Numbers"],0, 1, 0, 0, 1, 1)
	end

	if list_enable then 
	
		-- Check if GMEXP_NAMES is empty
		if next(GMEXP_NAMES) ~= nil then
		
			local num = 0
			tooltip:AddLine(" ")
			
			for name in pairs(GMEXP_NAMES) do
				tooltip:AddDoubleLine(classcolor(GMEXP_NAMES[name]["NAME"],GMEXP_NAMES[name]["CLASS"]) .." : ".. GMEXP_NAMES[name]["LIVL"], GMEXP_NAMES[name]["ILVO"],1, 1, 1, 1, 1, 1)
				num = num +1
				if num > list_maxpgnum then
					tooltip:AddLine("...")
					break
				end
			end		

			tooltip:AddLine(" ")
			tooltip:AddDoubleLine(L["Shift"] .. "+" .. L["Middle-Click"], _G["RESET"],0, 1, 0, 0, 1, 1)
			tooltip:AddDoubleLine("/gmexp", "For cli mode",0, 1, 0, 0, 1, 1)
			
		end
	end
end

SLASH_GMEXP1 = "/gmexp"
SlashCmdList["GMEXP"] = function(args) 	

	local name=SecureCmdOptionParse(args)
		
	if name == "" then 
		print(prgname .. " help")
		print("/gmexp Realm-Name - Remove a pg from DB")
		return
	else		
		GMEXP_NAMES[name]=nil
	end
	
end