SLASH_ABANDONZONE1 = "/abandonzone";

SlashCmdList["ABANDONZONE"] = function(zone)
	QuestTitles = {}
	HeaderValues = {}
	SectionIndices = {}
	for i = 1, GetNumQuestLogEntries() do
		local title = select(1, GetQuestLogTitle(i))
		local isHeader = select(4, GetQuestLogTitle(i))
		table.insert(QuestTitles, i, title)
		table.insert(HeaderValues, i, isHeader)
	end
	
	for index, value in pairs(HeaderValues) do
		if value == true then
			table.insert(SectionIndices, index)
		end
	end
	
	local valueFound = {false, nil, nil }
	for index, value in pairs(QuestTitles) do
		if (string.lower(value) == string.lower(zone)) and (HeaderValues[index]==true) then
			valueFound = { true, index, value }
		end
	end
	if valueFound[1] == true then
		nextSectionIndex = 0
		for index, value in pairs(SectionIndices) do
			if value == valueFound[2] then
				if index == table.getn(SectionIndices) then
					nextSectionIndex = table.getn(QuestTitles) + 1
				else
					nextSectionIndex = SectionIndices[index + 1]
				end
			end
		end
		for i = (valueFound[2]+1), (nextSectionIndex-1) do
			SelectQuestLogEntry(i)
			SetAbandonQuest()
			print("|cFFFFFF00Abandoned quest: '".. QuestTitles[i].. "'|r")
			AbandonQuest()
		end
	else
		if (string.lower(zone) == "all") then
			for i= 1, GetNumQuestLogEntries() do
				SelectQuestLogEntry(i);
				SetAbandonQuest();
				AbandonQuest();
			end
			print("|cFFFFFF00Abandoned all quests|r")
		elseif (string.lower(zone) == "help") or (zone == "") then
				print("|cFFFFFF00Type '/abandonzone' followed by the name of the zone you wish to abandon quests in, or type '/abandonzone all' to abandon all quests.|r")
		else
			print("|cFFFFFF00Zone '".. zone.. "' not found|r")
		end
	end
end