local panel = CreateFrame("FRAME")
panel.name = "Z-Target Me!"
local SPath = "Interface\\Addons\\ZTargetMe\\Sound"
local mstate = ""

local ZTMeFairy = {
	"Navi",
	"Tatl",
	"Midna",
	"None"
	}
	
local FairyV = {
	"100",
	"75",
	"50",
	"25",
	"Off"
	}
	
local CoreV = {
	"100",
	"75",
	"50",
	"25",
	"Off"
	}
	
function ZTMe_Panel_Close()
	if ZTMe_GUIFrame_ZTMe:GetChecked() == true then
		mstate = "On"
		ZTMeConfig.ModState = 1
	else
		mstate = "Off"
		ZTMeConfig.ModState = 0
	end
		
	ZTMeConfig.Fairy = UIDropDownMenu_GetText(ZTMe_FairyDropDown);
	ZTMeConfig.CoreVolume = VolConvert(ZTMe_GUIFrame_CoreVolSlider:GetValue());
	ZTMeConfig.FairyVolume = VolConvert(ZTMe_GUIFrame_FairyVolSlider:GetValue());
	ZTMeConfig.CamOn = ZTMe_GUIFrame_CamOn:GetChecked();
	ZTMeConfig.AutoLock = ZTMe_GUIFrame_AutoLock:GetChecked();
	ZTMeConfig.PlateEnable = ZTMe_GUIFrame_PlateEnable:GetChecked();
end

function ZTMe_Panel_Cancel()
	if ZTMeConfig.ModState == 1 then
		ZTMe_GUIFrame_ZTMe:SetChecked(true)
		mstate = "On"
	else
		ZTMe_GUIFrame_ZTMe:SetChecked(false)
		mstate = "Off"
	end
	
	ZTMe_GUIFrame_ZTMe:SetChecked(ZTMeConfig.ModState);
	UIDropDownMenu_SetText(ZTMe_FairyDropDown, ZTMeConfig.Fairy);
	ZTMe_GUIFrame_CoreVolSlider:SetValue(VolConvert(ZTMeConfig.CoreVolume, true))
	ZTMe_GUIFrame_FairyVolSlider:SetValue(VolConvert(ZTMeConfig.FairyVolume, true))
	ZTMe_GUIFrame_CamOn:SetChecked(ZTMeConfig.CamOn);
	ZTMe_GUIFrame_AutoLock:SetChecked(ZTMeConfig.AutoLock);
	ZTMe_GUIFrame_PlateEnable:SetChecked(ZTMeConfig.PlateEnable);
end

function ZTMe_Panel_OnLoad(panel)
	ZTMe_GUIFrame_Play:SetText("Test");
	ZTMe_GUIFrame_CVPlay:SetText("Test");
	ZTMe_GUIFrame_FVPlay:SetText("Test");
	ZTMe_GUIFrame_CamOnText:SetText("  Action Cam: Focuses the camera on locked targets");
	ZTMe_GUIFrame_AutoLockText:SetText("  Auto-Lock: Automatically locks onto selected targets");
	ZTMe_GUIFrame_ZTMeText:SetText("  Z-Targeting")
	ZTMe_GUIFrame_PlateEnableText:SetText("  Auto-enable nameplates on target lock-on")
	panel.name = "Z-Target Me!";
	panel.okay = function (self) ZTMe_Panel_Close(); end;
	panel.cancel = function (self)  ZTMe_Panel_Cancel();  end;
	InterfaceOptions_AddCategory(panel);
end

function CoreVolSlider_OnClick()
	local voltemp = ZTMe_GUIFrame_CoreVolSlider:GetValue();
	math.floor(voltemp + 0.5)	
	ZTMe_GUIFrame_CoreVolSlider:SetValue(voltemp);
end

function FairyVolSlider_OnClick()
	local voltemp = ZTMe_GUIFrame_FairyVolSlider:GetValue();
	math.floor(voltemp + 0.5)	
	ZTMe_GUIFrame_FairyVolSlider:SetValue(voltemp);
end
 
function VolConvert(int, rev)
	if not rev then
		if int == 0 then
			return "Off";
		elseif int == 1 then
			return "25";
		elseif int == 2 then
			return "50";
		elseif int == 3 then
			return "75";
		elseif int == 4 then
			return "100";
		end
	else
		if int == "100" then
			return 4;
		elseif int == "75" then
			return 3;
		elseif int == "50" then
			return 2;
		elseif int == "25" then
			return 1;
		elseif int == "Off" then
			return 0;
		end
	end
end

function ZTMe_Config_OnInit()
	if (ZTMeConfig == nil) then
        ZTMeConfig = { };
		ZTMeConfig.ModState = 1
        ZTMeConfig.Fairy = "Navi";
		ZTMeConfig.CoreVolume = "100";
		ZTMeConfig.FairyVolume = "100";
		ZTMeConfig.CamOn = true;
		ZTMeConfig.AutoLock = false;
		ZTMeConfig.PlateEnable = false;
		ZTMeConfig.Journal = false;		
    end;
	
	if (ZTMeConfig.ModState == nil) then
        ZTMeConfig.ModState = 1;
		onoff = "on"
    end;

    if (ZTMeConfig.Fairy == nil) then
        ZTMeConfig.Fairy = "Navi";
    end;

	if (ZTMeConfig.CoreVolume == nil) then
        ZTMeConfig.CoreVolume = "100";
    end;
	
    if (ZTMeConfig.FairyVolume == nil) then
        ZTMeConfig.FairyVolume = "100";
    end;
	
	if (ZTMeConfig.CamOn == nil) then
        ZTMeConfig.CamOn = true;
    end;	

	if (ZTMeConfig.AutoLock == nil) then
        ZTMeConfig.AutoLock = true;
    end;	
	
	if (ZTMeConfig.PlateEnable == nil) then
        ZTMeConfig.PlateEnable = true;
    end;	
	
	if (ZTMeConfig.Journal == nil) then
        ZTMeConfig.Journal = false;
    end;	
		
	CreateFrame("Frame", "ZTMe_FairyDropDown", ZTMe_GUIFrame, "UIDropDownMenuTemplate");

	UIDropDownMenu_Initialize(ZTMe_FairyDropDown, ZTMe_FairyDropDown_Init);

    UIDropDownMenu_JustifyText(ZTMe_FairyDropDown, "LEFT");
	UIDropDownMenu_SetWidth(ZTMe_FairyDropDown, 120);
	UIDropDownMenu_SetText(ZTMe_FairyDropDown, ZTMeConfig.Fairy);
	
	if ZTMeConfig.ModState == 1 then
		mstate = "on"
	else
		mstate = "off"
	end
	
	if GetCVar("nameplateTargetBehindMaxDistance") ~= "0" then
		SetCVar("nameplateTargetBehindMaxDistance", 0)
	end	

	print("Z-Target Me loaded! Z-Targeting is currently " .. mstate .. ". Type '/ZTMe help' for commands.");
	
	if ZTMe_Init then
		ConsoleExec("ActionCam focusOn")
		ConsoleExec("ActionCam off")
		return
	else	
		ZTMeWelcome()
		ZTMe_Init = true
	end
end

function ZTMe_FairyDropDown_Init(self)
	local ddtext = UIDropDownMenu_GetText(ZTMe_FairyDropDown);
	local info = UIDropDownMenu_CreateInfo();
	for index, filename in ipairs(ZTMeFairy) do
		info.text = filename;
		info.isNotRadio = true;
		info.checked = (filename == ddtext);
		
		info.func = function (self)
			UIDropDownMenu_SetText(ZTMe_FairyDropDown, self:GetText());
		end

		UIDropDownMenu_AddButton(info);
	end
end

function ZTMe_CoreVolDropDown_Init(self)
	local ddtext = UIDropDownMenu_GetText(ZTMe_CoreVolDropDown);
	local info = UIDropDownMenu_CreateInfo();
	for index, filename in ipairs(CoreV) do
		info.text = filename;
		info.isNotRadio = true;
		info.checked = (filename == ddtext);
		
		info.func = function (self)
			UIDropDownMenu_SetText(ZTMe_CoreVolDropDown, self:GetText());
		end

		UIDropDownMenu_AddButton(info);
	end
end

function ZTMe_FairyVolDropDown_Init(self)
	local ddtext = UIDropDownMenu_GetText(ZTMe_FairyVolDropDown);
	local info = UIDropDownMenu_CreateInfo();
	for index, filename in ipairs(FairyV) do
		info.text = filename;
		info.isNotRadio = true;
		info.checked = (filename == ddtext);
		
		info.func = function (self)
			UIDropDownMenu_SetText(ZTMe_FairyVolDropDown, self:GetText());
		end

		UIDropDownMenu_AddButton(info);
	end
end

function ZTMe_Config_OnLoad(frame)
    frame:RegisterEvent("PLAYER_LOGIN");
end

function WorldEnter(frame, event, arg1, ...)    
    if (event == "PLAYER_LOGIN") then
        ZTMe_Config_OnInit();
        ZTMe_Panel_Cancel();

        Load_Time = GetTime();
    end;
end

function FairyTest(Test)
    PlaySoundFile(SPath .. "\\Fairies\\Fairies" .. ZTMeConfig.FairyVolume .. "\\" .. Test .. "\\Hey.ogg");
end

function CoreVTest(Test)
    PlaySoundFile(SPath .. "\\Core\\Core" .. Test .. "\\targetfriendly.ogg")
end

function FairyVTest(Test, Comp)
	if Comp == "None" then
		Comp = "Navi"
	end

    PlaySoundFile(SPath .. "\\Fairies\\Fairies" .. Test .. "\\" .. Comp .. "\\Hey.ogg");
end

function OptionsOpen()
	InterfaceOptionsFrame_OpenToCategory("Z-Target Me!"); --fires twice because it likes to be stupid
	InterfaceOptionsFrame_OpenToCategory("Z-Target Me!");
end

function AutoTarget()
	if ZTMeConfig.AutoLock == false then
		ZTMeConfig.AutoLock = true
		print("Auto-target enabled.");
		ZTMe_GUIFrame_AutoLock:SetChecked(ZTMeConfig.AutoLock);
		PlaySoundFile(SPath .. "\\Fairies\\Fairies" .. ZTMeConfig.FairyVolume .. "\\" .. ZTMeConfig.Fairy .. "\\Listen.ogg")	
	else
		ZTMeConfig.AutoLock = false
		print("Auto-target disabled.");
		ZTMe_GUIFrame_AutoLock:SetChecked(ZTMeConfig.AutoLock);
		PlaySoundFile(SPath .. "\\Fairies\\Fairies" .. ZTMeConfig.FairyVolume .. "\\" .. ZTMeConfig.Fairy .. "\\Listen.ogg")
	end
end

function ZTMeWelcome()
	local welcometext = "Welcome to Z-Target Me! \n \n This addon emulates the Legend of Zelda's Z-Targeting feature using the ActionCam! \n\n" ..
						"By default, target locking is automatic, but this can be toggled in favour of using a hotkey trigger instead. \n" ..
						"This can be set in Key Bindings from the main menu. \n\n" ..
						"Would you like to configure Z-Target Me! options now?"
						
	PlaySoundFile(SPath .. "\\Fairies\\Fairies100\\\Navi\\Hello.ogg")

	StaticPopupDialogs["ZTMeWelcome"] = {
		text = welcometext,
		button1 = "Yes",
		button2 = "No",
		OnAccept = function()
			InterfaceOptionsFrame_OpenToCategory("Z-Target Me!");
			InterfaceOptionsFrame_OpenToCategory("Z-Target Me!");
			ConsoleExec("ActionCam focusOn")
			ConsoleExec("ActionCam off")
			end,
		OnCancel = function()
			StaticPopup_Show("ZTMeWelcome2")
			end,
		timeout = 0,
		whileDead = true,
		hideOnEscape = true,
		preferredIndex = 3,
	}
	
	StaticPopupDialogs["ZTMeWelcome2"] = {
		text = "Options will be set to default. These can be accessed at any time by going to Interface from the main menu, then looking for Z-Target Me! under the AddOns tab.",
		button1 = "Okay",
		OnAccept = function()
			ConsoleExec("ActionCam focusOn")
			ConsoleExec("ActionCam off")
			end,
		timeout = 0,
		whileDead = true,
		hideOnEscape = true,
		preferredIndex = 3,
	}
	
	StaticPopup_Show("ZTMeWelcome")
end