--[[
XPGain by EVmaker, v0.1.10:
Simply prints out the exp gain information from killing or questing to your chat frame, and lets you see the experience status for anyone in your party that uses XPGain.
Also lets you ask for the experience information of a specific party member (if they use XPGain) and display a frame with basic experience information.

Todo:
* Remove any bugs (if any).
* Add a way for the user to change the experience brackets (from 0, 25, 40, 55, 70, and 85 percents, to whatever they wish).
* Rework the code to be in the more embedded format to only use a single global namespace (xpg.colors etc..)
]]--

-- Declares the globals
XPG_Colors = {
	["c85"] = {38, 255, 26},
	["c70"] = {141, 255, 1},
	["c55"] = {255, 255, 0},
	["c40"] = {255, 131, 0},
	["c25"] = {255, 75, 0},
	["c00"] = {255, 19, 23},
}
XPG_Settings = {
	["OnOff"] = true,
	["Channel"] = 1,
	["Version"] = "0.1.9",
	["PetExp"] = false,
	["ShowExpWindow"] = false,
	["ShowPetWindow"] = false,
	["ShortMsg"] = false
}
XPG_expArray = {};

-- Declares the locals
local XPG_percentNames = {
	["85"] = true,
	["70"] = true,
	["55"] = true,
	["40"] = true,
	["25"] = true,
	["00"] = true
}
local XPG_ExpArray = {
	["expColor"] = nil,
	["expCurrent"] = 0,
	["expMax"] = 0,
	["expOld"] = 0,
}
local thePlayer;
local XPG_EML = "XPGain";
local XPG_expColor = nil;
local XPG_expCurrent = 0;
local XPG_expMax = 0;
local XPG_expOld = 0;
local XPG_expChange = 0;
local XPG_expPercentGain = 0;
local XPG_expPercentLeft = 0;
local XPG_expPercent = 0;
local XPG_expNext = 0;
local XPG_currentLevel = 0;
local XPG_nextLevel = 0;
local XPG_Reps = 0;
local XPG_firstKill = false;
local debugMode = false;
local XPG_PartyList = {};
local XPG_PartyExp = {};
local XPG_petColor = nil;
local XPG_petExp = 0;
local XPG_petMax = 0;
local XPG_petOld = 0;
local XPG_petChange = 0;
local XPG_petPercGain = 0;
local XPG_petPercLeft = 0;
local XPG_petPerc = 0;
local XPG_petNext = 0;
local XPG_petLevel = 0;
local XPG_petNextLevel = 0;
local XPG_petReps = 0;
local XPG_backColor = EML_getColor("black")
local XPG_playerClass;

-- Sets the defaults
local XPG_defaultColors = {
	["c85"] = {38, 255, 26}, -- Bright Green
	["c70"] = {141, 255, 1}, -- Yellow-Green
	["c55"] = {255, 255, 0}, -- Yellow
	["c40"] = {255, 131, 0}, -- Yellow-Orange
	["c25"] = {255, 75, 0}, -- Orange
	["c00"] = {255, 19, 23}, -- Bright Red
}
local XPG_defaultSettings = {
	["OnOff"] = true,
	["Channel"] = 1,
	["Version"] = "0.1.9",
	["PetExp"] = false,
	["ShowExpWindow"] = false,
	["ShowPetWindow"] = false,
	["ShortMsg"] = false
}

-- Handles setup
function XPG_OnLoad(self)
	self:RegisterEvent("PLAYER_XP_UPDATE")
	self:RegisterEvent("PLAYER_LEVEL_UP")
	self:RegisterEvent("CHAT_MSG_ADDON")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("PARTY_MEMBERS_CHANGED")
	local prefix = RegisterAddonMessagePrefix("XPG")
	EMLChat("XPGain "..XPG_defaultSettings["Version"].." loaded","plainchat",XPG_EML,"teal")
	if (not prefix) then EMLChat("Addon prefix could not be registered, partyexp feature will not work","plainchat",XPG_EML,"red") end
	SLASH_XPG1 = "/xpgain"
	SLASH_XPG2 = "/xpg"
	SlashCmdList["XPG"] = function(msg)
		XPG_SlashHandler(msg);
	end
end

-- Handles the events
function XPG_OnEvent(self,event,...)
	local arg1,arg2,arg3,arg4,arg5,arg6 = ...;
	if (XPG_Settings["OnOff"]) then
		if (event == "PLAYER_XP_UPDATE") then
			if (XPG_expCurrent ~= 0 and XPG_Settings["ShowExpWindow"]) then
				XPG_calculateExp("window")
			elseif (XPG_expCurrent == 0 and XPG_Settings["ShowExpWindow"]) then
				XPG_calculateExp()
			elseif (not XPG_Settings["ShowExpWindow"]) then
				XPG_calculateExp()
			end
			XPG_sendExp("send")
		end
		if (event == "PLAYER_LEVEL_UP") then
			local playerLevel = UnitLevel("player");
			SendAddonMessage("XPG","PLAYER_LEVEL_UP"..","..playerLevel,"PARTY")
		end
		if (event == "PARTY_MEMBERS_CHANGED") then
			XPG_populateParty()
			XPG_sendExp("get")
		end
	end
	if (event == "PLAYER_ENTERING_WORLD") then
		XPG_calculateExp()
		XPG_populateParty()
		XPG_sendExp("get")
		XPG_setCheckBoxes()
		thePlayer, _ = UnitName("player");
		if (XPG_Settings["Version"] ~= XPG_defaultSettings["Version"]) then
			if (debugMode) then EMLChat("Version is different.","chat",XPG_EML) end
			XPG_Reset("version")
		else
			if (debugMode) then EMLChat("Version is the same.","chat",XPG_EML) end
		end
		XPG_playerClass = UnitClass("player");
		local listenOk = RegisterAddonMessagePrefix("XPG")
		if (not listenOk) then
			EMLChat("XPG was not registered.","chat",XPG_EML,"red")
		end
	end
	if (event == "CHAT_MSG_ADDON") then
		if (arg1 == "XPG") then
			if (debugMode) then EMLChat("Recieved: "..arg2..", From: "..arg1,"chat",XPG_EML,"teal") end
			local addMsg = {strsplit(",", arg2)}
			local arg4 = ({strsplit("-", arg4)})[1]
			if addMsg[1] == "PLAYER_LEVEL_UP" then
				local whatLevel;
				local whoLeveled=string.lower(arg4);
				if (EML_findTable(whoLeveled,XPG_PartyList)) then
					whatLevel = addMsg[2];
					if (debugMode) then EMLChat(whoLeveled.." leveled to "..tostring(whatLevel),"chat",XPG_EML) end
				end
				if (whatLevel) and (XPG_Settings["OnOff"]) then EMLChat(arg4.." Leveled to "..(whatLevel).."!","chat",XPG_EML,"green") end
				return;
			end
			if (addMsg[1] == "PLAYER_XP_UPDATE") and (arg4 ~= thePlayer) then
				XPG_expUpdate(arg4, addMsg[2], addMsg[3])
				return;
			end
			if (addMsg[1] == "REQUEST_XP_UPDATE") and (arg4 ~= thePlayer) then
				XPG_sendExp("send")
				return;
			end
		elseif (arg1 == "UE") then
			if (debugMode) then EMLChat("Recieved: "..arg2..", From: "..arg1,"chat",XPG_EML,"teal") end
			local addMsg = {strsplit(",", arg2)}
			if addMsg[1] == "PLAYER_EXP" then
				-- Do something
			end
		else
			return;
		end
	end
end

-- Handles the slash commands
function XPG_SlashHandler(theMsg)
	msg = strtrim(strlower(theMsg or ""))
	if msg == "version" then
		EMLChat("This version of XPG is: "..XPG_defaultSettings["Version"],"chat",XPG_EML)
	elseif strmatch(msg, "reset") then
		local theChoice = strmatch(msg, "reset (.*)")
		if (theChoice == nil) then
			XPG_Reset("colors")
		elseif (theChoice == "colors") then
			XPG_Reset("colors")
		elseif (theChoice == "all") then
			XPG_Reset("all")
		else
			-- Nothing yet
		end
	elseif msg == "debug" then
		if (debugMode) then
			debugMode = false;
			EMLChat("Debug mode turned off.","chat",XPG_EML)
		else
			debugMode = true;
			EMLChat("Debug mode turned on.","chat",XPG_EML)
		end
	elseif msg == "toggle xpgain" then
		if (XPG_Settings["OnOff"]) then
			XPG_Settings["OnOff"] = false;
			EMLChat("XPGain toggled off.","chat",XPG_EML)
		else
			XPG_Settings["OnOff"] = true;
			EMLChat("XPGain toggled on.","chat",XPG_EML)
		end
		XPG_setCheckBoxes()
	elseif msg == "toggle petexp" then
		if (XPG_Settings["PetExp"]) then
			XPG_Settings["PetExp"] = false;
			EMLChat("Pet Experience printing turned off.","chat",XPG_EML)
		else
			XPG_Settings["PetExp"] = true;
			EMLChat("Pet Experience printing turned on.","chat",XPG_EML)
		end
		XPG_setCheckBoxes()
	elseif msg == "toggle expwindow" then
		if (XPG_Settings["ShowExpWindow"]) then
			XPG_Settings["ShowExpWindow"] = false;
			EMLChat("Your experience will be shown in chat.","chat",XPG_EML)
		else
			XPG_Settings["ShowExpWindow"] = true;
			EMLChat("Your experience will be shown in a window.","chat",XPG_EML)
		end
		XPG_setCheckBoxes()
	elseif msg == "toggle petwindow" then
		if (XPG_Settings["ShowPetWindow"]) then
			XPG_Settings["ShowPetWindow"] = false;
			EMLChat("Pet experience will be shown in chat.","chat",XPG_EML)
		else
			XPG_Settings["ShowPetWindow"] = true;
			EMLChat("Pet experience will be shown in a window.","chat",XPG_EML)
		end
		XPG_setCheckBoxes()
	elseif msg == "toggle shortmsg" then
		if (XPG_Settings["ShortMsg"]) then
			XPG_Settings["ShortMsg"] = false;
			EMLChat("Short Experience printout is now disabled","chat",XPG_EML)
		else
			XPG_Settings["ShortMsg"] = true;
			EMLChat("Short Experience printout is now enabled","chat",XPG_EML)
		end
		XPG_setCheckBoxes()
	elseif msg == "toggle status" then
		if (XPG_Settings["OnOff"]) then
			EMLChat("XPGain is enabled.","chat",XPG_EML)
		else
			EMLChat("XPGain is disabled.","chat",XPG_EML)
		end
		if (XPG_Settings["PetExp"]) then
			EMLChat("Pet Experience is being displayed.","chat",XPG_EML)
		else
			EMLChat("Pet Experience is not being displayed.","chat",XPG_EML)
		end
		if (XPG_Settings["ShowExpWindow"]) then
			EMLChat("Player experience gains are being shown in a window.","chat",XPG_EML)
		else
			EMLChat("Player experience gains are being shown in chat.","chat",XPG_EML)
		end
		if (XPG_Settings["ShowPetWindow"]) then
			EMLChat("Pet experience gains are being shown in a window.","chat",XPG_EML)
		else
			EMLChat("Pet experience gains are being shown in chat.","chat",XPG_EML)
		end
		if (XP_Settings["ShortMsg"]) then
			EMLChat("Short experience printout is enabled.","chat",XPG_EML)
		else
			EMLChat("Short experience printout is disabled.","chat",XPG_EML)
		end
	elseif msg == "testcolors" then
		XPG_testColors("mycolors")
	elseif msg == "test1" then
		XPG_testFunction()
	elseif msg == "test2" then
		XPG_testFunction2()
	elseif msg == "menu" then
		EMLFrame_Toggle("XPG1")
		EMLChat("Opening Menu.","chat",XPG_EML)
	elseif msg == "expwindow" then
		EMLFrame_Toggle("XPG2")
	elseif msg == "petwindow" then
		EMLFrame_Toggle("XPG3")
	elseif strmatch(msg, "list") then
		local theChoice = strmatch(msg, "list (.*)")
		if (theChoice ~= nil) then
			if (theChoice == "defaultcolors") then
				XPG_testColors("defaultcolors")
			elseif (theChoice == "mycolors") then
				XPG_testColors("mycolors")
			elseif (theChoice == "party") then
				EML_Display(XPG_PartyList,XPG_EML)
			else
				EMLChat("Choices are: defaultcolors, mycolors","chat",XPG_EML)
			end
		else
			EMLChat("Choices are: colors, mycolors","chat",XPG_EML)
		end
	elseif msg == "partyexp" then
		XPG_sendExp("get")
		for index,value in pairs(XPG_PartyList) do
			XPG_printExp(value)
		end
	elseif msg == "petexp" then
		if (XPG_playerClass == "Hunter") then
			XPG_calculatePetExp("report")
		else
			EMLChat("You are not a hunter, you don't have a pet that gains experience.","chat",XPG_EML)
		end
	elseif strmatch(msg, "exp") then
		local theChoice = strmatch(msg, "exp (.*)");
		if (theChoice ~= nil) then
			XPG_printExp(theChoice)
		else
			XPG_calculateExp("report")
		end
	elseif strmatch(msg, "setcolor") then
		local thePlace,theR,theG,theB = strmatch(msg, "setcolor (.*),(.*),(.*),(.*)");
		local theColor = {theR,theG,theB};
		if (thePlace and theR and theG and theB) then
			XPG_setColor(thePlace,theColor)
		else
			EMLChat("Must enter similar to /xpg setcolor percent,r,g,b or /xpg setcolor 85,231,154,10","chat",XPG_EML)
		end
	elseif strmatch(msg, "channel") then
		local theChannel = tonumber(strmatch(msg, "channel (.*)"));
		if (debugMode) then EML_Display(theChannel,XPG_EML) end
		if (theChannel) then
			getglobal("ChatFrame"..theChannel):AddMessage("XPG: ".."Will now print to this channel.", 1, 1, 0)
			XPG_Settings["Channel"] = theChannel;
		end
	elseif msg == "test1" then
		XPG_testColors()
	else
		EMLChat("XPGain","chat",XPG_EML)
		EMLChat("-------------------","chat",XPG_EML)
		EMLChat("toggle, (toggles XPGain on and off)","chat",XPG_EML)
		EMLChat("menu, (opens the color config menu)","chat",XPG_EML)
		EMLChat("expwindow, (opens or closes the player experience window)","chat",XPG_EML)
		EMLChat("petwindow, (opens or closes the pet experience window)","chat",XPG_EML)
		EMLChat("exp, (prints your current experience status)","chat",XPG_EML)
		EMLChat("exp name, (prints the experience data from a party member that uses XPGain)","chat",XPG_EML)
		EMLChat("petexp, (prints your pets current experience status)","chat",XPG_EML)
		EMLChat("partyexp, (prints the party experience status for those using XPGain)","chat",XPG_EML)
		EMLChat("setcolor, (sets the color of different exp percentages)","chat",XPG_EML)
		EMLChat("testcolors, (prints out the experience color percentages)","chat",XPG_EML)
		EMLChat("version, (displays version information)","chat",XPG_EML)
		EMLChat("list, (choose what to list such as the colors)","chat",XPG_EML)
	end
end

function XPG_altChat(msg,colors)
	local r,g,b;
	if (colors) then
		r,g,b = EML_splitTable(colors);
	end
	if (r and g and b) then
		getglobal("ChatFrame"..XPG_Settings["Channel"]):AddMessage("<XPG> "..msg, r, g, b)
	else
		if (debugMode) then EMLChat("Colors not set.","chat",XPG_EML) end
	end
end

-- Calculates and displays the players current experience
function XPG_calculateExp(where)
	if (XPG_expCurrent == 0) then
		EMLChat("First experience gain of session, starting.","chat",XPG_EML,"teal")
		XPG_expCurrent = UnitXP("player");
		XPG_expOld = XPG_expCurrent;
		XPG_currentLevel = UnitLevel("player");
		return;
	end
	XPG_expPercent = ((floor((UnitXP("player") / UnitXPMax("player")) * 10000)) / 100);
	if (XPG_expPercent > 85) then
		XPG_expColor = XPG_Colors.c85;
	elseif (XPG_expPercent > 70) then
		XPG_expColor = XPG_Colors.c70;
	elseif (XPG_expPercent > 55) then
		XPG_expColor = XPG_Colors.c55;
	elseif (XPG_expPercent > 40) then
		XPG_expColor = XPG_Colors.c40;
	elseif (XPG_expPercent > 25) then
		XPG_expColor = XPG_Colors.c25;
	else
		XPG_expColor = XPG_Colors.c00;
	end
	local textR,textG,textB = EML_splitTable(XPG_expColor);
	local XPG_Class = UnitClass("player");
	XPG_expCurrent = UnitXP("player");
	XPG_expMax = UnitXPMax("player");
	XPG_expChange = (XPG_expCurrent - XPG_expOld);
	XPG_expNext = (XPG_expMax - XPG_expCurrent);
	XPG_expPercentGain = (XPG_expCurrent/XPG_expMax)*100;
	XPG_expPercentLeft = strsub(((XPG_expNext/XPG_expMax)*100),1,5);
	XPG_expOld = XPG_expCurrent;

	XPG_currentLevel = UnitLevel("player");
	XPG_nextLevel = XPG_currentLevel + 1;

	XPG_Reps = (floor(XPG_expNext/XPG_expChange)) + 1;

	local XPG_Msg = "";
	local XPG_Msg2 = "";
	-- For print to chat on exp gain
	-- Amount of XP gained.
	XPG_Msg = XPG_Msg.."+"..XPG_expChange.."XP. "
	-- Percentage of this level completed.
	XPG_Msg = XPG_Msg.."("..XPG_expPercent.."%) "
	-- Amount of XP till next level.
	XPG_Msg = XPG_Msg..XPG_expNext.."XP ("..XPG_expPercentLeft.."%) to go. "
	-- Repititions till level
	XPG_Msg = XPG_Msg..XPG_Reps.." Repetitions."
	-- For report when directly asked
	-- Current Level
	XPG_Msg2 = XPG_Msg2.."Level "..XPG_currentLevel.." "..XPG_Class..", "
	-- Percentage of this level completed.
	XPG_Msg2 = XPG_Msg2..XPG_expPercent.."% of the way to "..XPG_nextLevel..", with "
	-- Amount of XP till next level.
	XPG_Msg2 = XPG_Msg2..XPG_expNext.."XP ("..XPG_expPercentLeft.."%) to go. "
	-- Write message to chat window during normal exp gain.
	local XPG_ShortMsg = "";
	local XPG_ShortMsg2 = "";
	XPG_ShortMsg = XPG_ShortMsg.."You gained "..XPG_expChange.."XP, "..XPG_expPercentLeft.."% to go.";
	XPG_ShortMsg2 = XPG_ShortMsg2.."You are "..XPG_expPercent.."% of the way to "..(XPG_currentLevel+1)..".";
	if (not tonumber(XPG_Reps)) then
		return nil;
	end
	if (where == nil) and (XPG_Settings["Channel"] == 1) and XPG_Settings["ShortMsg"] then
		EMLChat(XPG_ShortMsg,"chat",XPG_EML,XPG_expColor)
		return true;
	elseif (where == nil) and (XPG_Settings["Channel"] ~= 1) and XPG_Settings["ShortMsg"] then
		XPG_altChat(XPG_ShortMsg,XPG_expColor)
		return true;
	elseif (where == "report") and (XPG_Settings["Channel"] == 1) and XPG_Settings["ShortMsg"] then
		EMLChat(XPG_ShortMsg2,"chat",XPG_EML,XPG_expColor)
		return true;
	elseif (where == "report") and (XPG_Settings["Channel"] ~= 1) and XPG_Settings["ShortMsg"] then
		XPG_altChat(XPG_ShortMsg2,XPG_expColor)
		return true;
	end
	if (where == nil) and (XPG_Settings["Channel"] == 1) then
		EMLChat(XPG_Msg,"chat",XPG_EML,XPG_expColor)
	elseif (where == nil) and (XPG_Settings["Channel"] ~= 1) then
		XPG_altChat(XPG_Msg,XPG_expColor)
	-- Write message to chat on request.
	elseif (where == "report") and (XPG_Settings["Channel"] == 1) then
		--EMLChat(XPG_Msg2,"chat",XPG_EML,XPG_expColor)
		EMLChat(XPG_ShortMsg2,"error",XPG_EML,XPG_expColor)
	elseif (where == "report") and (XPG_Settings["Channel"] ~= 1) then
		XPG_altChat(XPG_Msg2,XPG_expColor)
	elseif (where == "window") then
		EMLFrame_Toggle("XPG2","open")
		XPG2_Color:SetVertexColor(backR,backG,backB);
		XPG2_textExp:SetText(XPG_Msg)
		XPG2_textExp:SetTextColor(textR,textG,textB)
	else
		-- Do nothing
	end
end

function XPG_calculatePetExp(where)
	if (XPG_petExp == 0) then
		EMLChat("[Pet] First experience gain of session, starting.","chat",XPG_EML,"teal")
		XPG_petExp, _ = GetPetExperience();
		XPG_petOld = XPG_petExp;
		return;
	end
	local petCur, petMax = GetPetExperience();
	XPG_petPerc = ((floor((petCur / petMax) * 10000)) / 100);
	if (XPG_petPerc > 85) then
		XPG_expColor = XPG_Colors.c85;
	elseif (XPG_petPerc > 70) then
		XPG_petColor = XPG_Colors.c70;
	elseif (XPG_petPerc > 55) then
		XPG_petColor = XPG_Colors.c55;
	elseif (XPG_petPerc > 40) then
		XPG_petColor = XPG_Colors.c40;
	elseif (XPG_petPerc > 25) then
		XPG_petColor = XPG_Colors.c25;
	else
		XPG_petColor = XPG_Colors.c00;
	end
	local textR,textG,textB = EML_splitTable(XPG_petColor);
	local XPG_petType = UnitCreatureFamily("pet");
	XPG_petExp, XPG_petMax = GetPetExperience();
	XPG_petChange = (XPG_petExp - XPG_petOld);
	XPG_petNext = (XPG_petMax - XPG_petExp);
	XPG_petPercGain = (XPG_petExp/XPG_petMax)*100;
	XPG_petPercLeft = strsub(((XPG_petNext/XPG_petMax)*100),1,5);
	XPG_petOld = XPG_petExp;

	XPG_petLevel = UnitLevel("pet");
	XPG_petNextLevel = XPG_petLevel + 1;

	XPG_petReps = (floor(XPG_petNext/XPG_petChange)) + 1;

	local XPG_Msg = "";
	local XPG_Msg2 = "";
	-- For print to chat on exp gain
	-- Amount of XP gained.
	XPG_Msg = XPG_Msg.."[Pet] +"..XPG_petChange.."XP. "
	-- Percentage of this level completed.
	XPG_Msg = XPG_Msg.."("..XPG_petPerc.."%) "
	-- Amount of XP till next level.
	XPG_Msg = XPG_Msg..XPG_petNext.."XP ("..XPG_petPercLeft.."%) to go. "
	-- Repititions till level
	XPG_Msg = XPG_Msg..XPG_petReps.." Repetitions."
	-- For report when directly asked
	-- Current Level
	XPG_Msg2 = XPG_Msg2.."[Pet] Level "..XPG_petLevel.." "..XPG_petType..", "
	-- Percentage of this level completed.
	XPG_Msg2 = XPG_Msg2..XPG_petPerc.."% of the way to "..XPG_petNextLevel..", with "
	-- Amount of XP till next level.
	XPG_Msg2 = XPG_Msg2..XPG_petNext.."XP ("..XPG_petPercLeft.."%) to go. "
	-- Write message to chat window during normal exp gain.
	if (where == nil) and (XPG_Settings["Channel"] == 1) then
		EMLChat(XPG_Msg,"chat",XPG_EML,XPG_petColor)
	elseif (where == nil) and (XPG_Settings["Channel"] ~= 1) then
		XPG_altChat(XPG_Msg,XPG_petColor)
	-- Write message to chat on request.
	elseif (where == "report") and (XPG_Settings["Channel"] == 1) then
		EMLChat(XPG_Msg2,"chat",XPG_EML,XPG_petColor)
	elseif (where == "report") and (XPG_Settings["Channel"] ~= 1) then
		XPG_altChat(XPG_Msg2,XPG_petColor)
	elseif (where == "window") then
		EMLFrame_Toggle("XPG3","open")
		XPG3_Color:SetVertexColor(backR,backG,backB);
		XPG3_textExp:SetText(XPG_Msg)
		XPG3_textExp:SetTextColor(textR,textG,textB)
	else
		-- Do nothing
	end
end

-- Allows the user to set the color of a percentage
function XPG_setColor(where,theColor)
	local theR,theG,theB = EML_splitWoWTable(theColor);
	-- 85, 70, 55, 40, 25, 00
	if (theR and theG and theB) then
		if (EML_findTable(where,XPG_percentNames)) then
			local newColor = {theR,theG,theB};
			XPG_Colors["c"..(where)]=newColor;
			if (debugMode) then EML_Display(XPG_Colors,XPG_EML) end
		else
			EMLChat("Must be either the 85, 70, 55, 40, 25, or 00 percent marker for the color change.","chat",XPG_EML)
		end
	else
		EMLChat("Must enter valid percent and RGB color values (such as /xpg setcolor 85,175,125,10)","chat",XPG_EML)
	end
end

-- Displays the default colors
function XPG_testColors(what)
	if (what == "defaultcolors") then
		EMLChat("Displaying default colors.","chat",XPG_EML,"teal")
		-- 85% +
		EMLChat("+1XP. (85%) 15XP to go.  15 Repititions.","plainchat",nil,XPG_defaultColors.c85)
		-- 70% +
		EMLChat("+1XP. (70%) 30XP to go.  30 Repititions.","plainchat",nil,XPG_defaultColors.c70)
		-- 55% +
		EMLChat("+1XP. (55%) 45XP to go.  45 Repititions.","plainchat",nil,XPG_defaultColors.c55)
		-- 40% +
		EMLChat("+1XP. (40%) 60XP to go.  60 Repititions.","plainchat",nil,XPG_defaultColors.c40)
		-- 25% +
		EMLChat("+1XP. (25%) 75XP to go.  75 Repititions.","plainchat",nil,XPG_defaultColors.c25)
		-- 0% +
		EMLChat("+1XP. (1%) 99XP to go.  99 Repititions.","plainchat",nil,XPG_defaultColors.c00)
		EMLChat("End of colors.","chat",XPG_EML,"teal")
	elseif (what == "mycolors") then
		EMLChat("Displaying your colors.","chat",XPG_EML,"teal")
		-- 85% +
		EMLChat("+1XP. (85%) 15XP to go.  15 Repititions.","plainchat",nil,XPG_Colors.c85)
		-- 70% +
		EMLChat("+1XP. (70%) 30XP to go.  30 Repititions.","plainchat",nil,XPG_Colors.c70)
		-- 55% +
		EMLChat("+1XP. (55%) 45XP to go.  45 Repititions.","plainchat",nil,XPG_Colors.c55)
		-- 40% +
		EMLChat("+1XP. (40%) 60XP to go.  60 Repititions.","plainchat",nil,XPG_Colors.c40)
		-- 25% +
		EMLChat("+1XP. (25%) 75XP to go.  75 Repititions.","plainchat",nil,XPG_Colors.c25)
		-- 0% +
		EMLChat("+1XP. (1%) 99XP to go.  99 Repititions.","plainchat",nil,XPG_Colors.c00)
		EMLChat("End of colors.","chat",XPG_EML,"teal")
	else
		if (debugMode) then EMLChat("Entered wrong display option.","chat",XPG_EML) end
	end
end

-- Resets settings
function XPG_Reset(what)
	local localColors = EML_copyTable(XPG_defaultColors);
	local localSettings = EML_copyTable(XPG_defaultSettings);
	XPG_Settings = EML_mergeTable(XPG_Settings,localSettings);
	EML_clearTable(XPG_PartyExp)
	XPG_populateParty()
	if (what == "version") then
		XPG_Settings["Version"]=localSettings["Version"];
		EMLChat("Version is different, updating settings.","chat",XPG_EML)
	elseif (what == "colors") then
		EML_clearTable(XPG_Colors)
		XPG_Colors = localColors;
		EMLChat("Colors reset to defaults.","chat",XPG_EML)
	else
		EML_clearTable(XPG_Settings)
		XPG_Settings = localSettings;
		EML_clearTable(XPG_Colors)
		XPG_Colors = localColors;
		EMLChat("All settings reset.","chat",XPG_EML)
	end
end

-- Fills the party list
function XPG_populateParty()
	EML_clearTable(XPG_PartyList)
	for Count = 1,GetNumSubgroupMembers() do
		local theName = UnitName("party"..Count);
		if (theName) then
			EML_addTable(string.lower(tostring(theName)),XPG_PartyList)
		else
			if (debugMode) then EMLChat("Not a name.","chat",XPG_EML,"red") end
		end
	end
	if (debugMode) then eml.sdisplay(XPG_PartyList) end
end

-- Records party member experience information.
function XPG_expUpdate(who,minXP,maxXP)
	local theWho = string.lower(who);
	XPG_populateParty()
	for index,value in pairs(XPG_PartyList) do
		if (theWho == value) then
			XPG_PartyExp[index]={minXP,maxXP};
		else
			-- Do nothing
		end
	end
end

-- Formats party member experience data for printing.
function XPG_getExp(who)
	local theWho = string.lower(who);
	local theIndex = nil;
	local expReturned = nil;
	for index,value in pairs(XPG_PartyList) do
		if (value == theWho) then
			theIndex = index;
		end
	end
	for index2,value2 in pairs(XPG_PartyExp) do
		if (index2 == theIndex) then
			local minExp,maxExp = EML_splitTwo(value2);
			local percTo,percLeft,expLeft;
			local whoParty = (tostring("party"..theIndex));
			local curLevel = (UnitLevel(whoParty));
			local curClass = (UnitClass(whoParty));
			if (minExp ~= nil and maxExp ~= nil) then
				minExp = tonumber(minExp);
				maxExp = tonumber(maxExp);
				expLeft = (maxExp-minExp);
				percTo = ((floor((minExp/maxExp)*10000))/100);
				percLeft = (strsub((((maxExp-minExp)/maxExp)*100),1,5))
			end
			if (minExp ~= nil and maxExp ~= nil) then
				expReturned = {
					["MinExp"] = minExp,
					["MaxExp"] = maxExp,
					["ExpLeft"] = expLeft,
					["PercTo"] = percTo,
					["PercLeft"] = percLeft,
					["CurLevel"] = curLevel,
					["CurClass"] = curClass,
				}
				return expReturned;
			end
		end
	end
end

-- Prints party member experience information to chat.
function XPG_printExp(who)
	local theWho = string.lower(who);
	local expInfo = XPG_getExp(theWho);
	if (debugMode) then EML_Display(expInfo,XPG_EML) end
	local XPG_Msg="";
	if (expInfo) then
		-- Current Level
		XPG_Msg = XPG_Msg..theWho.." is a Level "..expInfo.CurLevel.." "..expInfo.CurClass..", "
		-- Percentage of this level completed.
		XPG_Msg = XPG_Msg..expInfo.PercTo.."% of the way to "..(expInfo.CurLevel+1)..", with "
		-- Amount of XP till next level.
		XPG_Msg = XPG_Msg..expInfo.ExpLeft.."XP ("..expInfo.PercLeft.."%) to go. "
		-- Write message to chat on request.
		if (XPG_Settings["Channel"] == 1) then
			EMLChat(XPG_Msg,"chat",XPG_EML)
		else
			XPG_altChat(XPG_Msg,XPG_Colors["c85"])
		end
	else
		if (who ~= nil) then EMLChat(theWho.." has no experience data.","chat",XPG_EML,"teal") end
	end
end

-- Sends experience updates or requests experience updates to party members.
function XPG_sendExp(what)
	if (what == "send") then
		SendAddonMessage("XPG","PLAYER_XP_UPDATE"..","..UnitXP("player")..","..UnitXPMax("player"),"PARTY")
	end
	if (what == "get") then
		SendAddonMessage("XPG","PLAYER_XP_UPDATE"..","..UnitXP("player")..","..UnitXPMax("player"),"PARTY")
		SendAddonMessage("XPG","REQUEST_XP_UPDATE","PARTY")
	end
end

-- Functions compatible with the GUI
function XPG_GUIColors(what)
	if (what == "reset") then
		XPG_Reset("colors")
	elseif (what == "set") then
		local userPercent=XPG1_Percent:GetText();
		local userR=tonumber(XPG1_RVal:GetText());
		local userG=tonumber(XPG1_GVal:GetText());
		local userB=tonumber(XPG1_BVal:GetText());
		local userColor;
		if (userR and userG and userB) then
			userColor={userR,userG,userB};
		end
		if (EML_findTable(userPercent,XPG_percentNames)) then
			if (userColor) then
				EMLChat("Red is: "..userR..", Green is: "..userG..", Blue is: "..userB,"chat",XPG_EML,userColor)
				XPG_Colors["c"..userPercent]=userColor;
			else
				EMLChat("Must enter valid Red, Green and Blues values (between 0 and 255)","chat",XPG_EML)
			end
		else
			EMLChat("Valid experience percents are: 85, 70, 55, 40, 25 and 00","chat",XPG_EML)
		end
	else
		-- Nothing yet
	end
end

function XPG_GUIColorPicker(what)
	-- 85, 70, 55, 40, 25, 00
	if (what == "open") then
		EML_colorPicker("open")
	elseif (what == "setcolor") then
		local userPercent=XPG1_Percent:GetText();
		if (EML_findTable(userPercent,XPG_percentNames)) then
			local chosenColor = EML_colorPicker();
			local theR,theG,theB = EML_splitWoWTable(chosenColor);
			EMLChat("Red is: "..theR..", Green is: "..theG..", Blue is: "..theB,"chat",XPG_EML,chosenColor)
			XPG_Colors["c"..userPercent]=chosenColor;
		else
			EMLChat("Valid experience percents are: 85, 70, 55, 40, 25, and 00","chat",XPG_EML)
		end
	else
		-- Nothing yet
	end
end

function XPG_checkCheckBoxes()
	if (XPG1_OnOff:GetChecked()) then
		XPG_Settings["OnOff"]=true;
	else
		XPG_Settings["OnOff"]=false;
	end
	if (XPG1_PetExp:GetChecked()) then
		XPG_Settings["PetExp"]=true;
	else
		XPG_Settings["PetExp"]=false;
	end
	if (XPG1_ExpWindow:GetChecked()) then
		XPG_Settings["ShowExpWindow"]=true;
	else
		XPG_Settings["ShowExpWindow"]=false;
	end
	if (XPG1_PetWindow:GetChecked()) then
		XPG_Settings["ShowPetWindow"]=true;
	else
		XPG_Settings["ShowPetWindow"]=false;
	end
	if (XPG1_ShortMsg:GetChecked()) then
		XPG_Settings["ShortMsg"]=true;
	else
		XPG_Settings["ShortMsg"]=false;
	end
end

function XPG_setCheckBoxes()
	if (XPG_Settings["OnOff"]) then
		XPG1_OnOff:SetChecked(true)
	else
		XPG1_OnOff:SetChecked(nil)
	end
	if (XPG_Settings["PetExp"]) then
		XPG1_PetExp:SetChecked(true)
	else
		XPG1_PetExp:SetChecked(nil)
	end
	if (XPG_Settings["ShowExpWindow"]) then
		XPG1_ExpWindow:SetChecked(true)
	else
		XPG1_ExpWindow:SetChecked(nil)
	end
	if (XPG_Settings["ShowPetWindow"]) then
		XPG1_PetWindow:SetChecked(true)
	else
		XPG1_PetWindow:SetChecked(nil)
	end
	if (XPG_Settings["ShortMsg"]) then
		XPG1_ShortMsg:SetChecked(true)
	else
		XPG1_ShortMsg:SetChecked(false)
	end
end

function XPG_testFunction()
	local theColors = XPG_defaultColors["c55"];
	XPG_altChat("test message",theColors)
end

function XPG_testFunction2()
	-- Nothing yet
end
-- End of code
