-------------------------------------------------------------------------------
-- English localization (Default)
-------------------------------------------------------------------------------

-- Bindings
getfenv()["BINDING_NAME_CLICK XPvPBarButtonToggle:LeftButton"] = "Show/hide XPvPBar";

-- Most of these buffs affect a party.  Some buffs that only affect the caster are included
-- if the class only has a few of them.  Warlocks and Rogues have so many other abilities
-- they will be in a separate bar.

-- Buffs
XPvPBarSpells = {
-- PVP Spells
	"#RACE ALIANCE",
	"^59752",--Every Man for Himself
	"^58984",--Shadowmeld
	"^20594",--Stoneform
	"^20589",--Escape Artist
	"^28880",--Gift of the Naaru
	"^68992",--Darkflight
	"^107079",--Quaking Palm
	
	"#RACE HORDE",
	XBAR_SNOWRAP,
	"^20572",--Blood Fury
	-- "^33702",--Blood Fury
	-- "^33697",--Blood Fury

	"^26297",--Berserking
	"^20549",--War Stomp
	"^7744",--Will of the Forsaken
	"^20577",--Cannibalize	
	"^69070",--Rocket Jump
	"^69041",--Rocket Barrage
	
	"^28730",--Arcane Torrent
	-- "^25046",--Arcane Torrent
	-- "^50613",--Arcane Torrent
	-- "^69179",--Arcane Torrent
	-- "^80483",--Arcane Torrent
	-- "^129597",--Arcane Torrent	
	
	"#All classes",
	"^195710",--Honorable Medallion
	"^208683",--Gladiator's Medallion
	
-- Death Knight
	
	XBAR_SNOWRAP,
	"^77606",--Dark Simulacrum
	"^51052",--Anti-Magic Zone
	"^47476",--Strangulate
	"^203173",--Death Chain
	XBAR_SNOWRAP,
	"^204160",--Chill Streak
	XBAR_SNOWRAP,
	"^210128",--Reanimation
	"^199725",--Wandering Plague
	"^223829",--Necrotic Strike
	
	
-- Druid Buffs
	"^209753",--Cyclone
	"^209749",--Faerie Swarm
	XBAR_SNOWRAP,	
	"^33786",--Cyclone
	"^203727",--Thorns
	"^203651",--Overgrowth
	XBAR_SNOWRAP,	
	"^203242",--Rip and Tear
	XBAR_SNOWRAP,	
	"^201664",--Demoralizing Roar
	"^202246",--Overrun
	
-- Hunter Buffs
	--"^202793",--Viper Sting
	--"^202901",--Scorpid Sting
	"^202914",--Spider Sting
	"^208652",--Dire Beast: Hawk
	"^205691",--Dire Beast: Basilisk
	
	XBAR_SNOWRAP,	
	"^213691",--Scatter Shot
	"^209789",--Freezing Arrow
	"^203155",--Sniper Shot
	XBAR_SNOWRAP,	
	"^212640",--Mending Bandage
	"^53271",--Master's Call
	"^212638",--Tracker's Net
	
-- Mage Buffs
	"^198111",--Temporal Shield
	"^198158",--Mass Invisibility	
	XBAR_SNOWRAP,
	"^203286",--Greater Pyroblast
	XBAR_SNOWRAP,
	"^198144",--Ice Form
	
-- Pally buffs
	"^210294",--Divine Favor
	"^216331",--Avenging Crusader
	
	XBAR_SNOWRAP,
	"^215652",--Shield of Virtue
	"^236186",--Cleansing Light
	"^228049",--Guardian of the Forgotten Queen
	XBAR_SNOWRAP,
	"^210256",--Blessing of Sanctuary
	"^204939",--Hammer of Reckoning
		
-- Priest Buffs

	"^211681",--Power Word: Fortitude
	"^209780",--Premonition	
	"^197862",--Archangel
	"^197871",--Dark Archangel
	
	XBAR_SNOWRAP,	
	"^196762",--Inner Focus
	"^213610",--Holy Ward	
	"^213602",--Greater Fade
	"^197268",--Ray of Hope
	
	XBAR_SNOWRAP,
	"^211522",--Psyfiend
	"^108968",--Void Shift
		
-- Rogue Buffs

	XBAR_SNOWRAP,
	"^206328",--Shiv
	
	XBAR_SNOWRAP,
	"^207777",--Dismantle
	"^198529",--Plunder Armor
	
	XBAR_SNOWRAP,
	"^212182",--Smoke Bomb
	"^213981",--Cold Blood
	"^207736",--Shadowy Duel
		
-- Shaman buffs
	"#SHAMAN",
	"^204437",--Lightning Lasso
	"^204332",--Windfury Totem
	"^204331",--Counterstrike Totem
	"^204330",--Skyfury Totem
	
	XBAR_SNOWRAP,
	"^210918",--Ethereal Form
	"^204366",--Thundercharge
	
	XBAR_SNOWRAP,
	"^204336",--Grounding Totem
	"^204293",--Spirit Link
	"^204288",--Earth Shield
	
-- Warlock Buffs

	"^199890",--Curse of Tongues
	"^199892",--Curse of Weakness
	"^199954",--Curse of Fragility
	"^234877",--Curse of Shadows
	"^221703",--Casting Circle
	"^212295",--Nether Ward
	"^212356",--Soulshatter
	
	XBAR_SNOWRAP,
	"^212623",--Singe Magic
	"^212619",--Call Felhunter
	"^212459",--Call Fel Lord
	"^201996",--Call Observer
	
	XBAR_SNOWRAP,
	"^212284",--Firestone
	"^200546",--Bane of Havoc
	
-- Warrior Buffs

	
	"^236077",--Disarm
	"^216890",--Spell Reflection
	"^236273",--Duel
	"^236320",--War Banner
	"^198817",--Sharpen Blade
	
	XBAR_SNOWRAP,
	"^199261",--Death Wish
	
	XBAR_SNOWRAP,
	"^236236",--Disarm
	"^213915",--Mass Spell Reflection
	"^213871",--Bodyguard
	"^198912",--Shield Bash
	"^206572",--Dragon Charge
	
	
-- Monk Buffs
	"#Monk",
	"^202162",--Guard
	"^202335",--Double Barrel
	"^213658",--Craft: Nimble Brew
	"^202370",--Mighty Ox Kick
		
	XBAR_SNOWRAP,
	"^216113",--Way of the Crane
	"^205234",--Healing Sphere
	
	XBAR_SNOWRAP,
	"^201318",--Fortifying Elixir
	"^233759",--Grapple Weapon
	"^201325",--Zen Moment
	"^202077",--Spinning Fire Blossom
	
-- Demon hunter Buffs
	"^206803",--Rain from Above
	"^205604",--Reverse Magic	
	"^206649",--Eye of Leotheras
	"^203704",--Mana Break
	"^235903",--Mana Rift	
	XBAR_SNOWRAP,
	"^205629",--Demonic Trample
	"^205630",--Illidan's Grasp
		

};

-- Maximum bar size will be auto-calculated in the main section

XBarCore.Localize(XPvPBarSpells);

XBAR_HELP_CONTEXT_XPvPBar = XBarHelpGUI.ContextHeader("XPvPBar").."Spells are organized by class, check a spell to show or uncheck to hide it."

local i,v,p,s;

-- Auto-translate the class headers
for i,v in pairs(XPvPBarSpells) do
	if strsub(XPvPBarSpells[i],1,1)=="#" then
		s="";
		p=strfind(XPvPBarSpells[i],"-",2,true);
		if (p==nil) then
			p=strlen(XPvPBarSpells[i]);
		else
			s=strsub(XPvPBarSpells[i],p);
			p=p-1;
		end
		XPvPBarSpells[i]="#"..tostring(LOCALIZED_CLASS_NAMES_MALE[strsub(XPvPBarSpells[i],2,p)])..s;
	end
end
