-------------------------------------------------------------------------------
-- English localization (Default)
-------------------------------------------------------------------------------

-- Bindings
getfenv()["BINDING_NAME_CLICK XHealBarButtonToggle:LeftButton"] = "Show/hide XHealBar";

-- Most of these buffs affect a party.  Some buffs that only affect the caster are included
-- if the class only has a few of them.  Warlocks and Rogues have so many other abilities
-- they will be in a separate bar.

-- Buffs
XHealBarSpells = {
-- Profession spells
--	XBAR_SNOWRAP,
-- Death Knight

-- Druid Buffs
	"#DRUID",
	"^88423",--Nature's Cure
	"^2782",--Remove Corruption
	XBAR_SNOWRAP,	
	"^108238",--Renewal
	XBAR_SNOWRAP,
	"^18562",--Swiftmend
	"^5185",--Healing Touch
	"^8936",--Regrowth
	"^774",--Rejuvenation
	"^33763",--Lifebloom
	XBAR_SNOWRAP,
	"^48438",--Wild Growth
	"^740",--Tranquility
	XBAR_SNOWRAP,
	"^50769",--Revive
	"^212040",--Revitalize
	"^20484",--Rebirth	
	XBAR_SNOWRAP,
	"^124974",--Nature's Vigil
	"^102352",--Cenarion Ward
	"^145205",--Efflorescence
	"^197721",--Flourish

-- Hunter Buffs
-- Mage Buffs

-- Pally buffs
	"^210191",--Word of Glory
	"^19750",--Flash of Light
	"^82326",--Divine Light
	XBAR_SNOWRAP,
	"^105809",--Holy Avenger
	"^114165",--Holy Prism
	"^20473",--Holy Shock
	XBAR_SNOWRAP,
	"^183998",--Light of the Martyr
	"^223306",--Bestow Faith
	"^114158",--Light's Hammer
	"^214202",--Rule of Law
	XBAR_SNOWRAP,
	"^200025",--Beacon of Virtue
	"^53563",--Beacon of Light
	"^156910",--Beacon of Faith
	XBAR_SNOWRAP,
	"^85222",--Light of Dawn
	"^633",--Lay on Hands
	XBAR_SNOWRAP,
	"^4987",--Cleanse
	"^7328",--Redemption
	"^212056",--Absolution
	
-- Priest Buffs

	"^17",--Power Word: Shield
	"^152118",--Clarity of Will	
	XBAR_SNOWRAP,
	
	"^47536",--Rapture
	"^81782",--Power Word: Barrier	
	"^121536",--Angelic Feather
	"^214121",--Body and Mind
	
	XBAR_SNOWRAP,
	"^47540",--Penance
	"^139",--Renew
	"^2061",--Flash Heal
	"^32546",--Binding Heal	
	"^2060",--Heal
	
	XBAR_SNOWRAP,
	-- "^121135",--Cascade
	"^120517",--Halo
	"^110744",--Divine Star	
	
	XBAR_SNOWRAP,
	"^47788",--Guardian Spirit
	"^64843",--Divine Hymn
	"^64901",--Symbol of Hope
	
	XBAR_SNOWRAP,
	"^33076",--Prayer of Mending	
	"^596",--Prayer of Healing
	"^204883",--Circle of Healing
	"^34861",--Holy Word: Sanctify
	"^88625",--Holy Word: Chastise
	"^194509",--Power Word: Radiance
	
	XBAR_SNOWRAP,	
	"^200183",--Apotheosis
		
	XBAR_SNOWRAP,
	"^132157",--Holy Nova	
	"^204263",--Shining Force
	"^19236",--Desperate Prayer
	"^200829",--Plea
	
	XBAR_SNOWRAP,
	"^528",--Dispel Magic
	"^32375",--Mass Dispel
	"^527",--Purify
	"^213634",--Purify Disease
	
	XBAR_SNOWRAP,
	"^2006",--Resurrection
	"^212036",--Mass Resurrection
	
-- Rogue Buffs
-- Shaman buffs
	"#SHAMAN",
	"^61295",--Riptide
	"^188070",--Healing Surge
	"^1064",--Chain Heal
	"^77472",--Healing Wave
	XBAR_SNOWRAP,
	"^370",--Purge
	XBAR_SNOWRAP,
	"^2008",--Ancestral Spirit
	"^212048",--Ancestral Vision
	XBAR_SNOWRAP,
	"^73920",--Healing Rain	
	"^197995",--Wellspring
	"^215864",--Rainfall
	XBAR_SNOWRAP,
	"^370",--Purge
	"^51886",--Cleanse Spirit
	"^77130",--Purify Spirit
	XBAR_SNOWRAP,
	"^2008",--Ancestral Spirit	
	"^212048",--Ancestral Vision
	
-- Warlock Buffs
-- Warrior Buffs

-- Monk Buffs
	"#Monk",
	"^115175",--Soothing Mist
	"^115151",--Renewing Mist
	"^116694",--Surging Mist
	"^124682",--Enveloping Mist
	"^116670",--Uplift
	"^116849",--Life Cocoon
	"^115072",--Expel Harm
	
	XBAR_SNOWRAP,
	"^115450",--Detox
	"^115310",--Revival
	
	XBAR_SNOWRAP,
	"^115178",--Resuscitate
	"^212051",--Reawaken
};

-- Maximum bar size will be auto-calculated in the main section

XBarCore.Localize(XHealBarSpells);

XBAR_HELP_CONTEXT_XHealBar = XBarHelpGUI.ContextHeader("XHealBar").."Spells are organized by class, check a spell to show or uncheck to hide it."

local i,v,p,s;

-- Auto-translate the class headers
for i,v in pairs(XHealBarSpells) do
	if strsub(XHealBarSpells[i],1,1)=="#" then
		s="";
		p=strfind(XHealBarSpells[i],"-",2,true);
		if (p==nil) then
			p=strlen(XHealBarSpells[i]);
		else
			s=strsub(XHealBarSpells[i],p);
			p=p-1;
		end
		XHealBarSpells[i]="#"..tostring(LOCALIZED_CLASS_NAMES_MALE[strsub(XHealBarSpells[i],2,p)])..s;
	end
end
