-------------------------------------------------------------------------------
-- English localization (Default)
-------------------------------------------------------------------------------

-- Bindings
getfenv()["BINDING_NAME_CLICK XBuffBarButtonToggle:LeftButton"] = "Show/hide XBuffBar";

-- Most of these buffs affect a party.  Some buffs that only affect the caster are included
-- if the class only has a few of them.  Warlocks and Rogues have so many other abilities
-- they will be in a separate bar.

-- Buffs
XBuffBarSpells = {
-- Death Knight
	"#DEATHKNIGHT",
	"^3714",--Path of Frost
	
	XBAR_SNOWRAP,
	"^48792",--Icebound Fortitude
	"^194679",--Rune Tap
	"^51271",--Pillar of Frost	
	"^55233",--Vampiric Blood
	"^57330",--Horn of Winter
	"^206977",--Blood Mirror
	"^194844",--Bonestorm
	
	XBAR_SNOWRAP,
	"^48707",--Anti-Magic Shell
	"^51052",--Anti-Magic Zone
	
	XBAR_SNOWRAP,
	"^47568",--Empower Rune Weapon
	"^49028",--Dancing Rune Weapon
	"^207127",--Hungering Rune Weapon
	"^194918",--Blighted Rune Weapon
	
	XBAR_SNOWRAP,
	"^77575",--Outbreak
	
	XBAR_SNOWRAP,
	"^77606",--Dark Simulacrum
	"^49039",--Lichborne
	"^108201",--Desecrated Ground
	"^108199",--Gorefiend's Grasp
	"^108194",--Asphyxiate	
	
	XBAR_SNOWRAP,
	"^45524",--Chains of Ice
	"^47528",--Mind Freeze
	
	XBAR_SNOWRAP,
	"^212552",--Wraith Walk	
	"^207167",--Blinding Sleet	
	"^221699",--Blood Tap		
	"^127344",--Corpse Explosion
	
	XBAR_SNOWRAP,
	"^56222",--Dark Command
	"^206940",--Mark of Blood
	"^219809",--Tombstone
	"^221699",--Blood Tap
	
	XBAR_SNOWRAP,
	"^152279",--Breath of Sindragosa
	"^196770",--Remorseless Winter
	"^207256",--Obliteration
	"^194913",--Glacial Advance
	
	XBAR_SNOWRAP,
	"^61999",--Raise Ally
	
	XBAR_SNOWRAP,
	"^111673",--Control Undead
	
	XBAR_SNOWRAP,
	"^46584",--Raise Dead
	"^207319",--Corpse Shield
	
	XBAR_SNOWRAP,
	"^49206",--Summon Gargoyle
	"^207349",--Dark Arbiter
	"^42650",--Army of the Dead
	"^63560",--Dark Transformation	
	
	XBAR_SNOWRAP,
	"^50977",--Death Gate
	
-- Druid Buffs
	"#DRUID",
	"^22812",--Barkskin
	"^102342",--Ironbark
	XBAR_SNOWRAP,
	"^339",--Entangling Roots
	"^102359",--Mass Entanglement
	"^33786",--Cyclone
	XBAR_SNOWRAP,
	"^78675",--Solar Beam
	XBAR_SNOWRAP,
	"^191034",--Starfall
	"^194223",--Celestial Alignment
	"^29166",--Innervate
	"^202770",--Fury of Elune
	"^202359",--Astral Communion
	"^202360",--Blessing of the Ancients
	XBAR_SNOWRAP,
	"^102794",--Ursol's Vortex
	"^127757",--Charm Woodland Creature	
	XBAR_SNOWRAP,
	"^5215",--Prowl
	"^5217",--Tiger's Fury
	"^61336",--Survival Instincts
	"^202060",--Elune's Guidance
	XBAR_SNOWRAP,
	"^102558",--Incarnation: Guardian of Ursoc
	"^102543",--Incarnation: King of the Jungle
	"^33891",--Incarnation: Tree of Life
	"^102560",--Incarnation: Chosen of Elune
	XBAR_SNOWRAP,
	"^5211",--Mighty Bash
	"^22842",--Frenzied Regeneration
	"^106951",--Berserk
	XBAR_SNOWRAP,
	"^106898",--Stampeding Roar
	"^1850",--Dash
	XBAR_SNOWRAP,
	"^99",--Incapacitating Roar
	"^192081",--Ironfur
	--"^192083",--Mark of Ursol
	XBAR_SNOWRAP,
	"^33891",--Tree of Life
	"^124974",--Nature's Vigil
	"^132469",--Typhoon
	"^164862",--Flap
	"^205636",--Force of Nature
	XBAR_SNOWRAP,
	"^88423",--Nature's Cure
	"^2782",--Remove Corruption
	XBAR_SNOWRAP,	
	"^108238",--Renewal
	XBAR_SNOWRAP,
	"^102351",--Cenarion Ward
	"^18562",--Swiftmend
	"^5185",--Healing Touch
	"^8936",--Regrowth
	"^774",--Rejuvenation
	
-- Hunter Buffs
	"#HUNTER",
	"^193530",--Aspect of the Wild	
	"^186289",--Aspect of the Eagle
	"^191384",--Aspect of the Beast
	"^61648",--Aspect of the Chameleon
	XBAR_SNOWRAP,
	"^186265",--Aspect of the Turtle	
	
	XBAR_SNOWRAP,
	"^186283",--Aspect of the Cheetah
	--"^186258",--Aspect of the Cheetah
	
	XBAR_SNOWRAP,
	"^109304",--Exhilaration
	
	XBAR_SNOWRAP,
	"^199483",--Camouflage
	"^5384",--Feign Death
	
	XBAR_SNOWRAP,
	"^19263",--Deterrence
	"^82726",--Fervor
	"^206817",--Sentinel
	"^193526",--Trueshot
	"^1543",--Flare
	"^201078",--Snake Hunter
	
	XBAR_SNOWRAP,
	"^6197",--Eagle Eye
	
	XBAR_SNOWRAP,
	"^781",--Disengage
	
	XBAR_SNOWRAP,
	"^3045",--Rapid Fire
	"^34477",--Misdirection
	"^20736",--Distracting Shot		
	"^200163",--Throwing Axes
	
	XBAR_SNOWRAP,
	"^19386",--Wyvern Sting
	"^147362",--Counter Shot
	"^109248",--Binding Shot
	"^187707",--Muzzle
	
	XBAR_SNOWRAP,
	"^131894",--A Murder of Crows
	"^201430",--Stampede
	"^120360",--Barrage
	
	XBAR_SNOWRAP,
	"^127933",--Fireworks
	
-- Mage Buffs
	"#MAGE",
	"^130",--Slow Fall
	"^12051",--Evocation
	"^45438",--Ice Block
	
	XBAR_SNOWRAP,
	"^66",--Invisibility
	"^110959",--Greater Invisibility
	
	XBAR_SNOWRAP,
	"^12042",--Arcane Power
	"^31687",--Summon Water Elemental
	
	XBAR_SNOWRAP,
	"^55342",--Mirror Image
	
	XBAR_SNOWRAP,
	"^2139",--Counterspell
	"^205032",--Charged Up
	"^205030",--Frozen Touch
	"^12472",--Icy Veins
	"^31589",--Slow	
	"^195676",--Displacement
	"^205022",--Arcane Familiar
	"^205025",--Presence of Mind
	
	XBAR_SNOWRAP,
	"^30449",--Spellsteal
	
	XBAR_SNOWRAP,
	--"^108978",--Alter Time
	"^80353",--Time Warp
	
	
	XBAR_SNOWRAP,
	"^153626",--Arcane Orb
	"^114923",--Nether Tempest
	"^157980",--Supernova
	"^1449",--Arcane Explosion
	
	XBAR_SNOWRAP,
	"^153595",--Comet Storm
	"^112948",--Frost Bomb
	"^84714",--Frozen Orb
	"^113724",--Ring of Frost
	"^157997",--Ice Nova
	"^190356",--Blizzard
	"^205021",--Ray of Frost
	
	XBAR_SNOWRAP,
	"^153561",--Meteor
	"^2120",--Flamestrike
	"^198929",--Cinderstorm
	"^190319",--Combustion	
	"^205029",--Flame On
	
	XBAR_SNOWRAP,
	"^44457",--Living Bomb
	"^157981",--Blast Wave	
	
	XBAR_SNOWRAP,
	"^108839",--Ice Floes
	"^11426",--Ice Barrier
	--"^115610",--Temporal Shield
	"^113724",--Ring of Frost
	--"^11958",--Cold Snap
	"^1463",--Incanter's Ward
	"^116011",--Rune of Power
	
	XBAR_SNOWRAP,
	"^126578",--Conjure Familiar
	"^131784",--Illusion
	
	XBAR_SNOWRAP,
	"^42955",--Conjure Refreshment
	"^43987",--Conjure Refreshment Table	
	
-- Pally buffs
	"#PALADIN",	
	"^1044",--Blessing of Freedom
    "^199448",--Blessing of Sacrifice
	"^204013",--Blessing of Salvation
	"^204018",--Blessing of Spellwarding
	"^175365",--Blessing of Wisdom
	"^1022",--Blessing of Protection
	XBAR_SNOWRAP,
	"^498",--Divine Protection
	"^642",--Divine Shield
	"^204150",--Aegis of Light
	XBAR_SNOWRAP,
	"^62124",--Hand of Reckoning
	"^25780",--Righteous Fury
	XBAR_SNOWRAP,
	--"^203528",--Greater Blessing of Might
	"^203538",--Greater Blessing of Kings
	"^203539",--Greater Blessing of Wisdom
	XBAR_SNOWRAP,
	"^204035",--Bastion of Light
	"^31884",--Avenging Wrath
	"^224668",--Crusade	
	XBAR_SNOWRAP,
	"^205191",--Eye for an Eye
	XBAR_SNOWRAP,
	"^210220",--Holy Wrath
	"^31821",--Aura Mastery
	"^4987",--Cleanse
	XBAR_SNOWRAP,
	"^190784",--Divine Steed
	XBAR_SNOWRAP,
	"^86659",--Guardian of Ancient Kings
	"^31850",--Ardent Defender
	
	XBAR_SNOWRAP,
	"^853",--Hammer of Justice
	"^198054",--Fist of Justice
	"^96231",--Rebuke
	"^20066",--Repentance
	"^115750",--Blinding Light	
	XBAR_SNOWRAP,
	"^114158",--Light's Hammer
	XBAR_SNOWRAP,
	"^183415",--Aura of Mercy
	"^210191",--Word of Glory
	"^114165",--Holy Prism
	"^213652",--Hand of the Protector
	"^19750",--Flash of Light
	"^184092",--Light of the Protector
	XBAR_SNOWRAP,
	"^82326",--Holy Light
	"^85222",--Light of Dawn
	XBAR_SNOWRAP,
	"^213644",--Cleanse Toxins
	"^4987",--Cleanse	
	XBAR_SNOWRAP,
	"^212056",--Absolution
	"^157199",--Redemption
	XBAR_SNOWRAP,
	"^633",--Lay on Hands
	
-- Priest Buffs
	"#PRIEST",
	"^1706",--Levitate
	XBAR_SNOWRAP,
	"^15286",--Vampiric Embrace	
	XBAR_SNOWRAP,
	"^17",--Power Word: Shield
	"^47536",--Rapture
	"^81782",--Power Word: Barrier
	"^121536",--Angelic Feather
	"^214121",--Body and Mind
	XBAR_SNOWRAP,
	"^34433",--Shadowfiend
	"^123040",--Mindbender
	XBAR_SNOWRAP,
	"^15487",--Silence
	"^8122",--Psychic Scream
	XBAR_SNOWRAP,
	"^586",--Fade
	
	XBAR_SNOWRAP,
	"^10060",--Power Infusion
	"^33206",--Pain Suppression
	"^47585",--Dispersion
	"^186263",--Shadow Mend
	
	XBAR_SNOWRAP,
	"^47788",--Guardian Spirit
	"^9484",--Shackle Undead
	"^2096",--Mind Vision
	"^605",--Dominate Mind
	"^73325",--Leap of Faith
	"^126123",--Confession
	"^121536",--Angelic Feather
	"^112833",--Spectral Guise	
		
	XBAR_SNOWRAP,
	"^193223",--Surrender to Madness
	
	XBAR_SNOWRAP,
	"^528",--Dispel Magic
	"^32375",--Mass Dispel
	"^527",--Purify
	"^213634",--Purify Disease
	
	XBAR_SNOWRAP,
	"^2006",--Resurrection
	"^212036",--Mass Resurrection
		
-- Rogue Buffs
	"#ROGUE",
	
	"#Combat Abilities",
	"^195457",--Grappling Hook	
	"^36554",--Shadowstep	
	"^13877",--Blade Flurry
	"^5171",--Slice and Dice
	"^13750",--Adrenaline Rush
	"^74001",--Combat Readiness
	"^57934",--Tricks of the Trade
	"^121471",--Shadow Blades
	"^79140",--Vendetta
	"^185313",--Shadow Dance
	"^31224",--Cloak of Shadows	
	XBAR_SNOWRAP,
	"^200802",--Agonizing Poison
	"^108211",--Leeching Poison
	"^8680",--Wound Poison
	"^2818",--Deadly Poison
	"^3409",--Crippling Poison
	XBAR_SNOWRAP,
	"^185767",--Cannonball Barrage
	"^51690",--Killing Spree
	"^152150",--Death from Above
	"^137619",--Marked for Death
	XBAR_SNOWRAP,
    "#Survival Abilities",
	"^1856",--Vanish
	"^2094",--Blind	
	XBAR_SNOWRAP,
	"^5277",--Evasion	
	XBAR_SNOWRAP,
	"^1966",--Feint
	XBAR_SNOWRAP,
	"^2983",--Sprint
	"^108212",--Burst of Speed
	XBAR_SNOWRAP,
	"^1766",--Kick
	XBAR_SNOWRAP,
    "#Crowd Control",
	"^76577",--Smoke Bomb
	"^1725",--Distract
	"^6770",--Sap
	XBAR_SNOWRAP,
    "#Miscellaneous",
	"^199740",--Bribe
	"^921",--Pick Pocket
	"^1804",--Pick Lock
-- Shaman buffs

	"#SHAMAN",
	"^556",--Astral Recall
	"^546",--Water Walking
	XBAR_SNOWRAP,
	-- "^8232",--Windfury Weapon
	"^188089",--Earthen Spike
	XBAR_SNOWRAP,
	"^192106",--Lightning Shield
	"^197211",--Fury of Air
	XBAR_SNOWRAP,
	"^79206",--Spiritwalker's Grace
	"^58875",--Spirit Walk
	XBAR_SNOWRAP,
	"^197214",--Sundering
	"^210714",--Icefury
	"^51533",--Feral Spirit
	"^108271",--Astral Shift
	"^6196",--Far Sight
	"^192063",--Gust of Wind
	"^57994",--Wind Shear
	"^108281",--Ancestral Guidance
	XBAR_SNOWRAP,
	"^2825",--Bloodlust
	"^32182",--Heroism
	XBAR_SNOWRAP,
	"^114049",--Ascendance
	"^16166",--Elemental Mastery
	XBAR_SNOWRAP,	
	"^2645",--Ghost Wolf
	XBAR_SNOWRAP,
	"^51514",--Hex
	XBAR_SNOWRAP,
	"^370",--Purge
	"^51886",--Cleanse Spirit
	"^77130",--Purify Spirit
	XBAR_SNOWRAP,
	"^2008",--Ancestral Spirit	
	"^212048",--Ancestral Vision
	
	
-- Warlock Buffs
	"#WARLOCK",
	
	"^108503",--Grimoire of Sacrifice
	"^108501",--Grimoire of Service
	"^108359",--Dark Regeneration
	"^108416",--Sacrificial Pact
	"^119898",--Command Demon
	"^755",--Health Funnel
	"^1098",--Enslave Demon
	"^205179",--Phantom Singularity
	XBAR_SNOWRAP,
	"#Demons",
	"^688",--Summon Imp
	"^112866",--Summon Fel Imp	
	"^697",--Summon Voidwalker
	"^112867",--Summon Voidlord	
	"^712",--Summon Succubus
	"^112868",--Summon Shivarra	
	"^691",--Summon Felhunter
	"^112869",--Summon Observer	
	"^30146",--Summon Felguard
	"^112870",--Summon Wrathguard	
	XBAR_SNOWRAP,
	"#Demons",
	"^1122",--Summon Infernal	
	"^18540",--Summon Doomguard
	"^126",--Eye of Kilrogg
	XBAR_SNOWRAP,
	"^104316",--Imp Swarm	
	XBAR_SNOWRAP,
    "#Miscellaneous",
	"^111400",--Burning Rush
	"^1454",--Life Tap
	"^710",--Banish
	"^5697",--Unending Breath
	XBAR_SNOWRAP,
	"^5740",--Rain of Fire
	"^152108",--Cataclysm
	XBAR_SNOWRAP,
	"^29858",--Soulshatter
	"^5782",--Fear
	"^6789",--Mortal Coil
	"^5484",--Howl of Terror
	"^30283",--Shadowfury
	XBAR_SWRAP,
	"#Conjurables",
	"^48018",--Demonic Circle 
	-- "^48018",--Demonic Circle: Summon
	-- "^48020",--Demonic Circle: Teleport
	"^111771",--Demonic Gateway
	"^698",--Ritual of Summoning
	XBAR_SNOWRAP,
	"^29893",--Create Soulwell
	"^20707",--Soulstone
	"^6201",--Create Healthstone
	XBAR_SNOWRAP,
	"^104773",--Unending Resolve
	"^205178",--Soul Effigy
	"^196098",--Soul Harvest
	"^108416",--Dark Pact
	
-- Warrior Buffs
	"#WARRIOR",
	"^197690",--Defensive Stance
	
	XBAR_SNOWRAP,
	"^97462",--Commanding Shout
	
	XBAR_SNOWRAP,
	"^5246",--Intimidating Shout
	"^1160",--Demoralizing Shout
	"^107566",--Staggering Shout
	
	XBAR_SNOWRAP,
	"^12323",--Piercing Howl
	"^118000",--Dragon Roar
	
	XBAR_SNOWRAP,
	"^23920",--Spell Reflection
	"^114028",--Mass Spell Reflection
	
	XBAR_SNOWRAP,
	"^18499",--Berserker Rage
	"^118038",--Die by the Sword
	
	XBAR_SNOWRAP,
	"^184364",--Enraged Regeneration
	
	XBAR_SNOWRAP,
	"^198304",--Intercept
	
	XBAR_SNOWRAP,
	"^871",--Shield Wall
	"^12975",--Last Stand	 
	"^97462",--Rallying Cry
	"^3411",--Intervene
	
	XBAR_SNOWRAP,
	"^50622",--Bladestorm
	"^152277",--Ravager
	"^107574",--Avatar
	"^1719",--Recklessness
	"^12292",--Bloodbath
	"^114030",--Vigilance
	
-- Monk Buffs
	"#MONK",
	"^115203",--Fortifying Brew
	"^115288",--Energizing Brew
	"^115399",--Chi Brew
	"^116740",--Tigereye Brew
	"^119582",--Purifying Brew
	"^115399",--Black Ox Brew
	"^115308",--Ironskin Brew
	"^119582",--Purifying Brew
	
	XBAR_SNOWRAP,
	"^197908",--Mana Tea
	"^116680",--Thunder Focus Tea	
	
	XBAR_SNOWRAP,
	"^126892",--Zen Meditation	
	
	XBAR_SNOWRAP,
	"^115313",--Summon Jade Serpent Statue
	"^115315",--Summon Black Ox Statue
	
	XBAR_SNOWRAP,
	"^122470",--Touch of Karma
	"^115080",--Touch of Death
	
	XBAR_SNOWRAP,
	"^137639",--Storm, Earth, and Fire
	"^152173",--Serenity	
	
	XBAR_SNOWRAP,
	"^198664",--Invoke Chi-Ji, the Red Crane
	"^132578",--Invoke Niuzao, the Black Ox
	"^123904",--Invoke Xuen, the White Tiger
	
		
	XBAR_SNOWRAP,
	"^116095",--Disable 
	"^116705",--Spear Hand Strike
	"^115078",--Paralysis
	"^107079",--Quaking Palm
	"^116844",--Ring of Peace
	"^198898",--Song of Chi-Ji
	
	XBAR_SNOWRAP,
	"^101643",--Transcendence
	"^119996",--Transcendence: Transfer
	
	XBAR_SNOWRAP,
	"^126892",--Zen Pilgrimage
	
	XBAR_SNOWRAP,
	"^116841",--Tiger's Lust
	"^119381",--Leg Sweep
	"^122278",--Dampen Harm
	"^122783",--Diffuse Magic
	
	XBAR_SNOWRAP,
	"^123904",--Invoke Xuen, the White Tiger
	-- "^119392",--Charging Ox Wave
	
	XBAR_SNOWRAP,	
	"^115072",--Expel Harm
	"^115310",--Revival
	"^116849",--Life Cocoon	
	"^115450",--Detox
	"^115178",--Resuscitate
	"^212051",--Reawaken
	
	XBAR_SNOWRAP,	
	"^125883",--Zen Flight
	
-- Demon Hunter Buffs	
	"^207810",--Nether Bond
	"^212084",--Fel Devastation

	XBAR_SNOWRAP,
	"^202138",--Sigil of Chains
	"^207684",--Sigil of Misery
	"^202137",--Sigil of Silence
	"^204596",--Sigil of Flame

	XBAR_SNOWRAP,
	"^204021",--Fiery Brand
	
	XBAR_SNOWRAP,
	"^187827",--Metamorphosis
	
	XBAR_SNOWRAP,
	"^206491",--Nemesis
	"^196555",--Netherwalk
	
	XBAR_SNOWRAP,
	"^198589",--Blur
	
	XBAR_SNOWRAP,
	"^211048",--Chaos Blades
	
	XBAR_SNOWRAP,
	"^196718",--Darkness
	
	XBAR_SNOWRAP,
	"^217832",--Imprison	
	"^183752",--Consume Magic
	
	XBAR_SNOWRAP,
	"^188501",--Spectral Sight

};

-- Maximum bar size will be auto-calculated in the main section

XBarCore.Localize(XBuffBarSpells);

XBAR_HELP_CONTEXT_XBuffBar = XBarHelpGUI.ContextHeader("XBuffBar").."Spells are organized by class, check a spell to show or uncheck to hide it."

local i,v,p,s;

-- Auto-translate the class headers
for i,v in pairs(XBuffBarSpells) do
	if strsub(XBuffBarSpells[i],1,1)=="#" then
		s="";
		p=strfind(XBuffBarSpells[i],"-",2,true);
		if (p==nil) then
			p=strlen(XBuffBarSpells[i]);
		else
			s=strsub(XBuffBarSpells[i],p);
			p=p-1;
		end
		XBuffBarSpells[i]="#"..tostring(LOCALIZED_CLASS_NAMES_MALE[strsub(XBuffBarSpells[i],2,p)])..s;
	end
end
