local name = "Wyr3d_IcyVeins_Stats"
local version = "Release Version April 2018"
local title = "for Patch 7.3.5"

Wyr3d_STATS = CreateFrame("Frame",Wyr3d_STATS,UIParent)

function Wyr3d_STATS:CreateWin()
    if PaperDollFrame:IsVisible() then
        if not Wyr3d_STATSwin then
            Wyr3d_STATSwin = CreateFrame("Frame",Wyr3d_STATSwin,Wyr3d_STATS)
            local f = Wyr3d_STATS
            f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                    edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                    tile = true, tileSize = 16, edgeSize = 16, 
                    insets = { left = 1, right = 1, top = 1, bottom = 1 }}) 
            f:SetBackdropColor(0,0,0,1)
            f:SetFrameStrata("TOOLTIP")
            f:SetWidth(PaperDollFrame:GetWidth()-50) 
            f:SetHeight(55)
    	    Wyr3d_STATStxt = f:CreateFontString(nil,"OVERLAY","GameFontWhite")
			local ft = Wyr3d_STATStxt 
			ft:ClearAllPoints()
			ft:SetAllPoints(Wyr3d_STATS) 
			ft:SetJustifyH("CENTER")
			ft:SetJustifyV("CENTER")
            f:ClearAllPoints()
            f:SetPoint("BOTTOMRIGHT",PaperDollFrame,"TOPRIGHT",0,0)
            f:SetParent(PaperDollFrame)
            f:Show()            
        end
        return true
    end
    return false
end

function Wyr3d_STATS:Update()
    if Wyr3d_STATS:CreateWin() then
        local _, className = UnitClass("player")
        local sId, specName = GetSpecializationInfo(GetSpecialization())
        local s = Wyr3d_StatTable[className .. "-" .. sId]
        if s then
            s = gsub(s,"Strength","STR")
            s = gsub(s,"Agility","AGI")
            s = gsub(s,"Intelligence","INT")
            s = gsub(s,"Stamina","STA")
            Wyr3d_STATStxt:SetText(s) 
        end               
    end
end

local f = Wyr3d_STATS
f:RegisterEvent("SPELLS_CHANGED") 
f:RegisterEvent("ADDON_LOADED") 
f:SetScript("OnEvent", function(self, event, ...)
    if event == "ADDON_LOADED" and ... == name then
        Wyr3d_STATS:Update()
        PaperDollFrame:HookScript("OnShow", function() Wyr3d_STATS:Update() end)
    end
    if event == "SPELLS_CHANGED" then
        if IsAddOnLoaded("Wyr3d_IcyVeins_Stats") then
            Wyr3d_STATS:Update()
        end
    end
end)

print(name,title,"Loaded!")