--
-- WorldPlan
-- Map Frame Customizations
--
local _, db = ...
local print = DEVIAN_WORKSPACE and function(...) print('MapFrame',...) end or nop
local enableConfigLayers = false
local regionLabels = {}

WorldPlanMapFrameMixin = {
  defaults = {
    anchors = {
      point = 'LEFT',
      x = 50,
    },
    size = {
      x = 800,
      y = 600
    }
  }

}
local Module = WorldPlanMapFrameMixin

function Module:OnLoad()
  WorldPlan:AddHandler(self)
  hooksecurefunc("WorldMap_ToggleSizeUp", function()
    self:ApplySettings()
  end)
  hooksecurefunc("WorldMap_ToggleSizeDown", function()
    self:ApplySettings()
  end)
  print('OnLoad()')
end

function Module:Setup()
  print('Setup()')
  self:ApplySettings()


  --if not InCombatLockdown() then
  --end
end



db.CLTriggers.map = function(arg2)
  WorldPlanMapFrame:ApplySettings()
  if enableConfigLayers then
    enableConfigLayers = false
    db.print('Map Labels off')
  else
    enableConfigLayers = true
    db.print('Map Labels on')
  end
  for m, label  in pairs(regionLabels) do
    print(m, label)
    label:SetShown(enableConfigLayers)
  end
end

local BORDER_COLOR = {0,0,0,1}
local BORDER_INSET = 0
local BORDER_WIDTH = 2
local BORDER_INSET_WIDTH = BORDER_INSET+BORDER_WIDTH

local GlobalRegions = {
  [WorldMapFrameLeftBorder] = {
    color = BORDER_COLOR,
    w = BORDER_WIDTH,
    [1] = {'TOPRIGHT', 'TOPLEFT', BORDER_INSET, 0},
    [2] = {'BOTTOMRIGHT', 'BOTTOMRIGHT', BORDER_INSET_WIDTH, -BORDER_INSET }
  },
  [WorldMapFrameRightBorder] = {
    color = BORDER_COLOR,
    w = BORDER_WIDTH,
    [1] = {'TOPLEFT', 'TOPRIGHT', BORDER_INSET,0 },
    [2] = {'BOTTOMRIGHT', 'BOTTOMRIGHT', BORDER_INSET_WIDTH, -BORDER_INSET_WIDTH}
  },
  [WorldMapFrameTopBorder] = {
    color = BORDER_COLOR,
    h = BORDER_WIDTH,
    [1] = {'BOTTOMRIGHT', 'TOPRIGHT', BORDER_INSET_WIDTH, 0},
    [2] = {'BOTTOMLEFT', 'TOPLEFT', -(BORDER_INSET_WIDTH), 0}
  },
  [WorldMapFrameBottomBorder]  = {
    h = BORDER_WIDTH,
    color = BORDER_COLOR,
    [1] = {'TOPRIGHT', 'BOTTOMRIGHT', BORDER_INSET_WIDTH, -BORDER_INSET},
    [2] = {'TOPLEFT', 'BOTTOMLEFT', -BORDER_INSET_WIDTH, -BORDER_INSET}
  },
  [WorldMapFrameBg] = {
    color = BORDER_COLOR,
    [1] = {'TOPLEFT', 'TOPLEFT', 0, 0},
    [2] = {'BOTTOMRIGHT', 'BOTTOMRIGHT', 0, 0}
  },
  [WorldMapFrameNavBar] = {
    [1] = {'TOPLEFT', 'TOPLEFT', 3, 0, WorldMapFrameBg},
    [2] = {'TOPRIGHT', 'TOPRIGHT', -3, 0, WorldMapFrameBg}
  },
  [WorldMapTitleButton] = {
    [1] = {'TOPLEFT', 'TOPLEFT', 0, 0, WorldMapFrameNavBarOverlay},
    [2] = {'BOTTOMRIGHT', 'BOTTOMRIGHT', 0, 0, WorldMapFrameNavBarOverlay},
  },
  [WorldMapFrameTitleText] = { hidden = true },
  [WorldMapFrameBotLeftCorner] = { hidden = true},
  [WorldMapFramePortraitFrame] = { hidden = true},
  [WorldMapFramePortrait] = { hidden = true, },
  [WorldMapFrameTutorialButton] = { hidden = true, },
  [WorldMapFrameTopRightCorner] = {hidden = true},
  [WorldMapFrameTopLeftCorner] = {hidden = true},
  [WorldMapFrameBotLeftCorner] = {hidden = true},
  [WorldMapFrameBotRightCorner] = {hidden = true},
  [WorldMapFrameTopTileStreaks] = { hidden = true},
  [WorldMapFrame.BorderFrame.ButtonFrameEdge] = { hidden = true},
  [WW] = {hidden = true}
}



function Module:ApplySettings()
  print('ApplySettings()')

  local regions = {WorldMapFrame.BorderFrame:GetRegions() }
  local r,g,b,a = 1,0,0,1
  for name, region in pairs(regions) do
    local fs = regionLabels[region]
    if not fs then
      --print(name, type(region), tostring(region), region:GetName())
      fs = self:CreateFontString(nil, 'OVERLAY')
      fs:SetFontObject(WorldPlanFont)
      regionLabels[region] = fs
      fs:SetPoint('TOPLEFT', region, 'TOPLEFT')
      fs:SetShown(enableConfigLayers)
      fs:SetText(tostring(region:GetName()))
    end

--[[
    if region.SetColorTexture then
      region:SetColorTexture(r,g,b,a)
      print('===', region.GetName and region:GetName() or tostring(region), string.format("|cFF%2X%2X%2X%f,%f,%f", r*255, g*255, b*255, r,g,b))
      if g < 1 then
        g = g + 0.25
      elseif r > 0 then
        r = r - 0.25
      elseif b < 1 then
        b = b + .25
      end
    end
    ]]

  end

  for region, data in pairs(GlobalRegions) do
    print(region, data)
    if data.hidden then
      region:SetShown(false)
    else

      if data.w then
        print('width =', data.w)
        region:SetWidth(data.w)
      end
      if data.h then
        print('height =', data.h)
        region:SetHeight(data.h)
      end
      if data.color then
        print('color =', unpack(data.color))
        region:SetColorTexture(unpack(data.color))
      end

      if #data >= 1 then
        region:ClearAllPoints()
        for i, point in ipairs(data) do
          print(i)
          if type(point) == 'table' then
            print('point +=', unpack(point))
            region:SetPoint(point[1], point[5] or region:GetParent(), point[2], point[3], point[4])
          end
        end
      end
    end

  end

end
