
local _, db = ...
local print = DEVIAN_WORKSPACE and function(...) _G.print('Map', ...) end or function() end


WorldPlanMapMixin = {}
local Map = WorldPlanMapMixin
local wmf = WorldMapFrame

local ArgusPins = {}

function Map:OnLoad()

  tinsert(db.modules, self)
  --hooksecurefunc("WorldMap_SetupWorldQuestButton", function(taskPOI, ...)
  --  self:OnSetupWorldQuestButton(taskPOI, ...)
  --end)

  --WorldMapFrame:UnregisterAllEvents()


  hooksecurefunc("WorldMap_QuantizeWorldQuestPOIs", function(...)
    self:OnWorldMap_QuantizeWorldQuestPOIs(...)
  end)

  hooksecurefunc("WorldMapPOIFrame_AnchorPOI", function(taskPOI, ...)
    self:OnWorldMapPOIFrame_AnchorPOI(taskPOI, ...)
  end)

  hooksecurefunc("WorldMapFrame_Update", function()
    self:OnWorldMapPOIFrame_Update()
  end)
end

function Map:OnWorldMapPOIFrame_Update()



  local map = GetCurrentMapAreaID()
  _G.print('WQRefresh', '|cFF88FF00WorldMapFrame_Update()|r', map)
  if map == 1007 then
    _G.print('WQRefresh', 'is a continent map')
    self:Update('WorldMapFrame_Update')
  end

end

function Map:OnWorldMap_QuantizeWorldQuestPOIs(pois)
  --_G.print('WQRefresh', '|cFF88FF00WorldMap_QuantizeWorldQuestPOIs()|r')
  for k, worldQuestPOI in pairs(pois) do
    --print(worldQuestPOI.questID, worldQuestPOI:GetPoint(1))
    WorldMapPOIFrame_AnchorPOI(worldQuestPOI, worldQuestPOI.quantizedX or worldQuestPOI.x, worldQuestPOI.quantizedY or worldQuestPOI.y, WORLD_MAP_POI_FRAME_LEVEL_OFFSETS.WORLD_QUEST);
  end
end
function Map:OnWorldMapPOIFrame_AnchorPOI(taskPOI, x, y, level)
  --_G.print('WQRefresh','|cFF88FF00OnWorldMapPOIFrame_AnchorPOI()|r', taskPOI:GetName())
  taskPOI.lastAnchor = time()
end

function Map:OnSetupWorldQuestButton(taskPOI, ...)

  _G.print('WQRefresh','SetupWorldQuestButton()', taskPOI.questID)
end


local usedPOI = {}
function Map:Update(source)
  local existingPOI = db.pins.id
  print('|cFF00FFFF' .. (source or '?'), '->Refresh()', NUM_WORLDMAP_TASK_POIS)
  wipe(usedPOI)
  for index = 1, 100  do

    local poi =  _G["WorldMapFrameTaskPOI"..index];
    if poi and poi.worldQuest and poi.questID then
      print(index, 'used by #', poi.questID)
      existingPOI[poi.questID] = poi
    end
  end
  local poiIndex = NUM_WORLDMAP_TASK_POIS
  local quests = db.pins.current
  for questID, info in pairs(quests) do

    local msg = 'Q #' .. questID .. ' ' .. (existingPOI[questID] and '(!)' or '-')
    --print(questID, info.x, info.y)

    --for k,v in pairs(info) do
    --  print(questID .. '.' .. tostring(k), '=', v)
    --end

    --local taskPOI = existingPOI[questID]
    --if not taskPOI or ( taskPOI.questID ~= questID) then


    local taskPOI
    if existingPOI[questID] then

      taskPOI = existingPOI[questID]
      msg = msg .. '\n  there is a POI for this quest, re-using ' .. taskPOI:GetName()
    else
      msg = msg .. 'no poi found... create one'
      poiIndex = poiIndex + 1
      taskPOI = WorldMap_GetOrCreateTaskPOI(poiIndex);

      local tagID, tagName, worldQuestType, rarity, isElite, tradeskillLineIndex, displayTimeLeft = GetQuestTagInfo(info.questId);

      taskPOI.name = tagName

      local selected = info.questId == GetSuperTrackedQuestID();

      local isCriteria = WorldMapFrame.UIElementsFrame.BountyBoard:IsWorldQuestCriteriaForSelectedBounty(info.questId);
      local isSpellTarget = SpellCanTargetQuest() and IsQuestIDValidSpellTarget(info.questId);
      local isEffectivelyTracked = WorldMap_IsWorldQuestEffectivelyTracked(info.questId);

      taskPOI.worldQuest = true;

      taskPOI.questID = questID
      taskPOI.Texture:SetDrawLayer("OVERLAY");

      WorldMap_SetupWorldQuestButton(taskPOI, worldQuestType, rarity, isElite, tradeskillLineIndex, info.inProgress, selected, isCriteria, isSpellTarget, isEffectivelyTracked);

      C_TaskQuest.RequestPreloadRewardData(info.questId);

    end

    if taskPOI then
      msg = msg .. "\n  taskPOI established/"
    end

      --[[
      taskPOI = WorldMap_TryCreatingWorldQuestPOI(info, poiIndex)
      print(WorldMap_IsWorldQuestSuppressed(info.questId), not WorldMap_DoesWorldQuestInfoPassFilters(info))
      existingPOI[questID] = taskPOI
      if not taskPOI then
        print('|cFFFF4400unable to create for|r', questID)
      else
        --print(taskPOI, 'created',poiIndex)
      end
      --]]



    --else

      --print(taskPOI, 're-used')
    --end
    if taskPOI then


      msg = msg .. '\n  POS '..tostring(taskPOI:GetName())..' |cFF00FF00x/y:|r ' .. tostring(info.x) ..' '..tostring(info.y)
        taskPOI.x = info.x;
        taskPOI.y = info.y;
        taskPOI.quantizedX = nil;
        taskPOI.quantizedY = nil;
        taskPOI.questID = info.questId;
        taskPOI.numObjectives = info.numObjectives;
        taskPOI:Show();

        usedPOI[questID] = taskPOI
    end
    print(msg)

  end

  for questID, poi in pairs(existingPOI) do
    if not usedPOI[questID] then
      print('|cFFFF4400remove un-updated:', poi:GetName())
      poi:Hide()
    end

  end



  WorldMapFrame.UIElementsFrame.ActionButton:SetHasWorldQuests(#usedPOI > 0);
  WorldMap_QuantizeWorldQuestPOIs(usedPOI)

  _G.print('WQRefresh', time())
end
