local _, db = ...
local print = DEVIAN_WORKSPACE and function(...) _G.print('Canvas', ...) end or function() end
local wprint = DEVIAN_WORKSPACE and function(...) _G.print('WP', ...) end or function() end
local wipe, pairs, ipairs = wipe, pairs, ipairs
local HaveQuestData, QuestUtils_IsQuestWorldQuest, C_MapCanvas, C_TaskQuest = HaveQuestData, QuestUtils_IsQuestWorldQuest, C_MapCanvas, C_TaskQuest

WorldPlanFlightMapHandler = {
  TaskQueue = {}
}
WorldPlanDataProvider = {}
WorldPlanDataPinMixin = {}

function WorldPlanFlightMapHandler:OnLoad()
  print('MapCanvas Module')
  self:RegisterEvent('ADDON_LOADED')
end
function WorldPlanFlightMapHandler:OnEvent(event, arg)
  if arg == "Blizzard_FlightMap" then
    print('sending data provider')
    local dataProvider = Mixin(MapCanvasDataProviderMixin, WorldPlanDataProvider)
    WorldPlanDataPinMixin = Mixin(MapCanvasPinMixin, WorldPlanDataPinMixin)
    WorldPlanDataPinMixin.OnNext = function(...) self:OnNext(...) end
    FlightMapFrame:AddDataProvider(dataProvider)
  end
end

function WorldPlanFlightMapHandler:OnNext(func)
  tinsert(self.TaskQueue, func)
end

function WorldPlanFlightMapHandler:OnUpdate()
  if #self.TaskQueue >= 1 then
    print('firing scheduled task ('.. tostring(#self.TaskQueue) ..' remaining)')
    local func = tremove(self.TaskQueue, 1)
    func()
  end
end

function WorldPlanDataProvider:OnLoad()

  self:SetNudgeTargetFactor(0.015);
  self:SetNudgeZoomedOutFactor(0.5);
  self:SetNudgeZoomedInFactor(0.15);
end

function WorldPlanDataProvider:OnShow()
  assert(self.ticker == nil);
  self.ticker = C_Timer.NewTicker(10, function() self:RefreshAllData() end);
end
function WorldPlanDataProvider:OnHide()
  self.ticker:Cancel();
  self.ticker = nil;
end


function WorldPlanDataProvider:OnAdded(mapCanvas)
  self.activePins = {};
  self.owningMap = mapCanvas
  self:RegisterEvent('QUEST_LOG_UPDATE')

  -- get rid of blizzard's widgery-joob
  for frame in pairs(FlightMapFrame.dataProviders) do
    if frame.OnAdded == WorldQuestDataProviderMixin.OnAdded then
      FlightMapFrame:RemoveDataProvider(frame)
      break
    end
  end
end


function WorldPlanDataProvider:RefreshAllData()
  local print = print
  print('|cFFFF0088'..self.owningMap:GetName()..':RefreshAllData()|r')
  db.PinStrata = 'HIGH'

  local pinsToRemove = {};
  for questId in pairs(self.activePins) do
    pinsToRemove[questId] = true;
  end
  print(unpack(db.Config.FlightMapAlphaLimits))
  local alpha1, alpha2, alpha3 = unpack(db.Config.FlightMapAlphaLimits)
  local scale1, scale2, scale3 = unpack(db.Config.FlightMapScalingLimits)

  local mapAreaID = self:GetMap():GetMapID();
  print(mapAreaID)
  WorldPlanQuests.isStale = true
  for zoneIndex = 1, C_MapCanvas.GetNumZones(mapAreaID) do
    local zoneMapID, zoneName, zoneDepth, left, right, top, bottom = C_MapCanvas.GetZoneInfo(mapAreaID, zoneIndex);
    print(zoneMapID, zoneName, self:GetTransformFlags())
    if zoneDepth <= 1 then -- Exclude subzones
    local taskInfo = C_TaskQuest.GetQuestsForPlayerByMapID(zoneMapID, mapAreaID, self:GetTransformFlags());

    if taskInfo then
      for i, info in ipairs(taskInfo) do
        if HaveQuestData(info.questId) then
          if QuestUtils_IsQuestWorldQuest(info.questId) then
            local pin = WorldPlanQuests:AcquirePin(info, zoneMapID)
            if pin then

              --print(pin:GetID(), pin.used, pin.filtered)

              if pin.canShow then
                pinsToRemove[info.questId] = nil;

                pin.used = true
                local frame = self.activePins[info.questId]
                if not frame then
                  frame = self:GetMap():AcquirePin("WorldPlanFlightPin")
                  frame:SetAlphaLimits(alpha1, alpha2, alpha3)
                  frame:SetScalingLimits(scale1, scale2, scale3);
                  frame:SetFrameLevel(1000 + self:GetMap():GetNumActivePinsByTemplate("WorldPlanFlightPin"));
                  frame:Show()
                  self.activePins[info.questId] = frame
                end
                frame:SetPosition(info.x, info.y)
                frame.pin = pin

                -- fix the scale
                pin.owningFrame = frame:GetMap()
                pin:SetAnchor(frame, nil, nil, nil, nil, 1)
                pin.throttle = 1
                pin:ClearAllPoints()
                pin:SetPoint('CENTER', frame, 'CENTER')
                pin:SetShown(true)
                frame:SetSize(pin:GetSize())
                --print(pin.Overlay:IsShown(), pin.Overlay:GetPoint(1))
              end
            end

          end
        end
      end
    end
    end
  end

  for questId in pairs(pinsToRemove) do
    self:GetMap():RemovePin(self.activePins[questId]);
    self.activePins[questId] = nil;
  end
  --self:GetMap():RemoveAllPinsByTemplate("WorldQuestPinTemplate");
  for pin in self:GetMap():EnumeratePinsByTemplate("WorldQuestPinTemplate") do
    pin:Hide()
  end

end



function WorldPlanDataProvider:OnEvent()
end

function WorldPlanDataPinMixin:OnLoad()
  self.UpdateTooltip = self.OnMouseEnter;

  -- Flight points can nudge world quests.
  self:SetNudgeTargetFactor(0.015);
  self:SetNudgeZoomedOutFactor(1.0);
  self:SetNudgeZoomedInFactor(0.25);
end

function WorldPlanDataPinMixin:OnUpdate()
  local pin = self.pin
  if pin and pin.isStale then
    -- print(pin.questID, 'is stale')
    -- no longer needed
    -- pin:SetAnchor(nil, nil, nil, nil, nil, pin.filtered and 0.5 or 1)
    if pin.isNew then
      pin:OnShow()
    end
  end
end


function WorldPlanDataPinMixin:OnShow()
end

function WorldPlanDataPinMixin:OnMouseEnter ()
  WorldMap_HijackTooltip(self:GetMap())
end

function WorldPlanDataPinMixin:OnMouseLeave ()
  WorldMap_RestoreTooltip()
  WorldMapTooltip:Hide()
end

function WorldPlanDataPinMixin:RemoveAllData()
  wipe(self.activePins);
  self:GetMap():RemoveAllPinsByTemplate("WorldPlanFlightPin");
end
