local _, db= ...
local ORDERHALL_TYPE = LE_GARRISON_TYPE_7_0
local UnitClass = UnitClass
local time, max, min = time, max, min
local print = DEVIAN_WORKSPACE and function(...) print('ClassPlan', ...) end or nop
local GetPrimaryGarrisonFollowerType = GetPrimaryGarrisonFollowerType
local C_Garrison = C_Garrison

local wipe, tinsert, date, ipairs = table.wipe, table.insert, date, ipairs
local GetItemIcon = GetItemIcon


local MissionList = {
  templateName = 'ClassPlanMissionEntry',
  listKey = {'missions', 'available'},
  listTitle = {'In Progress', 'Available'},

  point = 'TOPLEFT',
  relativePoint ='TOPLEFT',
  events = {
    'GARRISON_MISSION_LIST_UPDATE'},
}
local ListEntry = {}

function MissionList:Reanchor()
  self:SetPoint('TOPRIGHT', ClassOrderPlan.BackgroundInset, 'TOPRIGHT', 0, 0)
  self:SetPoint('BOTTOMLEFT', ClassOrderPlan:GetWidth()/2, 0)
end




function MissionList:GetPlayerData ()
  local profile = self:GetParent().profile
  local items = C_Garrison.GetAvailableMissions(GetPrimaryGarrisonFollowerType(ORDERHALL_TYPE));
  if not items then
    return
  end
  wipe(profile.missions)
  wipe(profile.available)


  for _, data in ipairs(items) do

    --print(' -',data.name, '|cFF00FF00'.. data.offerEndTime .. '|r', date("%A %I:%m %p", data.offerEndTime))
    if data.offerEndTime then
      data.offerEndTime = time() + (data.offerEndTime - GetTime())
    end
    tinsert(profile.available, data)

  end

  local items = C_Garrison.GetLandingPageItems(ORDERHALL_TYPE)
  for index, data in ipairs(items) do
    print(' -',data.name, '|cFF00FF00'.. data.timeLeft .. '|r', date("%A %I:%m %p", data.missionEndTime))
    tinsert(profile.missions, data)
  end
  return true
end

function MissionList:OnGetItem (data)
  if data.missionEndTime then
    if (data.missionEndTime < self.currentTime) then
      data.isComplete = true
    else
      self:ScheduleUpdate(data.missionEndTime)
    end
  end

  if data.offerEndTime then
    if (data.offerEndTime < self.currentTime) then
      data.isExpired = true
      data.timeToKeep = self.currentTime + 300
    else
      self:ScheduleUpdate(data.offerEndTime)
    end
  end

end

MissionList.SortHandler = function (a,b)
  local result = false
  if b.isComplete ~= a.isComplete then
    return a.isComplete
  else
    if b.isMine ~= a.isMine then
      return a.isMine
    else
      if a.isComplete then
        if a.profileKey ~= b.profileKey then
          return (a.profileKey < b.profileKey)
        else
          return (a.name < b.name)
        end
      else
        if b.missionEndTime then
          return ( b.missionEndTime > a.missionEndTime)
        else
          return ((b.offerEndTime or 0) > (a.offerEndTime or 0))
        end
      end
    end
  end
end

function MissionList:OnEvent(event, ...)
  self:RefreshData()
  if event == 'GARRISON_MISSION_FINISHED' then
    local followerTypeID, missionID = ...;
  elseif event == 'GARRISON_TALENT_COMPLETE' then
    local garrisonType = ...;
    elseif event == '' then
  end

end

function MissionList:OnShow()
  print('|cFF00FF88'..self:GetName()..':OnShow()|r')
end

function ListEntry:OnComplete()
  print('flagging complete', self.name)
  self:Update()
end

function ListEntry:OnUpdate(sinceLast)
  if self.doAnimation then
    self.doAnimation = nil
    self.NewBlockFade:Play()
  end
  self.throttle = (self.throttle or .5) + sinceLast
  if self.throttle < .5 then
    return
  else
    self.throttle = self.throttle - .5
  end

  if self.offerEndTime then
    self:SetTimeLeft(self.offerEndTime)
  elseif self.missionEndTime then
    self:SetTimeLeft(self.missionEndTime, self.durationSeconds)
  end
end

function ListEntry:OnHide(...)
  print(self:GetName().. ':Hide()', ...)
end

function ListEntry:OnLoad()
  print('|cFFFF4400'..self:GetName()..':OnLoad()')
  self.Count = self.Overlay.Count
  self.Name = self.Overlay.Name
  self.TimeLeft = self.Overlay.TimeLeft
  self.Owner = self.Overlay.Owner
  self.maxDisplayed = 10

  self.Icon:SetDesaturated(false)
  self.Done:Hide()
  --[[
  hooksecurefunc(self.Background, 'SetColorTexture', function(self, ...)
    print(self:GetName(), ...)
  end)
  hooksecurefunc(self.Background, 'SetTexture', function(self, ...)
    --print(self:GetName(), ...)
  end)
  --]]
end

function ListEntry:Update()
  local r,g,b = 1, 1, 1
  if self.isRare then
    r,g,b = 0.1, 0.4, 1
    self.IconBorder:SetVertexColor(r, g, b, 1)
  end

  --self.missionData = data
  self.Name:SetText(self.name)
  if #self.rewards >= 1 then
    self.Icon:SetTexture(self.rewards[1].icon or GetItemIcon(self.rewards[1].itemID))
    self.rewardInfo = self.rewards[1]
  else
    self.Icon:SetAtlas(self.typeAtlas, false)
  end

  local itemType = db.ClassPlanTypes.inProgress
  if self.isComplete then
    itemType = db.ClassPlanTypes.complete
  end

  self.Background:SetColorTexture(unpack(itemType.backgroundColor))
end

function ListEntry:OnEnter()
  WorldMap_HijackTooltip(self)
  if self.rewardInfo and self.rewardInfo.itemID then
    WorldMapTooltip:SetOwner(self, 'ANCHOR_LEFT')
    WorldMapTooltip:AddLine(self.name)
    EmbeddedItemTooltip_SetItemByID(WorldMapTooltip.ItemTooltip, self.rewardInfo.itemID)
    WorldMapTooltip:Show()
  end
end

function ListEntry:OnLeave()
  WorldMap_RestoreTooltip()
  if WorldMapTooltip:IsOwned(self) then
    WorldMapTooltip:Hide()
  end
end


ClassPlanMissionHandler = CreateFromMixins(ClassPlanHandlerBase, MissionList)
ClassPlanMissionEntryMixin = CreateFromMixins(ClassPlanEntryBase, ListEntry)
