
local print = DEVIAN_WORKSPACE and function(...) print('ClassPlanF', ...) end or nop
local c  = {

  templateName = 'ClassPlanFollowerEntry',
  listKey = {'followers','troops'},
  listTitle = {'Followers', 'Troops'},
  events = {
    'GARRISON_FOLLOWER_LIST_UPDATE',
    'GARRISON_FOLLOWER_XP_CHANGED',
    'GARRISON_FOLLOWER_DURABILITY_CHANGED',
    'GARRISON_FOLLOWER_UPGRADED',
    'GARRISON_FOLLOWER_REMOVED'
  }
}


function c:OnLoad()
  print('Followers:OnLoad()')
  self.followerType = 4
  -- follower type, versus garrison_type
end

function c:OnEvent(event, ...)
  print('|cFF00FF00'..self:GetName()..':OnEvent()|r', event, ...)
  self:GetPlayerData()
end

function c:GetPlayerData()

  print('|cFF0088FF'..self:GetName()..':GetPlayerData()|r', self.followerType, time())
  local profile = self:GetParent().profile

  local followerInfo = C_Garrison.GetFollowers(self.followerType)



  if followerInfo then
    table.wipe(profile.followers)
    table.wipe(profile.troops)
    for followerID, follower in pairs(followerInfo) do
      print(FOLLOWER_QUALITY_COLORS[follower.quality].hex, follower.name, follower.isTroop)
      if follower.isTroop then
        print('added troop')
        profile.troops[followerID] = follower
      else
        print(follower.isMaxLevel, follower.xp, follower.levelXP, follower.iLevel)

        profile.followers[followerID] = follower
      end


      --profileList[followerID] = follower
    end
  end

  return true
end

function c:UpdateTroops (followers, baseIndex)
  baseIndex = baseIndex or 1
  for followerID, follower in pairs(followers) do
    --local frame = self.
  end


  return baseIndex
end

function c:OnUpdateRequested ()
  print('OnUpdateRequested()')
end

function c:OnItemsUpdated()
  print('OnItemsUpdated()')
  return nil
end

function c:RefreshData()

  print('|cFF0088FF'..self:GetName()..':RefreshData()')
  local activeKey = self.activeKey
  self.truncatedItems = 0
  self.currentTime = time()
  if self:GetParent().profile then
    self:GetPlayerData()
  end
  local profile = self.profile
  for _, listKey in ipairs(self.listKey) do
    local sortedItems = self.sortedItems[listKey]
    wipe(sortedItems)
      local isMine = (profile == self.profile)
      print(listKey, isMine, profile.showItems)
      local profileList = self.profile[listKey]
      if profileList and #profileList >= 1 then
        local classColor = profile.classColor or RAID_CLASS_COLORS['HUNTER']
        if profile.showItems then
          for index, data in ipairs(profileList) do
            data.classColor = classColor
            data.profileKey = ClassOrderPlan.profileName
            data.isMine = isMine
            if self.OnGetItem then
              self:OnGetItem(data)
            end
            tinsert(sortedItems, data)
          end
        else
          self.truncatedItems = self.truncatedItems + 1
        end
      end

    if self.SortHandler then
      sort(sortedItems, self.SortHandler)
    end
  end

  for k,v in pairs(self.sortedItems) do
    print('  ', k)
  end

  self.isStale = true
end

--[[
-- function c:UpdateItems()

  local profileList = self:GetParent().profile.followers

  local troopList = self:GetParent().profile.troops

  print('UpdateItems()  ')


end
--]]
function c:Reanchor()
  self:SetPoint('TOPLEFT', ClassOrderPlan.BackgroundInset, 'BOTTOMLEFT')
  self:SetPoint('RIGHT', ClassOrderPlan.BackgroundInset, 'RIGHT')
end

local f = {}
function f:Update()
  self.Icon:SetTexture()
end
function f:OnLoad()
  self.Owner = self.Overlay.Owner

  self.Count = self.Overlay.Count
  self.Name = self.Overlay.Name
end

function f.SortHandler (a, b)
  return true
end

ClassPlanFollowersHandler = CreateFromMixins(ClassPlanHandlerBase, c)
ClassPlanFollowerEntryMixin = CreateFromMixins(ClassPlanEntryBase, f)
