-- $Id: Core.lua 14 2017-06-30 08:05:19Z arith $
-----------------------------------------------------------------------
-- Upvalued Lua API.
-----------------------------------------------------------------------
-- Functions
local _G = getfenv(0)
local select = _G.select
-- Libraries
-- ----------------------------------------------------------------------------
-- AddOn namespace.
-- ----------------------------------------------------------------------------
local FOLDER_NAME, private = ...

local LibStub = _G.LibStub
local L = LibStub("AceLocale-3.0"):GetLocale(private.addon_name)
local AceDB = LibStub("AceDB-3.0")

local addon = LibStub("AceAddon-3.0"):NewAddon(private.addon_name, "AceEvent-3.0", "AceHook-3.0")
addon.constants = private.constants
addon.constants.addon_name = private.addon_name
addon.Name = FOLDER_NAME
addon.LocName = select(2, GetAddOnInfo(addon.Name))
addon.Notes = select(3, GetAddOnInfo(addon.Name))
_G.WorldMapTunable = addon
local profile
local wmFrame
local isInLockdown = false

-- //////////////////////////////////////////////////////////////////////////
-- Opacity
local function updateOpacity(opacity)
	profile.opacity = opacity or OpacityFrameSlider:GetValue()
	if (profile.opacity > 0.8) then profile.opacity = 0.8 end
	local alpha = 1.0 - profile.opacity
	WorldMapFrame:SetAlpha(alpha)
end

local function showOpacity()
	OpacityFrame:ClearAllPoints()
	local anchor = WorldMapFrame:GetPoint()
	if (anchor == "LEFT" or anchor == "TOPLEFT" or anchor == "BOTTOMLEFT") then
		OpacityFrame:SetPoint("TOPLEFT", "WorldMapFrame", "TOPRIGHT", 0, -50)
	else
		OpacityFrame:SetPoint("TOPRIGHT", "WorldMapFrame", "TOPLEFT", 0, -50)
	end
	OpacityFrame.opacityFunc = updateOpacity
	OpacityFrame:Show()
	OpacityFrameSlider:SetValue(profile.opacity)
end

-- Scale
local function updateScale(scale)
	profile.scale = scale and 1 - scale or 1 - OpacityFrameSlider:GetValue()
	if (profile.scale < 0.2) then profile.scale = 0.2 end
	WorldMapFrame:SetScale(profile.scale)
end

local function showScale()
	OpacityFrame:ClearAllPoints()
	local anchor = WorldMapFrame:GetPoint()
	if (anchor == "LEFT" or anchor == "TOPLEFT" or anchor == "BOTTOMLEFT") then
		OpacityFrame:SetPoint("BOTTOMLEFT", "UIParent", "BOTTOMRIGHT", -200, 100)
	else
		OpacityFrame:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMLEFT", 100, 100)
	end
	
	OpacityFrame.opacityFunc = updateScale
	OpacityFrame:Show()
	OpacityFrameSlider:SetValue(1 - profile.scale)
	OpacityFrameSliderText:SetText(L["Scale"])
end

local function toggleLock()
	profile.locked = not profile.locked
	WORLDMAP_SETTINGS.locked = profile.locked
	if ( WORLDMAP_SETTINGS.locked ) then
		SetCVar("lockedWorldMap", 1);
	else
		SetCVar("lockedWorldMap", 0);
	end
end

local function toggleFade()
	profile.fade = not profile.fade
	if ( profile.fade ) then
		SetCVar("mapFade", 1);
	else
		SetCVar("mapFade", 0);
	end
end

local function WorldMapTunableWorldMapTitleDropDown_Initialize()
	local checked
	local info = L_UIDropDownMenu_CreateInfo()
	info.isNotRadio = true
	info.notCheckable = true
	-- Lock/Unlock
	info.func = toggleLock
	if ( WORLDMAP_SETTINGS.locked ) then
		info.text = UNLOCK_FRAME
	else
		info.text = LOCK_FRAME
	end
	L_UIDropDownMenu_AddButton(info)
	-- Reset
	info.func = WorldMapTitleDropDown_ResetPosition
	info.text = RESET_POSITION
	L_UIDropDownMenu_AddButton(info)
	-- Fadeout
	--info.isNotRadio = nil
	info.notCheckable = nil
	info.text = MAP_FADE_TEXT
	info.checked = profile.fade
	info.func = toggleFade
	L_UIDropDownMenu_AddButton(info)
	-- Opacity
	--info.isNotRadio = true
	info.notCheckable = true
	info.checked = nil
	info.text = CHANGE_OPACITY
	info.func = showOpacity
	L_UIDropDownMenu_AddButton(info)
	-- Scale
	info.text = L["Change Scale"]
	info.func = showScale
	if ( issecure() or isInLockdown) then
		info.disabled = true
	else
		info.disabled = nil
	end
	L_UIDropDownMenu_AddButton(info)
end

local function frame_OnShow(self)
	L_UIDropDownMenu_Initialize(WorldMapTunableWorldMapTitleDropDown, WorldMapTunableWorldMapTitleDropDown_Initialize, "MENU")
end

local function frame_OnClick(self, button)
	PlaySound(PlaySoundKitID and "UChatScrollButton" or 1115)

	-- If Rightclick bring up the options menu
	if ( button == "RightButton" ) then
		L_ToggleDropDownMenu(1, nil, addon.dropdown, "cursor", 0, 0)
		return
	end

	-- Close all dropdowns
	L_CloseDropDownMenus()
end

function frame_OnDragStart()
	if ( isInLockdown and profile.lockedInCombat ) then
		return
	end
	if ( not profile.locked ) then
		WorldMapScreenAnchor:ClearAllPoints();
		--WorldMapFrame:ClearAllPoints();
		WorldMapFrame:StartMoving();
	end
end

function frame_OnDragStop()
	if ( not profile.locked ) then
		WorldMapFrame:StopMovingOrSizing();
		WorldMapFrame_ResetPOIHitTranslations();
		-- move the anchor
		WorldMapScreenAnchor:StartMoving();
		WorldMapScreenAnchor:SetPoint("TOPLEFT", WorldMapFrame);
		WorldMapScreenAnchor:StopMovingOrSizing();
		local a, b, c, d, e = WorldMapFrame:GetPoint()
		profile.point = { a, b, c, d, e }
	end
end

local function createWorldMapTitleDropDown()
	local f = _G[addon.Name.."WorldMapTitleDropDown"]
	if not f then f = CreateFrame("Frame", addon.Name.."WorldMapTitleDropDown", WorldMapFrame, "L_UIDropDownMenuTemplate") end
	f:SetPoint("TOP", -80, -35)
	
	return f
end

local function createWorldMapTitleButton()
	local f = _G[addon.Name.."WorldMapTitleButton"]
	if not f then f = CreateFrame("Button", addon.Name.."WorldMapTitleButton") end
	f:SetWidth(0)
	f:SetHeight(22)
	f:SetParent(WorldMapFrame)
	f:SetPoint("TOPLEFT", 0, 0)
	f:SetPoint("TOPRIGHT", -46, 0)
	f:RegisterForClicks("LeftButtonDown", "LeftButtonUp", "RightButtonUp")
	f:RegisterForDrag("LeftButton")
	f:SetScript("OnShow", frame_OnShow)
	f:SetScript("OnClick", frame_OnClick)
	f:SetScript("OnDragStart", frame_OnDragStart)
	f:SetScript("OnDragStop", frame_OnDragStop)
	f:Show()
	
	return f
end

function addon:WorldMap_ToggleSizeDown()
	WorldMapTitleButton:Hide()
	addon.wmFrame:Show()
end

function addon:WorldMap_ToggleSizeUp()
	addon.wmFrame:Hide()
end

local function fOnShow()
	WorldMapFrame:SetAlpha(1 - profile.opacity)

	-- WorldMapFrame will become secure frame while in combat
	if ( issecure() or isInLockdown) then
	else
		WorldMapFrame:SetScale(profile.scale)
	end
end

local function fOnHide()
	if (OpacityFrame:IsShown()) then
		OpacityFrame:Hide()
	end
end

function addon:OnInitialize()
	self.db = AceDB:New(addon.Name.."DB", addon.constants.defaults, true)
	profile = self.db.profile

	self:SetupOptions()
	addon.dropdown = createWorldMapTitleDropDown()
	addon.wmFrame = createWorldMapTitleButton()
end

function addon:OnEnable()
	for key, value in pairs( addon.constants.events ) do
		self:RegisterEvent( value )
	end
	addon:SecureHook("WorldMap_ToggleSizeDown")
	addon:SecureHook("WorldMap_ToggleSizeUp")
	--addon:SecureHook("WorldMapTitleButton_OnDragStop")
	addon:SecureHookScript(WorldMapFrame, "OnShow", fOnShow)
	addon:SecureHookScript(WorldMapFrame, "OnHide", fOnHide)
	WorldMapTitleButton:Hide()

	if ( issecure() or isInLockdown) then
	else
		-- Set WorldMap's position
		local point, relativeTo, relativePoint, ofsx, ofsy = unpack(profile.point)
		WorldMapFrame:ClearAllPoints()
		WorldMapFrame:SetParent("UIParent")
		WorldMapFrame:SetPoint(point or "TOPLEFT", nil, relativePoint or "TOPLEFT", ofsx or 10, ofsy or 118)
		-- move the anchor
		WorldMapScreenAnchor:StartMoving();
		WorldMapScreenAnchor:SetPoint("TOPLEFT", WorldMapFrame);
		WorldMapScreenAnchor:StopMovingOrSizing();
	end
	
	self:Refresh()
end

function addon:Refresh()
	profile = self.db.profile

	WORLDMAP_SETTINGS.locked = profile.locked
	if ( WORLDMAP_SETTINGS.locked ) then
		SetCVar("lockedWorldMap", 1);
	else
		SetCVar("lockedWorldMap", 0);
	end
	if ( profile.fade ) then
		SetCVar("mapFade", 1);
	else
		SetCVar("mapFade", 0);
	end
	WorldMapFrame:SetAlpha(1 - profile.opacity)
	WorldMapFrame:SetScale(profile.scale)
end

function addon:CLOSE_WORLD_MAP()
end

function addon:PLAYER_REGEN_DISABLED()
	isInLockdown = true
end

function addon:PLAYER_REGEN_ENABLED()
	isInLockdown = false
end
