-- $Id: Config.lua 11 2017-06-05 13:34:45Z arith $
-----------------------------------------------------------------------
-- Upvalued Lua API.
-----------------------------------------------------------------------
-- Functions
local _G = getfenv(0)
local pairs = _G.pairs
-- Libraries
-- ----------------------------------------------------------------------------
-- AddOn namespace.
-- ----------------------------------------------------------------------------
local FOLDER_NAME, private = ...
local LibStub = _G.LibStub;
local addon = LibStub("AceAddon-3.0"):GetAddon(private.addon_name)
local L = LibStub("AceLocale-3.0"):GetLocale(private.addon_name);

local AceConfigReg = LibStub("AceConfigRegistry-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")
local AceDBOptions = LibStub("AceDBOptions-3.0")

local optGetter, optSetter
do
	function optGetter(info)
		local key = info[#info]
		return addon.db.profile[key]
	end

	function optSetter(info, value)
		local key = info[#info]
		addon.db.profile[key] = value
		addon:Refresh()
	end
end

local options, moduleOptions = nil, {}

local function getOptions()
	if not options then
		options = {
			type = "group",
			name = addon.LocName,
			args = {
				general = {
					order = 1,
					type = "group",
					name = L["Options"],
					get = optGetter,
					set = optSetter,
					args = {
						description = {
							order = 1,
							type = "description",
							name = addon.Notes,
						},
						spacer1 = {
							order = 10,
							type = "description",
							name = "\n",
						},
						locked = {
							order = 11,
							type = "toggle",
							name = L["Locked"],
							desc = L["Lock WorldMap Window."],
						},
						lockedInCombat = {
							order = 11.1,
							type = "toggle",
							name = L["Locked in Combat"],
							desc = L["Lock WorldMap Window while in combat."],
							disabled = function() return addon.db.profile.locked end,
						},
						fade = {
							order = 12,
							type = "toggle",
							name = L["Fade out"],
							desc = MAP_FADE_TEXT,
						},
						reset = { 
							order = 13,
							type = "execute",
							name = RESET_POSITION,
							desc = L["Reset WorldMap window's position"],
							func = WorldMapTitleDropDown_ResetPosition,
						},
						spacer2 = {
							order = 20,
							type = "description",
							name = "\n",
						},
						scale = {
							order = 21,
							type = "range",
							name = L["Scale"],
							desc = L["Change WorldMap window's scale."],
							min = 0.2, max = 1, bigStep = 0.01, 
						},
						opacity = {
							order = 22,
							type = "range",
							name = OPACITY,
							desc = L["Change WorldMap window's opacity."],
							min = 0, max = 0.8, bigStep = 0.01, 
						}
					},
				},
			},
		}
		for k,v in pairs(moduleOptions) do
			options.args[k] = (type(v) == "function") and v() or v
		end
	end
	
	return options
end

local function openOptions()
	-- open the profiles tab before, so the menu expands
	InterfaceOptionsFrame_OpenToCategory(addon.optionsFrames.Profiles)
	InterfaceOptionsFrame_OpenToCategory(addon.optionsFrames.Profiles) -- yes, run twice to force the tre get expanded
	InterfaceOptionsFrame_OpenToCategory(addon.optionsFrames.General)
	InterfaceOptionsFrame:Raise()
end

function addon:OpenOptions() 
	openOptions()
end

local function giveProfiles()
	return AceDBOptions:GetOptionsTable(addon.db)
end

function addon:SetupOptions()
	self.optionsFrames = {}

	-- setup options table
	AceConfigReg:RegisterOptionsTable(addon.LocName, getOptions)
	self.optionsFrames.General = AceConfigDialog:AddToBlizOptions(addon.LocName, nil, nil, "general")

	self:RegisterModuleOptions("Profiles", giveProfiles, L["Profile Options"])
end

-- Description: Function which extends our options table in a modular way
-- Expected result: add a new modular options table to the modularOptions upvalue as well as the Blizzard config
-- Input:
--		name			: index of the options table in our main options table
--		optionsTable	: the sub-table to insert
--		displayName	: the name to display in the config interface for this set of options
-- Output: None.
function addon:RegisterModuleOptions(name, optionTbl, displayName)
	moduleOptions[name] = optionTbl
	self.optionsFrames[name] = AceConfigDialog:AddToBlizOptions(addon.LocName, displayName, addon.LocName, name)
end
