local menuOpen
local function IsMenuOpen()
   if menuOpen == nil then
      menuOpen = false
   end
   return menuOpen
end

local function MenuOpen(open)
   menuOpen = open
end

Prototype_Menu =
{
   OnLoad = nil,
}

function Prototype_Menu:NewContextMenu(name, o)
   o = o or {}
   setmetatable(o, self)
   self.menu = CreateFrame("Frame", name, UIParent, "L_UIDropDownMenuTemplate")
   self.__index = self

   L_UIDropDownMenu_Initialize(o.menu, o.OnLoad, "MENU", 1)

   return o
end

function Prototype_Menu:NewDropDownMenu(name, parent, o)
   o = o or {}
   setmetatable(o, self)
   self.menu = CreateFrame("Frame", name, parent, "L_UIDropDownMenuTemplate")
   self.__index = self

   L_UIDropDownMenu_Initialize(o.menu, o.OnLoad)

   return o
end

function Prototype_Menu:AddOption(text, level, func)
   info = {}
   info.text = text
   info.notCheckable = 1
   info.func = func
   L_UIDropDownMenu_AddButton(info, level)
end

function Prototype_Menu:AddDescriptor(text, level, isTitle)
   info = {}
   info.text = text
   if isTitle then
      info.isTitle = true
   else
      info.notClickable = 1
   end
   info.notCheckable = 1
   L_UIDropDownMenu_AddButton(info, level)
end

function Prototype_Menu:AddRadioOption(text, checkFunc, level, func)
   info = {}
   info.text = text
   info.checked = checkFunc
   info.func = func
   info.keepShownOnClick = true
   L_UIDropDownMenu_AddButton(info, level)
end

function Prototype_Menu:AddCheckOption(text, checkFunc, level, func)
   info = {}
   info.text = text
   info.checked = checkFunc
   info.func = func
   info.keepShownOnClick = true
   info.isNotRadio = true
   L_UIDropDownMenu_AddButton(info, level)
end

function Prototype_Menu:AddMenu(text, level, menuList)
   info = {}
   info.text = text
   info.menuList = menuList
   info.hasArrow = true
   info.notCheckable = 1

   L_UIDropDownMenu_AddButton(info, level)
end

function Prototype_Menu:ToggleMenu(anchor)
   MenuOpen(not IsMenuOpen())
   L_ToggleDropDownMenu(1, nil, self.menu, anchor, 0, 0)
end

function Prototype_Menu:OpenMenu(anchor)
   if IsMenuOpen() then
      return
   end

   self:ToggleMenu(anchor)
end

function Prototype_Menu:CloseMenu()
   if not IsMenuOpen() then
      return
   end

   self:ToggleMenu()
end

function Prototype_Menu:Refresh()
   L_UIDropDownMenu_RefreshAll(self.menu, nil)
end

function Prototype_Menu:IsMenuOpen()
   return menuOpen
end

function Prototype_Menu:SetWidth(w)
   L_UIDropDownMenu_SetWidth(self.menu, w)
end

function Prototype_Menu:SetText(text)
   L_UIDropDownMenu_SetText(self.menu, text)
end

function Prototype_Menu:SetPoint(point, relativeFrame, relativePoint, ofsx, ofsy)
   if ofsx and ofsy then
      self.menu:SetPoint(point, relativeFrame, relativePoint, ofsx, ofsy)
   elseif relativePoint then
      self.menu:SetPoint(point, relativeFrame, relativePoint)
   else
      self.menu:SetPoint(point)
   end
end
------------------------------------------------------------------------------------------------------
-- Hooks
------------------------------------------------------------------------------------------------------
-- This is needed to update my counter when a dropdown hides.  Without this, MenuOpen becomes outdated
-- when a menu times out and auto-hides.
local onHide = L_UIDropDownMenu_OnHide
function L_UIDropDownMenu_OnHide(self)
   if self:GetID() == 1 and self.dropdown == Prototype_Menu.menu then
      MenuOpen(false)
   end
   onHide(self)
end
