local _, addon = ...
local util = addon.utility

local _G = _G

local ClassColors = {}
ClassColors["DEATHKNIGHT"] = 0xC41F3B
ClassColors["DEMONHUNTER"] = 0xA330C9
ClassColors["DRUID"]       = 0xFF7D0A
ClassColors["HUNTER"]      = 0xABD473
ClassColors["MAGE"]        = 0x69CCF0
ClassColors["MONK"]        = 0x00FF96
ClassColors["PALADIN"]     = 0xF58CBA
ClassColors["PRIEST"]      = 0xFFFFFF
ClassColors["ROGUE"]       = 0xFFF569
ClassColors["SHAMAN"]      = 0x0070DE
ClassColors["WARLOCK"]     = 0x9482C9
ClassColors["WARRIOR"]     = 0xC79C6E
ClassColors["EMPHASIS"]    = 0x00C800

local SECOND = 1
local MINUTE = 60 * SECOND
local HOUR = 60 * MINUTE
local DAY = 24 * HOUR
local WEEK = 7 * DAY

local GoldIcon    = "|TInterface\\MoneyFrame\\UI-GoldIcon:12:12|t"
local SilverIcon  = "|TInterface\\MoneyFrame\\UI-SilverIcon:12:12|t"
local CopperIcon  = "|TInterface\\MoneyFrame\\UI-CopperIcon:12:12|t"

local LDBinteraction = false

local SexyCompatDefault = true

local DefaultFont = "Friz"
local DefaultFontSize = 12

local DaysToAdvance = 0

local realm = GetRealmName()

function util.AdvanceDays(days)
   DaysToAdvance = DaysToAdvance + days
end

function util.GetDaysToAdvance()
   return DaysToAdvance
end

function util.ResetDays()
   DaysToAdvance = 0
end

function util.UpdateEarnedSpent(cash, pcash)
   if pcash ~= nil then
      if cash >= pcash then
         local earned = cash - pcash
         _G.WOWMMGlobal[realm].AllTime.Earned = _G.WOWMMGlobal[realm].AllTime.Earned + earned
         _G.WOWMMGlobal[realm].Year.Earned = _G.WOWMMGlobal[realm].Year.Earned + earned
         _G.WOWMMGlobal[realm].Month.Earned = _G.WOWMMGlobal[realm].Month.Earned + earned
         _G.WOWMMGlobal[realm].Week.Earned = _G.WOWMMGlobal[realm].Week.Earned + earned
         _G.WOWMMGlobal[realm].Day.Earned = _G.WOWMMGlobal[realm].Day.Earned + earned
         _G.WOWMMGlobal[realm].Session.Earned = _G.WOWMMGlobal[realm].Session.Earned + earned
      else
         local spent = pcash - cash
         _G.WOWMMGlobal[realm].AllTime.Spent = _G.WOWMMGlobal[realm].AllTime.Spent + spent
         _G.WOWMMGlobal[realm].Year.Spent = _G.WOWMMGlobal[realm].Year.Spent + spent
         _G.WOWMMGlobal[realm].Month.Spent = _G.WOWMMGlobal[realm].Month.Spent + spent
         _G.WOWMMGlobal[realm].Week.Spent = _G.WOWMMGlobal[realm].Week.Spent + spent
         _G.WOWMMGlobal[realm].Day.Spent = _G.WOWMMGlobal[realm].Day.Spent + spent
         _G.WOWMMGlobal[realm].Session.Spent = _G.WOWMMGlobal[realm].Session.Spent + spent
      end
   end
end

function util.SetLDBInteraction(interaction)
   LDBinteraction = interaction
end

function util.IsLDBInteraction()
   return LDBinteraction
end

function util.GetClassRGB(class)
   if not class then
      return
   end
   local colors = {}
   local color = ClassColors[class]
   
   if not color then
      return
   end

   for i=1,3 do
      table.insert(colors, 1, bit.band(color, 0x0000FF)/0xFF)
      color = bit.rshift(color, 8)
   end
   return unpack(colors)
end

function util.GetSortedCharList(server)
   local chars = {}
   for n, v in pairs(_G.WOWMMGlobal) do
      if n == server and type(v) == "table" then
         for n, _ in pairs(v.Chars) do
            table.insert(chars, n)
         end
         table.sort(chars)
      end
   end
   return chars
end

function util.FormatMoney(cash)
	local value = abs(cash)
	local gold = floor(value / 10000)
	local silver = floor(mod(value / 100, 100))
	local copper = floor(mod(value, 100))

	return format("%d%s %02d%s %02d%s", gold, GoldIcon, silver, SilverIcon, copper, CopperIcon)
end

function util.FormatCurrency(currency, icon)
   return format("|T%s:12:12|t %s", icon, currency)
end

function util.GetRealmTotalCash(Realm)
   local total = 0
   for name, value in pairs(_G.WOWMMGlobal[Realm].Chars) do
   	total = total + value.Cash
   end
   return total
end

function util.GetCalendarDate(daysToAdvance)
   if daysToAdvance == nil then return nil, nil, nil, nil end

   local weekday, month, day, year = CalendarGetDate()
   local _, _, monthDays, _ = CalendarGetAbsMonth(month, year)
   while (day + daysToAdvance) > monthDays do
      daysToAdvance = daysToAdvance - monthDays
      weekday = (weekday + (monthDays%7))%7
      month = month + 1
      if month > 12 then
         month = 1
         year = year + 1
      end
      _, _, monthDays, _ = CalendarGetAbsMonth(month, year)
   end
   day = day + daysToAdvance
   weekday = (weekday + (daysToAdvance%7))%7

   return weekday, month, day, year
end

function util.GetTimeSinceEpoch(daysToAdvance)
   if daysToAdvance == nil then return nil end
   return (time() + (daysToAdvance * DAY))
end

function util.GetFontSetting()
   local font = _G.WOWMMChar.Font
   if font == nil then
      font = DefaultFont
   end
   return font
end

function util.SetFontSetting(font)
   if util.GetFontSetting() ~= font then
      _G.WOWMMChar.Font = font
   end
end

function util.GetFontSizeSetting()
   local fontSize = _G.WOWMMChar.FontSize
   if fontSize == nil then
      fontSize = DefaultFontSize
   end
   return fontSize
end

function util.SetFontSizeSetting(fontSize)
   if util.GetFontSizeSetting() ~= fontSize then
      _G.WOWMMChar.FontSize = fontSize
   end
end

function util.GetSexyCompatSetting()
   local isSexyCompat = _G.WOWMMChar.Minimap.IsSexyCompat
   if isSexyCompat == nil then
      isSexyCompat = SexyCompatDefault
   end
   return isSexyCompat
end

function util.RegisterEvents(self, handler, ...)
	for i = 1, select('#', ...) do
      self:RegisterEvent(select(i, ...))
	end
   self:SetScript("OnEvent", handler)
end
