local addon_name, addon = ...
local tt = addon.tooltip

local token = addon.token
local util = addon.utility
local _G = _G

local tooltip
local realm = GetRealmName()
local TTGap = 10

local OptionalShowDefault = {}
local OptionalDispFunc = {}
local OptionalCalcAvg = {}
local OptionalTimeBased = {}
local OptionalSpaceAfter = {}
local OptionalKeys = {}
local function RegisterOptionalSetting(key, defaultShow, dispFunc, calcAvg, timeBased, spaceAfter)
   if key == nil or type(key) ~= "string" then 
      error("key should be a string")
      return
   end

   if defaultShow == nil or type(defaultShow) ~= "boolean" then 
      error("defaultShow should be a boolean")
      return
   end

   if dispFunc == nil or type(dispFunc) ~= "function" then 
      error("dispFunc should be a function")
      return
   end

   if calcAvg == nil then
      calcAvg = false
   end

   if type(calcAvg) ~= "boolean" then 
      error("calcAvg should be a boolean")
      return
   end

   if timeBased == nil then
      timeBased = false
   end

   if type(timeBased) ~= "boolean" then 
      error("timeBased should be a boolean")
      return
   end

   if type(spaceAfter) ~= "boolean" then 
      error("spaceAfter should be a boolean")
      return
   end

   if not OptionalDispFunc[key] then
      OptionalShowDefault[key] = defaultShow
      OptionalDispFunc[key] = dispFunc
      OptionalCalcAvg[key] = calcAvg
      OptionalTimeBased[key] = timeBased
      OptionalSpaceAfter[key] = spaceAfter
      table.insert(OptionalKeys, key)
   end
end

local function GetOptionalSettingShown(key)
   local shown = _G.WOWMMChar[key.."Shown"]
   if shown == nil then
      shown = OptionalShowDefault[key]
   end
   return shown
end

local function GetMovingAvgShownSetting()
   local Shown = _G.WOWMMChar.MovingAvgShown
   if Shown == nil then
      Shown = true -- Default Value
   end
   return Shown
end

local function AddCashItem(title, cash, pos, class)
   local r, g, b = 1, 1, 1
   if class then
      r, g, b = util.GetClassRGB(class)
   end
   if pos then
      tooltip:AddDoubleLine(title, util.FormatMoney(cash), r, g, b, 1, 1, 1)
   else
      tooltip:AddDoubleLine(title, util.FormatMoney(cash), r, g, b, 1, 0, 0)
   end
end

local function AddSeperator()
   local total = 0
   local longestLeft = "Character:"
   for name, value in pairs(_G.WOWMMGlobal) do
      if type(value) == "table" then
         total = total + value.Total
         if #name > #longestLeft then
            longestLeft = name
         end
      end
   end

   for name, _ in pairs(_G.WOWMMGlobal[realm].Chars) do
      if #name > #longestLeft then
         longestLeft = name
      end
   end

   local longestRight = total
   if GetOptionalSettingShown("WowTokenPrice") then 
      local price = token.GetTokenPrice()
      if #(util.FormatMoney(price)) > #(util.FormatMoney(longestRight))then
         longestRight = price
      end

      local WTP = "WoW Token Price:"
      if #WTP > #longestLeft then
         longestLeft = WTP
      end
   end

   tooltip:AddSeperator("-", longestLeft, util.FormatMoney(longestRight), TTGap)
end

local function DisplayAvg(key)
   if _G.WOWMMGlobal[realm][key.."Count"] > 0 then
      local A = floor(_G.WOWMMGlobal[realm][key.."Net"] / _G.WOWMMGlobal[realm][key.."Count"])
      AddCashItem("Avg:", abs(A), A >= 0, "EMPHASIS")
   else
      local E = _G.WOWMMGlobal[realm][key].Earned
      local S = _G.WOWMMGlobal[realm][key].Spent
      AddCashItem("Avg:", (E - S), E >= S, "EMPHASIS")
   end
end

local function PopulateTooltip()
   local TimeBasedShown = false

   for i = 1, #OptionalKeys do
      local key = OptionalKeys[i]
      if GetOptionalSettingShown(key) then
         TimeBasedShown = OptionalTimeBased[key] or TimeBasedShown
         OptionalDispFunc[key]()
         if OptionalCalcAvg[key] and GetMovingAvgShownSetting() then
            DisplayAvg(key)
         end
         if OptionalSpaceAfter[key] then
            tooltip:AddLine(' ')
         end
      end
   end

   if TimeBasedShown then
      AddSeperator()
      tooltip:AddLine(' ')
   end
   tooltip:AddLine("Character:")
   local chars = util.GetSortedCharList(realm)
   for _, name in pairs(chars) do
      AddCashItem(name, _G.WOWMMGlobal[realm].Chars[name].Cash, true, _G.WOWMMGlobal[realm].Classes[name])
   end
   tooltip:AddLine(' ')
   tooltip:AddLine("Server:")

   local total = 0
   for name, value in pairs(_G.WOWMMGlobal) do
      if type(value) == "table" then
         total = total + value.Total
         AddCashItem(name, value.Total, true)
      end
   end
   tooltip:AddLine(' ')
   AddCashItem("Total:", total, true)
end

function tt.ShowTooltip(self)
   tooltip:Init(self)
   PopulateTooltip()
   tooltip:Show()
end

function tt.HideTooltip()
   tooltip:Hide()
end

local function SetFont(font)
   tooltip:SetFont(font)
end

local function GetFont()
   tooltip:GetFont()
end

local function SetFontSize(fontSize)
   tooltip:SetFontSize(fontSize)
end

local function GetFontSize()
   tooltip:GetFontSize()
end

local function UpdateFontInfo()
   SetFont(util.GetFontSetting())
   SetFontSize(util.GetFontSizeSetting())
end

tt.GetOptionalSettingShown = GetOptionalSettingShown
tt.GetMovingAvgShownSetting = GetMovingAvgShownSetting
tt.UpdateFontInfo = UpdateFontInfo

tooltip = Prototype_Tooltip:new()

RegisterOptionalSetting ("WowTokenPrice",
                           false,
                           function()
                              AddCashItem("WoW Token Price:", token.GetTokenPrice(), true)
                              tooltip:AddLine(' ')
                              AddSeperator()
                           end,
                           false,
                           false,
                           true
                        )
RegisterOptionalSetting ("WatchedCurrencies",
                           false,
                           function()
                              local currencyCount = GetCurrencyListSize()
                              local shownCount = 0
                              for i = 1, currencyCount do
                                 local currency, isHeader, _, isUnused, isWatched, count, icon = GetCurrencyListInfo(i)
                                 if not isHeader and not isUnused and isWatched then
                                    shownCount = shownCount + 1
                                    tooltip:AddDoubleLine(util.FormatCurrency(currency, icon), count, 1, 1, 1, 1, 1, 1)
                                 end
                              end
                              if shownCount ~= 0 then
                                 tooltip:AddLine(' ')
                                 AddSeperator()
                                 tooltip:AddLine(' ')
                              end
                           end,
                           false,
                           false,
                           false
                        )
RegisterOptionalSetting ("AllTime",
                           true,
                           function()
                              local E = _G.WOWMMGlobal[realm].AllTime.Earned
                              local S = _G.WOWMMGlobal[realm].AllTime.Spent
                              tooltip:AddLine("All Time:")
                              AddCashItem("Earned:", E, true)
                              AddCashItem("Spent:", S, (S == 0))
                              AddCashItem("Net:", (E - S), E >= S)
                           end,
                           false,
                           true,
                           true
                        )
RegisterOptionalSetting ("Year",
                           true,
                           function()
                              local E = _G.WOWMMGlobal[realm].Year.Earned
                              local S = _G.WOWMMGlobal[realm].Year.Spent
                              tooltip:AddLine("Year:")
                              AddCashItem("Earned:", E, true)
                              AddCashItem("Spent:", S, (S == 0))
                              AddCashItem("Net:", (E - S), E >= S)
                           end,
                           true,
                           true,
                           true
                        )
RegisterOptionalSetting ("Month",
                           true,
                           function()
                              local E = _G.WOWMMGlobal[realm].Month.Earned
                              local S = _G.WOWMMGlobal[realm].Month.Spent
                              tooltip:AddLine("Month:")
                              AddCashItem("Earned:", E, true)
                              AddCashItem("Spent:", S, (S == 0))
                              AddCashItem("Net:", (E - S), E >= S)
                           end,
                           true,
                           true,
                           true
                        )
RegisterOptionalSetting ("Week",
                           true,
                           function()
                              local E = _G.WOWMMGlobal[realm].Week.Earned
                              local S = _G.WOWMMGlobal[realm].Week.Spent
                              tooltip:AddLine("Week:")
                              AddCashItem("Earned:", E, true)
                              AddCashItem("Spent:", S, (S == 0))
                              AddCashItem("Net:", (E - S), E >= S)
                           end,
                           true,
                           true,
                           true
                        )
RegisterOptionalSetting ("Day",
                           true,
                           function()
                              local E = _G.WOWMMGlobal[realm].Day.Earned
                              local S = _G.WOWMMGlobal[realm].Day.Spent
                              tooltip:AddLine("Day:")
                              AddCashItem("Earned:", E, true)
                              AddCashItem("Spent:", S, (S == 0))
                              AddCashItem("Net:", (E - S), E >= S)
                           end,
                           true,
                           true,
                           true
                        )
RegisterOptionalSetting ("Session",
                           true,
                           function()
                              local E = _G.WOWMMGlobal[realm].Session.Earned
                              local S = _G.WOWMMGlobal[realm].Session.Spent
                              tooltip:AddLine("Session:")
                              AddCashItem("Earned:", E, true)
                              AddCashItem("Spent:", S, (S == 0))
                              AddCashItem("Net:", (E - S), E >= S)
                           end,
                           true,
                           true,
                           true
                        )
local frame = CreateFrame("Frame")

local function EventHandler(self, event, ...)
   local args = {...}
   if event == "ADDON_LOADED" and args[1] == addon_name then
      UpdateFontInfo()
   end
end

util.RegisterEvents(frame, EventHandler, 'ADDON_LOADED')
