local _, addon = ...
local slash = addon.slash

local minimap = addon.minimap
local util = addon.utility

local CommandList = {}
local CommandListDescription = {}
local CommandListRaw = {}

local function ShowHelp()
   local c = _G.DEFAULT_CHAT_FRAME;
   c:AddMessage("|cffff6600".."WoW Money Statistics".."|r")
   c:AddMessage("|cffff6600".."Usage"..":|r  ".."/wms { "..string.lower(table.concat(CommandListRaw, " | ")).." | help }")
   for i=1, #CommandListRaw do
      local desc = CommandListDescription[CommandListRaw[i]]
      desc = desc and ":|r "..desc or "|r"
      c:AddMessage("  - |cffffd1b3"..string.lower(CommandListRaw[i])..desc)
   end
   c:AddMessage("  - |cffffd1b3".."help:|r Show Slash Command Usage")
end

local function ParseSlashCommand(msg)
   if #CommandListRaw == 0 then return end

   msg = (msg ~= "") and msg or "help"
   local cmd, args = string.match(msg, "([^%s]*)%s*(.*)")
   cmd = string.upper(cmd)

   if(CommandList[cmd]) then
      CommandList[cmd](args)
   else
      ShowHelp()
   end
end

local function RegisterSlashCommand(cmd, func, desc)
   if(type(cmd) == "string" and not CommandList[string.upper(cmd)] and type(func) == "function") then
      CommandList[string.upper(cmd)] = func
      CommandListDescription[string.upper(cmd)] = desc
      table.insert(CommandListRaw, string.upper(cmd))
      table.sort(CommandListRaw)
   end
end

SLASH_WOWMONEYSTATISTICS1 = '/wms'
SlashCmdList["WOWMONEYSTATISTICS"] = ParseSlashCommand

slash.RegisterSlashCommand = RegisterSlashCommand

RegisterSlashCommand("minimap",
                     function(...)
                        local isHidden = minimap.GetMinimapHideSetting()
                        _G.WOWMMChar.Minimap.IsMinimapHidden = minimap.SetMinimapHidden(not isHidden) 
                     end, 
                     "Toggle Minimap Icon")


if IsAddOnLoaded("SexyMap") then
   RegisterSlashCommand("sexymap",
                        function(...)
                           local isSexyCompat = util.GetSexyCompatSetting()
                           _G.WOWMMChar.Minimap.IsSexyCompat = (not isSexyCompat)
                           ReloadUI()
                        end, 
                        "Toggle SexyMap Integration")
end
