local addon_name, addon = ...
local minimap = addon.minimap

local ldb = addon.ldb
local tt = addon.tooltip
local menu = addon.menu
local util = addon.utility
local _G = _G

local mmb

local defaultX, defaultY = 100, 100
local MinimapLockDefault = true
local MinimapHideDefault = false
local LockDefault = false

local function GetMinimapLockSetting()
   local isMinimapLocked = _G.WOWMMChar.Minimap.IsMinimapLocked
   if isMinimapLocked == nil then
      isMinimapLocked = MinimapLockDefault
   end
   return isMinimapLocked
end

local function SetMinimapLock(lock)
   return mmb:SetMinimapLock(lock)
end

local function GetMinimapHideSetting()
   local isMinimapHidden = _G.WOWMMChar.Minimap.IsMinimapHidden
   if isMinimapHidden == nil then
      isMinimapHidden = MinimapHideDefault
   end
   return isMinimapHidden
end

local function SetMinimapHidden(hide)
   return mmb:SetMinimapHidden(hide)
end

local function GetLockSetting()
   local isLocked = _G.WOWMMChar.Minimap.IsLocked
   if isLocked == nil then
      isLocked = LockDefault
   end
   return isLocked
end

local function SetLock(lock)
   return mmb:SetLock(lock)
end

local function OnEnter(self)
   util.SetLDBInteraction(false)
   if (not menu.IsMenuOpen()) and not mmb:IsDragging() then
      tt.ShowTooltip(self)
   end
end

local function OnLeave(self)
   tt.HideTooltip()
end

local function OnClick(self, button, down)
   if down and menu.IsMenuOpen() then
      -- if context menu is open allow both left and right clicks to close it
      menu.CloseMenu()
      OnEnter(self)
   elseif button == "RightButton" and down then
      tt.HideTooltip()
      menu.ToggleMenu(mmb.button)
   end
end

local frame = CreateFrame("Frame")
local function EventHandler(self, event, ...)
   local args = {...}
   if event == "ADDON_LOADED" and args[1] == addon_name then
      mmb =    Prototype_MMB:new (
                                    {
                                       IconTexture = "Interface\\Icons\\INV_Misc_Coin_17",
                                       IsMinimapLocked = GetMinimapLockSetting(),
                                       IsMinimapHidden = GetMinimapHideSetting(),
                                       IsMinimapSexyCompat = util.GetSexyCompatSetting(),
                                       IsLocked = GetLockSetting(),
                                       OnPositionChange =   function(x, y)
                                                               menu.CloseMenu()
                                                               tt.HideTooltip()
                                                               _G.WOWMMChar.Minimap.x = x
                                                               _G.WOWMMChar.Minimap.y = y
                                                            end,
                                       OnEnter = OnEnter,
                                       OnLeave = OnLeave,
                                       OnClick = OnClick,
                                    }
                                 )
      mmb:Initialize(addon_name, (_G.WOWMMChar.Minimap.x or defaultX), (_G.WOWMMChar.Minimap.y or defaultY))
   end
end

util.RegisterEvents(frame, EventHandler, 'ADDON_LOADED')

minimap.GetMinimapLockSetting = GetMinimapLockSetting
minimap.SetMinimapLock = SetMinimapLock
minimap.GetMinimapHideSetting = GetMinimapHideSetting
minimap.SetMinimapHidden = SetMinimapHidden
minimap.GetLockSetting = GetLockSetting
minimap.SetLock = SetLock
