local addon_name, addon = ...

local menu = addon.menu
local tt = addon.tooltip
local util = addon.utility

local ldb

-- TitanPanel calls some of the same methods I do to create the right-click context menus; Bypassing.
local TitanHack 
local function OnEnter(self)
   TitanHack = TitanPanelRightClickMenu_Toggle
   TitanPanelRightClickMenu_Toggle = function(...) end

   util.SetLDBInteraction(true)

   if (not menu.IsMenuOpen()) then
      tt.ShowTooltip(self)
   end
end

local function OnLeave(self)
   tt.HideTooltip()
   TitanPanelRightClickMenu_Toggle = TitanHack
end

local function OnClick(self, button)
   if menu.IsMenuOpen() then
      -- if context menu is open allow both left and right clicks to close it
      menu.CloseMenu()
   elseif button == "RightButton" then
      tt.HideTooltip()
      menu.ToggleMenu(self)
   end
end

ldb = LibStub:GetLibrary("LibDataBroker-1.1"):NewDataObject (addon_name,   {
                                                                              type = "launcher",
                                                                              icon = "Interface\\Icons\\INV_Misc_Coin_17",
                                                                              OnEnter = OnEnter,
                                                                              OnLeave = OnLeave,
                                                                              OnClick = OnClick,
                                                                              text = util.FormatMoney(GetMoney()),
                                                                           }
                                                            )

local frame = CreateFrame("Frame")
local function EventHandler(self, event, ...)
   ldb.text = util.FormatMoney(GetMoney())
end
util.RegisterEvents(frame, EventHandler,
                              'PLAYER_ENTERING_WORLD',
                              'PLAYER_MONEY')

