local addon_name, addon = ...
local core = addon.core

local util = addon.utility
local menu = addon.menu
local _G = _G

local player = UnitName("player")
local _, class = UnitClass("player")
local realm = GetRealmName()

local SECOND = 1
local MINUTE = 60 * SECOND
local HOUR = 60 * MINUTE
local DAY = 24 * HOUR
local WEEK = 7 * DAY

local function InitializePersistantVariables()
   _G.WOWMMGlobal[realm] = _G.WOWMMGlobal[realm] or {}
   
   _G.WOWMMGlobal[realm].Chars = _G.WOWMMGlobal[realm].Chars or {}
   _G.WOWMMGlobal[realm].Classes = _G.WOWMMGlobal[realm].Classes or {}
   local wd, m, d, y = util.GetCalendarDate(util.GetDaysToAdvance())
   local logonTime = util.GetTimeSinceEpoch(util.GetDaysToAdvance())

   --[===[@debug
   local currencyCount = GetCurrencyListSize()

   _G.WOWMMChar.Currency = _G.WOWMMChar.Currency or {}
   _G.WOWMMChar.Currency.AllTime = _G.WOWMMChar.Currency.AllTime or {}
   _G.WOWMMChar.Currency.Year = _G.WOWMMChar.Currency.Year or {}
   _G.WOWMMChar.Currency.Month = _G.WOWMMChar.Currency.Month or {}
   _G.WOWMMChar.Currency.Week = _G.WOWMMChar.Currency.Week or {}
   _G.WOWMMChar.Currency.Day = _G.WOWMMChar.Currency.Day or {}
   _G.WOWMMChar.Currency.Session = _G.WOWMMChar.Currency.Session or {}
   --@end-debug]===]
   
   -- All Time Initialization
   do
      _G.WOWMMGlobal[realm].AllTime = _G.WOWMMGlobal[realm].AllTime or {}
      _G.WOWMMGlobal[realm].AllTime.Earned = _G.WOWMMGlobal[realm].AllTime.Earned or 0
      _G.WOWMMGlobal[realm].AllTime.Spent = _G.WOWMMGlobal[realm].AllTime.Spent or 0

      --[===[@debug
      -- Currency Initialization
      for i = 1, currencyCount do
         local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
         if not isHeader and not isUnused then
            _G.WOWMMChar.Currency.AllTime[currency] = _G.WOWMMChar.Currency.AllTime[currency] or {}
            _G.WOWMMChar.Currency.AllTime[currency].Spent = _G.WOWMMChar.Currency.AllTime[currency].Spent or 0
            _G.WOWMMChar.Currency.AllTime[currency].Earned = _G.WOWMMChar.Currency.AllTime[currency].Earned or 0
         end
      end
      --@end-debug]===]
   end
   
   -- Year Initialization
   do
      local id = y

      _G.WOWMMGlobal[realm].Year = _G.WOWMMGlobal[realm].Year or {}
      _G.WOWMMGlobal[realm].YearCount = _G.WOWMMGlobal[realm].YearCount or 0
      _G.WOWMMGlobal[realm].YearNet = _G.WOWMMGlobal[realm].YearNet or 0
      _G.WOWMMGlobal[realm].Year.ID = _G.WOWMMGlobal[realm].Year.ID or id
      if _G.WOWMMGlobal[realm].Year.ID == id then
         _G.WOWMMGlobal[realm].Year.Earned = _G.WOWMMGlobal[realm].Year.Earned or 0
         _G.WOWMMGlobal[realm].Year.Spent = _G.WOWMMGlobal[realm].Year.Spent or 0

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Year[currency] = _G.WOWMMChar.Currency.Year[currency] or {}
               _G.WOWMMChar.Currency.Year[currency].Spent = _G.WOWMMChar.Currency.Year[currency].Spent or 0
               _G.WOWMMChar.Currency.Year[currency].Earned = _G.WOWMMChar.Currency.Year[currency].Earned or 0
            end
         end
         --@end-debug]===]
      else
         local previousYearEarned = _G.WOWMMGlobal[realm].Year.Earned or 0
         local previousYearSpent = _G.WOWMMGlobal[realm].Year.Spent or 0
         if previousYearEarned and previousYearSpent then
            local net = previousYearEarned - previousYearSpent
            _G.WOWMMGlobal[realm].YearNet = _G.WOWMMGlobal[realm].YearNet + net
         end

         _G.WOWMMGlobal[realm].Year.ID = id
         _G.WOWMMGlobal[realm].Year.Earned = 0
         _G.WOWMMGlobal[realm].Year.Spent = 0
         _G.WOWMMGlobal[realm].YearCount = _G.WOWMMGlobal[realm].YearCount + 1

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Year[currency] = {}
               _G.WOWMMChar.Currency.Year[currency].Spent = 0
               _G.WOWMMChar.Currency.Year[currency].Earned = 0
            end
         end
         --@end-debug]===]
      end
   end

   -- Month Initialization
   do
      local id = m.."/"..y

      _G.WOWMMGlobal[realm].Month = _G.WOWMMGlobal[realm].Month or {}
      _G.WOWMMGlobal[realm].MonthCount = _G.WOWMMGlobal[realm].MonthCount or 0
      _G.WOWMMGlobal[realm].MonthNet = _G.WOWMMGlobal[realm].MonthNet or 0
      _G.WOWMMGlobal[realm].Month.ID = _G.WOWMMGlobal[realm].Month.ID or id
      if _G.WOWMMGlobal[realm].Month.ID == id then
         _G.WOWMMGlobal[realm].Month.Earned = _G.WOWMMGlobal[realm].Month.Earned or 0
         _G.WOWMMGlobal[realm].Month.Spent = _G.WOWMMGlobal[realm].Month.Spent or 0

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Month[currency] = _G.WOWMMChar.Currency.Month[currency] or {}
               _G.WOWMMChar.Currency.Month[currency].Spent = _G.WOWMMChar.Currency.Month[currency].Spent or 0
               _G.WOWMMChar.Currency.Month[currency].Earned = _G.WOWMMChar.Currency.Month[currency].Earned or 0
            end
         end
         --@end-debug]===]
      else
         local previousMonthEarned = _G.WOWMMGlobal[realm].Month.Earned or 0
         local previousMonthSpent = _G.WOWMMGlobal[realm].Month.Spent or 0
         if previousMonthEarned and previousMonthSpent then
            local net = previousMonthEarned - previousMonthSpent
            _G.WOWMMGlobal[realm].MonthNet = _G.WOWMMGlobal[realm].MonthNet + net
         end

         _G.WOWMMGlobal[realm].Month.ID = id
         _G.WOWMMGlobal[realm].Month.Earned = 0
         _G.WOWMMGlobal[realm].Month.Spent = 0
         _G.WOWMMGlobal[realm].MonthCount = _G.WOWMMGlobal[realm].MonthCount + 1

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Month[currency] = {}
               _G.WOWMMChar.Currency.Month[currency].Spent = 0
               _G.WOWMMChar.Currency.Month[currency].Earned = 0
            end
         end
         --@end-debug]===]
      end
   end

   -- Week Initialization
   do
      local dowSetting = menu.GetDOWSetting()
      local id = (wd - dowSetting) % 7

      _G.WOWMMGlobal[realm].Week = _G.WOWMMGlobal[realm].Week or {}
      _G.WOWMMGlobal[realm].WeekCount = _G.WOWMMGlobal[realm].WeekCount or 0
      _G.WOWMMGlobal[realm].WeekNet = _G.WOWMMGlobal[realm].WeekNet or 0
      _G.WOWMMGlobal[realm].Week.ID = _G.WOWMMGlobal[realm].Week.ID or id
      _G.WOWMMGlobal[realm].Week.LLIT = _G.WOWMMGlobal[realm].Week.LLIT or logonTime
      if (logonTime - _G.WOWMMGlobal[realm].Week.LLIT) < WEEK and id >= _G.WOWMMGlobal[realm].Week.ID then
         _G.WOWMMGlobal[realm].Week.Earned = _G.WOWMMGlobal[realm].Week.Earned or 0
         _G.WOWMMGlobal[realm].Week.Spent = _G.WOWMMGlobal[realm].Week.Spent or 0

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Week[currency] = _G.WOWMMChar.Currency.Week[currency] or {}
               _G.WOWMMChar.Currency.Week[currency].Spent = _G.WOWMMChar.Currency.Week[currency].Spent or 0
               _G.WOWMMChar.Currency.Week[currency].Earned = _G.WOWMMChar.Currency.Week[currency].Earned or 0
            end
         end
         --@end-debug]===]
      else
         local previousWeekEarned = _G.WOWMMGlobal[realm].Week.Earned or 0
         local previousWeekSpent = _G.WOWMMGlobal[realm].Week.Spent or 0
         if previousWeekEarned and previousWeekSpent then
            local net = previousWeekEarned - previousWeekSpent
            _G.WOWMMGlobal[realm].WeekNet = _G.WOWMMGlobal[realm].WeekNet + net
         end

         _G.WOWMMGlobal[realm].Week.Earned = 0
         _G.WOWMMGlobal[realm].Week.Spent = 0
         _G.WOWMMGlobal[realm].WeekCount = _G.WOWMMGlobal[realm].WeekCount + 1

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Week[currency] = {}
               _G.WOWMMChar.Currency.Week[currency].Spent = 0
               _G.WOWMMChar.Currency.Week[currency].Earned = 0
            end
         end
         --@end-debug]===]
      end
      _G.WOWMMGlobal[realm].Week.ID = id
      _G.WOWMMGlobal[realm].Week.LLIT = logonTime
   end

   -- Day Initialization
   do
      local id =  format("%02d/%02d/%d", m, d, strsub(y, 3))

      _G.WOWMMGlobal[realm].Day = _G.WOWMMGlobal[realm].Day or {}
      _G.WOWMMGlobal[realm].DayCount = _G.WOWMMGlobal[realm].DayCount or 0
      _G.WOWMMGlobal[realm].DayNet = _G.WOWMMGlobal[realm].DayNet or 0
      _G.WOWMMGlobal[realm].Day.Date = _G.WOWMMGlobal[realm].Day.Date or id
      if _G.WOWMMGlobal[realm].Day.Date == id then
      	_G.WOWMMGlobal[realm].Day.Earned = _G.WOWMMGlobal[realm].Day.Earned or 0
      	_G.WOWMMGlobal[realm].Day.Spent = _G.WOWMMGlobal[realm].Day.Spent or 0

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Day[currency] = _G.WOWMMChar.Currency.Day[currency] or {}
               _G.WOWMMChar.Currency.Day[currency].Spent = _G.WOWMMChar.Currency.Day[currency].Spent or 0
               _G.WOWMMChar.Currency.Day[currency].Earned = _G.WOWMMChar.Currency.Day[currency].Earned or 0
            end
         end
         --@end-debug]===]
      else
      	local previousDayEarned = _G.WOWMMGlobal[realm].Day.Earned or 0
      	local previousDaySpent = _G.WOWMMGlobal[realm].Day.Spent or 0
         if previousDayEarned and previousDaySpent then
            local net = previousDayEarned - previousDaySpent
            _G.WOWMMGlobal[realm].DayNet = _G.WOWMMGlobal[realm].DayNet + net
         end

      	_G.WOWMMGlobal[realm].Day.Date = id
      	_G.WOWMMGlobal[realm].Day.Earned = 0
      	_G.WOWMMGlobal[realm].Day.Spent = 0
         _G.WOWMMGlobal[realm].DayCount = _G.WOWMMGlobal[realm].DayCount + 1

         --[===[@debug
         -- Currency Initialization
         for i = 1, currencyCount do
            local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
            if not isHeader and not isUnused then
               _G.WOWMMChar.Currency.Day[currency] = {}
               _G.WOWMMChar.Currency.Day[currency].Spent = 0
               _G.WOWMMChar.Currency.Day[currency].Earned = 0
            end
         end
         --@end-debug]===]
      end
   end
   
   -- Session Initialization
   do
      if  _G.WOWMMGlobal[realm] and _G.WOWMMGlobal[realm].Session then
         local previousSessionEarned = _G.WOWMMGlobal[realm].Session.Earned
         local previousSessionSpent = _G.WOWMMGlobal[realm].Session.Spent
         if previousSessionEarned and previousSessionSpent then
            local net = previousSessionEarned - previousSessionSpent
            if _G.WOWMMGlobal[realm].SessionNet then
               _G.WOWMMGlobal[realm].SessionNet = _G.WOWMMGlobal[realm].SessionNet + net
            end
         end
         if _G.WOWMMGlobal[realm].SessionCount then
            _G.WOWMMGlobal[realm].SessionCount = _G.WOWMMGlobal[realm].SessionCount + 1
         end
      end

      _G.WOWMMGlobal[realm].SessionCount = _G.WOWMMGlobal[realm].SessionCount or 0
      _G.WOWMMGlobal[realm].SessionNet = _G.WOWMMGlobal[realm].SessionNet or 0

      _G.WOWMMGlobal[realm].Session = {}
      _G.WOWMMGlobal[realm].Session.Earned = 0
      _G.WOWMMGlobal[realm].Session.Spent = 0

      --[===[@debug
      -- Currency Initialization
      for i = 1, currencyCount do
         local currency, isHeader, _, isUnused = GetCurrencyListInfo(i)
         if not isHeader and not isUnused then
            _G.WOWMMChar.Currency.Session[currency] = {}
            _G.WOWMMChar.Currency.Session[currency].Spent = 0
            _G.WOWMMChar.Currency.Session[currency].Earned = 0
         end
      end
      --@end-debug]===]
   end

   -- Changing the format of the save table from previous versions.
   -- I do not want to lose previously saved data.
   do
      -- Version information added in 1.0.6.
      -- All version information before 1.0.6 would be nil.
      local version = _G.WOWMMGlobal.Version or "1.0.5.1"

      -- Format change from version 1.0.5.1 to 1.0.6 for introduction of currency information.
      if version <= "1.0.5.1" then
         local OldFormat = {}
         for k, v in pairs(_G.WOWMMGlobal[realm].Chars) do
            if type(v) == "number" then
               OldFormat[k] = v
            end
         end

         for k, v in pairs(OldFormat) do
            _G.WOWMMGlobal[realm].Chars[k] = {}
            _G.WOWMMGlobal[realm].Chars[k].Cash = v
         end
      end

      _G.WOWMMGlobal.Version = GetAddOnMetadata(addon_name, "version")
   end

   _G.WOWMMGlobal[realm].Chars[player] = _G.WOWMMGlobal[realm].Chars[player] or {}
   _G.WOWMMGlobal[realm].Chars[player].Cash = _G.WOWMMGlobal[realm].Chars[player].Cash or 0
   
   _G.WOWMMGlobal[realm].Total = util.GetRealmTotalCash(realm)
end

local function UpdatePersistantVariables()
   local cash = GetMoney()
   local pcash = _G.WOWMMGlobal[realm].Chars[player].Cash
   
   util.UpdateEarnedSpent(cash, pcash)
   
   _G.WOWMMGlobal[realm].Chars[player].Cash = cash
   _G.WOWMMGlobal[realm].Classes[player] = class
   _G.WOWMMGlobal[realm].Total = util.GetRealmTotalCash(realm)

end

local loaded = false
local frame = CreateFrame("Frame")
local function EventHandler(self, event, ...)
   local args = {...}

   if event == "ADDON_LOADED" and args[1] ~= addon_name then
      return
   end

   if event == "ADDON_LOADED" and args[1] == addon_name then
   end

   if event =="PLAYER_ENTERING_WORLD" then
      if not loaded then
         InitializePersistantVariables()
         loaded = true
      end
      UpdatePersistantVariables()
   elseif event == 'KNOWN_CURRENCY_TYPES_UPDATE' then
   elseif event == 'CURRENCY_DISPLAY_UPDATE' then
   elseif event == "PLAYER_MONEY" then
      UpdatePersistantVariables()
   end
end
util.RegisterEvents(frame, EventHandler,
                                    'PLAYER_ENTERING_WORLD',
                                    'ADDON_LOADED',
                                    'PLAYER_MONEY',
                                    'CURRENCY_DISPLAY_UPDATE',
                                    'KNOWN_CURRENCY_TYPES_UPDATE')

core.InitializePersistantVariables = InitializePersistantVariables
