local addon_name, addon = ...
local menu = addon.menu

local util = addon.utility
local tt = addon.tooltip
local core = addon.core
local minimap = addon.minimap
--local goals = addon.goals
local _G = _G

local cm
local DOWDefault = 3
local DOW = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" }

local COPPER = 1
local SILVER = 100 * COPPER
local GOLD = 100 * SILVER

local realm = GetRealmName()

local function GetDOWSetting()
   local dowSetting = _G.WOWMMChar.DOWSetting or DOWDefault
   return dowSetting
end

local function SetDOWSetting(dow)
   if GetDOWSetting() ~= dow then
      _G.WOWMMChar.DOWSetting = dow
   end
   cm:Refresh()
end

local function ResetYearMA()
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].YearNet = 0
   _G.WOWMMGlobal[realm].YearCount = 0
end

local function ResetMonthMA()
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].MonthNet = 0
   _G.WOWMMGlobal[realm].MonthCount = 0
end

local function ResetWeekMA()
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].WeekNet = 0
   _G.WOWMMGlobal[realm].WeekCount = 0
end

local function ResetDayMA()
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].DayNet = 0
   _G.WOWMMGlobal[realm].DayCount = 0
end

local function ResetSessionMA()
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].SessionNet = 0
   _G.WOWMMGlobal[realm].SessionCount = 0
end

local function ResetSession()
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].Session.Earned = 0
   _G.WOWMMGlobal[realm].Session.Spent = 0
end

local function ResetDay(recursive)
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].Day.Earned = 0
   _G.WOWMMGlobal[realm].Day.Spent = 0
   if recursive then
      ResetSession()
   end
end

local function ResetWeek(recursive)
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].Week.Earned = 0
   _G.WOWMMGlobal[realm].Week.Spent = 0
   if recursive then
      ResetDay(recursive)
   end
end

local function ResetMonth(recursive)
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].Month.Earned = 0
   _G.WOWMMGlobal[realm].Month.Spent = 0
   if recursive then
      ResetWeek(recursive)
   end
end

local function ResetYear(recursive)
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].Year.Earned = 0
   _G.WOWMMGlobal[realm].Year.Spent = 0
   if recursive then
      ResetMonth(recursive)
   end
end

local function ResetAllTime(recursive)
   cm:CloseMenu()
   _G.WOWMMGlobal[realm].AllTime.Earned = 0
   _G.WOWMMGlobal[realm].AllTime.Spent = 0
   if recursive then
      ResetYear(recursive)
   end
end

local function RemoveCharacter(Realm, CharName)
   cm:CloseMenu()
   _G.WOWMMGlobal[Realm].Chars[CharName] = nil
   _G.WOWMMGlobal[Realm].Classes[CharName] = nil

   local count = 0
   for _ in pairs(_G.WOWMMGlobal[Realm].Chars) do count = count + 1 end
   if count == 0 then
      if Realm ~= realm then
         _G.WOWMMGlobal[Realm] = nil
      end
   else
      _G.WOWMMGlobal[Realm].Total = util.GetRealmTotalCash(Realm)
   end
   core.InitializePersistantVariables()
end

-- Right-Click context cm initialization
local function ContextMenu_OnLoad(self, level, menuList)
   if cm then
      if level == 1 then
         -- If SexyMap is loaded this addon will allow SexyMap to control minimap icon movements and visibility
         -- Don't allow any context cm options to be visible that will not function
         local sexyMapLoaded = IsAddOnLoaded("SexyMap")

         cm:AddDescriptor    (  "WoW Money Statistics", 1, true )
         --[===[@debug
         -- TODO: Add Goals
         cm:AddOption        (  "Manage Goals",
                                    1,
                                    function(self)
                                       goals.ToggleDialog()
                                    end)
         cm:AddDescriptor    (  "-------------------", 1 )
         --@end-debug]===]
         cm:AddMenu          (  "Tooltip", 1, "Tooltips" )
         if not util.IsLDBInteraction() and (not sexyMapLoaded or not util.GetSexyCompatSetting()) then
            cm:AddMenu          (  "Minimap", 1, "Minimaps" )
         elseif util.IsLDBInteraction() then
            cm:AddCheckOption   (  "Hide Minimap Icon",
                                       function(self)
                                          return minimap.GetMinimapHideSetting()
                                       end,
                                       1,
                                       function(self, _, _, checked) 
                                          _G.WOWMMChar.Minimap.IsMinimapHidden = minimap.SetMinimapHidden(checked)
                                       end
                                    )
         end
         cm:AddDescriptor    (  "-------------------", 1 )
         cm:AddMenu          (  "Font", 1, "Fonts" )
         cm:AddMenu          (  "Font Size", 1, "FontSize" )
         cm:AddDescriptor    (  "-------------------", 1 )
         cm:AddMenu          (  "Remove Character", 1, "Removes" )
         cm:AddMenu          (  "Reset", 1, "Resets" )
         --[===[@debug
         cm:AddDescriptor    (  "-------------------", 1 )
         cm:AddMenu          (  "Debug", 1, "Debug" )
         --@end-debug]===]
      elseif menuList == "Tooltips" then
         cm:AddCheckOption   (  "Show All Time",
                                    function(self)
                                       return tt.GetOptionalSettingShown("AllTime")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.AllTimeShown = checked
                                    end
                                 )
         cm:AddCheckOption   (  "Show Year",
                                    function(self)
                                       return tt.GetOptionalSettingShown("Year")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.YearShown = checked
                                    end
                                 )
         cm:AddCheckOption   (  "Show Month",
                                    function(self)
                                       return tt.GetOptionalSettingShown("Month")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.MonthShown = checked
                                    end
                                 )
         cm:AddCheckOption   (  "Show Week",
                                    function(self)
                                       return tt.GetOptionalSettingShown("Week")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.WeekShown = checked
                                    end
                                 )
         cm:AddCheckOption   (  "Show Day",
                                    function(self)
                                       return tt.GetOptionalSettingShown("Day")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.DayShown = checked
                                    end
                                 )
         cm:AddCheckOption   (  "Show Session",
                                    function(self)
                                       return tt.GetOptionalSettingShown("Session")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.SessionShown = checked
                                    end
                                 )
         cm:AddDescriptor    (  "-------------------", 2 )
         cm:AddCheckOption   (  "Show Avgs",
                                    function(self)
                                       return tt.GetMovingAvgShownSetting()
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.MovingAvgShown = checked
                                    end
                                 )
         cm:AddDescriptor    (  "-------------------", 2 )
         cm:AddCheckOption   (  "Show Current WoW Token Price",
                                    function(self)
                                       return tt.GetOptionalSettingShown("WowTokenPrice")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.WowTokenPriceShown = checked
                                    end
                                 )
         cm:AddCheckOption   (  "Show Watched Currencies",
                                    function(self)
                                       return tt.GetOptionalSettingShown("WatchedCurrencies")
                                    end,
                                    2,
                                    function(self, _, _, checked)
                                       _G.WOWMMChar.WatchedCurrenciesShown = checked
                                    end
                                 )
      elseif menuList == "Debug" then
         cm:AddMenu          (  "Weekly Reset Day", 2, "ResetDay")
         cm:AddOption  (  "Advance Time - Day",
                              2,
                              function(self)
                                 util.AdvanceDays(1)
                                 core.InitializePersistantVariables()
                              end
                           )
         cm:AddOption  (  "Advance Time - Week",
                              2,
                              function(self)
                                 util.AdvanceDays(7)
                                 core.InitializePersistantVariables()
                              end
                           )
         cm:AddOption  (  "Advance Time - Month",
                              2,
                              function(self)
                                 _, m, d, y = GetCalendarDate()
                                 _, _, md, _ = CalendarGetAbsMonth(m, y)
                                 util.AdvanceDays(md - d + 1)
                                 core.InitializePersistantVariables()
                              end
                           )
         cm:AddOption  (  "Reset Time",
                              2,
                              function(self)
                                 util.ResetDays()
                                 core.InitializePersistantVariables()
                              end
                           )
         cm:AddDescriptor    (  "-------------------", 2 )
         cm:AddOption  (  "Earn 99 Gold",
                              2,
                              function(self)
                                 local cash = GetMoney()
                                 util.UpdateEarnedSpent(cash + (99 * GOLD), cash)
                              end
                           )
         cm:AddOption  (  "Spend 99 Gold",
                              2,
                              function(self)
                                 local cash = GetMoney()
                                 util.UpdateEarnedSpent(cash - (99 * GOLD), cash)
                              end
                           )
         cm:AddOption  (  "Earn 99 Silver",
                              2,
                              function(self)
                                 local cash = GetMoney()
                                 util.UpdateEarnedSpent(cash + (99 * SILVER), cash)
                              end
                           )
         cm:AddOption  (  "Spend 99 Silver",
                              2,
                              function(self)
                                 local cash = GetMoney()
                                 util.UpdateEarnedSpent(cash - (99 * SILVER), cash)
                              end
                           )
         cm:AddOption  (  "Earn 99 Copper",
                              2,
                              function(self)
                                 local cash = GetMoney()
                                 util.UpdateEarnedSpent(cash + (99 * COPPER), cash)
                              end
                           )
         cm:AddOption  (  "Spend 99 Copper",
                              2,
                              function(self)
                                 local cash = GetMoney()
                                 util.UpdateEarnedSpent(cash - (99 * COPPER), cash)
                              end
                           )
         cm:AddDescriptor    (  "-------------------", 2 )
         cm:AddOption  (  "Reset All",
                              2,
                              function(self)
                                 ResetAllTime(true)
                                 ResetYearMA()
                                 ResetMonthMA()
                                 ResetWeekMA()
                                 ResetDayMA()
                                 ResetSessionMA()
                              end
                           )
      elseif menuList == "ResetDay" then
         for n, v in pairs(DOW) do
            cm:AddRadioOption   (  v,
                                       function(self)
                                          return GetDOWSetting() == n
                                       end,
                                       3,
                                       function(self, _, _, _)
                                          SetDOWSetting(n)
                                          core.InitializePersistantVariables()
                                       end
                                    )
         end
      elseif menuList == "Minimaps" then
         cm:AddCheckOption   (  "Lock to Minimap",
                                    function(self)
                                       return minimap.GetMinimapLockSetting()
                                    end,
                                    2,
                                    function(self, _, _, checked) 
                                       _G.WOWMMChar.Minimap.IsMinimapLocked = minimap.SetMinimapLock(checked)
                                    end
                                 )
         cm:AddCheckOption   (  "Lock",
                                    function(self)
                                       return minimap.GetLockSetting()
                                    end,
                                    2,
                                    function(self, _, _, checked) 
                                       _G.WOWMMChar.Minimap.IsLocked = minimap.SetLock(checked)
                                    end
                                 )
      elseif menuList == "Fonts" then
         local fonts = {}
         for n, v in pairs(_G["Prototype_Fonts"]) do
            if type(v) ~= "table" then 
               table.insert(fonts, n)
            end
         end
         table.sort(fonts)
         for _, v in pairs(fonts) do
            cm:AddRadioOption   (  v,
                                       function(self)
                                          return util.GetFontSetting() == v
                                       end,
                                       2,
                                       function(self, _, _, _)
                                          util.SetFontSetting(v)
                                          tt.UpdateFontInfo()
                                          cm:Refresh()
                                       end
                                    )
         end      
      elseif menuList == "FontSize" then
         local fontSizes = _G["Prototype_Fonts"].Sizes
         for _, v in pairs(fontSizes) do
            cm:AddRadioOption   (  tostring(v),
                                       function(self)
                                          return util.GetFontSizeSetting() == v
                                       end,
                                       2,
                                       function(self, _, _, _)
                                          util.SetFontSizeSetting(v)
                                          tt.UpdateFontInfo()
                                          cm:Refresh()
                                       end
                                    )
         end
      elseif menuList == "Removes" then
         for n, v in pairs(_G.WOWMMGlobal) do
            if type(v) == "table" then
               cm:AddMenu       (  n, 2, n )
            end
         end
      elseif menuList == "Resets" then
         cm:AddOption  (  "All Time",
                              2,
                              function(self)
                                 ResetAllTime()
                              end
                           )
         cm:AddOption  (  "Year",
                              2,
                              function(self)
                                 ResetYear()
                              end
                           )
         cm:AddOption  (  "Month",
                              2,
                              function(self)
                                 ResetMonth()
                              end
                           )
         cm:AddOption  (  "Week",
                              2,
                              function(self)
                                 ResetWeek()
                              end
                           )
         cm:AddOption  (  "Day",
                              2,
                              function(self)
                                 ResetDay()
                              end
                           )
         cm:AddDescriptor    (  "-------------------", 2 )
         cm:AddOption  (  "Avg (Year)",
                              2,
                              function(self)
                                 ResetYearMA()
                              end
                           )
         cm:AddOption  (  "Avg (Month)",
                              2,
                              function(self)
                                 ResetMonthMA()
                              end
                           )
         cm:AddOption  (  "Avg (Week)",
                              2,
                              function(self)
                                 ResetWeekMA()
                              end
                           )
         cm:AddOption  (  "Avg (Day)",
                              2,
                              function(self)
                                 ResetDayMA()
                              end
                           )
         cm:AddOption  (  "Avg (Session)",
                              2,
                              function(self)
                                 ResetSessionMA()
                              end
                           )
      else
         if level == 3 then
            local chars = util.GetSortedCharList(menuList)
            for _, cn in pairs(chars) do
               cm:AddOption  (  cn,
                                    3,
                                    function(self)
                                       RemoveCharacter(menuList, cn)
                                    end
                                 )
            end
         end
      end
   end
end

cm = Prototype_Menu:NewContextMenu  (addon_name.."ContextMenu",
                                       {
                                          OnLoad = ContextMenu_OnLoad,
                                       }
                                    )

function menu.IsMenuOpen()
   return cm and cm:IsMenuOpen()
end

function menu.ToggleMenu(anchor)
   if cm then
      cm:ToggleMenu(anchor)
   end
end

function menu.OpenMenu(anchor)
   if cm then
      cm:OpenMenu(anchor)
   end
end

function menu.CloseMenu()
   if cm then
      cm:CloseMenu()
   end
end

menu.GetDOWSetting = GetDOWSetting
