
------------------------------------------ SOURCE ------------------------------------------

--create the frame to check if the map is open
local WhereDoWeGoNow = CreateFrame("frame")

--create the main frame
local WorldMapFramePoint = CreateFrame("frame", "PointInWorldMap", WorldMapUnitPositionFrame)
WorldMapFramePoint:SetSize (1, 1)

--store saved variables
local DB

--register on load event
WhereDoWeGoNow:RegisterEvent("ADDON_LOADED")
WhereDoWeGoNow:SetScript("OnEvent", function(self, event, addonName)
	if (addonName == "WhereDoWeGoNow") then
		
		--saved variables
		DB = WhereDoWeGoNowDB or {}
		WhereDoWeGoNowDB = DB
		
		do 
			--default settings
			local DefaultSettings = {
				ColorSRGB = {1, 1, 1, 1},
				DotSize = 4,
				DotAmount = 30,
				DotTexture = [[Interface\CHARACTERFRAME\TempPortraitAlphaMaskSmall]],
				LineSize = 500,
			}
			
			--check if default settings exists
			for key, value in pairs(DefaultSettings) do
				if (not DB [key]) then
					DB [key] = value
				end
			end
		end
		
		--all textures created are stored here, these textures show the dots
		WhereDoWeGoNow.AllDots = {}
		WhereDoWeGoNow.AllDotsNotUsed = {}
		
		--distance in pixels between each dot
		WhereDoWeGoNow.Distance = DB.LineSize / DB.DotAmount
		
		--when true, it is showing the dots on the map
		WhereDoWeGoNow.bShowingLines = false
		
		--pre create all dots
		for i = 1, DB.DotAmount do
			local Dot = WorldMapFramePoint:CreateTexture (nil, "overlay")
			Dot:SetPoint ("center")
			WhereDoWeGoNow.RefreshDot(Dot)
			tinsert (WhereDoWeGoNow.AllDots, Dot)
		end
	end
end)


WhereDoWeGoNow:SetScript("OnUpdate", function()
	
	--check if the map is opened and if the player is flying
	if (WorldMapFrame:IsShown() and IsFlying()) then
	
		--get the direction the player is facing
		local Direction = GetPlayerFacing()
		--build a forward vector based on the the direction the player is facing
		local ForwardVector = {x = -math.sin(Direction), y = -math.cos(Direction), z = 0}
		
		--get the player map position
		local SelfX, SelfY = GetPlayerMapPosition("player")
		
		--zoom data (shout-out to @rondowar on www.curseforge.com/members/rondowar)
		local Scale = WorldMapDetailFrame:GetScale() / (WorldMapFrame_InWindowedMode() and 0.69499999284744 or 1)
		
		--project the player coordinates to map coordinates
		local ProjectionX = WorldMapDetailFrame:GetWidth() * (WorldMapFrame_InWindowedMode() and 1 or WORLDMAP_FULLMAP_SIZE) * SelfX * Scale
		local ProjectionY = WorldMapDetailFrame:GetHeight() * (WorldMapFrame_InWindowedMode() and 1 or WORLDMAP_FULLMAP_SIZE) * SelfY * Scale
		
		--show the map and set the start point
		WorldMapFramePoint:Show()
		WorldMapFramePoint:ClearAllPoints()
		WorldMapFramePoint:SetPoint ("CENTER", WorldMapPOIFrame, "TOPLEFT", ProjectionX, -ProjectionY)
		WorldMapFramePoint:SetFrameLevel (WorldMapFramePoint:GetParent():GetFrameLevel() + 2000)
		
		--update all dot position
		for i = 1, #WhereDoWeGoNow.AllDots do
			local Dot = WhereDoWeGoNow.AllDots[i]
			
			--calculate the dot position
			local nx, ny = ForwardVector.x*WhereDoWeGoNow.Distance*i, ForwardVector.y*WhereDoWeGoNow.Distance*i
			nx, ny = nx+ProjectionX, ny+ProjectionY
			
			--set the dot position
			Dot:SetPoint ("CENTER", WorldMapPOIFrame, "TOPLEFT", nx, -ny)
			
			--if not already showing the line, call Show
			if (not WhereDoWeGoNow.bShowingLines) then
				Dot:Show()
			end
		end
		
		--line are shown
		WhereDoWeGoNow.bShowingLines = true
	else
		--the map is closed or the player isn't flying, check if the line is showing
		if (WhereDoWeGoNow.bShowingLines) then
			--hide all dots
			for i = 1, #WhereDoWeGoNow.AllDots do
				local Dot = WhereDoWeGoNow.AllDots[i]
				Dot:Hide()
			end
			
			--line are now hide
			WhereDoWeGoNow.bShowingLines = false
		end
	end
end)

function WhereDoWeGoNow.RefreshDot(Dot)
	Dot:SetTexture (DB.DotTexture)
	Dot:SetSize (DB.DotSize, DB.DotSize)
	Dot:SetVertexColor (unpack (DB.ColorSRGB))
end

function WhereDoWeGoNow.Refresh()
	for i = 1, #WhereDoWeGoNow.AllDots do
		local Dot = WhereDoWeGoNow.AllDots[i]
		WhereDoWeGoNow.RefreshDot(Dot)
	end
	
	--line length
	WhereDoWeGoNow.Distance = DB.LineSize / DB.DotAmount
	
	--dot amount
	if (#WhereDoWeGoNow.AllDots ~= DB.DotAmount) then
		if (#WhereDoWeGoNow.AllDots < DB.DotAmount) then
			--increase
			for i = #WhereDoWeGoNow.AllDots+1, DB.DotAmount do
				local Dot = tremove (WhereDoWeGoNow.AllDotsNotUsed)
				if (not Dot) then
					Dot = WorldMapFramePoint:CreateTexture (nil, "overlay")
				end

				Dot:SetPoint ("center")
				Dot:Show()
				WhereDoWeGoNow.RefreshDot(Dot)
				tinsert (WhereDoWeGoNow.AllDots, Dot)
			end
		else
			--decrease
			for i = DB.DotAmount+1, #WhereDoWeGoNow.AllDots do
				local Dot = tremove (WhereDoWeGoNow.AllDots)
				Dot:Hide()
				tinsert (WhereDoWeGoNow.AllDotsNotUsed, Dot)
			end
		end
	end
end

function WhereDoWeGoNow.Message(...)
	print(...)
end

function WhereDoWeGoNow.ParseChatCommand(s)
	local command, argument = s:match("^(%S*)%s*(.-)$")
	command = string.lower (command)
	return command, argument
end

SLASH_WHEREDOWEGONOW1, SLASH_WHEREDOWEGONOW2, SLASH_WHEREDOWEGONOW3 = "/wdwgn", "/wd", "/where"

function SlashCmdList.WHEREDOWEGONOW(message)

	local command, argument = WhereDoWeGoNow.ParseChatCommand(message)
	
	if (not command or command == "") then
		WhereDoWeGoNow.Message("Where Do We Go Now", "commands:")
		WhereDoWeGoNow.Message("dotsize: change the size of dots")
		WhereDoWeGoNow.Message("dotamount: change the amount of dots")
		WhereDoWeGoNow.Message("linesize: change the length of the line")
		
	else
		
		if (command == "dotsize") then
			local dotSize = tonumber (argument)
			if (dotSize) then
				DB.DotSize = dotSize
				WhereDoWeGoNow.Message("Where Do We Go Now", command, "changed to", argument)
				WhereDoWeGoNow.Refresh()
			else
				WhereDoWeGoNow.Message("use:", command, "[size]")
			end
			
		elseif (command == "dotamount") then
			local dotAmount = tonumber (argument)
			if (dotAmount) then
				DB.DotAmount = dotAmount
				WhereDoWeGoNow.Message("Where Do We Go Now", command, "changed to", argument)
				WhereDoWeGoNow.Refresh()
			else
				WhereDoWeGoNow.Message("use:", command, "[amount]")
			end
			
		elseif (command == "linesize") then
			local lineSize = tonumber (argument)
			if (lineSize) then
				DB.LineSize = lineSize
				WhereDoWeGoNow.Message("Where Do We Go Now", command, "changed to", argument)
				WhereDoWeGoNow.Refresh()
			else
				WhereDoWeGoNow.Message("use:", command, "[length]")
			end
			
		end
		
	end
	
end











