WakeningEssenceTracker = {}
WET_DB = WET_DB or {}

local currencyId = 1533
local essenceCount
local unitName, realmName, unitLevel
local unitClass, classColor
local WET = WakeningEssenceTracker
local green = "|cff00ff00"
local printColor = "|cff0080ff"

local WET_Frame = CreateFrame("Frame")
WET_Frame:RegisterEvent("ADDON_LOADED")
WET_Frame:RegisterEvent("CURRENCY_DISPLAY_UPDATE")
WET_Frame:RegisterEvent("PLAYER_ENTERING_WORLD")

function WET.OnEvent(self, event, arg1, arg2)
	if event == "PLAYER_ENTERING_WORLD" then
		WET.GetEssenceCount()
		unitName = UnitName("player")
		unitLevel = UnitLevel("player")
		realmName = GetRealmName()
		WET.ClassColor()
		--WET.Print()
		WET.UpdateTable()
	end
	
	if event == "CURRENCY_DISPLAY_UPDATE" and arg1 == currencyId and arg2 ~= 0 then
		--print("|cffff0000CURRENCY_DISPLAY_UPDATE|r")
		WET.GetEssenceCount()
		--WET.Print()
		WET.UpdateTable()
	end
end

function WET.Print()
	print(printColor.."Wakening Essence Count:|r\n".."|c"..classColor..unitName.."|r-"..realmName..": "..essenceCount)
	print(printColor.."------------------------------|r")
end

function WET.GetEssenceCount()
	_, essenceCount = GetCurrencyInfo(currencyId)
end

function WET.ClassColor()
	_, unitCLass = UnitClass("player")
	if unitCLass then
		classColor = RAID_CLASS_COLORS[unitCLass]["colorStr"]
	end
end

function WET.UpdateTable()
	if WET_DB[realmName] == nil then
		WET_DB[realmName] = {}
	end
	
	if WET_DB[realmName][unitName] == nil then
		WET_DB[realmName][unitName] = {}
	end
	
	WET_DB[realmName][unitName].colorStr = classColor
	WET_DB[realmName][unitName].essenceCount = essenceCount
end


function WET.PrintTable()
	local name
	local colorStr 
	local tempCount 

    if type(WET_DB) == "table" and WET_DB ~= nil then
		print(printColor.."Wakening Essence Count:|r")
        for r,u in pairs(WET_DB) do 
            print(r)
			if type(u) == "table" then
				for n,d in pairs(u) do
					for k,v in pairs(d) do
						if k == "essenceCount" then
							if v > 1000 then
								tempCount = printColor..v.."|r"
							else
								tempCount = v
							end
						end
						if k == "colorStr" then
							colorStr = v
						end
					end	
					print("  |c"..colorStr..n.."|r: "..tempCount)
				end
			end
        end
		print(printColor.."------------------------------|r")
	elseif WET_DB == nil then
		print(printColor.."WET_DB is empty!|r")
	end
end

--Hook on tooltip
function WET.AddLine(tooltip, leftText, rightText)
	tooltip:AddDoubleLine(leftText, rightText)
	tooltip:Show() 
end

hooksecurefunc(GameTooltip, "SetCurrencyToken", function(self, index)
	local id = tonumber(string.match(GetCurrencyListLink(index),"currency:(%d+)"))
	if id == currencyId then 
		if type(WET_DB) == "table" and WET_DB ~= nil then
			WET.AddLine(self, " ", " ") 
			for r, u in pairs(WET_DB) do
			   WET.AddLine(self, "|cffffffff-"..r.."-|r", nil)
			   
			   local keys = {}
			   
			   for k in pairs(u) do 
					table.insert(keys, k) 
			   end
			   
			   table.sort(keys, function(a, b)
					return u[a]["essenceCount"] > u[b]["essenceCount"]
			   end)
			   
			   for _, k in ipairs(keys) do 
					WET.AddLine(self, "|c"..u[k]["colorStr"]..k.."|r", u[k]["essenceCount"]) 
			   end
			end
		end
	end
end)





--slash commands
SLASH_WET1 = "/wet"
SlashCmdList["WET"] = function(msg, editBox)
	if msg == "" then
		WET.PrintTable()
	elseif msg == "reset" then
		WET_DB = nil
		print(printColor.."WET has been reset|r")
	end
end



WET_Frame:SetScript("OnEvent", WET.OnEvent)


--[[
TODO:

Kazzak:
	Parach: 254
	Womyn: 350	
Stormscale:
	Bestworld: 1
	
WET_DB = {
	["Kazzak"] = {
		["Parach"] = {
			["colorStr"] = "ff00ff00",
			["essenceCount"] = 123,
		},
		["Racpa"] = {
			["colorStr"] = "ff00ff00",
			["essenceCount"] = 123,
		},
	},
	["Frostmane"] = {
		["Parach"] = {
			["colorStr"] = "ff00ff00",
			["essenceCount"] = 123,
		},
		["Bestworld"] = {
			["colorStr"] = "ff00ff00",
			["essenceCount"] = 123,
		},
	},
}
	
	

--]]
	
	

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
