vexinterrupt = {}
vexinterrupt.inParty = false
vexinterrupt.started = false
vexinterrupt.playerName = ""
vexinterrupt.AceConfigDialog = LibStub("AceConfigDialog-3.0", true)
vexinterrupt.AceConfig = LibStub("AceConfig-3.0", true)
vexinterrupt.AceConsole= LibStub("AceConsole-3.0", true)
vexinterrupt.LSM = LibStub("LibSharedMedia-3.0", true)
vexinterrupt.LSMWidgets = LibStub("AceGUI-3.0-SharedMediaWidgets", true)
vexinterrupt.scanTool = {}
vexinterrupt.options = {}
vexinterrupt.spamcontrol = {}

function vexinterrupt_onEvent(self, event, ...)
	if event == "PLAYER_LOGIN" then
		vexinterrupt.initialize(false)
	elseif event == "COMBAT_LOG_EVENT_UNFILTERED" and vexinterrupt.started then
		if vexinterrupt_data["active"] then		-- Active Addon Check
			local a, event, c, guid, caster, f, g, targetUID, target, j, k, l, m, n, spellid = CombatLogGetCurrentEventInfo()
			
			-- local eventdata = CombatLogGetCurrentEventInfo()
			-- local caster = select(5, eventdata)
			-- local guid = select(4, eventdata)
			-- local event = select(2, eventdata)
			-- local targetUID = select(8, eventdata)
			-- local target = select(9, eventdata)
			
			local areaCode = vexinterrupt.getAreaCode()
			
			if vexinterrupt_data["zones"][areaCode] then			-- Zone check
				if vexinterrupt.casterCheck(guid, caster) and vexinterrupt.grpCheck() then	--check (caster==player or caster==player's pet) and check inGrp
					if vexinterrupt.eventCheck(event, targetUID) then						-- typical events: SPELL_INTERRUPT, SPELL_DISPEL, SPELL_STOLEN
						local spelllink = GetSpellLink(spellid)
						local spellname = select(1, GetSpellInfo(spellid))
						local msg = vexinterrupt_data["msg"][event][2]
					
					
						local msg = vexinterrupt_data["msg"][event][2]
						local targetRaidIcon = nil
						if target ~= nil then
							targetRaidIcon = GetRaidTargetIndex(target)
						end
						if targetRaidIcon ~= nil then
							targetRaidIcon = "{rt"..tostring(targetRaidIcon).."}"
						else
							targetRaidIcon = ""
						end
						
						if spelllink == nil then	spelllink = ""	end
						if spellname == nil then	spellname = ""	end
						if target == nil 	then	target = ""	end
						
						msg = string.gsub(msg, "%[spelllink%]", spelllink)
						msg = string.gsub(msg, "%[spellname%]", spellname)
						msg = string.gsub(msg, "%[targetRaidIcon%]", targetRaidIcon)
						msg = string.gsub(msg, "%[target%]", target)
						
						local channel = vexinterrupt_data["channel"][areaCode]
						SendChatMessage(msg, channel)
					-- elseif event == "SPELL_AURA_APPLIED" and vexinterrupt_data["msg"]["ATYPICAL"][1] then	-- atypical events: "Interrupt" by Arcane Torrent, Frag belts, etc
						-- local spellid = select(10,...)
						-- if spellid == 66888 or spellid == 2600 then
							-- local currentTime = time()
							-- local spam = false
							-- for key,val in pairs(vexinterrupt.spamcontrol) do	--check for spam
								-- if val[1] + 2 < currentTime then
									-- vexinterrupt.spamcontrol[key] = nil
								-- elseif val[2] == select(10,...) then
									-- spam = true
								-- end
							-- end
							
							-- if not(spam) then									--if msg isn't spamming
								-- local msg = vexinterrupt_data["msg"]["ATYPICAL"][2]
								-- local channel = vexinterrupt_data["channel"][areaCode]
								-- SendChatMessage(msg, channel)
								-- vexinterrupt.spamcontrol[currentTime.." "..spellid] = {currentTime, spellid}
							-- end
						-- end
					end
				end
			end
		end
	end
end

function vexinterrupt.eventCheck(event, targetUID)
	local returnvalue = (event == "SPELL_INTERRUPT" or event == "SPELL_DISPEL" or event == "SPELL_STOLEN") and vexinterrupt_data["msg"][event][1]
	if event == "SPELL_DISPEL" then
		if string.find(targetUID, "Player") ~= nil then
			returnvalue = false
		end
	end
	return returnvalue
end

function vexinterrupt.grpCheck()
	local returnvalue = true
	local inGrp = false
	inGrp = UnitPlayerOrPetInRaid("player")
	if not(inGrp) then
		inGrp = UnitPlayerOrPetInParty("player")
	end
	if not(inGrp) and vexinterrupt_data["inGrpOnly"] then
		returnvalue = false
	end
	
	return returnvalue
end

function vexinterrupt.casterCheck(guid, caster)
	if string.find(guid, "Pet")~=nil then
		caster = vexinterrupt.getOwnerOfPet(caster)
	end
	return caster == vexinterrupt.playerName
end


function vexinterrupt.getOwnerOfPet(caster)
	vexinterrupt.scanTool.frame:ClearLines()
	vexinterrupt.scanTool.frame:SetUnit(caster)
	local ownerText = vexinterrupt.scanTool.text:GetText()
	if not ownerText then return nil end
	local owner, _ = string.split("'",ownerText)
	   
	return owner
end

function vexinterrupt.checkArea()
	return vexinterrupt_data["zones"][vexinterrupt.getAreaCode()]
end

function vexinterrupt.getAreaCode()
	local returnvalue = ""
	
	--General, Instance,Bg, Raid, Challenge Mode
	local difficultyID  = select(3, GetInstanceInfo())
	local inArena  = select(1, IsActiveBattlefieldArena())
	local inBG = UnitInBattleground("player") ~= nil
	
	-- Check if in dng
	if difficultyID  ~= 0 then
		-- 	normal 					heroic					heroic	Scenario		normal Scenario
		if 	difficultyID == 1 or 	difficultyID == 2 or 	difficultyID == 11 or 	difficultyID == 12 then	
			returnvalue = "dng"
			
		-- 		Mythic Dng
		elseif 	difficultyID == 23 or	difficultyID == 8 then
			returnvalue = "mythdng"
			
		-- 		10 player, 				25 player, 				10 player heroic		25 player heroic		lfr						40 player 				normal					heroic					mythic					lfr						MC?
		elseif 	difficultyID == 3 or 	difficultyID == 4 or 	difficultyID == 5 or 	difficultyID == 6 or 	difficultyID == 7 or 	difficultyID == 9 or 	difficultyID == 14 or 	difficultyID == 15 or 	difficultyID == 16 or 	difficultyID == 17 or 	difficultyID == 18 then	
			returnvalue = "raid"
		end
	elseif inBG then
		returnvalue = "bg"
	elseif inArena then
		returnvalue = "arena"
	else
		returnvalue = "general"
	end
	return returnvalue
end
